/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManager$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r%u!\u0002*T\u0011\u0003Af!\u0002.T\u0011\u0003Y\u0006\"\u00022\u0002\t\u0003\u0019\u0007b\u00023\u0002\u0005\u0004%\t!\u001a\u0005\u0007]\u0006\u0001\u000b\u0011\u00024\t\u000f=\f!\u0019!C\u0001K\"1\u0001/\u0001Q\u0001\n\u0019Dq!]\u0001C\u0002\u0013\u0005Q\r\u0003\u0004s\u0003\u0001\u0006IA\u001a\u0005\bg\u0006\u0011\r\u0011\"\u0001f\u0011\u0019!\u0018\u0001)A\u0005M\"9Q/\u0001b\u0001\n\u0003)\u0007B\u0002<\u0002A\u0003%a\rC\u0004x\u0003\t\u0007I\u0011A3\t\ra\f\u0001\u0015!\u0003g\u0011\u001dI\u0018A1A\u0005\u0002\u0015DaA_\u0001!\u0002\u00131\u0007bB>\u0002\u0005\u0004%\t!\u001a\u0005\u0007y\u0006\u0001\u000b\u0011\u00024\t\u000fu\f!\u0019!C\u0001K\"1a0\u0001Q\u0001\n\u0019D\u0001b`\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003\u0013\t\u0001\u0015!\u0003\u0002\u0004!I\u00111B\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003\u001b\t\u0001\u0015!\u0003\u0002\u0004!9\u0011qB\u0001\u0005\u0002\u0005E\u0001bBA\u001e\u0003\u0011\u0005\u0011Q\b\u0005\b\u0003'\nA\u0011AA+\u0011\u001d\ty!\u0001C\u0001\u00037Bq!!\u0019\u0002\t\u0003\t\u0019\u0007C\u0004\u0002\u0016\u0006!\t!a&\t\u000f\u0005%\u0016\u0001\"\u0001\u0002,\u001a)!l\u0015\u0001\u0002n\"Q!q\u0001\u0011\u0003\u0006\u0004%\tA!\u0003\t\u0015\tE\u0001E!A!\u0002\u0013\u0011Y\u0001\u0003\u0006\u0003\u0014\u0001\u0012)\u0019!C\u0001\u0005+A!Ba\t!\u0005\u0003\u0005\u000b\u0011\u0002B\f\u0011)\u0011)\u0003\tBC\u0002\u0013\u0005!q\u0005\u0005\u000b\u0005g\u0001#\u0011!Q\u0001\n\t%\u0002B\u0003B\u001bA\t\u0015\r\u0011\"\u0001\u00038!Q!Q\t\u0011\u0003\u0002\u0003\u0006IA!\u000f\t\r\t\u0004C\u0011\u0001B$\u000b\u0019\u0011\u0019\u0006\t\u0001\u0003V\u00151!1\r\u0011\u0001\u0005K*aA! !\u0001\t\u0015TA\u0002B@A\u0001\u0011\t\tC\u0005\u0002:\u0001\u0012\r\u0011\"\u0001\u0003\u0006\"A!q\u0011\u0011!\u0002\u0013\ty\u0004C\u0005\u0003\n\u0002\u0012\r\u0011\"\u0001\u0003\f\"A!Q\u0012\u0011!\u0002\u0013\u00119\bC\u0005\u0003\u0010\u0002\u0012\r\u0011\"\u0001\u0003\f\"A!\u0011\u0013\u0011!\u0002\u0013\u00119\bC\u0005\u0003\u0014\u0002\u0012\r\u0011\"\u0001\u0003\f\"A!Q\u0013\u0011!\u0002\u0013\u00119\bC\u0005\u0003\u0018\u0002\u0012\r\u0011\"\u0003\u0003\u001a\"A!\u0011\u0015\u0011!\u0002\u0013\u0011Y\nC\u0005\u0003$\u0002\u0002\r\u0011\"\u0003\u0003&\"I!\u0011\u0017\u0011A\u0002\u0013%!1\u0017\u0005\t\u0005s\u0003\u0003\u0015)\u0003\u0003(\"9!1\u0018\u0011\u0005\u0002\tu\u0006b\u0002B`A\u0011\u0005!Q\u0018\u0005\b\u0005\u0003\u0004C\u0011\u0002B_\u0011\u001d\u0011\u0019\r\tC\u0005\u0005\u000bDqAa3!\t\u0013\u0011i\rC\u0004\u0003R\u0002\"IAa5\t\u000f\t\u001d\b\u0005\"\u0001\u0003j\"911\u0001\u0011\u0005\u0002\r\u0015\u0001bBB\u0013A\u0011%1q\u0005\u0005\b\u0007W\u0001C\u0011BB\u0017\u0011\u001d\u0019\t\u0004\tC\u0005\u0007gAqaa\u000b!\t\u0003\u0019Y\u0004C\u0004\u0004,\u0001\"Iaa\u0010\t\u000f\r\r\u0003\u0005\"\u0001\u0004F!91Q\u000b\u0011\u0005\n\r]\u0003bBB.A\u0011%1Q\f\u0005\b\u0007C\u0002C\u0011\u0001B_\u0011\u001d\u0019\u0019\u0007\tC\u0001\u0007KBqa!\u001b!\t\u0003\u0019YgB\u0004\u0004r\u0001B\taa\u001d\u0007\u000f\rU\u0004\u0005#\u0001\u0004x!1!m\u0014C\u0001\u0007\u007fBqa!!P\t\u0003\u001a\u0019)\u0001\fEK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0015\t!V+\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0006)1.\u00194lC\u000e\u0001\u0001CA-\u0002\u001b\u0005\u0019&A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0014\u0005\u0005a\u0006CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021\u0006!B)\u001a4bk2$\b*\\1d\u00032<wN]5uQ6,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001\\1oO*\t1.\u0001\u0003kCZ\f\u0017BA7i\u0005\u0019\u0019FO]5oO\u0006)B)\u001a4bk2$\b*\\1d\u00032<wN]5uQ6\u0004\u0013\u0001C(x]\u0016\u00148*Z=\u0002\u0013=;h.\u001a:LKf\u0004\u0013!\u0005+pW\u0016t'+Z9vKN$XM]&fs\u0006\u0011Bk\\6f]J+\u0017/^3ti\u0016\u00148*Z=!\u0003-\u0011VM\\3xKJ\u001c8*Z=\u0002\u0019I+g.Z<feN\\U-\u001f\u0011\u0002#%\u001b8/^3US6,7\u000f^1na.+\u00170\u0001\nJgN,X\rV5nKN$\u0018-\u001c9LKf\u0004\u0013aD'bqRKW.Z:uC6\u00048*Z=\u0002!5\u000b\u0007\u0010V5nKN$\u0018-\u001c9LKf\u0004\u0013AE#ya&\u0014\u0018\u0010V5nKN$\u0018-\u001c9LKf\f1#\u0012=qSJLH+[7fgR\fW\u000e]&fs\u0002\n!\u0002V8lK:LEmS3z\u0003-!vn[3o\u0013\u0012\\U-\u001f\u0011\u0002\u0015Y+'o]5p].+\u00170A\u0006WKJ\u001c\u0018n\u001c8LKf\u0004\u0013AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0003\u0003\u0007\u00012!XA\u0003\u0013\r\t9A\u0018\u0002\u0004\u0013:$\u0018aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\u0002\u001d\u0015\u0013(o\u001c:US6,7\u000f^1na\u0006yQI\u001d:peRKW.Z:uC6\u0004\b%\u0001\u0006de\u0016\fG/\u001a%nC\u000e$b!a\u0005\u0002 \u0005]\u0002#B/\u0002\u0016\u0005e\u0011bAA\f=\n)\u0011I\u001d:bsB\u0019Q,a\u0007\n\u0007\u0005uaL\u0001\u0003CsR,\u0007bBA\u00113\u0001\u0007\u00111E\u0001\bi>\\WM\\%e!\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003SqVBAA\u0016\u0015\r\ticV\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Eb,\u0001\u0004Qe\u0016$WMZ\u0005\u0004[\u0006U\"bAA\u0019=\"9\u0011\u0011H\rA\u0002\u0005\r\u0012!C:fGJ,GoS3z\u0003=\u0019'/Z1uKN+7M]3u\u0017\u0016LH\u0003BA \u0003\u001f\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0004def\u0004Ho\u001c\u0006\u0003\u0003\u0013\nQA[1wCbLA!!\u0014\u0002D\tI1+Z2sKR\\U-\u001f\u0005\b\u0003#R\u0002\u0019AA\n\u0003!YW-\u001f2zi\u0016\u001c\u0018\u0001E2sK\u0006$XMQ1tKZ\"\u0004*T!D)\u0019\t\u0019#a\u0016\u0002Z!9\u0011\u0011E\u000eA\u0002\u0005\r\u0002bBA\u001d7\u0001\u0007\u0011q\b\u000b\u0007\u0003'\ti&a\u0018\t\u000f\u0005\u0005B\u00041\u0001\u0002$!9\u0011\u0011\b\u000fA\u0002\u0005}\u0012a\u0005;p\u0015N|gnQ8na\u0006$\u0018N\u00197f\u001b\u0006\u0004H\u0003BA3\u0003c\u0002\u0002\"!\n\u0002h\u0005\r\u00121N\u0005\u0005\u0003S\n)DA\u0002NCB\u00042!XA7\u0013\r\tyG\u0018\u0002\u0004\u0003:L\bbBA:;\u0001\u0007\u0011QO\u0001\u0006i>\\WM\u001c\t\u0005\u0003o\n\t*\u0004\u0002\u0002z)!\u00111PA?\u0003)!W\r\\3hCRLwN\u001c\u0006\u0005\u0003g\nyH\u0003\u0003\u0002\u0002\u0006\r\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\t\u0005\u0015\u0015qQ\u0001\u0007G>lWn\u001c8\u000b\u0007Y\u000bII\u0003\u0003\u0002\f\u00065\u0015AB1qC\u000eDWM\u0003\u0002\u0002\u0010\u0006\u0019qN]4\n\t\u0005M\u0015\u0011\u0010\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\u0006IaM]8n\u0005f$Xm\u001d\u000b\u0005\u00033\u000b)\u000bE\u0003^\u00037\u000by*C\u0002\u0002\u001ez\u0013aa\u00149uS>t\u0007\u0003BA<\u0003CKA!a)\u0002z\t\u0001Bk\\6f]&sgm\u001c:nCRLwN\u001c\u0005\b\u0003Os\u0002\u0019AA\n\u0003\u0015\u0011\u0017\u0010^3t\u0003-1\u0017\u000e\u001c;feR{7.\u001a8\u0015\u0019\u00055\u00161WAb\u00037\fi.a:\u0011\u0007u\u000by+C\u0002\u00022z\u0013qAQ8pY\u0016\fg\u000eC\u0004\u00026~\u0001\r!a.\u0002%I,\u0017/^3ti\u0016\u0014\bK]5oG&\u0004\u0018\r\u001c\t\u0005\u0003s\u000by,\u0004\u0002\u0002<*!\u0011QXA@\u0003\u0011\tW\u000f\u001e5\n\t\u0005\u0005\u00171\u0018\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u001d\t)m\ba\u0001\u0003\u000f\faa\\<oKJ\u001c\b#B/\u0002\u001c\u0006%\u0007CBAf\u0003+\f9L\u0004\u0003\u0002N\u0006Eg\u0002BA\u0015\u0003\u001fL\u0011aX\u0005\u0004\u0003't\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003/\fIN\u0001\u0003MSN$(bAAj=\"9\u00111O\u0010A\u0002\u0005}\u0005bBAp?\u0001\u0007\u0011\u0011]\u0001\u000fCV$\bn\u001c:ju\u0016$vn[3o!\u001di\u00161]A\u0012\u0003[K1!!:_\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002j~\u0001\r!a;\u0002%\u0005,H\u000f[8sSj,'+Z9vKN$XM\u001d\t\b;\u0006\r\u0018qWAW'\u0019\u0001C,a<\u0002|B!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002vV\u000bQ!\u001e;jYNLA!!?\u0002t\n9Aj\\4hS:<\u0007\u0003BA\u007f\u0005\u0007i!!a@\u000b\u0007\t\u0005Q+A\u0004nKR\u0014\u0018nY:\n\t\t\u0015\u0011q \u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018AB2p]\u001aLw-\u0006\u0002\u0003\fA\u0019\u0011L!\u0004\n\u0007\t=1KA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000bi>\\WM\\\"bG\",WC\u0001B\f!\u0011\u0011IBa\b\u000e\u0005\tm!\u0002\u0002B\u000f\u0003s\n\u0011\"\u001b8uKJt\u0017\r\\:\n\t\t\u0005\"1\u0004\u0002\u0015\t\u0016dWmZ1uS>tGk\\6f]\u000e\u000b7\r[3\u0002\u0017Q|7.\u001a8DC\u000eDW\rI\u0001\u0005i&lW-\u0006\u0002\u0003*A!!1\u0006B\u0018\u001b\t\u0011iC\u0003\u0003\u0002v\u0006\r\u0015\u0002\u0002B\u0019\u0005[\u0011A\u0001V5nK\u0006)A/[7fA\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0003:A!!1\bB!\u001b\t\u0011iDC\u0002\u0003@U\u000b!A_6\n\t\t\r#Q\b\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013i\\7\t\\5f]R\u0004CC\u0003B%\u0005\u0017\u0012iEa\u0014\u0003RA\u0011\u0011\f\t\u0005\b\u0005\u000fI\u0003\u0019\u0001B\u0006\u0011\u001d\u0011\u0019\"\u000ba\u0001\u0005/AqA!\n*\u0001\u0004\u0011I\u0003C\u0004\u00036%\u0002\rA!\u000f\u0003-\r\u0013X-\u0019;f%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004r!XAr\u0005/\u0012i\u0006E\u0002Z\u00053J1Aa\u0017T\u0005E\u0019%/Z1uKR{7.\u001a8SKN,H\u000e\u001e\t\u0004;\n}\u0013b\u0001B1=\n!QK\\5u\u0005U\u0011VM\\3x%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004\u0012\"\u0018B4\u0005W\u00129H!\u0018\n\u0007\t%dLA\u0005Gk:\u001cG/[8oeA!!Q\u000eB:\u001b\t\u0011yG\u0003\u0003\u0003r\u0005\r\u0015\u0001\u00039s_R|7m\u001c7\n\t\tU$q\u000e\u0002\u0007\u000bJ\u0014xN]:\u0011\u0007u\u0013I(C\u0002\u0003|y\u0013A\u0001T8oO\n1R\t\u001f9je\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7N\u0001\rEKN\u001c'/\u001b2f%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004\u0012\"\u0018B4\u0005W\u0012\u0019I!\u0018\u0011\r\u0005-\u0017Q[A;+\t\ty$\u0001\u0006tK\u000e\u0014X\r^&fs\u0002\n\u0001\u0003^8lK:l\u0015\r\u001f'jM\u0016$\u0018.\\3\u0016\u0005\t]\u0014!\u0005;pW\u0016tW*\u0019=MS\u001a,G/[7fA\u0005)B-\u001a4bk2$Hk\\6f]J+g.Z<US6,\u0017A\u00063fM\u0006,H\u000e\u001e+pW\u0016t'+\u001a8foRKW.\u001a\u0011\u00021Q|7.\u001a8SK6|g/\u001a:TG\u0006t\u0017J\u001c;feZ\fG.A\ru_.,gNU3n_Z,'oU2b]&sG/\u001a:wC2\u0004\u0013\u0001\u00027pG.,\"Aa'\u0011\u0007\u001d\u0014i*C\u0002\u0003 \"\u0014aa\u00142kK\u000e$\u0018!\u00027pG.\u0004\u0013a\u0005;pW\u0016t7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014XC\u0001BT!\u0011\u0011IK!,\u000e\u0005\t-&bAAC+&!!q\u0016BV\u0005\u0001R6NT8eK\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c'jgR,g.\u001a:\u0002/Q|7.\u001a8DQ\u0006tw-\u001a'jgR,g.\u001a:`I\u0015\fH\u0003\u0002B/\u0005kC\u0011Ba.:\u0003\u0003\u0005\rAa*\u0002\u0007a$\u0013'\u0001\u000bu_.,gn\u00115b]\u001e,G*[:uK:,'\u000fI\u0001\bgR\f'\u000f^;q)\t\u0011i&\u0001\u0005tQV$Hm\\<o\u0003%aw.\u00193DC\u000eDW-\u0001\bhKR$vn[3o\rJ|WNW6\u0015\t\t\u001d'\u0011\u001a\t\u0006;\u0006m\u0015Q\u000f\u0005\b\u0003Cq\u0004\u0019AA\u0012\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\t\tu#q\u001a\u0005\b\u0003gz\u0004\u0019AA;\u0003]\u0001(/\u001a9be\u0016\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0003\u0003V\n\r\b\u0003CA\u0013\u0003O\n\u0019Ca6\u0011\t\te'q\\\u0007\u0003\u00057TAA!8\u0002\u0000\u0005)1o\u0019:b[&!!\u0011\u001dBn\u0005=\u00196M]1n\u0007J,G-\u001a8uS\u0006d\u0007b\u0002Bs\u0001\u0002\u0007\u00111E\u0001\u000bQ6\f7m\u0015;sS:<\u0017aC2sK\u0006$X\rV8lK:$BB!\u0018\u0003l\n=(1\u001fB|\u0005wDqA!<B\u0001\u0004\t9,A\u0003po:,'\u000fC\u0004\u0003r\u0006\u0003\r!a.\u0002\u001dQ|7.\u001a8SKF,Xm\u001d;fe\"9!Q_!A\u0002\u0005%\u0017\u0001\u0003:f]\u0016<XM]:\t\u000f\te\u0018\t1\u0001\u0003x\u0005iQ.\u0019=MS\u001a,G+[7f\u001bNDqA!@B\u0001\u0004\u0011y0\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB\u00191\u0011\u0001\u0016\u000e\u0003\u0001\n!B]3oK^$vn[3o))\u0011ifa\u0002\u0004\f\rm1q\u0004\u0005\b\u0007\u0013\u0011\u0005\u0019AA\\\u0003%\u0001(/\u001b8dSB\fG\u000eC\u0004\u0004\u000e\t\u0003\raa\u0004\u0002\t!l\u0017m\u0019\t\u0005\u0007#\u00199\"\u0004\u0002\u0004\u0014)\u00191Q\u00036\u0002\u00079Lw.\u0003\u0003\u0004\u001a\rM!A\u0003\"zi\u0016\u0014UO\u001a4fe\"91Q\u0004\"A\u0002\t]\u0014a\u0004:f]\u0016<H*\u001b4f)&lW-T:\t\u000f\r\u0005\"\t1\u0001\u0004$\u0005i!/\u001a8fo\u000e\u000bG\u000e\u001c2bG.\u00042a!\u0001,\u0003-)\b\u000fZ1uKR{7.\u001a8\u0015\t\tu3\u0011\u0006\u0005\b\u0003g\u001a\u0005\u0019AA;\u0003!9W\r\u001e+pW\u0016tG\u0003\u0002Bd\u0007_Aqa!\u0004E\u0001\u0004\u0019y!\u0001\bbY2|w/\u001a3U_J+g.Z<\u0015\r\u000556QGB\u001c\u0011\u001d\u0019I!\u0012a\u0001\u0003oCqa!\u000fF\u0001\u0004\ty*A\u0005u_.,g.\u00138g_R!!qYB\u001f\u0011\u001d\t\tC\u0012a\u0001\u0003G!B!!\u001e\u0004B!91\u0011H$A\u0002\u0005}\u0015aC3ya&\u0014X\rV8lK:$\"B!\u0018\u0004H\r%31JB(\u0011\u001d\u0019I\u0001\u0013a\u0001\u0003oCqa!\u0004I\u0001\u0004\u0019y\u0001C\u0004\u0004N!\u0003\rAa\u001e\u0002!\u0015D\b/\u001b:f\u0019&4W\rV5nK6\u001b\bbBB)\u0011\u0002\u000711K\u0001\u0017Kb\u0004\u0018N]3SKN\u0004xN\\:f\u0007\u0006dGNY1dWB\u00191\u0011\u0001\u0017\u0002\u0017I,Wn\u001c<f)>\\WM\u001c\u000b\u0005\u0005;\u001aI\u0006C\u0004\u0002\"%\u0003\r!a\t\u0002\u0017I,Wn\u001c<f\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0005;\u001ay\u0006C\u0004\u0002\")\u0003\r!a\t\u0002\u0019\u0015D\b/\u001b:f)>\\WM\\:\u0002-\u001d,G/\u00117m)>\\WM\\%oM>\u0014X.\u0019;j_:,\"aa\u001a\u0011\r\u0005-\u0017Q[AP\u0003%9W\r\u001e+pW\u0016t7\u000f\u0006\u0003\u0003\u0004\u000e5\u0004bBAU\u001b\u0002\u00071q\u000e\t\b;\u0006\r\u0018qTAW\u0003}!vn[3o\u0007\"\fgnZ3e\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM\u001d\t\u0004\u0007\u0003y%a\b+pW\u0016t7\t[1oO\u0016$gj\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feN!q\nXB=!\u0011\u0011Ika\u001f\n\t\ru$1\u0016\u0002\u0014\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM\u001d\u000b\u0003\u0007g\n1\u0003\u001d:pG\u0016\u001c8OT8uS\u001aL7-\u0019;j_:$BA!\u0018\u0004\u0006\"91qQ)A\u0002\u0005M\u0011\u0001\u0004;pW\u0016t\u0017\n\u001a\"zi\u0016\u001c\b")
public class DelegationTokenManager
implements KafkaMetricsGroup {
    private volatile DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private final long tokenRemoverScanInterval;
    private final Object kafka$server$DelegationTokenManager$$lock;
    private ZkNodeChangeNotificationListener tokenChangeListener;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal kafkaPrincipal, Option<List<KafkaPrincipal>> option, TokenInformation tokenInformation, Function1<String, Object> function1, Function1<KafkaPrincipal, Object> function12) {
        if (DelegationTokenManager$.MODULE$ == null) {
            throw null;
        }
        if (option.isDefined() && !((LinearSeqOptimized)option.get()).exists(arg_0 -> DelegationTokenManager$.$anonfun$filterToken$1$adapted(tokenInformation, arg_0))) {
            return false;
        }
        if (tokenInformation.ownerOrRenewer(kafkaPrincipal)) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)function1.apply((Object)tokenInformation.tokenId())) || BoxesRunTime.unboxToBoolean((Object)function12.apply((Object)tokenInformation.owner()));
    }

    public static Option<TokenInformation> fromBytes(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.fromBytes(byArray);
    }

    public static scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken delegationToken) {
        return DelegationTokenManager$.MODULE$.toJsonCompatibleMap(delegationToken);
    }

    public static byte[] createHmac(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(string, secretKey);
    }

    public static String createBase64HMAC(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createBase64HMAC(string, secretKey);
    }

    public static SecretKey createSecretKey(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.createSecretKey(byArray);
    }

    public static byte[] createHmac(String string, String string2) {
        return DelegationTokenManager$.MODULE$.createHmac(string, string2);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManager$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManager$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManager$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManager$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManager$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManager$.MODULE$.RenewersKey();
    }

    public static String TokenRequesterKey() {
        return DelegationTokenManager$.MODULE$.TokenRequesterKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManager$.MODULE$.OwnerKey();
    }

    public static String DefaultHmacAlgorithm() {
        return DelegationTokenManager$.MODULE$.DefaultHmacAlgorithm();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        if (this.TokenChangedNotificationHandler$module == null) {
            this.TokenChangedNotificationHandler$lzycompute$1();
        }
        return this.TokenChangedNotificationHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public long tokenRemoverScanInterval() {
        return this.tokenRemoverScanInterval;
    }

    public Object kafka$server$DelegationTokenManager$$lock() {
        return this.kafka$server$DelegationTokenManager$$lock;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    public void startup() {
        if (this.config().tokenAuthEnabled()) {
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
            this.tokenChangeListener().init();
        }
    }

    public void shutdown() {
        if (this.config().tokenAuthEnabled() && this.tokenChangeListener() != null) {
            this.tokenChangeListener().close();
            return;
        }
    }

    private void loadCache() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading the token cache. Total token count: ").append(tokens.size()).toString());
            tokens.foreach((Function1 & Serializable & scala.Serializable)tokenId -> {
                DelegationTokenManager.$anonfun$loadCache$2(this, tokenId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManager$$getTokenFromZk(String tokenId) {
        None$ none$;
        Option<TokenInformation> option = this.zkClient().getDelegationTokenInfo(tokenId);
        if (option instanceof Some) {
            TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            none$ = new Some((Object)new DelegationToken(tokenInformation, hmac));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public void kafka$server$DelegationTokenManager$$updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        scala.collection.immutable.Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(scramCredentialMap).asJava());
    }

    private scala.collection.immutable.Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
            scramCredentialMap.update((Object)mechanism.mechanismName(), (Object)DelegationTokenManager.scramCredential$1(mechanism, hmacString));
            return BoxedUnit.UNIT;
        });
        return scramCredentialMap.toMap(Predef$.MODULE$.$conforms());
    }

    public void createToken(KafkaPrincipal owner, KafkaPrincipal tokenRequester, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            responseCallback.apply((Object)new CreateTokenResult(owner, tokenRequester, -1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
            long issueTimeStamp = this.time().milliseconds();
            long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
            long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
            long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, tokenRequester, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            DelegationToken token = new DelegationToken(tokenInfo, hmac);
            this.updateToken(token);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Created a delegation token: ").append(tokenId).append(" for owner: ").append(owner).toString());
            responseCallback.apply((Object)new CreateTokenResult(owner, tokenRequester, issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            return;
        }
    }

    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!this.config().tokenAuthEnabled()) {
            renewCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                long now = this.time().milliseconds();
                TokenInformation tokenInfo = token.tokenInfo();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                    long renewTimeStamp = now + renewLifeTime;
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Delegation token renewed for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)renewCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_3 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    private void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.kafka$server$DelegationTokenManager$$updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        None$ none$;
        try {
            byte[] byteArray = new byte[hmac.remaining()];
            hmac.get(byteArray);
            String base64Pwd = Base64.getEncoder().encodeToString(byteArray);
            TokenInformation tokenInfo = this.tokenCache().tokenForHmac(base64Pwd);
            if (tokenInfo != null) {
                return new Some((Object)new DelegationToken(tokenInfo, byteArray));
            }
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while getting token for hmac", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals((Object)tokenInfo.owner()) || ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewers()).asScala()).toList().contains((Object)principal);
    }

    public Option<DelegationToken> getToken(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache().token(tokenId);
        if (tokenInfo != null) {
            return new Some((Object)this.getToken(tokenInfo));
        }
        return None$.MODULE$;
    }

    private DelegationToken getToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                TokenInformation tokenInfo = token.tokenInfo();
                long now = this.time().milliseconds();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (expireLifeTimeMs < 0L) {
                    this.removeToken(tokenInfo.tokenId());
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)now));
                } else {
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Updated expiry time for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_3 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_4 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    private void removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.kafka$server$DelegationTokenManager$$removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    public void kafka$server$DelegationTokenManager$$removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach((Function1 & Serializable & scala.Serializable)tokenInfo -> {
                DelegationTokenManager.$anonfun$expireTokens$1(this, tokenInfo);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.tokenCache().tokens()).asScala()).toList();
    }

    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        return (List)((List)this.getAllTokenInformation().filter(filterToken)).map((Function1 & Serializable & scala.Serializable)token -> this.getToken((TokenInformation)token), List$.MODULE$.canBuildFrom());
    }

    private final void TokenChangedNotificationHandler$lzycompute$1() {
        synchronized (this) {
            if (this.TokenChangedNotificationHandler$module == null) {
                this.TokenChangedNotificationHandler$module = new DelegationTokenManager$TokenChangedNotificationHandler$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$2(DelegationTokenManager $this, String tokenId) {
        try {
            Option<DelegationToken> option = $this.kafka$server$DelegationTokenManager$$getTokenFromZk(tokenId);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                $this.kafka$server$DelegationTokenManager$$updateCache(token);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Error while getting Token for tokenId: ").append(tokenId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
        }
    }

    private static final ScramCredential scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public static final /* synthetic */ void $anonfun$expireTokens$1(DelegationTokenManager $this, TokenInformation tokenInfo) {
        long now = $this.time().milliseconds();
        if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Delegation token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
            $this.removeToken(tokenInfo.tokenId());
        }
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Token Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenSecretKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(keyBytes)).isEmpty() ? null : DelegationTokenManager$.MODULE$.createSecretKey(keyBytes);
        this.tokenMaxLifetime = Predef$.MODULE$.Long2long(config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = Predef$.MODULE$.Long2long(config.delegationTokenExpiryTimeMs());
        this.tokenRemoverScanInterval = Predef$.MODULE$.Long2long(config.delegationTokenExpiryCheckIntervalMs());
        this.kafka$server$DelegationTokenManager$$lock = new Object();
        this.tokenChangeListener = null;
    }
}

