/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractLogReadResult;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLag$;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.FetchTxnCommitted$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\t\u0013\u0001]A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tA\u0001\u0011\t\u0011)A\u0005C!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011M\u0003!\u0011!Q\u0001\nQC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006]\u0002!\te\u001c\u0005\u0006w\u0002!I\u0001 \u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\tI\u0002\u0001C\u0005\u0003/Aq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u00055\u0002\u0001\"\u0011\u0002\u001e\taA)\u001a7bs\u0016$g)\u001a;dQ*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002%%\u00111D\u0005\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fa\u0001]1sC6\u001c\bCA\r\u001f\u0013\ty\"CA\u0006GKR\u001c\u0007\u000eU1sC6\u001c\u0018a\u00044fi\u000eD\u0007+\u0019:uSRLwN\\:\u0011\u0007\t:\u0013&D\u0001$\u0015\t!S%\u0001\u0006d_2dWm\u0019;j_:T\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\r\u00121aU3r!\u0011Q3&\f\u001d\u000e\u0003\u0015J!\u0001L\u0013\u0003\rQ+\b\u000f\\33!\tqc'D\u00010\u0015\t\u0001\u0014'\u0001\u0004d_6lwN\u001c\u0006\u0003+IR!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO&\u0011qg\f\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"!G\u001d\n\u0005i\u0012\"A\u0006)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0011$P\u0005\u0003}I\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0003rk>$\u0018\r\u0005\u0002\u001a\u0003&\u0011!I\u0005\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\ri&,'OR3uG\"|\u0005\u000f\u001e\t\u0004U\u0015;\u0015B\u0001$&\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\bM\u0016$8\r[3s\u0015\taE#\u0001\u0003uS\u0016\u0014\u0018B\u0001(J\u00051\u0001VM\u001c3j]\u001e4U\r^2i\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0005\u0002\u001a#&\u0011!K\u0005\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t)*v\u000bX\u0005\u0003-\u0016\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007\t:\u0003\f\u0005\u0003+W5J\u0006CA\r[\u0013\tY&C\u0001\nGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007C\u0001\u0016^\u0013\tqVE\u0001\u0003V]&$\u0018\u0001\b4fi\u000eD\u0007+\u0019:uSRLwN\u001c)sk:LgnZ#oC\ndW\r\u001a\t\u0003U\u0005L!AY\u0013\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\u0012\"\u001a4hQ&T7\u000e\\7\u0011\u0005e\u0001\u0001\"\u0002\u000f\n\u0001\u0004i\u0002\"\u0002\u0011\n\u0001\u0004\t\u0003\"B\u001e\n\u0001\u0004a\u0004\"B \n\u0001\u0004\u0001\u0005\"B\"\n\u0001\u0004!\u0005\"B(\n\u0001\u0004\u0001\u0006\"B*\n\u0001\u0004!\u0006\"B0\n\u0001\u0004\u0001\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003A\u0004\"!\u001d=\u000f\u0005I4\bCA:&\u001b\u0005!(BA;\u0017\u0003\u0019a$o\\8u}%\u0011q/J\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002xK\u0005\u0019b-\u001a;dQ>3gm]3u\u001b\u0016$\u0018\rZ1uCR)Q0!\u0001\u0002\u0006A\u0011\u0011D`\u0005\u0003\u007fJ\u0011\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011\u0019\t\u0019a\u0003a\u0001q\u0005ia-\u001a;dQ6+G/\u00193bi\u0006Dq!a\u0002\f\u0001\u0004\tI!A\u0005qCJ$\u0018\u000e^5p]B!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010Q\tqa\u00197vgR,'/\u0003\u0003\u0002\u0014\u00055!!\u0003)beRLG/[8o\u0003-!(/_\"p[BdW\r^3\u0015\u0003\u0001\f\u0011$[:O_:$\u0016.\u001a:GKR\u001c\u0007nQ8na2,G/\u00192mK\u0006aqN\\#ya&\u0014\u0018\r^5p]R\tA,A\u000bd_2dWm\u0019;M_\u001e\u0014V-\u00193SKN,H\u000e^:\u0015\u0005\u0005\r\u0002\u0003\u0002\u0012(\u0003K\u0001RAK\u0016.\u0003O\u00012!GA\u0015\u0013\r\tYC\u0005\u0002\u0016\u0003\n\u001cHO]1di2{wMU3bIJ+7/\u001e7u\u0003)ygnQ8na2,G/\u001a")
public class DelayedFetch
extends DelayedOperation {
    private final FetchParams params;
    private final Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchPartitions;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Option<PendingFetch> tierFetchOpt;
    private final BrokerTopicStats brokerTopicStats;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private final boolean fetchPartitionPruningEnabled;

    public String toString() {
        return new StringBuilder(37).append("DelayedFetch(params=").append(this.params).append(", numPartitions=").append(this.fetchPartitions.size()).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    private LogOffsetMetadata fetchOffsetMetadata(PartitionFetchMetadata fetchMetadata, Partition partition) {
        void var3_3;
        LogOffsetMetadata fetchOffsetMetadata;
        LogOffsetMetadata logOffsetMetadata = fetchOffsetMetadata = fetchMetadata.fetchOffsetMetadata();
        LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        if ((logOffsetMetadata == null ? logOffsetMetadata2 != null : !((Object)logOffsetMetadata).equals(logOffsetMetadata2)) && fetchOffsetMetadata.messageOffsetOnly()) {
            long fetchOffset = fetchMetadata.fetchOffset();
            fetchOffsetMetadata = (LogOffsetMetadata)partition.convertToLocalOffsetMetadata(fetchOffset).getOrElse((Function0 & Serializable & scala.Serializable)() -> LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
            fetchMetadata.setFetchOffsetMetadata(fetchOffsetMetadata);
        }
        return var3_3;
    }

    @Override
    public boolean tryComplete() {
        boolean bl;
        Option<PendingFetch> option = this.tierFetchOpt;
        if (option instanceof Some) {
            bl = ((PendingFetch)((Some)option).value()).isComplete() ? this.forceComplete() : false;
        } else if (None$.MODULE$.equals(option)) {
            bl = this.isNonTierFetchCompletable() ? this.forceComplete() : false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private boolean isNonTierFetchCompletable() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchPartitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$isNonTierFetchCompletable$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (accumulatedSize.elem < this.params.minBytes()) {
                return false;
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        this.tierFetchOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.markFetchExpired();
            return BoxedUnit.UNIT;
        });
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    private Seq<Tuple2<TopicIdPartition, AbstractLogReadResult>> collectLogReadResults() {
        return this.replicaManager.readFromLocalLog(this.params, this.fetchPartitions, this.quota, true);
    }

    @Override
    public void onComplete() {
        Option tierFetcherReadResults = this.tierFetchOpt.map((Function1 & Serializable & scala.Serializable)x$2 -> (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$2.finish()).asScala());
        Seq fetchPartitionData = (Seq)this.collectLogReadResults().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogReadResult logReadResult;
            if (x0$1 == null) throw new MatchError(null);
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            AbstractLogReadResult logReadResult2 = (AbstractLogReadResult)x0$1._2();
            if (logReadResult2 instanceof TierLogReadResult) {
                TierFetchResult tierFetchResult;
                TierLogReadResult tierLogReadResult = (TierLogReadResult)logReadResult2;
                logReadResult = tierLogReadResult.intoLogReadResult(tierFetchResult, !(tierFetchResult = (TierFetchResult)tierFetcherReadResults.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)tp.topicPartition())).getOrElse((Function0 & Serializable & scala.Serializable)() -> TierFetchResult.emptyFetchResult())).isEmpty());
            } else {
                if (!(logReadResult2 instanceof LogReadResult)) throw new MatchError((Object)logReadResult2);
                logReadResult = (LogReadResult)logReadResult2;
            }
            FetchLag$.MODULE$.maybeRecordConsumerFetchTimeLag(!$this.params.isFromFollower(), logReadResult, $this.brokerTopicStats);
            boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)logReadResult.toFetchPartitionData(isReassignmentFetch));
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$isNonTierFetchCompletable$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$1._1();
            PartitionFetchMetadata fetchPartition = (PartitionFetchMetadata)x0$1._2();
            if (!$this.fetchPartitionPruningEnabled || !fetchPartition.isCaughtUp()) {
                Optional<Integer> fetchLeaderEpoch = fetchPartition.currentLeaderEpoch();
                try {
                    LogOffsetMetadata logOffsetMetadata;
                    LogOffsetMetadata fetchOffset;
                    Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
                    LogOffsetMetadata logOffsetMetadata2 = fetchOffset = $this.fetchOffsetMetadata(fetchPartition, partition);
                    LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                    if (logOffsetMetadata2 == null) {
                        if (logOffsetMetadata3 == null) return;
                    } else if (((Object)logOffsetMetadata2).equals(logOffsetMetadata3)) return;
                    LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader());
                    FetchIsolation fetchIsolation = $this.params.isolation();
                    if (FetchLogEnd$.MODULE$.equals(fetchIsolation)) {
                        logOffsetMetadata = offsetSnapshot.logEndOffset();
                    } else if (FetchHighWatermark$.MODULE$.equals(fetchIsolation)) {
                        logOffsetMetadata = offsetSnapshot.highWatermark();
                    } else {
                        if (!FetchTxnCommitted$.MODULE$.equals(fetchIsolation)) throw new MatchError((Object)fetchIsolation);
                        logOffsetMetadata = offsetSnapshot.lastStableOffset();
                    }
                    if (logOffsetMetadata.messageOffset() != fetchOffset.messageOffset()) {
                        if (logOffsetMetadata.onOlderSegment(fetchOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this).append(" since it is fetching later segments of partition ").append(topicIdPartition).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                        }
                        if (fetchOffset.onOlderSegment(logOffsetMetadata)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Satisfying fetch ").append($this).append(" immediately since it is fetching older segments of partition ").append(topicIdPartition).append(".").toString());
                            if (!$this.params.isFromFollower()) throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                            if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId())) {
                                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                            }
                        } else if (fetchOffset.messageOffset() < logOffsetMetadata.messageOffset()) {
                            int bytesAvailable = package$.MODULE$.min(logOffsetMetadata.positionDiff(fetchOffset), fetchPartition.maxBytes());
                            if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId())) {
                                accumulatedSize$1.elem += bytesAvailable;
                            }
                        }
                    }
                    fetchPartition.lastFetchedEpoch().ifPresent(fetchEpoch -> {
                        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                        if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Could not obtain last offset for leader epoch for partition ").append(topicIdPartition).append(", epochEndOffset=").append(epochEndOffset).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                        }
                        if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchPartition.fetchOffset()) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Satisfying fetch ").append($this).append(" since it has diverging epoch requiring truncation for partition ").append(topicIdPartition).append(" epochEndOffset=").append(epochEndOffset).append(" fetchEpoch=").append(fetchEpoch).append(" fetchOffset=").append(fetchPartition.fetchOffset()).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                        }
                    });
                    return;
                }
                catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Broker is no longer the leader or follower of ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
                catch (KafkaStorageException kafkaStorageException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicIdPartition).append(" is in an offline log directory, satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
                catch (FencedLeaderEpochException fencedLeaderEpochException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicIdPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
            }
        }
        if (x0$1 == null) return;
        TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
        PartitionFetchMetadata fetchInfo = (PartitionFetchMetadata)x0$1._2();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Ignored caught-up partition ").append(topicPartition).append(" with ").append(fetchInfo).append(" for replica ").append($this.params.replicaId()).append(".").toString());
    }

    public DelayedFetch(FetchParams params, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchPartitions, ReplicaManager replicaManager, ReplicaQuota quota, Option<PendingFetch> tierFetchOpt, BrokerTopicStats brokerTopicStats, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback, boolean fetchPartitionPruningEnabled) {
        this.params = params;
        this.fetchPartitions = fetchPartitions;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.tierFetchOpt = tierFetchOpt;
        this.brokerTopicStats = brokerTopicStats;
        this.responseCallback = responseCallback;
        this.fetchPartitionPruningEnabled = fetchPartitionPruningEnabled;
        super(params.maxWaitMs(), DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

