/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestThrottleType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUq!\u0002\u00192\u0011\u00031d!\u0002\u001d2\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0006\u0001\u000b\u0011\u0002#\t\u000f!\u000b!\u0019!C\u0001\u0007\"1\u0011*\u0001Q\u0001\n\u0011CqAS\u0001C\u0002\u0013\u00051\n\u0003\u0004P\u0003\u0001\u0006I\u0001\u0014\u0005\b!\u0006\u0011\r\u0011\"\u0003R\u0011\u0019Q\u0016\u0001)A\u0005%\u001a!\u0001(\r\u0001\\\u0011!y6B!b\u0001\n\u0013\u0001\u0007\u0002\u00033\f\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0015\\!Q1A\u0005\n\u0019D\u0001b]\u0006\u0003\u0002\u0003\u0006Ia\u001a\u0005\ni.\u0011\t\u0011)A\u0005knD\u0001\u0002`\u0006\u0003\u0006\u0004%I! \u0005\n\u0003#Y!\u0011!Q\u0001\nyD!\"a\u0005\f\u0005\u000b\u0007I\u0011BA\u000b\u0011)\tYc\u0003B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003[Y!\u0011!Q\u0001\n\u0005=\u0002B\u0002!\f\t\u0003\t9\u0004C\u0005\u0002H-\u0011\r\u0011\"\u0003\u0002J!A\u0011\u0011K\u0006!\u0002\u0013\tY\u0005\u0003\u0005\u0002T-\u0001\r\u0011\"\u0003D\u0011%\t)f\u0003a\u0001\n\u0013\t9\u0006C\u0004\u0002d-\u0001\u000b\u0015\u0002#\t\u0011\u0005\u00154B1A\u0005R-Cq!a\u001a\fA\u0003%A\nC\u0005\u0002j-\u0011\r\u0011\"\u0003\u0002l!A\u0011QO\u0006!\u0002\u0013\ti\u0007C\u0005\u0002x-\u0011\r\u0011\"\u0001\u0002z!A\u0011\u0011Q\u0006!\u0002\u0013\tY\bC\u0004\u0002\u0004.!\t!!\u001f\t\u000f\u0005\u00155\u0002\"\u0001\u0002\b\"9\u0011QS\u0006\u0005\u0002\u0005]\u0005bBAO\u0017\u0011\u0005\u0011q\u0014\u0005\b\u0003G[A\u0011AAS\u0011\u001d\t9m\u0003C\u0001\u0003\u0013Dq!!4\f\t\u0003\ny\rC\u0004\u0002X.!\t&!7\t\u000f\u0005\u00158\u0002\"\u0003\u0002h\"1\u0011Q^\u0006\u0005B\rCq!a<\f\t\u0013\t\t\u0010\u0003\u0005\u0003\u0004-!\t&\rB\u0003\u0011\u001d\u0011Ia\u0003C\u0001\u0005\u0017AQB!\u0005\f!\u0003\r\t\u0011!C\u0005\u0005'Y\u0018!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJT!AM\u001a\u0002\rM,'O^3s\u0015\u0005!\u0014!B6bM.\f7\u0001\u0001\t\u0003o\u0005i\u0011!\r\u0002\u001a\u00072LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'o\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u00025E+x\u000e^1SKF,Xm\u001d;QKJ\u001cWM\u001c;EK\u001a\fW\u000f\u001c;\u0016\u0003\u0011\u0003\"aO#\n\u0005\u0019c$A\u0002#pk\ndW-A\u000eRk>$\u0018MU3rk\u0016\u001cH\u000fU3sG\u0016tG\u000fR3gCVdG\u000fI\u0001\u001b\u001d\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,\u0007+\u001a:TK\u000e|g\u000eZ\u0001\u001c\u001d\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,\u0007+\u001a:TK\u000e|g\u000e\u001a\u0011\u0002a\u0011+g-Y;mi&s\u0017m\u0019;jm\u0016,\u00050Z7qiN+gn]8s\u000bb\u0004\u0018N]1uS>tG+[7f'\u0016\u001cwN\u001c3t+\u0005a\u0005CA\u001eN\u0013\tqEH\u0001\u0003M_:<\u0017!\r#fM\u0006,H\u000e^%oC\u000e$\u0018N^3Fq\u0016l\u0007\u000f^*f]N|'/\u0012=qSJ\fG/[8o)&lWmU3d_:$7\u000fI\u0001\u0011\u000bb,W\u000e\u001d;TK:\u001cxN\u001d(b[\u0016,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bA\u0001\\1oO*\tq+\u0001\u0003kCZ\f\u0017BA-U\u0005\u0019\u0019FO]5oO\u0006\tR\t_3naR\u001cVM\\:pe:\u000bW.\u001a\u0011\u0014\u0005-a\u0006CA\u001c^\u0013\tq\u0016G\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw-F\u0001b!\t9$-\u0003\u0002dc\tA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#A4\u0011\u0005!\fX\"A5\u000b\u0005\u0015T'BA6m\u0003\u0019\u0019w.\\7p]*\u0011A'\u001c\u0006\u0003]>\fa!\u00199bG\",'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sS\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\tQLW.\u001a\t\u0003mfl\u0011a\u001e\u0006\u0003q*\fQ!\u001e;jYNL!A_<\u0003\tQKW.Z\u0005\u0003iv\u000b\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0003y\u00042a`A\u0007\u001d\u0011\t\t!!\u0003\u0011\u0007\u0005\rA(\u0004\u0002\u0002\u0006)\u0019\u0011qA\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tY\u0001P\u0001\u0007!J,G-\u001a4\n\u0007e\u000byAC\u0002\u0002\fq\n\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u00035\tXo\u001c;b\u0007\u0006dGNY1dWV\u0011\u0011q\u0003\t\u0006w\u0005e\u0011QD\u0005\u0004\u00037a$AB(qi&|g\u000e\u0005\u0003\u0002 \u0005\u001dRBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000bE,x\u000e^1\u000b\u0005Ib\u0017\u0002BA\u0015\u0003C\u00111c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fa\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\u000bbGRLg/\u001a+f]\u0006tGo]'b]\u0006<WM\u001d\t\u0006w\u0005e\u0011\u0011\u0007\t\u0004o\u0005M\u0012bAA\u001bc\t!\u0012i\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ$b\"!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\n)\u0005\u0005\u00028\u0017!)qL\u0006a\u0001C\")QM\u0006a\u0001O\")AO\u0006a\u0001k\")AP\u0006a\u0001}\"9\u00111\u0003\fA\u0002\u0005]\u0001bBA\u0017-\u0001\u0007\u0011qF\u0001\u0013i\"\u0014X-\u00193Vg\u0006<WmU3og>\u00148/\u0006\u0002\u0002LA\u0019q'!\u0014\n\u0007\u0005=\u0013G\u0001\nUQJ,\u0017\rZ+tC\u001e,7+\u001a8t_J\u001c\u0018a\u0005;ie\u0016\fG-V:bO\u0016\u001cVM\\:peN\u0004\u0013a\u00057bgRd\u0015.\\5u\u0007>\u0014(/Z2uS>t\u0017a\u00067bgRd\u0015.\\5u\u0007>\u0014(/Z2uS>tw\fJ3r)\u0011\tI&a\u0018\u0011\u0007m\nY&C\u0002\u0002^q\u0012A!\u00168ji\"A\u0011\u0011\r\u000e\u0002\u0002\u0003\u0007A)A\u0002yIE\nA\u0003\\1ti2KW.\u001b;D_J\u0014Xm\u0019;j_:\u0004\u0013!E7bqRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0006\u0011R.\u0019=UQJ|G\u000f\u001e7f)&lW-T:!\u0003A)\u00070Z7qi6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002nA!\u0011qNA9\u001b\u0005Q\u0017bAA:U\nQQ*\u001a;sS\u000et\u0015-\\3\u0002#\u0015DX-\u001c9u\u001b\u0016$(/[2OC6,\u0007%\u0001\u0007fq\u0016l\u0007\u000f^*f]N|'/\u0006\u0002\u0002|A\u0019\u0001.! \n\u0007\u0005}\u0014N\u0001\u0004TK:\u001cxN]\u0001\u000eKb,W\u000e\u001d;TK:\u001cxN\u001d\u0011\u0002/9|g.\u0012=f[B$8)\u00199bG&$\u0018pU3og>\u0014\u0018!\u0007:fG>\u0014H-\u0012=f[B$h*\u001a;x_J\\G\u000b\u001b:fC\u0012$\u0002\"!\u0017\u0002\n\u00065\u0015\u0011\u0013\u0005\u0007\u0003\u0017\u001b\u0003\u0019\u0001#\u0002\u000bY\fG.^3\t\r\u0005=5\u00051\u0001\u007f\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011\u0019\t\u0019j\ta\u0001\u0019\u00061A/[7f\u001bN\fAC]3d_J$W\t_3naRLu\u000e\u00165sK\u0006$GCBA-\u00033\u000bY\n\u0003\u0004\u0002\f\u0012\u0002\r\u0001\u0012\u0005\u0007\u0003'#\u0003\u0019\u0001'\u0002+I,Wn\u001c<f\u0019&\u001cH/\u001a8fe6+GO]5dgR!\u0011\u0011LAQ\u0011\u0019\ty)\na\u0001}\u0006yR.Y=cKJ+7m\u001c:e\u0003:$w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\r\u0005\u001d\u0016QVAc!\rY\u0014\u0011V\u0005\u0004\u0003Wc$aA%oi\"9\u0011q\u0016\u0014A\u0002\u0005E\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003g\u000byL\u0004\u0003\u00026\u0006mVBAA\\\u0015\r\tIlM\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ti,a.\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011\u0011YAb\u0005\u001d\u0011V-];fgRTA!!0\u00028\"1\u00111\u0013\u0014A\u00021\u000b\u0011#\\1zE\u0016\u0014VmY8sI\u0016CX-\u001c9u)\u0011\tI&a3\t\u000f\u0005=v\u00051\u0001\u00022\u0006\u0019\"-Y2laJ,7o];sK\u0016s\u0017M\u00197fIV\u0011\u0011\u0011\u001b\t\u0004w\u0005M\u0017bAAky\t9!i\\8mK\u0006t\u0017\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002n\u0005m\u0007bBAoS\u0001\u0007\u0011q\\\u0001\u0010cV|G/Y'fiJL7\rV1hgB)q0!9\u007f}&!\u00111]A\b\u0005\ri\u0015\r]\u0001\u0012]\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,Gc\u0001#\u0002j\"1\u00111\u001e\u0016A\u00021\u000bQA\\1o_N\f1cZ3u\u0005J|7.\u001a:Rk>$\u0018\rT5nSR\f!C]3d_J$g*\u001a;x_J\\Wk]1hKRQ\u0011\u0011LAz\u0003k\f9P!\u0001\t\r\u0005-E\u00061\u0001E\u0011\u0019\ty\t\fa\u0001}\"9\u0011\u0011 \u0017A\u0002\u0005m\u0018\u0001\u0004;ie>$H\u000f\\3UsB,\u0007cA\u001c\u0002~&\u0019\u0011q`\u0019\u0003'I+\u0017/^3tiRC'o\u001c;uY\u0016$\u0016\u0010]3\t\r\u0005ME\u00061\u0001M\u0003Y)\b\u000fZ1uK\n\u0013xn[3s#V|G/\u0019'j[&$H\u0003BA-\u0005\u000fAa!a%.\u0001\u0004a\u0015AF;qI\u0006$X-\u00113kkN$X\rZ\"ba\u0006\u001c\u0017\u000e^=\u0015\u0007\u0011\u0013i\u0001\u0003\u0004\u0003\u00109\u0002\r\u0001R\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;MS6LG/\u0001\u0006tkB,'\u000f\n;j[\u0016,\u0012!\u001e")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final long maxThrottleTimeMs;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static long DefaultInactiveExemptSensorExpirationTimeSeconds() {
        return ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds();
    }

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static double QuotaRequestPercentDefault() {
        return ClientRequestQuotaManager$.MODULE$.QuotaRequestPercentDefault();
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    @Override
    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    public void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    public void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        double reqIoThreadPercentage = this.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, timeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, timeMs, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> {
                this.recordNoThrottle(request.session(), request.header().clientId(), this.nanosToPercentage(timeNanos));
                this.recordNetworkUsage(this.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds());
            }));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), reqIoThreadPercentage, timeMs);
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNetworkUsage(this.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds())));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = super.time().milliseconds();
        double reqIoThreadPercentage = this.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExemptNetworkThread(this.nanosToPercentage(timeNanos), listenerName, this.super$time().milliseconds())));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNetworkUsage(this.nanosToPercentage(timeNanos), listenerName, ExemptRequest$.MODULE$, this.super$time().milliseconds())));
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        double d = metricOpt instanceof Some ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue()) : Double.MAX_VALUE;
        return d;
    }

    private void recordNetworkUsage(double value, String listenerName, RequestThrottleType throttleType, long timeMs) {
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, this.threadUsageSensors().recordNetworkThreadUsage$default$4());
        if (this.quotasEnabled() && NonExemptRequest$.MODULE$.equals(throttleType)) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            return;
        }
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), ThreadUsageMetrics$.MODULE$.ioThreadsUsage$default$2());
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, ThreadUsageMetrics$.MODULE$.networkThreadsUsage$default$3());
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptIoThreadLimit + nonExemptNetworkThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
        }
    }

    public double updateAdjustedCapacity(double brokerRequestLimit) {
        double d;
        double queueSize = RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), this.dynamicBackpressureConfig().queueSizePercentile(), RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize$default$3());
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota();
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = this.lastLimitCorrection() < maxAdjustmentLimit ? this.lastLimitCorrection() + BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment() : this.lastLimitCorrection();
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment());
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(queueSize).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback, activeTenantsManager, ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        this.threadUsageSensors = new ThreadUsageSensors(metrics, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds());
        this.lastLimitCorrection = 0.0;
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.add(this.exemptMetricName(), (MeasurableStat)new Rate());
            return BoxedUnit.UNIT;
        });
    }
}

