/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.BrokerBlockingSender$;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Option;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u000b\u0017\u0011\u0003Yb!B\u000f\u0017\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\"B\u0014\u0002\t\u0003A\u0003\"CA@\u0003E\u0005I\u0011AAA\r\u0011ib\u0003\u0001\u0016\t\u00119*!\u0011!Q\u0001\n=B\u0001\"N\u0003\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0015\u0011\t\u0011)A\u0005u!AQ(\u0002B\u0001B\u0003%a\b\u0003\u0005L\u000b\t\u0005\t\u0015!\u0003;\u0011!aUA!A!\u0002\u0013i\u0005\u0002C*\u0006\u0005\u0003\u0005\u000b\u0011\u0002+\t\u000b\u0015*A\u0011A.\t\u000f\r,!\u0019!C\u0001I\"1\u0001.\u0002Q\u0001\n\u0015DQ![\u0003\u0005B)DQa[\u0003\u0005B1Dq!a\u000b\u0006\t\u0003\ni\u0003C\u0004\u00026\u0015!\t%!\f\t\u000f\u0005]R\u0001\"\u0011\u0002:\u0005!\"I]8lKJ\u0014En\\2lS:<7+\u001a8eKJT!a\u0006\r\u0002\rM,'O^3s\u0015\u0005I\u0012!B6bM.\f7\u0001\u0001\t\u00039\u0005i\u0011A\u0006\u0002\u0015\u0005J|7.\u001a:CY>\u001c7.\u001b8h'\u0016tG-\u001a:\u0014\u0005\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027\u0005)\u0011\r\u001d9msR\t\u0012&a\u0013\u0002N\u0005=\u0013QLA0\u0003C\n)'a\u001c\u0011\u0005q)1cA\u0003 WA\u0011A\u0004L\u0005\u0003[Y\u0011AB\u00117pG.LgnZ*f]\u0012\fAb]8ve\u000e,'I]8lKJ\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\r\u0002\u000f\rdWo\u001d;fe&\u0011A'\r\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u00031\u0011'o\\6fe\u000e{gNZ5h!\tar'\u0003\u00029-\tY1*\u00194lC\u000e{gNZ5h\u00035\u0019xnY6fiRKW.Z8viB\u0011\u0001eO\u0005\u0003y\u0005\u00121!\u00138u\u0003\u0011!\u0018.\\3\u0011\u0005}JU\"\u0001!\u000b\u0005\u0005\u0013\u0015!B;uS2\u001c(BA\"E\u0003\u0019\u0019w.\\7p]*\u0011\u0011$\u0012\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u0001\n!A+[7f\u0003%1W\r^2iKJLE-A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\u000bqa\u00197jK:$8/\u0003\u0002S\u001f\nY1*\u00194lC\u000ec\u0017.\u001a8u\u0003q\u0011XmY8oM&<WO]1cY\u0016\u001c\u0005.\u00198oK2\u0014U/\u001b7eKJ\u00042\u0001I+X\u0013\t1\u0016E\u0001\u0004PaRLwN\u001c\t\u00031fk\u0011AQ\u0005\u00035\n\u0013aBU3d_:4\u0017nZ;sC\ndW\r\u0006\u0005*9vsv\fY1c\u0011\u0015qS\u00021\u00010\u0011\u0015)T\u00021\u00017\u0011\u0015IT\u00021\u0001;\u0011\u0015iT\u00021\u0001?\u0011\u0015YU\u00021\u0001;\u0011\u0015aU\u00021\u0001N\u0011\u0015\u0019V\u00021\u0001U\u0003)\u0019x.\u001e:dK:{G-Z\u000b\u0002KB\u0011\u0001LZ\u0005\u0003O\n\u0013AAT8eK\u0006Y1o\\;sG\u0016tu\u000eZ3!\u00039\u0011'o\\6fe\u0016sG\rU8j]R$\u0012aL\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0002naB\u0011aJ\\\u0005\u0003_>\u0013ab\u00117jK:$(+Z:q_:\u001cX\rC\u0003r#\u0001\u0007!/\u0001\bsKF,Xm\u001d;Ck&dG-\u001a:1\u0007M\f9\u0002E\u0003u\u0003\u001b\t\u0019BD\u0002v\u0003\u000fq1A^A\u0002\u001d\r9\u0018\u0011\u0001\b\u0003q~t!!\u001f@\u000f\u0005ilX\"A>\u000b\u0005qT\u0012A\u0002\u001fs_>$h(C\u0001I\u0013\t1u)\u0003\u0002\u001a\u000b&\u00111\tR\u0005\u0004\u0003\u000b\u0011\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005%\u00111B\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti*\u0019\u0011Q\u0001\"\n\t\u0005=\u0011\u0011\u0003\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tI!a\u0003\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t-\tI\u0002]A\u0001\u0002\u0003\u0015\t!a\u0007\u0003\u0007}##'\u0005\u0003\u0002\u001e\u0005\r\u0002c\u0001\u0011\u0002 %\u0019\u0011\u0011E\u0011\u0003\u000f9{G\u000f[5oOB!\u0011QEA\u0014\u001b\t\tY!\u0003\u0003\u0002*\u0005-!aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f)\t\ty\u0003E\u0002!\u0003cI1!a\r\"\u0005\u0011)f.\u001b;\u0002\u000b\rdwn]3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000f\u0011\t\u0005u\u0012Q\t\b\u0005\u0003\u007f\t\t\u0005\u0005\u0002{C%\u0019\u00111I\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019%\t\u0005\u0006]\r\u0001\ra\f\u0005\u0006k\r\u0001\rA\u000e\u0005\b\u0003#\u001a\u0001\u0019AA*\u0003\u001diW\r\u001e:jGN\u0004B!!\u0016\u0002Z5\u0011\u0011q\u000b\u0006\u0004\u0003#\u0012\u0015\u0002BA.\u0003/\u0012q!T3ue&\u001c7\u000fC\u0003>\u0007\u0001\u0007a\bC\u0003L\u0007\u0001\u0007!\bC\u0004\u0002d\r\u0001\r!a\u000f\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!a\u001a\u0004\u0001\u0004\tI'\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u00042aPA6\u0013\r\ti\u0007\u0011\u0002\u000b\u0019><7i\u001c8uKb$\b\"CA9\u0007A\u0005\t\u0019AA:\u0003=)\u0007\u0010\u001e:b\u001b\u0016$(/[2UC\u001e\u001c\b\u0003CA;\u0003w\nY$a\u000f\u000e\u0005\u0005]$bAA=C\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0014q\u000f\u0002\u0004\u001b\u0006\u0004\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0005\r%\u0006BA:\u0003\u000b[#!a\"\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#\u000b\u0013AC1o]>$\u0018\r^5p]&!\u0011QSAF\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class BrokerBlockingSender
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final int socketTimeout;
    private final Time time;
    private final int fetcherId;
    private final KafkaClient networkClient;
    private final Option<Reconfigurable> reconfigurableChannelBuilder;
    private final Node sourceNode;

    public static Map<String, String> apply$default$8() {
        return BrokerBlockingSender$.MODULE$.apply$default$8();
    }

    public static BrokerBlockingSender apply(BrokerEndPoint brokerEndPoint, KafkaConfig kafkaConfig, Metrics metrics, Time time, int n, String string, LogContext logContext, Map<String, String> map) {
        return BrokerBlockingSender$.MODULE$.apply(brokerEndPoint, kafkaConfig, metrics, time, n, string, logContext, map);
    }

    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient, (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout)) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient.newClientRequest(Integer.toString(this.sourceBroker.id()), requestBuilder, this.time.milliseconds(), true);
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient, (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient.close(Integer.toString(this.sourceBroker.id()));
            throw e;
        }
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder.foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient.initiateClose();
    }

    @Override
    public void close() {
        this.networkClient.close();
    }

    public String toString() {
        return new StringBuilder(47).append("BrokerBlockingSender(sourceBroker=").append(this.sourceBroker).append(", fetcherId=").append(this.fetcherId).append(")").toString();
    }

    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, int socketTimeout, Time time, int fetcherId, KafkaClient networkClient, Option<Reconfigurable> reconfigurableChannelBuilder) {
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.socketTimeout = socketTimeout;
        this.time = time;
        this.fetcherId = fetcherId;
        this.networkClient = networkClient;
        this.reconfigurableChannelBuilder = reconfigurableChannelBuilder;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
    }
}

