/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.messages.KafkaFetchFtpsRequest;
import kafka.restore.messages.KafkaFetchFtpsResponse;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.schedulers.RetryableException;
import kafka.restore.schedulers.SchedulerUtil;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpsFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpsFetcher.class);
    private static final String HTTP_HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final Pattern FTPS_FILE_PATTERN = Pattern.compile(".+filename=\"(.+?)\".*");
    private CloseableHttpClient httpClient;
    private KafkaFetchFtpsRequest request;
    private final String ftpsDirPath;
    private final ThreadPoolExecutor executor;
    private final Time time;
    private RestoreMetricsManager metrics;

    public FtpsFetcher(CloseableHttpClient httpClient, KafkaFetchFtpsRequest request, String ftpsDirPath, Time time, RestoreMetricsManager metrics, ThreadPoolExecutor executor) {
        this.httpClient = httpClient;
        this.request = request;
        this.ftpsDirPath = ftpsDirPath;
        this.time = time;
        this.metrics = metrics;
        this.executor = executor;
    }

    public CompletableFuture<KafkaFetchFtpsResponse> fetchFtpsFile() {
        return CompletableFuture.supplyAsync(() -> {
            KafkaFetchFtpsResponse ftpsFileName2222222222;
            long startTimeMs;
            CloseableHttpResponse httpResponse;
            block17: {
                block15: {
                    KafkaFetchFtpsResponse kafkaFetchFtpsResponse;
                    block16: {
                        httpResponse = null;
                        startTimeMs = this.time.hiResClockMs();
                        HttpPost post = SchedulerUtil.buildKafkaHttpRequest(this.request);
                        httpResponse = this.httpClient.execute((HttpUriRequest)post);
                        if (httpResponse.getStatusLine().getStatusCode() != 200) break block15;
                        String ftpsFileName2222222222 = FtpsFetcher.getFtpsFileName(this.ftpsDirPath, this.request.getTopic(), this.request.getPartition(), httpResponse);
                        SchedulerUtil.saveHttpResponseToFile((HttpResponse)httpResponse, ftpsFileName2222222222);
                        LOGGER.debug("download ftps file to local success: " + ftpsFileName2222222222);
                        kafkaFetchFtpsResponse = new KafkaFetchFtpsResponse(0, this.request.getTopic(), this.request.getPartition(), this.request.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS, ftpsFileName2222222222);
                        if (httpResponse == null) break block16;
                        try {
                            httpResponse.close();
                        }
                        catch (IOException e) {
                            LOGGER.error(String.format("[%s]: Received IOException while closing HTTP response after replying to FetchFtpsRequest", this.request.getTopicPartition()), (Throwable)e);
                        }
                    }
                    if (this.metrics != null) {
                        long restoreFetchFtpsMs = this.time.hiResClockMs() - startTimeMs;
                        this.metrics.restoreFetchFtpsMs().record((double)restoreFetchFtpsMs);
                    }
                    return kafkaFetchFtpsResponse;
                }
                LOGGER.error(String.format("[%s]: received non-retryable failure status code, http response error status: %s, http response body: %s.", this.request.getTopicPartition(), httpResponse.getStatusLine().getStatusCode(), httpResponse.getEntity().toString()));
                ftpsFileName2222222222 = new KafkaFetchFtpsResponse(0, this.request.getTopic(), this.request.getPartition(), this.request.getUuid(), MessageStatusCode.EXTERNAL_SERVICE_ERROR, MessageResult.FAILURE);
                if (httpResponse == null) break block17;
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    LOGGER.error(String.format("[%s]: Received IOException while closing HTTP response after replying to FetchFtpsRequest", this.request.getTopicPartition()), (Throwable)e);
                }
            }
            if (this.metrics != null) {
                long restoreFetchFtpsMs = this.time.hiResClockMs() - startTimeMs;
                this.metrics.restoreFetchFtpsMs().record((double)restoreFetchFtpsMs);
            }
            return ftpsFileName2222222222;
            catch (Exception e) {
                try {
                    String errorMessage = String.format("[%s]: Exception during downloading ftps file, throw retryable exception", this.request.getTopicPartition());
                    LOGGER.error(errorMessage, (Throwable)e);
                    throw new RetryableException(errorMessage, e);
                }
                catch (Throwable throwable) {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error(String.format("[%s]: Received IOException while closing HTTP response after replying to FetchFtpsRequest", this.request.getTopicPartition()), (Throwable)e2);
                        }
                    }
                    if (this.metrics != null) {
                        long restoreFetchFtpsMs2 = this.time.hiResClockMs() - startTimeMs;
                        this.metrics.restoreFetchFtpsMs().record((double)restoreFetchFtpsMs2);
                    }
                    throw throwable;
                }
            }
        }, this.executor);
    }

    public static String getFtpsFileName(String ftpsDirPath, String topic, int partition, CloseableHttpResponse response) {
        Matcher m;
        String contentDisposition = response.getLastHeader(HTTP_HEADER_CONTENT_DISPOSITION).getValue();
        if (contentDisposition != null && (m = FTPS_FILE_PATTERN.matcher(contentDisposition)).find()) {
            String fileName = m.group(1);
            String suffix = fileName.substring(fileName.indexOf(46));
            return ftpsDirPath + "/ftps-" + topic + "-" + partition + suffix;
        }
        return ftpsDirPath + "/ftps-" + topic + "-" + partition;
    }
}

