/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kafka.restore.db.Job;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.db.RestoreDB;

public class FileRestoreDB
implements RestoreDB {
    private File dbFile = new File("restore.db");
    private File tmpFile = new File("restore.db.tmp");
    private List<Job> jobs;

    public FileRestoreDB() {
        this.jobs = this.recover();
    }

    public FileRestoreDB(List<Job> jobs) {
        this.jobs = jobs;
    }

    @Override
    public List<Job> getJobs() {
        return this.jobs;
    }

    @Override
    public void addPartitionRestoreContext(PartitionRestoreContext partitionRestoreContext) {
        this.currentJob().addPartitionRestoreContext(partitionRestoreContext);
    }

    @Override
    public int getPartitionContextCount() {
        if (this.currentJob() == null) {
            return 0;
        }
        return this.currentJob().getPartitionCount();
    }

    public List<Job> recover() {
        return new ArrayList<Job>(Arrays.asList(new Job[0]));
    }

    @Override
    public Job currentJob() {
        if (this.jobs.size() == 0) {
            return null;
        }
        return this.jobs.get(this.jobs.size() - 1);
    }
}

