/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.BrokerLoad;
import kafka.network.ProcessorTimeoutOptions;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SocketServer$ {
    public static SocketServer$ MODULE$;
    private final String MetricsGroup;
    private final Set<String> ReconfigurableConfigs;
    private final Set<String> ListenerQuotaReconfigurableConfigs;
    private final Set<String> ListenerNonQuotaReconfigurableConfigs;

    static {
        new SocketServer$();
    }

    public RequestCallback $lessinit$greater$default$6() {
        return new DefaultRequestCallbackManager();
    }

    public AuditLogProvider $lessinit$greater$default$7() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Option<ReverseNode.ReverseCallback> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public Option<BrokerLoad> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    public String MetricsGroup() {
        return this.MetricsGroup;
    }

    public Set<String> ReconfigurableConfigs() {
        return this.ReconfigurableConfigs;
    }

    public Set<String> ListenerQuotaReconfigurableConfigs() {
        return this.ListenerQuotaReconfigurableConfigs;
    }

    public Set<String> ListenerNonQuotaReconfigurableConfigs() {
        return this.ListenerNonQuotaReconfigurableConfigs;
    }

    public void closeSocket(SocketChannel channel, Logging logging) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> channel.socket().close(), logging, Level.ERROR);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> channel.close(), logging, Level.ERROR);
    }

    public void chainFuture(CompletableFuture<Void> sourceFuture, CompletableFuture<Void> destinationFuture) {
        sourceFuture.whenComplete((x$16, t) -> {
            if (t != null) {
                destinationFuture.completeExceptionally((Throwable)t);
                return;
            }
            destinationFuture.complete(null);
        });
    }

    public ProcessorTimeoutOptions getTimeoutOptionsFromConfig(KafkaConfig config, ListenerName listenerName) {
        Map<String, Object> parsedConfigs = config.valuesWithPrefixOverride(listenerName.configPrefix());
        long connectionMaxIdleMs = BoxesRunTime.unboxToLong((Object)parsedConfigs.getOrDefault(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), config.getLong(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp())));
        long connectionMaxAgeMs = BoxesRunTime.unboxToLong((Object)parsedConfigs.getOrDefault(KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), config.getLong(KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp())));
        long connectionMinCloseIntervalMs = BoxesRunTime.unboxToLong((Object)parsedConfigs.getOrDefault(KafkaConfig$.MODULE$.ConnectionMinExpireIntervalMsProp(), config.getLong(KafkaConfig$.MODULE$.ConnectionMinExpireIntervalMsProp())));
        return new ProcessorTimeoutOptions(connectionMaxIdleMs, connectionMaxAgeMs, connectionMinCloseIntervalMs);
    }

    private SocketServer$() {
        MODULE$ = this;
        this.MetricsGroup = "socket-server-metrics";
        this.ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.SocketSendBufferBytesProp(), KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), KafkaConfig$.MODULE$.MaxConnectionsProp(), KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp()}));
        this.ListenerQuotaReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp(), KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp(), KafkaConfig$.MODULE$.MaxConnectionRatePerIpThrottleEnableThresholdProp()}));
        this.ListenerNonQuotaReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp()}));
    }
}

