/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.metrics.LinuxCpuMetricsCollector$SystemCpuTime$;
import net.jcip.annotations.GuardedBy;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001\u00027n\u0001ID\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u0017\u0001!Q1A\u0005\u0002\u00055\u0001BCA\u0015\u0001\t\u0005\t\u0015!\u0003\u0002\u0010!Q\u00111\u0006\u0001\u0003\u0006\u0004%\t!!\f\t\u0015\u0005m\u0002A!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002>\u0001\u0011)\u0019!C\u0001\u0003\u007fA!\"!\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA!\u0011\u001d\ty\u0005\u0001C\u0001\u0003#B\u0011\"a\u0018\u0001\u0005\u0004%I!!\u0019\t\u0011\u0005]\u0004\u0001)A\u0005\u0003GB\u0011\"!\u001f\u0001\u0005\u0004%I!!\u0019\t\u0011\u0005m\u0004\u0001)A\u0005\u0003GB\u0011\"! \u0001\u0005\u0004%I!a \t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u0003C\u0011\"a&\u0001\u0001\u0004%I!!'\t\u0013\u0005m\u0005\u00011A\u0005\n\u0005u\u0005\u0002CAU\u0001\u0001\u0006K!!\u000e\t\u0013\u0005\u0015\u0007\u00011A\u0005\n\u0005\u001d\u0007\"CAh\u0001\u0001\u0007I\u0011BAi\u0011!\t)\u000e\u0001Q!\n\u0005%\u0007\"CAm\u0001\u0001\u0007I\u0011BAd\u0011%\tY\u000e\u0001a\u0001\n\u0013\ti\u000e\u0003\u0005\u0002b\u0002\u0001\u000b\u0015BAe\u0011%\t)\u000f\u0001a\u0001\n\u0013\t9\rC\u0005\u0002h\u0002\u0001\r\u0011\"\u0003\u0002j\"A\u0011Q\u001e\u0001!B\u0013\tI\rC\u0005\u0002r\u0002\u0011\r\u0011\"\u0003\u0002\u0000!A\u00111\u001f\u0001!\u0002\u0013\t\t\tC\u0005\u0002v\u0002\u0001\r\u0011\"\u0003\u0002\u001a\"I\u0011q\u001f\u0001A\u0002\u0013%\u0011\u0011 \u0005\t\u0003{\u0004\u0001\u0015)\u0003\u00026!I!1\u0001\u0001A\u0002\u0013%\u0011\u0011\u0014\u0005\n\u0005\u000b\u0001\u0001\u0019!C\u0005\u0005\u000fA\u0001Ba\u0003\u0001A\u0003&\u0011Q\u0007\u0005\n\u0005\u001f\u0001!\u0019!C\u0005\u0005#A\u0001Ba\b\u0001A\u0003%!1\u0003\u0005\n\u0005C\u0001!\u0019!C\u0005\u0005#A\u0001Ba\t\u0001A\u0003%!1\u0003\u0005\n\u0005K\u0001!\u0019!C\u0005\u0005OA\u0001Ba\u000b\u0001A\u0003%!\u0011\u0006\u0005\n\u0005[\u0001!\u0019!C\u0005\u0003\u007fB\u0001Ba\f\u0001A\u0003%\u0011\u0011\u0011\u0005\n\u0005c\u0001\u0001\u0019!C\u0005\u00033C\u0011Ba\r\u0001\u0001\u0004%IA!\u000e\t\u0011\te\u0002\u0001)Q\u0005\u0003kA\u0011Ba\u0010\u0001\u0001\u0004%I!!'\t\u0013\t\u0005\u0003\u00011A\u0005\n\t\r\u0003\u0002\u0003B$\u0001\u0001\u0006K!!\u000e\u0007\r\t-\u0003\u0001\u0011B'\u0011)\u0011Y&\rBK\u0002\u0013\u0005\u0011\u0011\u0014\u0005\u000b\u0005;\n$\u0011#Q\u0001\n\u0005U\u0002B\u0003B0c\tU\r\u0011\"\u0001\u0002\u001a\"Q!\u0011M\u0019\u0003\u0012\u0003\u0006I!!\u000e\t\u0015\t\r\u0014G!f\u0001\n\u0003\tI\n\u0003\u0006\u0003fE\u0012\t\u0012)A\u0005\u0003kA!Ba\u001a2\u0005+\u0007I\u0011AAM\u0011)\u0011I'\rB\tB\u0003%\u0011Q\u0007\u0005\u000b\u0005W\n$Q3A\u0005\u0002\u0005e\u0005B\u0003B7c\tE\t\u0015!\u0003\u00026!Q!qN\u0019\u0003\u0016\u0004%\t!!'\t\u0015\tE\u0014G!E!\u0002\u0013\t)\u0004\u0003\u0006\u0003tE\u0012)\u001a!C\u0001\u00033C!B!\u001e2\u0005#\u0005\u000b\u0011BA\u001b\u0011)\u00119(\rBK\u0002\u0013\u0005\u0011\u0011\u0014\u0005\u000b\u0005s\n$\u0011#Q\u0001\n\u0005U\u0002B\u0003B>c\tU\r\u0011\"\u0001\u0002\u001a\"Q!QP\u0019\u0003\u0012\u0003\u0006I!!\u000e\t\u0015\t}\u0014G!f\u0001\n\u0003\tI\n\u0003\u0006\u0003\u0002F\u0012\t\u0012)A\u0005\u0003kAq!a\u00142\t\u0003\u0011\u0019\tC\u0005\u0003\u001eF\u0012\r\u0011\"\u0001\u0002\u001a\"A!qT\u0019!\u0002\u0013\t)\u0004C\u0005\u0003\"F\n\t\u0011\"\u0001\u0003$\"I!\u0011X\u0019\u0012\u0002\u0013\u0005!1\u0018\u0005\n\u0005#\f\u0014\u0013!C\u0001\u0005wC\u0011Ba52#\u0003%\tAa/\t\u0013\tU\u0017'%A\u0005\u0002\tm\u0006\"\u0003BlcE\u0005I\u0011\u0001B^\u0011%\u0011I.MI\u0001\n\u0003\u0011Y\fC\u0005\u0003\\F\n\n\u0011\"\u0001\u0003<\"I!Q\\\u0019\u0012\u0002\u0013\u0005!1\u0018\u0005\n\u0005?\f\u0014\u0013!C\u0001\u0005wC\u0011B!92#\u0003%\tAa/\t\u0013\t\r\u0018'!A\u0005B\t\u0015\b\"\u0003Byc\u0005\u0005I\u0011\u0001Bz\u0011%\u0011Y0MA\u0001\n\u0003\u0011i\u0010C\u0005\u0004\bE\n\t\u0011\"\u0011\u0004\n!I1qC\u0019\u0002\u0002\u0013\u00051\u0011\u0004\u0005\n\u0007G\t\u0014\u0011!C!\u0007KA\u0011ba\n2\u0003\u0003%\te!\u000b\t\u0013\r-\u0012'!A\u0005B\r5r!CB\u0019\u0001\u0005\u0005\t\u0012AB\u001a\r%\u0011Y\u0005AA\u0001\u0012\u0003\u0019)\u0004C\u0004\u0002Pu#\taa\u0011\t\u0013\r\u001dR,!A\u0005F\r%\u0002\"CB#;\u0006\u0005I\u0011QB$\u0011%\u0019i&XA\u0001\n\u0003\u001by\u0006C\u0004\u0004n\u0001!\taa\u001c\t\u000f\rE\u0004\u0001\"\u0001\u0004p!911\u000f\u0001\u0005\n\rU\u0004\u0002CB>\u0001\u0011\u0005Qn! \t\u000f\r}\u0004\u0001\"\u0001\u0004p!91\u0011\u0011\u0001\u0005\u0002\r=\u0004bBBB\u0001\u0011\u00051q\u000e\u0005\b\u0007\u000b\u0003A\u0011BBD\u0011\u001d\u0019i\t\u0001C\u0001\u0007\u001fCqa!%\u0001\t\u0003\u0019\u0019J\u0001\rMS:,\bp\u00119v\u001b\u0016$(/[2t\u0007>dG.Z2u_JT!A\\8\u0002\u000f5,GO]5dg*\t\u0001/A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\bC\u0001;x\u001b\u0005)(\"\u0001<\u0002\u000bM\u001c\u0017\r\\1\n\u0005a,(AB!osJ+g-\u0001\u0005qe>\u001c'k\\8u!\rY\u0018Q\u0001\b\u0004y\u0006\u0005\u0001CA?v\u001b\u0005q(BA@r\u0003\u0019a$o\\8u}%\u0019\u00111A;\u0002\rA\u0013X\rZ3g\u0013\u0011\t9!!\u0003\u0003\rM#(/\u001b8h\u0015\r\t\u0019!^\u0001\u0005i&lW-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\u0013\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!B;uS2\u001c(\u0002BA\r\u00037\taaY8n[>t'b\u00019\u0002\u001e)!\u0011qDA\u0011\u0003\u0019\t\u0007/Y2iK*\u0011\u00111E\u0001\u0004_J<\u0017\u0002BA\u0014\u0003'\u0011A\u0001V5nK\u0006)A/[7fA\u0005a\u0001O]8dKN\u001c\u0018\nZ(qiV\u0011\u0011q\u0006\t\u0006i\u0006E\u0012QG\u0005\u0004\u0003g)(AB(qi&|g\u000eE\u0002u\u0003oI1!!\u000fv\u0005\u0011auN\\4\u0002\u001bA\u0014xnY3tg&#w\n\u001d;!\u0003\u0019awnZ4feV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)!\u0011qIA\u0011\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\tY%!\u0012\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\na\u0001P5oSRtDCCA*\u0003/\nI&a\u0017\u0002^A\u0019\u0011Q\u000b\u0001\u000e\u00035DQ!\u001f\u0005A\u0002iDq!a\u0003\t\u0001\u0004\ty\u0001C\u0004\u0002,!\u0001\r!a\f\t\u000f\u0005u\u0002\u00021\u0001\u0002B\u0005YAn\\1e\u0003Z<\u0007+\u0019;i+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005MTBAA4\u0015\u0011\tI'a\u001b\u0002\t\u0019LG.\u001a\u0006\u0005\u0003[\ny'A\u0002oS>T!!!\u001d\u0002\t)\fg/Y\u0005\u0005\u0003k\n9G\u0001\u0003QCRD\u0017\u0001\u00047pC\u0012\feo\u001a)bi\"\u0004\u0013\u0001C:uCR\u0004\u0016\r\u001e5\u0002\u0013M$\u0018\r\u001e)bi\"\u0004\u0013a\u00037pC\u0012\feo\u001a'pG.,\"!!!\u0011\t\u0005\r\u0015\u0011S\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006)An\\2lg*!\u00111RAG\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u001f\u000by'\u0001\u0003vi&d\u0017\u0002BAJ\u0003\u000b\u0013QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017\u0001\u00047pC\u0012\feo\u001a'pG.\u0004\u0013a\u00057bgRdu.\u00193Bm\u001e,\u0006\u000fZ1uK6\u001bXCAA\u001b\u0003]a\u0017m\u001d;M_\u0006$\u0017I^4Va\u0012\fG/Z't?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0006\u0015\u0006c\u0001;\u0002\"&\u0019\u00111U;\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003O\u0003\u0012\u0011!a\u0001\u0003k\t1\u0001\u001f\u00132\u0003Qa\u0017m\u001d;M_\u0006$\u0017I^4Va\u0012\fG/Z'tA!:\u0011#!,\u0002B\u0006\r\u0007\u0003BAX\u0003{k!!!-\u000b\t\u0005M\u0016QW\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u00028\u0006e\u0016\u0001\u00026dSBT!!a/\u0002\u00079,G/\u0003\u0003\u0002@\u0006E&!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\ti(A\u0007m_\u0006$\u0017I^4P]\u0016l\u0015N\\\u000b\u0003\u0003\u0013\u00042\u0001^Af\u0013\r\ti-\u001e\u0002\u0007\t>,(\r\\3\u0002#1|\u0017\rZ!wO>sW-T5o?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0006M\u0007\"CAT'\u0005\u0005\t\u0019AAe\u00039aw.\u00193Bm\u001e|e.Z'j]\u0002Bs\u0001FAW\u0003\u0003\f\u0019-\u0001\bm_\u0006$\u0017I^4GSZ,W*\u001b8\u0002%1|\u0017\rZ!wO\u001aKg/Z'j]~#S-\u001d\u000b\u0005\u0003?\u000by\u000eC\u0005\u0002(Z\t\t\u00111\u0001\u0002J\u0006yAn\\1e\u0003Z<g)\u001b<f\u001b&t\u0007\u0005K\u0004\u0018\u0003[\u000b\t-a1\u0002#1|\u0017\rZ!wO\u001aKg\r^3f]6Kg.A\u000bm_\u0006$\u0017I^4GS\u001a$X-\u001a8NS:|F%Z9\u0015\t\u0005}\u00151\u001e\u0005\n\u0003OK\u0012\u0011!a\u0001\u0003\u0013\f!\u0003\\8bI\u00063xMR5gi\u0016,g.T5oA!:!$!,\u0002B\u0006\r\u0017!D:zgR,Wn\u00119v\u0019>\u001c7.\u0001\btsN$X-\\\"qk2{7m\u001b\u0011\u0002\u0019Q|G/\u00197DaV$\u0016.\\3\u0002!Q|G/\u00197DaV$\u0016.\\3`I\u0015\fH\u0003BAP\u0003wD\u0011\"a*\u001f\u0003\u0003\u0005\r!!\u000e\u0002\u001bQ|G/\u00197DaV$\u0016.\\3!Q\u001dy\u0012QVAa\u0005\u0003\t#!!=\u0002\u001bQ|G/\u00197JI2,G+[7f\u0003E!x\u000e^1m\u0013\u0012dW\rV5nK~#S-\u001d\u000b\u0005\u0003?\u0013I\u0001C\u0005\u0002(\u0006\n\t\u00111\u0001\u00026\u0005qAo\u001c;bY&#G.\u001a+j[\u0016\u0004\u0003f\u0002\u0012\u0002.\u0006\u0005'\u0011A\u0001\rgB\f7-\u001a)biR,'O\\\u000b\u0003\u0005'\u0001BA!\u0006\u0003\u001c5\u0011!q\u0003\u0006\u0005\u00053\ti)A\u0003sK\u001e,\u00070\u0003\u0003\u0003\u001e\t]!a\u0002)biR,'O\\\u0001\u000egB\f7-\u001a)biR,'O\u001c\u0011\u00025A\f'/\u001a8uQ\u0016\u001c\u0018n]#oG2|7/\u001a3QCR$XM\u001d8\u00027A\f'/\u001a8uQ\u0016\u001c\u0018n]#oG2|7/\u001a3QCR$XM\u001d8!\u0003I\u0001(o\\2fgN\u001cF/\u0019;QCRDw\n\u001d;\u0016\u0005\t%\u0002#\u0002;\u00022\u0005\r\u0014a\u00059s_\u000e,7o]*uCR\u0004\u0016\r\u001e5PaR\u0004\u0013A\u00049s_\u000e,7o]\"qk2{7m[\u0001\u0010aJ|7-Z:t\u0007B,Hj\\2lA\u0005\tB.Y:u'f\u001cH/Z7KS\u001a4\u0017.Z:\u0002+1\f7\u000f^*zgR,WNS5gM&,7o\u0018\u0013fcR!\u0011q\u0014B\u001c\u0011%\t9\u000bLA\u0001\u0002\u0004\t)$\u0001\nmCN$8+_:uK6T\u0015N\u001a4jKN\u0004\u0003fB\u0017\u0002.\u0006\u0005'QH\u0011\u0003\u0005[\t!\u0003\\1tiB\u0013xnY3tg*KgMZ5fg\u00061B.Y:u!J|7-Z:t\u0015&4g-[3t?\u0012*\u0017\u000f\u0006\u0003\u0002 \n\u0015\u0003\"CAT_\u0005\u0005\t\u0019AA\u001b\u0003Ma\u0017m\u001d;Qe>\u001cWm]:KS\u001a4\u0017.Z:!Q\u001d\u0001\u0014QVAa\u0005{\u0011QbU=ti\u0016l7\t];US6,7CB\u0019t\u0005\u001f\u0012)\u0006E\u0002u\u0005#J1Aa\u0015v\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001\u001eB,\u0013\r\u0011I&\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005kN,'/A\u0003vg\u0016\u0014\b%\u0001\u0003oS\u000e,\u0017!\u00028jG\u0016\u0004\u0013AB:zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\t%$G.Z\u0001\u0006S\u0012dW\rI\u0001\u0007S><\u0016-\u001b;\u0002\u000f%|w+Y5uA\u0005\u0019\u0011N]9\u0002\t%\u0014\u0018\u000fI\u0001\bg>4G/\u0013:r\u0003!\u0019xN\u001a;JeF\u0004\u0013!B:uK\u0006d\u0017AB:uK\u0006d\u0007%A\u0003hk\u0016\u001cH/\u0001\u0004hk\u0016\u001cH\u000fI\u0001\nOV,7\u000f\u001e(jG\u0016\f!bZ;fgRt\u0015nY3!)Y\u0011)I!#\u0003\f\n5%q\u0012BI\u0005'\u0013)Ja&\u0003\u001a\nm\u0005c\u0001BDc5\t\u0001\u0001C\u0004\u0003\\\u0019\u0003\r!!\u000e\t\u000f\t}c\t1\u0001\u00026!9!1\r$A\u0002\u0005U\u0002b\u0002B4\r\u0002\u0007\u0011Q\u0007\u0005\b\u0005W2\u0005\u0019AA\u001b\u0011\u001d\u0011yG\u0012a\u0001\u0003kAqAa\u001dG\u0001\u0004\t)\u0004C\u0004\u0003x\u0019\u0003\r!!\u000e\t\u000f\tmd\t1\u0001\u00026!9!q\u0010$A\u0002\u0005U\u0012!\u0002;pi\u0006d\u0017A\u0002;pi\u0006d\u0007%\u0001\u0003d_BLHC\u0006BC\u0005K\u00139K!+\u0003,\n5&q\u0016BY\u0005g\u0013)La.\t\u0013\tm\u0013\n%AA\u0002\u0005U\u0002\"\u0003B0\u0013B\u0005\t\u0019AA\u001b\u0011%\u0011\u0019'\u0013I\u0001\u0002\u0004\t)\u0004C\u0005\u0003h%\u0003\n\u00111\u0001\u00026!I!1N%\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0005_J\u0005\u0013!a\u0001\u0003kA\u0011Ba\u001dJ!\u0003\u0005\r!!\u000e\t\u0013\t]\u0014\n%AA\u0002\u0005U\u0002\"\u0003B>\u0013B\u0005\t\u0019AA\u001b\u0011%\u0011y(\u0013I\u0001\u0002\u0004\t)$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu&\u0006BA\u001b\u0005\u007f[#A!1\u0011\t\t\r'QZ\u0007\u0003\u0005\u000bTAAa2\u0003J\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017,\u0018AC1o]>$\u0018\r^5p]&!!q\u001aBc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:\u0014AD2paf$C-\u001a4bk2$H\u0005O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\u0002\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003hB!!\u0011\u001eBx\u001b\t\u0011YO\u0003\u0003\u0003n\u0006=\u0014\u0001\u00027b]\u001eLA!a\u0002\u0003l\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u001f\t\u0004i\n]\u0018b\u0001B}k\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q`B\u0003!\r!8\u0011A\u0005\u0004\u0007\u0007)(aA!os\"I\u0011q\u0015,\u0002\u0002\u0003\u0007!Q_\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u0002\t\u0007\u0007\u001b\u0019\u0019Ba@\u000e\u0005\r=!bAB\tk\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rU1q\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0004\u001c\r\u0005\u0002c\u0001;\u0004\u001e%\u00191qD;\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u0015-\u0002\u0002\u0003\u0007!q`\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!Q_\u0001\ti>\u001cFO]5oOR\u0011!q]\u0001\u0007KF,\u0018\r\\:\u0015\t\rm1q\u0006\u0005\n\u0003O[\u0016\u0011!a\u0001\u0005\u007f\fQbU=ti\u0016l7\t];US6,\u0007c\u0001BD;N)Qla\u000e\u0003VAQ2\u0011HB \u0003k\t)$!\u000e\u00026\u0005U\u0012QGA\u001b\u0003k\t)$!\u000e\u0003\u00066\u001111\b\u0006\u0004\u0007{)\u0018a\u0002:v]RLW.Z\u0005\u0005\u0007\u0003\u001aYD\u0001\nBEN$(/Y2u\rVt7\r^5p]F\u0002DCAB\u001a\u0003\u0015\t\u0007\u000f\u001d7z)Y\u0011)i!\u0013\u0004L\r53qJB)\u0007'\u001a)fa\u0016\u0004Z\rm\u0003b\u0002B.A\u0002\u0007\u0011Q\u0007\u0005\b\u0005?\u0002\u0007\u0019AA\u001b\u0011\u001d\u0011\u0019\u0007\u0019a\u0001\u0003kAqAa\u001aa\u0001\u0004\t)\u0004C\u0004\u0003l\u0001\u0004\r!!\u000e\t\u000f\t=\u0004\r1\u0001\u00026!9!1\u000f1A\u0002\u0005U\u0002b\u0002B<A\u0002\u0007\u0011Q\u0007\u0005\b\u0005w\u0002\u0007\u0019AA\u001b\u0011\u001d\u0011y\b\u0019a\u0001\u0003k\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004b\r%\u0004#\u0002;\u00022\r\r\u0004c\u0006;\u0004f\u0005U\u0012QGA\u001b\u0003k\t)$!\u000e\u00026\u0005U\u0012QGA\u001b\u0013\r\u00199'\u001e\u0002\b)V\u0004H.Z\u00191\u0011%\u0019Y'YA\u0001\u0002\u0004\u0011))A\u0002yIA\nAc]=ti\u0016l7\t];Vi&d\u0017N_1uS>tGCAAe\u0003U\u0001(o\\2fgN\u001c\u0005/^+uS2L'0\u0019;j_:\fQcY;se\u0016tG\u000f\u0015:pG\u0016\u001c8OS5gM&,7\u000f\u0006\u0003\u00026\r]\u0004bBB=I\u0002\u0007\u00111M\u0001\u0005a\u0006$\b.\u0001\u000bdkJ\u0014XM\u001c;TsN$X-\u001c&jM\u001aLWm\u001d\u000b\u0003\u0005\u000b\u000bQb\u001c8f\u001b&tGj\\1e\u0003Z<\u0017A\u00044jm\u0016l\u0015N\u001c'pC\u0012\feoZ\u0001\u0012M&4G/Z3o\u001b&tGj\\1e\u0003Z<\u0017!D;qI\u0006$X\rT8bI\u00063x\r\u0006\u0003\u0004\u001c\r%\u0005bBBFS\u0002\u0007\u0011QG\u0001\u0004]><\u0018AB;tC\ndW\r\u0006\u0002\u0004\u001c\u0005!R.Y=cKJ+w-[:uKJlU\r\u001e:jGN$B!a(\u0004\u0016\"91qS6A\u0002\re\u0015\u0001\u0003:fO&\u001cHO]=\u0011\t\rm51V\u0007\u0003\u0007;SAaa(\u0004\"\u0006!1m\u001c:f\u0015\rq71\u0015\u0006\u0005\u0007K\u001b9+\u0001\u0004zC6lWM\u001d\u0006\u0003\u0007S\u000b1aY8n\u0013\u0011\u0019ik!(\u0003\u001f5+GO]5dgJ+w-[:uef\u0004")
public class LinuxCpuMetricsCollector {
    private volatile LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime$module;
    private final String procRoot;
    private final Time time;
    private final Option<Object> processIdOpt;
    private final Logger logger;
    private final Path loadAvgPath;
    private final Path statPath;
    private final ReentrantLock loadAvgLock;
    @GuardedBy(value="loadAvgLock")
    private long lastLoadAvgUpdateMs;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgOneMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFiveMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFifteenMin;
    private final ReentrantLock systemCpuLock;
    @GuardedBy(value="systemCpuLock")
    private long totalCpuTime;
    @GuardedBy(value="systemCpuLock")
    private long totalIdleTime;
    private final Pattern spacePattern;
    private final Pattern parenthesisEnclosedPattern;
    private final Option<Path> processStatPathOpt;
    private final ReentrantLock processCpuLock;
    @GuardedBy(value="processCpuLock")
    private long lastSystemJiffies;
    @GuardedBy(value="processCpuLock")
    private long lastProcessJiffies;

    public LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime() {
        if (this.SystemCpuTime$module == null) {
            this.SystemCpuTime$lzycompute$1();
        }
        return this.SystemCpuTime$module;
    }

    public Time time() {
        return this.time;
    }

    public Option<Object> processIdOpt() {
        return this.processIdOpt;
    }

    public Logger logger() {
        return this.logger;
    }

    private Path loadAvgPath() {
        return this.loadAvgPath;
    }

    private Path statPath() {
        return this.statPath;
    }

    private ReentrantLock loadAvgLock() {
        return this.loadAvgLock;
    }

    private long lastLoadAvgUpdateMs() {
        return this.lastLoadAvgUpdateMs;
    }

    private void lastLoadAvgUpdateMs_$eq(long x$1) {
        this.lastLoadAvgUpdateMs = x$1;
    }

    private double loadAvgOneMin() {
        return this.loadAvgOneMin;
    }

    private void loadAvgOneMin_$eq(double x$1) {
        this.loadAvgOneMin = x$1;
    }

    private double loadAvgFiveMin() {
        return this.loadAvgFiveMin;
    }

    private void loadAvgFiveMin_$eq(double x$1) {
        this.loadAvgFiveMin = x$1;
    }

    private double loadAvgFifteenMin() {
        return this.loadAvgFifteenMin;
    }

    private void loadAvgFifteenMin_$eq(double x$1) {
        this.loadAvgFifteenMin = x$1;
    }

    private ReentrantLock systemCpuLock() {
        return this.systemCpuLock;
    }

    private long totalCpuTime() {
        return this.totalCpuTime;
    }

    private void totalCpuTime_$eq(long x$1) {
        this.totalCpuTime = x$1;
    }

    private long totalIdleTime() {
        return this.totalIdleTime;
    }

    private void totalIdleTime_$eq(long x$1) {
        this.totalIdleTime = x$1;
    }

    private Pattern spacePattern() {
        return this.spacePattern;
    }

    private Pattern parenthesisEnclosedPattern() {
        return this.parenthesisEnclosedPattern;
    }

    private Option<Path> processStatPathOpt() {
        return this.processStatPathOpt;
    }

    private ReentrantLock processCpuLock() {
        return this.processCpuLock;
    }

    private long lastSystemJiffies() {
        return this.lastSystemJiffies;
    }

    private void lastSystemJiffies_$eq(long x$1) {
        this.lastSystemJiffies = x$1;
    }

    private long lastProcessJiffies() {
        return this.lastProcessJiffies;
    }

    private void lastProcessJiffies_$eq(long x$1) {
        this.lastProcessJiffies = x$1;
    }

    public double systemCpuUtilization() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.systemCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idleTime = systemJiffies.idle() + systemJiffies.ioWait();
                        if (this.totalCpuTime() == 0L) {
                            this.totalCpuTime_$eq(total);
                            this.totalIdleTime_$eq(idleTime);
                            d2 = 0.0;
                            break block6;
                        }
                        long currWindowCpuTime = total - this.totalCpuTime();
                        long currWindowIdleTime = idleTime - this.totalIdleTime();
                        this.totalCpuTime_$eq(total);
                        this.totalIdleTime_$eq(idleTime);
                        double idlePercentage = (double)currWindowIdleTime * 100.0 / (double)currWindowCpuTime;
                        d = 100.0 - idlePercentage;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.systemCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double processCpuUtilization() {
        double d;
        Option<Path> option = this.processStatPathOpt();
        if (option instanceof Some) {
            double d2;
            block12: {
                double d3;
                block11: {
                    Path path = (Path)((Some)option).value();
                    try {
                        try {
                            this.processCpuLock().lock();
                            SystemCpuTime systemJiffies = this.currentSystemJiffies();
                            long processJiffies = this.currentProcessJiffies(path);
                            if (this.lastProcessJiffies() == 0L || this.lastSystemJiffies() == 0L) {
                                this.lastSystemJiffies_$eq(systemJiffies.total());
                                this.lastProcessJiffies_$eq(processJiffies);
                                d3 = 0.0;
                                break block11;
                            }
                            long currentWindowSystemJiffies = systemJiffies.total() - this.lastSystemJiffies();
                            long currentWindowProcessJiffies = processJiffies - this.lastProcessJiffies();
                            this.lastSystemJiffies_$eq(systemJiffies.total());
                            this.lastProcessJiffies_$eq(processJiffies);
                            if (currentWindowSystemJiffies == 0L) {
                                d3 = 0.0;
                                break block11;
                            }
                            d2 = (double)currentWindowProcessJiffies * 100.0 / (double)currentWindowSystemJiffies;
                        }
                        catch (Throwable t) {
                            this.logger().warn("Unable to update CPU metrics for the process", t);
                            d2 = -1.0;
                        }
                        break block12;
                    }
                    finally {
                        this.processCpuLock().unlock();
                    }
                }
                return d3;
            }
            d = d2;
        } else if (None$.MODULE$.equals(option)) {
            d = -1.0;
        } else {
            throw new MatchError(option);
        }
        return d;
    }

    private long currentProcessJiffies(Path path) {
        String line = (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path)).asScala()).head();
        line = this.parenthesisEnclosedPattern().matcher(line).replaceFirst("process_name");
        String[] cpu = this.spacePattern().split(line);
        return new StringOps(Predef$.MODULE$.augmentString(cpu[13])).toLong() + new StringOps(Predef$.MODULE$.augmentString(cpu[14])).toLong();
    }

    public SystemCpuTime currentSystemJiffies() {
        String line = (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).head();
        String[] cpu = this.spacePattern().split(line);
        return new SystemCpuTime(this, new StringOps(Predef$.MODULE$.augmentString(cpu[1])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[2])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[3])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[4])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[5])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[6])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[7])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[8])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[9])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[10])).toLong());
    }

    public double oneMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgOneMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fiveMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFiveMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fifteenMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFifteenMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    private boolean updateLoadAvg(long now) {
        try {
            this.loadAvgOneMin_$eq(-1.0);
            this.loadAvgFiveMin_$eq(-1.0);
            this.loadAvgFifteenMin_$eq(-1.0);
            String[] loadAvgArr = ((String)((BufferLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.loadAvgPath())).asScala()).apply(0)).split("\\s+");
            this.loadAvgOneMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[0])).toDouble());
            this.loadAvgFiveMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[1])).toDouble());
            this.loadAvgFifteenMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[2])).toDouble());
            this.lastLoadAvgUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            return false;
        }
    }

    public boolean usable() {
        return this.loadAvgPath().toFile().exists() && this.statPath().toFile().exists();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-1m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-5m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-15m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-process-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
        }
    }

    private final void SystemCpuTime$lzycompute$1() {
        synchronized (this) {
            if (this.SystemCpuTime$module == null) {
                this.SystemCpuTime$module = new LinuxCpuMetricsCollector$SystemCpuTime$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Path $anonfun$processStatPathOpt$1(LinuxCpuMetricsCollector $this, long pid) {
        return Paths.get($this.procRoot, Long.toString(pid), "stat");
    }

    private static final void registerGauge$1(String name, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)"KafkaServer", (String)name);
        registry$1.newGauge(metricName, gauge);
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.oneMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.fiveMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5() {
        return this.fifteenMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7() {
        return this.systemCpuUtilization();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9() {
        return this.processCpuUtilization();
    }

    public LinuxCpuMetricsCollector(String procRoot, Time time, Option<Object> processIdOpt, Logger logger) {
        this.procRoot = procRoot;
        this.time = time;
        this.processIdOpt = processIdOpt;
        this.logger = logger;
        this.loadAvgPath = Paths.get(procRoot, "loadavg");
        this.statPath = Paths.get(procRoot, "stat");
        this.loadAvgLock = new ReentrantLock();
        this.lastLoadAvgUpdateMs = -1L;
        this.loadAvgOneMin = -1.0;
        this.loadAvgFiveMin = -1.0;
        this.loadAvgFifteenMin = -1.0;
        this.systemCpuLock = new ReentrantLock();
        this.totalCpuTime = 0L;
        this.totalIdleTime = 0L;
        this.spacePattern = Pattern.compile("\\s+");
        this.parenthesisEnclosedPattern = Pattern.compile("\\(.*?\\)");
        this.processStatPathOpt = processIdOpt.map((Function1 & Serializable & scala.Serializable)pid -> LinuxCpuMetricsCollector.$anonfun$processStatPathOpt$1(this, BoxesRunTime.unboxToLong((Object)pid)));
        this.processCpuLock = new ReentrantLock();
        this.lastSystemJiffies = 0L;
        this.lastProcessJiffies = 0L;
    }

    public class SystemCpuTime
    implements Product,
    scala.Serializable {
        private final long user;
        private final long nice;
        private final long system;
        private final long idle;
        private final long ioWait;
        private final long irq;
        private final long softIrq;
        private final long steal;
        private final long guest;
        private final long guestNice;
        private final long total;
        public final /* synthetic */ LinuxCpuMetricsCollector $outer;

        public long user() {
            return this.user;
        }

        public long nice() {
            return this.nice;
        }

        public long system() {
            return this.system;
        }

        public long idle() {
            return this.idle;
        }

        public long ioWait() {
            return this.ioWait;
        }

        public long irq() {
            return this.irq;
        }

        public long softIrq() {
            return this.softIrq;
        }

        public long steal() {
            return this.steal;
        }

        public long guest() {
            return this.guest;
        }

        public long guestNice() {
            return this.guestNice;
        }

        public long total() {
            return this.total;
        }

        public SystemCpuTime copy(long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            return new SystemCpuTime(this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer(), user, nice, system, idle, ioWait, irq, softIrq, steal, guest, guestNice);
        }

        public long copy$default$1() {
            return this.user();
        }

        public long copy$default$10() {
            return this.guestNice();
        }

        public long copy$default$2() {
            return this.nice();
        }

        public long copy$default$3() {
            return this.system();
        }

        public long copy$default$4() {
            return this.idle();
        }

        public long copy$default$5() {
            return this.ioWait();
        }

        public long copy$default$6() {
            return this.irq();
        }

        public long copy$default$7() {
            return this.softIrq();
        }

        public long copy$default$8() {
            return this.steal();
        }

        public long copy$default$9() {
            return this.guest();
        }

        public String productPrefix() {
            return "SystemCpuTime";
        }

        public int productArity() {
            return 10;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.user());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.nice());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.system());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.idle());
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this.ioWait());
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this.irq());
                }
                case 6: {
                    return BoxesRunTime.boxToLong((long)this.softIrq());
                }
                case 7: {
                    return BoxesRunTime.boxToLong((long)this.steal());
                }
                case 8: {
                    return BoxesRunTime.boxToLong((long)this.guest());
                }
                case 9: {
                    return BoxesRunTime.boxToLong((long)this.guestNice());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SystemCpuTime;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.user())), (int)Statics.longHash((long)this.nice())), (int)Statics.longHash((long)this.system())), (int)Statics.longHash((long)this.idle())), (int)Statics.longHash((long)this.ioWait())), (int)Statics.longHash((long)this.irq())), (int)Statics.longHash((long)this.softIrq())), (int)Statics.longHash((long)this.steal())), (int)Statics.longHash((long)this.guest())), (int)Statics.longHash((long)this.guestNice())), (int)10);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof SystemCpuTime && ((SystemCpuTime)x$1).kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() == this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer();
                    if (!bl) break block3;
                    SystemCpuTime systemCpuTime = (SystemCpuTime)x$1;
                    if (!(this.user() == systemCpuTime.user() && this.nice() == systemCpuTime.nice() && this.system() == systemCpuTime.system() && this.idle() == systemCpuTime.idle() && this.ioWait() == systemCpuTime.ioWait() && this.irq() == systemCpuTime.irq() && this.softIrq() == systemCpuTime.softIrq() && this.steal() == systemCpuTime.steal() && this.guest() == systemCpuTime.guest() && this.guestNice() == systemCpuTime.guestNice() && systemCpuTime.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LinuxCpuMetricsCollector kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() {
            return this.$outer;
        }

        public SystemCpuTime(LinuxCpuMetricsCollector $outer, long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            this.user = user;
            this.nice = nice;
            this.system = system;
            this.idle = idle;
            this.ioWait = ioWait;
            this.irq = irq;
            this.softIrq = softIrq;
            this.steal = steal;
            this.guest = guest;
            this.guestNice = guestNice;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.total = user + nice + system + idle + ioWait + irq + softIrq + steal;
        }
    }
}

