/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Client$;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!B\u000e\u001d\u0001q\u0001\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011A\u0018\t\u0011m\u0002!\u0011!Q\u0001\nAB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005}!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003E\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011=\u0003!Q1A\u0005\u0002uB\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006#\u0002!\tA\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0013\u0019\u0005B\u00025\u0001A\u0003%A\tC\u0003j\u0001\u0011%!\u000eC\u0003{\u0001\u0011%1\u0010C\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003s\u0002A\u0011AA>\u0011\u0019\t9\t\u0001C\u0001\u0007\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0002\u0013!J|G-^2fe\u0006\u0003\b/\u001a8e\u0013:4wN\u0003\u0002\u001e=\u0005\u0019An\\4\u000b\u0003}\tQa[1gW\u0006\u001c2\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001fK\u0007\u0002S)\u0011!FH\u0001\u0006kRLGn]\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0004\u0001U\t\u0001\u0007\u0005\u00022s5\t!G\u0003\u00024i\u000511m\\7n_:T!aH\u001b\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uI\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002}A\u0011!eP\u0005\u0003\u0001\u000e\u0012A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u00031\u0019WO\u001d:f]R,e\u000e\u001e:z+\u0005!\u0005CA#G\u001b\u0005a\u0012BA$\u001d\u0005I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\u0002\u001b\r,(O]3oi\u0016sGO]=!\u0003\u0019y'/[4j]V\t1\n\u0005\u0002F\u0019&\u0011Q\n\b\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\\\u0001\b_JLw-\u001b8!\u00035\u0019WO\u001d:f]R$\u0016.\\3Ng\u0006q1-\u001e:sK:$H+[7f\u001bN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004T)V3v\u000b\u0017\t\u0003\u000b\u0002AQ!L\u0006A\u0002ABQ\u0001P\u0006A\u0002yBQAQ\u0006A\u0002\u0011CQ!S\u0006A\u0002-CQaT\u0006A\u0002y\nA\u0002\u001e:b]N\f7\r^5p]N,\u0012a\u0017\t\u00049\u0006\u001cW\"A/\u000b\u0005y{\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003A\u000e\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011WL\u0001\u0006MSN$()\u001e4gKJ\u0004\"!\u00123\n\u0005\u0015d\"a\u0003+y]6+G/\u00193bi\u0006\fQ\u0002\u001e:b]N\f7\r^5p]N\u0004\u0013\u0001D;qI\u0006$X\rZ#oiJL\u0018!D;qI\u0006$X\rZ#oiJL\b%\u0001\fnCf\u0014WMV1mS\u0012\fG/\u001a#bi\u0006\u0014\u0015\r^2i)\u0011Ygn\u001d=\u0011\u0005\tb\u0017BA7$\u0005\u0011)f.\u001b;\t\u000b=\u0004\u0002\u0019\u00019\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\t\u0011\u0013/\u0003\u0002sG\t)1\u000b[8si\")A\u000f\u0005a\u0001k\u0006Aa-\u001b:tiN+\u0017\u000f\u0005\u0002#m&\u0011qo\t\u0002\u0004\u0013:$\b\"B=\u0011\u0001\u0004q\u0014AB8gMN,G/\u0001\ndQ\u0016\u001c7\u000e\u0015:pIV\u001cWM]#q_\u000eDGcA6}{\")q.\u0005a\u0001a\")\u00110\u0005a\u0001}\u0005i1\r[3dWN+\u0017/^3oG\u0016$ra[A\u0001\u0003\u0007\t9\u0001C\u0003p%\u0001\u0007\u0001\u000f\u0003\u0004\u0002\u0006I\u0001\r!^\u0001\u000fCB\u0004XM\u001c3GSJ\u001cHoU3r\u0011\u0015I(\u00031\u0001?\u0003)IgnU3rk\u0016t7-\u001a\u000b\u0007\u0003\u001b\t\u0019\"a\u0006\u0011\u0007\t\ny!C\u0002\u0002\u0012\r\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u0016M\u0001\r!^\u0001\bY\u0006\u001cHoU3r\u0011\u0019\tIb\u0005a\u0001k\u00069a.\u001a=u'\u0016\f\u0018AB1qa\u0016tG\r\u0006\u0004\u0002 \u0005-\u00121\b\t\u0006E\u0005\u0005\u0012QE\u0005\u0004\u0003G\u0019#AB(qi&|g\u000eE\u0002F\u0003OI1!!\u000b\u001d\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0011\u001d\ti\u0003\u0006a\u0001\u0003_\tQAY1uG\"\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k\u0011\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0002:\u0005M\"a\u0003*fG>\u0014HMQ1uG\"Dq!!\u0010\u0015\u0001\u0004\ty$\u0001\fgSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018m\u00149u!\u0015\u0011\u0013\u0011EA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$=\u000511/\u001a:wKJLA!a\u0013\u0002F\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0002\u001f\u0005\u0004\b/\u001a8e\t\u0006$\u0018MQ1uG\"$rb[A)\u0003+\n9&!\u0017\u0002^\u0005\u0005\u0014Q\r\u0005\u0007\u0003'*\u0002\u0019\u00019\u0002\u000b\u0015\u0004xn\u00195\t\u000bQ,\u0002\u0019A;\t\r\u0005UQ\u00031\u0001v\u0011\u0019\tY&\u0006a\u0001}\u0005iA.Y:u)&lWm\u001d;b[BDq!a\u0018\u0016\u0001\u0004\t\t%A\ngSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0002dU\u0001\rAP\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\bbBA4+\u0001\u0007\u0011QB\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006)2\r[3dW\u000e{wN\u001d3j]\u0006$xN]#q_\u000eDG#B6\u0002n\u0005]\u0004bBA8-\u0001\u0007\u0011\u0011O\u0001\rK:$G\u000b\u001f8NCJ\\WM\u001d\t\u0005\u0003c\t\u0019(\u0003\u0003\u0002v\u0005M\"\u0001F#oIR\u0013\u0018M\\:bGRLwN\\'be.,'\u000fC\u0003z-\u0001\u0007a(\u0001\nbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014HCCA\u0010\u0003{\ny(!!\u0002\u0004\"9\u0011qN\fA\u0002\u0005E\u0004\"B8\u0018\u0001\u0004\u0001\b\"B=\u0018\u0001\u0004q\u0004BBAC/\u0001\u0007a(A\u0005uS6,7\u000f^1na\u00069Ao\\#oiJL\u0018aE:uCJ$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cXCAAG!\u0015\ty)a(d\u001d\u0011\t\t*a'\u000f\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&/\u0003\u0019a$o\\8u}%\tA%C\u0002\u0002\u001e\u000e\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0006\r&\u0001\u0002'jgRT1!!($\u0003!!xn\u0015;sS:<GCAAU!\u0011\tY+a-\u000f\t\u00055\u0016q\u0016\t\u0004\u0003'\u001b\u0013bAAYG\u00051\u0001K]3eK\u001aLA!!.\u00028\n11\u000b\u001e:j]\u001eT1!!-$\u0001")
public class ProducerAppendInfo
implements Logging {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final AppendOrigin origin;
    private final long currentTimeMs;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public AppendOrigin origin() {
        return this.origin;
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateDataBatch(short producerEpoch, int firstSeq, long offset) {
        block7: {
            block6: {
                AppendOrigin$Client$ appendOrigin$Client$;
                AppendOrigin appendOrigin;
                block5: {
                    this.checkProducerEpoch(producerEpoch, offset);
                    appendOrigin = this.origin();
                    appendOrigin$Client$ = AppendOrigin$Client$.MODULE$;
                    if (appendOrigin != null) break block5;
                    if (appendOrigin$Client$ != null) {
                        return;
                    }
                    break block6;
                }
                if (!appendOrigin.equals(appendOrigin$Client$)) break block7;
            }
            this.checkSequence(producerEpoch, firstSeq, offset);
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            String message = new StringBuilder(81).append("Epoch of producer ").append(this.producerId()).append(" at offset ").append(offset).append(" in ").append(this.topicPartition()).append(" is ").append(producerEpoch).append(", ").append("which is smaller than the last seen epoch ").append(this.updatedEntry().producerEpoch()).toString();
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                return;
            }
            throw new InvalidProducerEpochException(message);
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset) {
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0 && this.updatedEntry().producerEpoch() != -1) {
                throw new OutOfOrderSequenceException(new StringBuilder(136).append("Invalid sequence number for new epoch of producer ").append(this.producerId()).append(" ").append("at offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(appendFirstSeq).append(" (seq. number), ").append(this.updatedEntry().producerEpoch()).append(" (current producer epoch)").toString());
            }
        } else {
            int currentLastSeq;
            int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
            if (this.currentEntry().producerEpoch() != -1 && !this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException(new StringBuilder(124).append("Out of order sequence number for producer ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(appendFirstSeq).append(" (incoming seq. number), ").append(currentLastSeq).append(" (current end sequence number)").toString());
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch, Option<LogOffsetMetadata> firstOffsetMetadataOpt) {
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                return this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
            }
            return None$.MODULE$;
        }
        LogOffsetMetadata firstOffsetMetadata = (LogOffsetMetadata)firstOffsetMetadataOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogOffsetMetadata(batch.baseOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.appendDataBatch(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata, batch.lastOffset(), batch.isTransactional());
        return None$.MODULE$;
    }

    public void appendDataBatch(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata.messageOffset();
        this.maybeValidateDataBatch(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(68).append("Expected transactional write from producer ").append(this.producerId()).append(" at ").append("offset ").append(firstOffsetMetadata).append(" in partition ").append(this.topicPartition()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffsetMetadata, this.currentTimeMs(), TxnMetadata$.MODULE$.apply$default$4()));
            return;
        }
    }

    private void checkCoordinatorEpoch(EndTransactionMarker endTxnMarker, long offset) {
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Detected invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").append("is older than previously known coordinator epoch ").append(this.updatedEntry().coordinatorEpoch()).toString());
                return;
            }
            throw new TransactionCoordinatorFencedException(new StringBuilder(89).append("Invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString());
        }
    }

    public Option<CompletedTxn> appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        this.checkProducerEpoch(producerEpoch, offset);
        this.checkCoordinatorEpoch(endTxnMarker, offset);
        Option completedTxn = this.updatedEntry().currentTxnFirstOffset().map((Function1 & Serializable & scala.Serializable)firstOffset -> ProducerAppendInfo.$anonfun$appendEndTxnMarker$1(this, offset, endTxnMarker, BoxesRunTime.unboxToLong((Object)firstOffset)));
        this.updatedEntry().maybeUpdateProducerEpoch(producerEpoch);
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        this.updatedEntry().lastTimestamp_$eq(timestamp);
        return completedTxn;
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public String toString() {
        return new StringBuilder(159).append("ProducerAppendInfo(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").append("lastTimestamp=").append(this.updatedEntry().lastTimestamp()).append(", ").append("startedTransactions=").append(this.transactions()).append(")").toString();
    }

    public static final /* synthetic */ CompletedTxn $anonfun$appendEndTxnMarker$1(ProducerAppendInfo $this, long offset$2, EndTransactionMarker endTxnMarker$2, long firstOffset) {
        ControlRecordType controlRecordType = endTxnMarker$2.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn($this.producerId(), firstOffset, offset$2, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, AppendOrigin origin, long currentTimeMs) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.origin = origin;
        this.currentTimeMs = currentTimeMs;
        Logging.$init$(this);
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().lastTimestamp_$eq(currentEntry.lastTimestamp());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

