/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rme!\u0002$H\u0001\u001d[\u0005\u0002\u00030\u0001\u0005\u000b\u0007I\u0011\u00011\t\u0011=\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t!\u001d\u0005\n\u0003\u0013\u0001!\u0011!Q\u0001\nID!\"a\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0007\u0011)\tY\u0002\u0001B\u0001B\u0003%\u0011q\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tI\u0003\u0001C)\u0003WA!\"a\u0011\u0001\u0005\u0004%\taRA#\u0011!\t\t\u0006\u0001Q\u0001\n\u0005\u001d\u0003\"CA*\u0001\u0001\u0007I\u0011BA+\u0011%\ti\u0007\u0001a\u0001\n\u0013\ty\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0015BA,\u0011%\t)\t\u0001b\u0001\n\u0013\t9\t\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAE\u0011%\ti\n\u0001b\u0001\n\u0013\ty\n\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAQ\u0011%\tY\u000b\u0001b\u0001\n\u0013\ti\u000b\u0003\u0005\u0002D\u0002\u0001\u000b\u0011BAX\u0011%\t)\r\u0001b\u0001\n\u0013\t9\r\u0003\u0005\u0002P\u0002\u0001\u000b\u0011BAe\u0011%\t\t\u000e\u0001b\u0001\n\u0003\t\u0019\u000e\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAk\u0011%\t\u0019\u000f\u0001b\u0001\n\u0003\t\u0019\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAk\u0011%\t9\u000f\u0001b\u0001\n\u0003\t\u0019\u000e\u0003\u0005\u0002j\u0002\u0001\u000b\u0011BAk\u0011%\tY\u000f\u0001a\u0001\n\u0003\ti\u000fC\u0005\u0002v\u0002\u0001\r\u0011\"\u0001\u0002x\"A\u00111 \u0001!B\u0013\ty\u000fC\u0005\u0002\u0000\u0002\u0001\r\u0011\"\u0003\u0003\u0002!I!\u0011\u0002\u0001A\u0002\u0013%!1\u0002\u0005\t\u0005\u001f\u0001\u0001\u0015)\u0003\u0003\u0004!I!1\u0003\u0001C\u0002\u0013%!Q\u0003\u0005\t\u0005[\u0001\u0001\u0015!\u0003\u0003\u0018!9!q\u0006\u0001\u0005\u0002\tE\u0002\u0002\u0003B\u001c\u0001\u0011\u0005qI!\u000f\t\u0011\t\u0015\u0003\u0001\"\u0001H\u0005\u000fBqAa\u0014\u0001\t\u0003\u0011\t\u0006C\u0005\u0003t\u0001\t\n\u0011\"\u0001\u0003v!9!1\u0012\u0001\u0005\u0002\t5\u0005b\u0002BN\u0001\u0011\u0005!Q\u0012\u0005\b\u0005;\u0003A\u0011\u0001BP\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqAa+\u0001\t\u0003\u0011i\u000bC\u0004\u00036\u0002!IAa.\t\u000f\t\u0015\u0007\u0001\"\u0003\u0003H\"9!1\u001a\u0001\u0005\u0002\t5\u0007b\u0002Bi\u0001\u0011\u0005!1\u001b\u0005\n\u0005O\u0004\u0011\u0013!C\u0001\u0005SD\u0011B!<\u0001#\u0003%\tAa<\t\u000f\tM\b\u0001\"\u0001\u0003v\"91\u0011\u0001\u0001\u0005\u0002\r\r\u0001bBB\u0005\u0001\u0011\u000511\u0002\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0007GA\u0001\"!(\u0001\t\u000395q\u0005\u0005\b\u0007c\u0001A\u0011AB\u001a\u0011\u001d\u0019Y\u0004\u0001C\u0001\u0007{Aqaa\u0011\u0001\t\u0003\u0019)eB\u0004\u0004H\u001dC\ta!\u0013\u0007\r\u0019;\u0005\u0012AB&\u0011\u001d\tiB\u0010C\u0001\u0007\u001bBqaa\u0014?\t\u0003\u0019\t\u0006C\u0004\u0004Vy\"\taa\u0016\t\u000f\r}c\b\"\u0001\u0004b!911\u000f \u0005\u0002\rU\u0004bBBD}\u0011\u00051\u0011\u0012\u0005\b\u0007+sD\u0011ABL\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0006\u0003\u0011&\u000b1\u0001\\8h\u0015\u0005Q\u0015!B6bM.\f7\u0003\u0002\u0001M%b\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a!\u00118z%\u00164\u0007CA*W\u001b\u0005!&BA+J\u0003\u0015)H/\u001b7t\u0013\t9FKA\u0004M_\u001e<\u0017N\\4\u0011\u0005ecV\"\u0001.\u000b\u0005mK\u0015aB7fiJL7m]\u0005\u0003;j\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u001dawn\u001a#jeN\u001c\u0001!F\u0001b!\r\u0011WmZ\u0007\u0002G*\u0011AMT\u0001\u000bG>dG.Z2uS>t\u0017B\u00014d\u0005\r\u0019V-\u001d\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f!![8\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0003I\u0004RaU:v\u0003\u0003I!\u0001\u001e+\u0003\tA{w\u000e\u001c\t\u0003mzl\u0011a\u001e\u0006\u0003qf\faaY8n[>t'B\u0001&{\u0015\tYH0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0006\u0019qN]4\n\u0005}<(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003\u0007\t)!D\u0001H\u0013\r\t9a\u0012\u0002\f\u0003\n\u001cHO]1di2{w-A\u0003m_\u001e\u001c\b%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+I\u0015AB:feZ,'/\u0003\u0003\u0002\u001a\u0005M!\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\rqJg.\u001b;?)!\t\t#a\t\u0002&\u0005\u001d\u0002cAA\u0002\u0001!)al\u0002a\u0001C\")\u0001o\u0002a\u0001e\"9\u00111B\u0004A\u0002\u0005=\u0011A\u00037pO\u001e,'OT1nKV\u0011\u0011Q\u0006\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001a\u001d6\u0011\u0011Q\u0007\u0006\u0004\u0003oy\u0016A\u0002\u001fs_>$h(C\u0002\u0002<9\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e\u001d\u0006!rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014l\u0003\u0011a\u0017M\\4\n\t\u0005}\u00121J\u0001\u0016_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3!\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u0016\u0005\u0005]\u0003cBA-\u0003?:\u00171M\u0007\u0003\u00037R1!!\u0018d\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002b\u0005m#aA'baB!\u0011QMA5\u001b\t\t9G\u0003\u0003\u0002T\u0005M\u0011\u0002BA6\u0003O\u0012Ac\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017aD2iK\u000e\\\u0007o\\5oiN|F%Z9\u0015\t\u0005E\u0014q\u000f\t\u0004\u001b\u0006M\u0014bAA;\u001d\n!QK\\5u\u0011%\tI\bDA\u0001\u0002\u0004\t9&A\u0002yIE\nAb\u00195fG.\u0004x.\u001b8ug\u0002B3!DA@!\ri\u0015\u0011Q\u0005\u0004\u0003\u0007s%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015%t\u0007K]8he\u0016\u001c8/\u0006\u0002\u0002\nB9\u00111RAIk\u0006UUBAAG\u0015\r\tyiY\u0001\b[V$\u0018M\u00197f\u0013\u0011\t\u0019*!$\u0003\u000f!\u000b7\u000f['baB!\u00111AAL\u0013\r\tIj\u0012\u0002\u0011\u0019><7\t\\3b]&twm\u0015;bi\u0016\f1\"\u001b8Qe><'/Z:tA\u0005)RO\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001cXCAAQ!!\tY)!%\u0002.\u0005\r\u0006#BAF\u0003K+\u0018\u0002BAT\u0003\u001b\u00131aU3u\u0003Y)hn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u00027pG.,\"!a,\u0011\t\u0005E\u0016qX\u0007\u0003\u0003gSA!!.\u00028\u0006)An\\2lg*!\u0011\u0011XA^\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003{[\u0017\u0001B;uS2LA!!1\u00024\ni!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\n!\u0003]1vg\u0016$7\t\\3b]&twmQ8oIV\u0011\u0011\u0011\u001a\t\u0005\u0003c\u000bY-\u0003\u0003\u0002N\u0006M&!C\"p]\u0012LG/[8o\u0003M\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3!\u00039\u0019G.Z1o\u0005f$Xm\u001d'bgR,\"!!6\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!a7\u00028\u00061\u0011\r^8nS\u000eLA!a8\u0002Z\nQ\u0011\t^8nS\u000eduN\\4\u0002\u001f\rdW-\u00198CsR,7\u000fT1ti\u0002\n!c\u00197fC:\f'\r\\3CsR,7\u000fT1ti\u0006\u00192\r\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cH*Y:uA\u0005!RO\\2mK\u0006t\u0017M\u00197f\u0005f$Xm\u001d'bgR\fQ#\u001e8dY\u0016\fg.\u00192mK\nKH/Z:MCN$\b%A\reSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|WCAAx!\ri\u0015\u0011_\u0005\u0004\u0003gt%A\u0002#pk\ndW-A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\u0011\t\t(!?\t\u0013\u0005eT$!AA\u0002\u0005=\u0018A\u00073jeRLWm\u001d;M_\u001e\u001cE.Z1oC\ndWMU1uS>\u0004\u0003f\u0001\u0010\u0002\u0000\u0005iA/[7f\u001f\u001ad\u0015m\u001d;Sk:,\"Aa\u0001\u0011\u00075\u0013)!C\u0002\u0003\b9\u0013A\u0001T8oO\u0006\tB/[7f\u001f\u001ad\u0015m\u001d;Sk:|F%Z9\u0015\t\u0005E$Q\u0002\u0005\n\u0003s\u0002\u0013\u0011!a\u0001\u0005\u0007\ta\u0002^5nK>3G*Y:u%Vt\u0007\u0005K\u0002\"\u0003\u007f\nQ#Y2iS\u00164X\rZ\"mK\u0006t\u0017N\\4SCRLw.\u0006\u0002\u0003\u0018A!!\u0011\u0004B\u0015\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011\u0001B2pe\u0016T1a\u0017B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\re\fW.\\3s\u0015\t\u00119#A\u0002d_6LAAa\u000b\u0003\u001c\tI\u0001*[:u_\u001e\u0014\u0018-\\\u0001\u0017C\u000eD\u0017.\u001a<fI\u000ecW-\u00198j]\u001e\u0014\u0016\r^5pA\u0005)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXC\u0001B\u001a!\u001d\tyC!\u000ev\u0005\u0007IA!!\u0019\u0002B\u0005i1\r\\3b]&twm\u0015;bi\u0016$BAa\u000f\u0003BA)QJ!\u0010\u0002\u0016&\u0019!q\b(\u0003\r=\u0003H/[8o\u0011\u0019\u0011\u0019%\na\u0001k\u0006\u0011A\u000f]\u0001\u0011g\u0016$8\t\\3b]&twm\u0015;bi\u0016$b!!\u001d\u0003J\t-\u0003B\u0002B\"M\u0001\u0007Q\u000fC\u0004\u0003N\u0019\u0002\r!!&\u0002\u000bM$\u0018\r^3\u00023\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u000b\u0007\u0005'\u0012YF!\u001b\u0011\u000b5\u0013iD!\u0016\u0011\t\u0005\r!qK\u0005\u0004\u00053:%A\u0003'pOR{7\t\\3b]\"9!QL\u0014A\u0002\t}\u0013\u0001\u0002;j[\u0016\u0004BA!\u0019\u0003f5\u0011!1\r\u0006\u0003+^LAAa\u001a\u0003d\t!A+[7f\u0011%\u0011Yg\nI\u0001\u0002\u0004\u0011i'A\u0007qe\u0016\u001cE.Z1o'R\fGo\u001d\t\u0005\u0003\u0007\u0011y'C\u0002\u0003r\u001d\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018aI4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0005oRCA!\u001c\u0003z-\u0012!1\u0010\t\u0005\u0005{\u00129)\u0004\u0002\u0003\u0000)!!\u0011\u0011BB\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0006:\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IIa \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"Aa$\u0011\u000b\t\u0014\tJ!&\n\u0007\tM5M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0019i%qS;\u0002\u0002%\u0019!\u0011\u0014(\u0003\rQ+\b\u000f\\33\u00035!W\r\\3uC\ndW\rT8hg\u0006i\u0011MY8si\u000ecW-\u00198j]\u001e$B!!\u001d\u0003\"\"1!1U\u0016A\u0002U\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005E$\u0011\u0016\u0005\u0007\u0005Gc\u0003\u0019A;\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR!\u0011\u0011\u000fBX\u0011\u001d\u0011\t,\fa\u0001\u0005g\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0005E\nEU/A\tjg\u000ecW-\u00198j]\u001eLen\u0015;bi\u0016$bA!/\u0003@\n\u0005\u0007cA'\u0003<&\u0019!Q\u0018(\u0003\u000f\t{w\u000e\\3b]\"1!1\u0015\u0018A\u0002UDqAa1/\u0001\u0004\t)*A\u0007fqB,7\r^3e'R\fG/Z\u0001\u0018SN\u001cE.Z1oS:<\u0017J\\*uCR,\u0007+Y;tK\u0012$BA!/\u0003J\"1!1U\u0018A\u0002U\fAc\u00195fG.\u001cE.Z1oS:<\u0017IY8si\u0016$G\u0003BA9\u0005\u001fDaAa)1\u0001\u0004)\u0018!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugRA\u0011\u0011\u000fBk\u00053\u0014\t\u000f\u0003\u0004\u0003XF\u0002\raZ\u0001\bI\u0006$\u0018\rR5s\u0011%\u0011Y.\rI\u0001\u0002\u0004\u0011i.\u0001\fqCJ$\u0018\u000e^5p]R{W\u000b\u001d3bi\u0016|%/\u00113e!\u0015i%Q\bBp!\u0019i%qS;\u0003\u0004!I!1]\u0019\u0011\u0002\u0003\u0007!Q]\u0001\u0012a\u0006\u0014H/\u001b;j_:$vNU3n_Z,\u0007\u0003B'\u0003>U\f1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TC\u0001BvU\u0011\u0011iN!\u001f\u00027U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tP\u000b\u0003\u0003f\ne\u0014AE1mi\u0016\u00148\t[3dWB|\u0017N\u001c;ESJ$\u0002\"!\u001d\u0003x\ne(Q \u0005\u0007\u0005G#\u0004\u0019A;\t\r\tmH\u00071\u0001h\u00031\u0019x.\u001e:dK2{w\rR5s\u0011\u0019\u0011y\u0010\u000ea\u0001O\u0006QA-Z:u\u0019><G)\u001b:\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\t\u0005E4Q\u0001\u0005\b\u0007\u000f)\u0004\u0019AA\u0017\u0003\r!\u0017N]\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"!\u001d\u0004\u000e\r=1\u0011\u0003\u0005\u0007\u0005/4\u0004\u0019A4\t\r\t\rf\u00071\u0001v\u0011\u001d\u0019\u0019B\u000ea\u0001\u0005\u0007\taa\u001c4gg\u0016$\u0018\u0001\u00043p]\u0016\u001cE.Z1oS:<G\u0003CA9\u00073\u0019Yb!\b\t\r\t\rv\u00071\u0001v\u0011\u0019\u00119n\u000ea\u0001O\"91qD\u001cA\u0002\t\r\u0011!C3oI>3gm]3u\u00031!wN\\3EK2,G/\u001b8h)\u0011\t\th!\n\t\u000f\tE\u0006\b1\u0001\u00034R!1\u0011FB\u0017!\u0015\tyca\u000bv\u0013\u0011\t9+!\u0011\t\u000f\r=\u0012\b1\u0001\u0002.\u00051An\\4ESJ\f\u0001$\\1sWB\u000b'\u000f^5uS>tWK\\2mK\u0006t\u0017M\u00197f)\u0019\t\th!\u000e\u00048!91q\u0006\u001eA\u0002\u00055\u0002BBB\u001du\u0001\u0007Q/A\u0005qCJ$\u0018\u000e^5p]\u00061\u0012n]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0003:\u000e}2\u0011\t\u0005\u0007\u0011n\u0002\r!!\u0001\t\r\t\r6\b1\u0001v\u0003ui\u0017-\u001b8uC&tWK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001cHCAA9\u0003EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\t\u0004\u0003\u0007q4c\u0001 M%R\u00111\u0011J\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0003:\u000eM\u0003B\u0002%A\u0001\u0004\t\t!\u0001\u0011m_\u000e\fG.R1sY&,7\u000f\u001e#jeRL()\u0019;dQRKW.Z:uC6\u0004HC\u0002B\u0002\u00073\u001aY\u0006\u0003\u0004I\u0003\u0002\u0007\u0011\u0011\u0001\u0005\b\u0007;\n\u0005\u0019\u0001B\u0002\u0003A1\u0017N]:u\t&\u0014H/_(gMN,G/\u0001\nnCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006LH\u0003\u0003B\u0002\u0007G\u001a)ga\u001c\t\r!\u0013\u0005\u0019AA\u0001\u0011\u001d\u00199G\u0011a\u0001\u0007S\na#Z1sY&,7\u000f\u001e#jeRLH+[7fgR\fW\u000e\u001d\t\u0006\u001b\u000e-$1A\u0005\u0004\u0007[r%!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\u0019\tH\u0011a\u0001\u0005\u0007\t1A\\8x\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0005\u0004x\ru4qPBC!\u0011\t\u0019a!\u001f\n\u0007\rmtI\u0001\bPM\u001a\u001cX\r^:U_\u000ecW-\u00198\t\r!\u001b\u0005\u0019AA\u0001\u0011\u001d\u0019\ti\u0011a\u0001\u0007\u0007\u000bq\u0002\\1ti\u000ecW-\u00198PM\u001a\u001cX\r\u001e\t\u0006\u001b\nu\"1\u0001\u0005\b\u0007c\u001a\u0005\u0019\u0001B\u0002\u0003]\u0019\u0017\r\\2vY\u0006$Xm\u00117fC:\f'\r\\3CsR,7\u000f\u0006\u0005\u0004\f\u000e55qRBI!\u001di%q\u0013B\u0002\u0005\u0007Aa\u0001\u0013#A\u0002\u0005\u0005\u0001bBB/\t\u0002\u0007!1\u0001\u0005\b\u0007'#\u0005\u0019\u0001B\u0002\u0003E)hn\u00197fC:\f'\r\\3PM\u001a\u001cX\r^\u0001\u001cIV\fGnQ8na\u0006\u001cG/[8o\u00072,\u0017M\\5oO\n{WO\u001c3\u0015\t\r\r5\u0011\u0014\u0005\u0007\u0011\u0016\u0003\r!!\u0001")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private final AtomicLong cleanBytesLast;
    private final AtomicLong cleanableBytesLast;
    private final AtomicLong uncleanableBytesLast;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private final Histogram achievedCleaningRatio;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Object> dualCompactionCleaningBound(AbstractLog abstractLog) {
        return LogCleanerManager$.MODULE$.dualCompactionCleaningBound(abstractLog);
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(AbstractLog abstractLog, long l, long l2) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(abstractLog, l, l2);
    }

    public static OffsetsToClean cleanableOffsets(AbstractLog abstractLog, Option<Object> option, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(abstractLog, option, l);
    }

    public static long maxCompactionDelay(AbstractLog abstractLog, Function0<Object> function0, long l) {
        long maxCompactionDelay_earliestDirtySegmentTimestamp;
        if (LogCleanerManager$.MODULE$ == null) {
            throw null;
        }
        long maxCompactionDelay_maxCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(abstractLog.config().maxCompactionLagMs()), 0L);
        long maxCompactionDelay_cleanUntilTime = l - maxCompactionDelay_maxCompactionLagMs;
        long l2 = maxCompactionDelay_cleanUntilTime < 0L ? 0L : ((maxCompactionDelay_earliestDirtySegmentTimestamp = function0.apply$mcJ$sp()) < maxCompactionDelay_cleanUntilTime ? maxCompactionDelay_cleanUntilTime - maxCompactionDelay_earliestDirtySegmentTimestamp : 0L);
        return l2;
    }

    public static long localEarliestDirtyBatchTimestamp(AbstractLog abstractLog, long l) {
        return LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(abstractLog, l);
    }

    public static boolean isCompactAndDelete(AbstractLog abstractLog) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(abstractLog);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public AtomicLong cleanBytesLast() {
        return this.cleanBytesLast;
    }

    public AtomicLong cleanableBytesLast() {
        return this.cleanableBytesLast;
    }

    public AtomicLong uncleanableBytesLast() {
        return this.uncleanableBytesLast;
    }

    public double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    public void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    private Histogram achievedCleaningRatio() {
        return this.achievedCleaningRatio;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, AbstractLog>> deletableLogs() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public void abortCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (!bl) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                int count = logCleaningPaused.pausedCount();
                if (count <= 1) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            bl = !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            boolean bl2 = (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void checkCleaningAborted(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, partitionToRemove, partitionToUpdateOrAdd);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleLogDirFailure(String dir) {
        void inLock_lock;
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$4, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        void inLock_lock;
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((GenTraversableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    /*
     * WARNING - void declaration
     */
    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isUncleanablePartition(AbstractLog log, TopicPartition topicPartition) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void maintainUncleanablePartitions() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt((Object)$this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$2(File dir$1) {
        int n;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            n = LogCleanerManager.$anonfun$new$3(this, dir$1);
        }
        finally {
            inLock_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$10(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, AbstractLog log) {
        void var8_7;
        Option lastCleanOffset = lastClean$1.get((Object)tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var8_7;
    }

    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.logs().get(tp)).map((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$10(lastClean$1, tp, now$1, log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        long l;
        Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
        if (option instanceof Some) {
            Set partitions = (Set)((Some)option).value();
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
            long now = Time.SYSTEM.milliseconds();
            l = BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$9($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else {
            throw new MatchError((Object)option);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$7(File dir$2) {
        long l;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            l = LogCleanerManager.$anonfun$new$8(this, dir$2);
        }
        finally {
            inLock_lock.unlock();
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$new$14(File dir$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)x0$1._2();
        boolean bl = log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        return bl;
    }

    public static final /* synthetic */ long $anonfun$new$15(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        long l = ((AbstractLog)x0$2._2()).sizeAsyncUpdated();
        return l;
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$13(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$14(dir$3, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$15(x0$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$17(File dir$3, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)x0$3._2();
        boolean bl = log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        return bl;
    }

    public static final /* synthetic */ long $anonfun$new$18(Tuple2 x0$4) {
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        long l = ((AbstractLog)x0$4._2()).sizeDetailsAsyncUpdated().localSize();
        return l;
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$16(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$17(dir$3, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$18(x0$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$20(File dir$3, Tuple2 x0$5) {
        if (x0$5 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)x0$5._2();
        boolean bl = log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        return bl;
    }

    public static final /* synthetic */ long $anonfun$new$21(Tuple2 x0$6) {
        if (x0$6 == null) {
            throw new MatchError(null);
        }
        long l = ((AbstractLog)x0$6._2()).sizeDetailsAsyncUpdated().tieredSize();
        return l;
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$19(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$20(dir$3, x0$5)))).map((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$21(x0$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$22() {
        return Time.SYSTEM.milliseconds() - this.timeOfLastRun();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((TraversableOnce)$this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$2) {
        return $this.inProgress().get((Object)tp$2);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$3, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$3, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractLog)x0$1._2()).isLocallyCompactable();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        AbstractLog log = (AbstractLog)x0$2._2();
        boolean bl = $this.isUncleanablePartition(log, topicPartition) || log.isFrozenLogStartOffsetState();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$10(LogCleanerManager $this, LogToClean logToClean) {
        return $this.inProgress().contains((Object)logToClean.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$11(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable allCleanableLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogToClean logToClean;
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                AbstractLog log = (AbstractLog)x0$3._2();
                try {
                    long maxCompactionDelay_earliestDirtySegmentTimestamp;
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (offsetsToClean.forceUpdateCheckpoint()) {
                        $this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), $this.updateCheckpoints$default$3());
                    }
                    if (LogCleanerManager$.MODULE$ == null) {
                        throw null;
                    }
                    long maxCompactionDelay_maxCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().maxCompactionLagMs()), 0L);
                    long maxCompactionDelay_cleanUntilTime = now - maxCompactionDelay_maxCompactionLagMs;
                    long l = maxCompactionDelay_cleanUntilTime < 0L ? 0L : ((maxCompactionDelay_earliestDirtySegmentTimestamp = LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(log, offsetsToClean.firstDirtyOffset())) < maxCompactionDelay_cleanUntilTime ? maxCompactionDelay_cleanUntilTime - maxCompactionDelay_earliestDirtySegmentTimestamp : 0L);
                    preCleanStats$1.updateMaxCompactionDelay(l);
                    logToClean = new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), l > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                }
            } else {
                throw new MatchError(null);
            }
            LogToClean logToClean2 = logToClean;
            return logToClean2;
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        $this.cleanBytesLast().set(BoxesRunTime.unboxToLong((Object)((TraversableOnce)allCleanableLogs.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.cleanBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        $this.cleanableBytesLast().set(BoxesRunTime.unboxToLong((Object)((TraversableOnce)allCleanableLogs.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.cleanableBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        $this.uncleanableBytesLast().set(BoxesRunTime.unboxToLong((Object)((TraversableOnce)allCleanableLogs.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.uncleanableBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Iterable dirtyLogs = (Iterable)allCleanableLogs.filterNot((Function1 & Serializable & scala.Serializable)logToClean -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$10($this, logToClean)));
        $this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$11(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        $this.achievedCleaningRatio().update((int)(filthiest.cleanableRatio() * (double)100));
        double expectedShrinkageRatio = filthiest.log().lastShrinkageRatio() * filthiest.cleanableRatio();
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Filthiest log %s has last.shrinkage.ratio=%.3f, dirty.ratio=%.3f, expected.shrinkage.ratio=%.3f %n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filthiest.log().name(), BoxesRunTime.boxToDouble((double)filthiest.log().lastShrinkageRatio()), BoxesRunTime.boxToDouble((double)filthiest.cleanableRatio()), BoxesRunTime.boxToDouble((double)expectedShrinkageRatio)})));
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = !((AbstractLog)x0$1._2()).isLocallyCompactable();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        void var1_1;
        Iterable deletableLogs = (Iterable)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            Option option = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        AbstractLog log = (AbstractLog)x0$1._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.isLocallyCompactable() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        void var1_1;
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Option option = $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition$1, (List)Nil$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
        if (Option$.MODULE$.apply((Object)$this.logs().get(topicPartition$3)).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFrozenLogStartOffsetState()))) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.logs().keys().contains((Object)tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option partitionToRemove$1, Option partitionToUpdateOrAdd$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2;
                scala.collection.immutable.Map currentCheckpoint = ((TraversableOnce)checkpoint.read().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
                if (partitionToRemove$1 instanceof Some) {
                    TopicPartition topicPartition = (TopicPartition)((Some)partitionToRemove$1).value();
                    map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartition);
                } else if (None$.MODULE$.equals(partitionToRemove$1)) {
                    map2 = currentCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToRemove$1);
                }
                if (partitionToUpdateOrAdd$1 instanceof Some) {
                    Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd$1).value();
                    map = map2.$plus(updatedOffset);
                } else if (None$.MODULE$.equals(partitionToUpdateOrAdd$1)) {
                    map = map2;
                } else {
                    throw new MatchError((Object)partitionToUpdateOrAdd$1);
                }
                checkpoint.write((Map<TopicPartition, Object>)map);
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            Option option = $this.checkpoints().get((Object)sourceLogDir$1).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.read().get((Object)topicPartition$4));
            if (option instanceof Some) {
                long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("from ").append(sourceLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                Option x$2 = Option$.MODULE$.apply((Object)topicPartition$4);
                Option<Tuple2<TopicPartition, Object>> x$3 = $this.updateCheckpoints$default$2();
                $this.updateCheckpoints(sourceLogDir$1, x$3, (Option<TopicPartition>)x$2);
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("to ").append(destLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)BoxesRunTime.boxToLong((long)offset))), $this.updateCheckpoints$default$3());
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir$1.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$4, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((File)x0$1._1()).getAbsolutePath();
        boolean bl = string == null ? dir$4 != null : !string.equals(dir$4);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateCheckpoint$2(AbstractLog x$7) {
        return x$7.config().compact();
    }

    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, long offset$1) {
        Map<TopicPartition, Object> existing;
        OffsetCheckpointFile checkpoint;
        if (Option$.MODULE$.apply((Object)$this.logs().get(topicPartition$5)).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maybeTruncateCheckpoint$2(x$7))) && (checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2)) != null && BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition$5, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > offset$1) {
            checkpoint.write((Map<TopicPartition, Object>)((Map)((scala.collection.mutable.MapLike)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(existing)).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$5), (Object)BoxesRunTime.boxToLong((long)offset$1)))));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)BoxesRunTime.boxToLong((long)endOffset$1))), $this.updateCheckpoints$default$3());
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition$6).append(" cannot be in ").append(option).append(" state.").toString());
        throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition$6).append(" should exist.").toString());
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Boolean bl;
        Option option = $this.uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            bl = BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        } else if (None$.MODULE$.equals(option)) {
            bl = $this.uncleanablePartitions().put((Object)logDir$2, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, AbstractLog log$2, TopicPartition topicPartition$7) {
        return $this.uncleanablePartitions().get((Object)log$2.parentDir()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition id) {
        return $this.logs().contains(id);
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$2(LogCleanerManager $this, Set partitions) {
        ((TraversableOnce)partitions.filterNot((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$3($this, id)))).toList().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitions.remove((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$5(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Set)x0$1._2()).isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$1(LogCleanerManager $this) {
        $this.uncleanablePartitions().values().foreach((Function1 & Serializable & scala.Serializable)partitions -> {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$2($this, partitions);
            return BoxedUnit.UNIT;
        });
        ((MapLike)$this.uncleanablePartitions().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$5(x0$1)))).keys().toList().foreach((Function1 & Serializable & scala.Serializable)key -> $this.uncleanablePartitions().remove(key));
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.cleanBytesLast = new AtomicLong(0L);
        this.cleanableBytesLast = new AtomicLong(0L);
        this.uncleanableBytesLast = new AtomicLong(0L);
        this.dirtiestLogCleanableRatio = 0.0;
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$2(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$7(this.dir$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.newGauge("compacted-partition-bytes", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$3;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$13(this.dir$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$3 = dir$3;
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))));
            this.newGauge("compacted-partition-local-bytes", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$3;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$16(this.dir$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$3 = dir$3;
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))));
            return this.newGauge("compacted-partition-tiered-bytes", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$3;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$19(this.dir$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$3 = dir$3;
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))));
        });
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$22();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.achievedCleaningRatio = this.newHistogram("AchievedCleaningRatio", this.newHistogram$default$2(), this.newHistogram$default$3());
    }
}

