/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleanerMetrics$;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.ThreadsCpuMeter;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B#G\u0001-C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011)\u0019!C\u0001U\"A\u0011\u0010\u0001B\u0001B\u0003%1\u000e\u0003\u0005{\u0001\t\u0015\r\u0011\"\u0001|\u0011%\tY\u0002\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u001e\u0001\u0011)\u0019!C\u0001\u0003?A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011)\tI\u0003\u0001B\u0001B\u0003%\u00111\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011%\t)\u0005\u0001a\u0001\n\u0013\t9\u0005C\u0005\u0002J\u0001\u0001\r\u0011\"\u0003\u0002L!9\u0011q\u000b\u0001!B\u0013)\u0007\"CA1\u0001\t\u0007I\u0011AA2\u0011!\tY\u0007\u0001Q\u0001\n\u0005\u0015\u0004\"CA7\u0001\u0001\u0007I\u0011BA8\u0011%\ti\b\u0001a\u0001\n\u0013\ty\b\u0003\u0005\u0002\u0004\u0002\u0001\u000b\u0015BA9\u0011%\t)\t\u0001b\u0001\n\u0013\t9\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAE\u0011)\t\t\n\u0001b\u0001\n\u00031\u00151\u0013\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002\u0016\"Q\u0011Q\u0014\u0001C\u0002\u0013\u0005a)a(\t\u0011\tM\u0004\u0001)A\u0005\u0003CCqA!\u001e\u0001\t\u0013\u00119\b\u0003\u0005\u0003\n\u0002!\tA\u0012BF\u0011\u001d\u0011i\t\u0001C\u0001\u0005+AqAa$\u0001\t\u0003\u0011)\u0002C\u0004\u0003\u0012\u0002!\tEa%\t\u000f\tm\u0005\u0001\"\u0011\u0003\u001e\"9!\u0011\u0016\u0001\u0005B\t-\u0006b\u0002BZ\u0001\u0011\u0005!Q\u0017\u0005\b\u0005s\u0003A\u0011\u0001B^\u0011%\u00119\rAI\u0001\n\u0003\u0011I\rC\u0004\u0003`\u0002!\tA!9\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!Q\u001f\u0001\u0005\u0002\t]\bbBB\u0001\u0001\u0011\u000511\u0001\u0005\b\u0007\u000f\u0001A\u0011AB\u0005\u0011\u001d\u0019)\u0002\u0001C\u0001\u0007/A\u0011b!\t\u0001#\u0003%\taa\t\t\u000f\r\u001d\u0002\u0001\"\u0001\u0004*!A11\u0007\u0001\u0005\u0002!\u000b9\u0005\u0003\u0005\u00046\u0001!\tA\u0012BF\r\u001d\t\t\f\u0001\u0001G\u0003gC!\"a/-\u0005\u0003\u0005\u000b\u0011BA_\u0011\u001d\t)\u0004\fC\u0001\u0003\u0007Dq!a2-\t#\nI\rC\u0005\u0002X2\u0012\r\u0011\"\u0001\u0002Z\"A\u0011\u0011\u001d\u0017!\u0002\u0013\tY\u000eC\u0005\u0002d2\u0002\r\u0011\"\u0001\u0002f\"I\u0011Q\u001e\u0017A\u0002\u0013\u0005\u0011q\u001e\u0005\t\u0003gd\u0003\u0015)\u0003\u0002h\"I\u0011q\u001f\u0017A\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005\u0003a\u0003\u0019!C\u0001\u0005\u0007A\u0001Ba\u0002-A\u0003&\u00111 \u0005\b\u0005\u0017aC\u0011\u0002B\u0007\u0011\u001d\u0011\u0019\u0002\fC!\u0005+AqAa\u0006-\t\u0013\u0011I\u0002C\u0004\u0003\"1\"IA!\u0007\t\u000f\tMB\u0006\"\u0003\u00036!9!\u0011\t\u0017\u0005\u0002\t\rsaBB\u001c\r\"\u00051\u0011\b\u0004\u0007\u000b\u001aC\taa\u000f\t\u000f\u0005Ur\b\"\u0001\u0004>!I1qH C\u0002\u0013\u00051\u0011\t\u0005\t\u0007\u000bz\u0004\u0015!\u0003\u0004D!91qI \u0005\u0002\r%\u0003\"CB'\u007fE\u0005I\u0011AB(\u0005)aunZ\"mK\u0006tWM\u001d\u0006\u0003\u000f\"\u000b1\u0001\\8h\u0015\u0005I\u0015!B6bM.\f7\u0001A\n\u0006\u00011\u0013\u0006L\u0018\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M3V\"\u0001+\u000b\u0005UC\u0015!B;uS2\u001c\u0018BA,U\u0005\u001daunZ4j]\u001e\u0004\"!\u0017/\u000e\u0003iS!a\u0017%\u0002\u000f5,GO]5dg&\u0011QL\u0017\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\bCA0c\u001b\u0005\u0001'BA1I\u0003\u0019\u0019XM\u001d<fe&\u00111\r\u0019\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\t1w-D\u0001G\u0013\tAgIA\u0007DY\u0016\fg.\u001a:D_:4\u0017nZ\u0001\bY><G)\u001b:t+\u0005Y\u0007c\u00017pc6\tQN\u0003\u0002o\u001d\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Al'aA*fcB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0003S>T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yg\n!a)\u001b7f\u0003!awn\u001a#jeN\u0004\u0013\u0001\u00027pON,\u0012\u0001 \t\u0006'v|\u0018QC\u0005\u0003}R\u0013A\u0001U8pYB!\u0011\u0011AA\t\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB2p[6|gNC\u0002J\u0003\u0013QA!a\u0003\u0002\u000e\u00051\u0011\r]1dQ\u0016T!!a\u0004\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0014\u0005\r!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004M\u0006]\u0011bAA\r\r\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003\u0015awnZ:!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\u0011\u0011\u0011\u0005\t\u0004?\u0006\r\u0012bAA\u0013A\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0003uS6,\u0007\u0003BA\u0017\u0003ci!!a\f\u000b\u0007U\u000b\u0019!\u0003\u0003\u00024\u0005=\"\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003DA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0003C\u00014\u0001\u0011\u0015!\u0017\u00021\u0001f\u0011\u0015I\u0017\u00021\u0001l\u0011\u0015Q\u0018\u00021\u0001}\u0011\u001d\ti\"\u0003a\u0001\u0003CA\u0011\"!\u000b\n!\u0003\u0005\r!a\u000b\u0002\r\r|gNZ5h+\u0005)\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011QJA*!\ri\u0015qJ\u0005\u0004\u0003#r%\u0001B+oSRD\u0001\"!\u0016\f\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\r\t\u0015\u0004\u0019\u0005m\u0003cA'\u0002^%\u0019\u0011q\f(\u0003\u0011Y|G.\u0019;jY\u0016\fab\u00197fC:,'/T1oC\u001e,'/\u0006\u0002\u0002fA\u0019a-a\u001a\n\u0007\u0005%dIA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fqb\u00197fC:,'/T1oC\u001e,'\u000fI\u0001\u0013G>l\u0007/Y2uS>t7\t];NKR,'/\u0006\u0002\u0002rA)Q*a\u001d\u0002x%\u0019\u0011Q\u000f(\u0003\r=\u0003H/[8o!\r\u0019\u0016\u0011P\u0005\u0004\u0003w\"&a\u0004+ie\u0016\fGm]\"qk6+G/\u001a:\u0002-\r|W\u000e]1di&|gn\u00119v\u001b\u0016$XM]0%KF$B!!\u0014\u0002\u0002\"I\u0011Q\u000b\t\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0014G>l\u0007/Y2uS>t7\t];NKR,'\u000fI\u0001\u000fG2,\u0017M\\3s\u001b\u0016$(/[2t+\t\tI\tE\u0002g\u0003\u0017K1!!$G\u0005EaunZ\"mK\u0006tWM]'fiJL7m]\u0001\u0010G2,\u0017M\\3s\u001b\u0016$(/[2tA\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u0003+\u00032aUAL\u0013\r\tI\n\u0016\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!\u0019G.Z1oKJ\u001cXCAAQ!\u0019\t\u0019+!+\u0002.6\u0011\u0011Q\u0015\u0006\u0004\u0003Ok\u0017aB7vi\u0006\u0014G.Z\u0005\u0005\u0003W\u000b)KA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcAAXY5\t\u0001AA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0004Y\u0005U\u0006cA*\u00028&\u0019\u0011\u0011\u0018+\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\rZ\u0001\ti\"\u0014X-\u00193JIB\u0019Q*a0\n\u0007\u0005\u0005gJA\u0002J]R$B!!,\u0002F\"9\u00111\u0018\u0018A\u0002\u0005u\u0016A\u00037pO\u001e,'OT1nKV\u0011\u00111\u001a\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011[;\u0002\t1\fgnZ\u0005\u0005\u0003+\fyM\u0001\u0004TiJLgnZ\u0001\bG2,\u0017M\\3s+\t\tY\u000eE\u0002g\u0003;L1!a8G\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\nY\u0006\u001cHo\u0015;biN,\"!a:\u0011\u0007\u0019\fI/C\u0002\u0002l\u001a\u0013Ab\u00117fC:,'o\u0015;biN\fQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA'\u0003cD\u0011\"!\u00164\u0003\u0003\u0005\r!a:\u0002\u00151\f7\u000f^*uCR\u001c\b\u0005K\u00025\u00037\n\u0011\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t+\t\tY\u0010E\u0002g\u0003{L1!a@G\u00055\u0001&/Z\"mK\u0006t7\u000b^1ug\u0006)B.Y:u!J,7\t\\3b]N#\u0018\r^:`I\u0015\fH\u0003BA'\u0005\u000bA\u0011\"!\u00167\u0003\u0003\u0005\r!a?\u0002%1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8\u000f\t\u0015\u0004o\u0005m\u0013!C2iK\u000e\\Gi\u001c8f)\u0011\tiEa\u0004\t\r\tE\u0001\b1\u0001\u0000\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0001Z8X_J\\GCAA'\u0003Q!(/_\"mK\u0006tg)\u001b7uQ&,7\u000f\u001e'pOR\u0011!1\u0004\t\u0004\u001b\nu\u0011b\u0001B\u0010\u001d\n9!i\\8mK\u0006t\u0017!E2mK\u0006tg)\u001b7uQ&,7\u000f\u001e'pO\"*1H!\n\u00032A)QJa\n\u0003,%\u0019!\u0011\u0006(\u0003\rQD'o\\<t!\r1'QF\u0005\u0004\u0005_1%\u0001\u0006'pO\u000ecW-\u00198j]\u001e,\u0005pY3qi&|gn\t\u0002\u0003,\u0005A1\r\\3b]2{w\r\u0006\u0003\u0002N\t]\u0002b\u0002B\u001dy\u0001\u0007!1H\u0001\nG2,\u0017M\\1cY\u0016\u00042A\u001aB\u001f\u0013\r\u0011yD\u0012\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u0003:fG>\u0014Hm\u0015;biN$B\"!\u0014\u0003F\t%#\u0011\rB6\u0005_BqAa\u0012>\u0001\u0004\ti,\u0001\u0002jI\"9!1J\u001fA\u0002\t5\u0013\u0001\u00028b[\u0016\u0004BAa\u0014\u0003^9!!\u0011\u000bB-!\r\u0011\u0019FT\u0007\u0003\u0005+R1Aa\u0016K\u0003\u0019a$o\\8u}%\u0019!1\f(\u0002\rA\u0013X\rZ3g\u0013\u0011\t)Na\u0018\u000b\u0007\tmc\nC\u0004\u0003du\u0002\rA!\u001a\u0002\t\u0019\u0014x.\u001c\t\u0004\u001b\n\u001d\u0014b\u0001B5\u001d\n!Aj\u001c8h\u0011\u001d\u0011i'\u0010a\u0001\u0005K\n!\u0001^8\t\u000f\tET\b1\u0001\u0002h\u0006)1\u000f^1ug\u0006I1\r\\3b]\u0016\u00148\u000fI\u0001\u0016[\u0006DxJ^3s\u00072,\u0017M\\3s)\"\u0014X-\u00193t)\u0011\tiL!\u001f\t\u000f\tm\u0004\u00041\u0001\u0003~\u0005\ta\rE\u0004N\u0005\u007f\niKa!\n\u0007\t\u0005eJA\u0005Gk:\u001cG/[8ocA\u0019QJ!\"\n\u0007\t\u001deJ\u0001\u0004E_V\u0014G.Z\u0001\u0010I\u0016\fG\r\u00165sK\u0006$7i\\;oiV\u0011\u0011QX\u0001\bgR\f'\u000f^;q\u0003!\u0019\b.\u001e;e_^t\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005+\u0003R\u0001\u001cBL\u0005\u001bJ1A!'n\u0005\r\u0019V\r^\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$B!!\u0014\u0003 \"9!\u0011U\u000fA\u0002\t\r\u0016!\u00038fo\u000e{gNZ5h!\ry&QU\u0005\u0004\u0005O\u0003'aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1\u0011Q\nBW\u0005cCqAa,\u001f\u0001\u0004\u0011\u0019+A\u0005pY\u0012\u001cuN\u001c4jO\"9!\u0011\u0015\u0010A\u0002\t\r\u0016!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002N\t]\u0006B\u0002B\t?\u0001\u0007q0A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$b!!\u0014\u0003>\n\u0005\u0007B\u0002B`A\u0001\u0007\u0011/A\u0004eCR\fG)\u001b:\t\u0013\t\r\u0007\u0005%AA\u0002\t\u0015\u0017!\u00059beRLG/[8o)>\u0014V-\\8wKB!Q*a\u001d\u0000\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u001a\u0016\u0005\u0005\u000b\u0014im\u000b\u0002\u0003PB!!\u0011\u001bBn\u001b\t\u0011\u0019N\u0003\u0003\u0003V\n]\u0017!C;oG\",7m[3e\u0015\r\u0011INT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bo\u0005'\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\tG\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:\u0015\u0011\u00055#1\u001dBs\u0005SDaA!\u0005#\u0001\u0004y\bB\u0002BtE\u0001\u0007\u0011/\u0001\u0007t_V\u00148-\u001a'pO\u0012K'\u000f\u0003\u0004\u0003l\n\u0002\r!]\u0001\u000bI\u0016\u001cH\u000fT8h\t&\u0014\u0018a\u00055b]\u0012dW\rT8h\t&\u0014h)Y5mkJ,G\u0003BA'\u0005cDqAa=$\u0001\u0004\u0011i%A\u0002eSJ\fq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u0011\u00055#\u0011 B~\u0005{DaAa0%\u0001\u0004\t\bB\u0002B\tI\u0001\u0007q\u0010C\u0004\u0003\u0000\u0012\u0002\rA!\u001a\u0002\r=4gm]3u\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$B!!\u0014\u0004\u0006!1!\u0011C\u0013A\u0002}\faB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u0002N\r-\u0001bBB\u0007M\u0001\u00071qB\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB!An!\u0005\u0000\u0013\r\u0019\u0019\"\u001c\u0002\t\u0013R,'/\u00192mK\u0006a\u0011m^1ji\u000ecW-\u00198fIRA!1DB\r\u00077\u0019i\u0002\u0003\u0004\u0003\u0012\u001d\u0002\ra \u0005\b\u0005\u007f<\u0003\u0019\u0001B3\u0011%\u0019yb\nI\u0001\u0002\u0004\u0011)'A\u0005nCb<\u0016-\u001b;Ng\u00061\u0012m^1ji\u000ecW-\u00198fI\u0012\"WMZ1vYR$3'\u0006\u0002\u0004&)\"!Q\rBg\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0007W\u0001R\u0001\\B\t\u0007[\u0001b!TB\u0018\u007f\u0006U\u0011bAB\u0019\u001d\n1A+\u001e9mKJ\nQbY;se\u0016tGoQ8oM&<\u0017\u0001D2mK\u0006tWM]\"pk:$\u0018A\u0003'pO\u000ecW-\u00198feB\u0011amP\n\u0003\u007f1#\"a!\u000f\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u001111\t\t\u0006Y\n]\u00151Z\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005i1\r\\3b]\u0016\u00148i\u001c8gS\u001e$2!ZB&\u0011\u001d\t)e\u0011a\u0001\u0005G\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAB)U\u0011\tYC!4")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private Option<ThreadsCpuMeter> compactionCpuMeter;
    private final LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    private Option<ThreadsCpuMeter> compactionCpuMeter() {
        return this.compactionCpuMeter;
    }

    private void compactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.compactionCpuMeter = x$1;
    }

    public LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics() {
        return this.kafka$log$LogCleaner$$cleanerMetrics;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
        this.compactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((Seq<Object>)((SeqLike)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getId()), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq())));
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond();
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (long)((int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }))) / 1000L;
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$3() {
        return this.cleanerManager().cleanBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$4() {
        return this.cleanerManager().cleanableBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$5() {
        return this.cleanerManager().uncleanableBytesLast().get();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$6() {
        return (int)((double)100 * this.cleanerManager().dirtiestLogCleanableRatio());
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$2) {
        return x$2.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$2));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public final /* synthetic */ double kafka$log$LogCleaner$$$anonfun$new$9() {
        return BoxesRunTime.unboxToDouble((Object)this.compactionCpuMeter().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) * (double)100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$12() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$17(CleanerThread x$7) {
        return x$7.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$16() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$17(x$7));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$18() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.compactionCpuMeter = None$.MODULE$;
        this.kafka$log$LogCleaner$$cleanerMetrics = new LogCleanerMetrics(LogCleanerMetrics$.MODULE$.$lessinit$greater$default$1());
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxCompactionDelayGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsUncleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxDirtyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxBufferUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final double value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanerRecopyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$16();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$18();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(ltc);
            }
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$12 -> (TopicPartition)x$12._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tOffset Map is Full: %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stats.offsetMapFull())}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (log.isFrozenLogStartOffsetState()) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Log cleanup blocked for ").append(log).append(" as it is in frozen start offset state").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun() - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            }, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastStats = new CleanerStats(LogCleaner.this.kafka$log$LogCleaner$$time, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

