/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.log.LogCleanerMetrics;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u001a5\u0001eB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")\u0011\f\u0001C\u00015\"9a\f\u0001b\u0001\n\u0003y\u0006BB2\u0001A\u0003%\u0001\rC\u0004e\u0001\u0001\u0007I\u0011A0\t\u000f\u0015\u0004\u0001\u0019!C\u0001M\"1A\u000e\u0001Q!\n\u0001Dq!\u001c\u0001A\u0002\u0013\u0005q\fC\u0004o\u0001\u0001\u0007I\u0011A8\t\rE\u0004\u0001\u0015)\u0003a\u0011\u001d\u0011\b\u00011A\u0005\u0002}Cqa\u001d\u0001A\u0002\u0013\u0005A\u000f\u0003\u0004w\u0001\u0001\u0006K\u0001\u0019\u0005\bo\u0002\u0001\r\u0011\"\u0001`\u0011\u001dA\b\u00011A\u0005\u0002eDaa\u001f\u0001!B\u0013\u0001\u0007b\u0002?\u0001\u0001\u0004%\ta\u0018\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0011\u001d\t\t\u0001\u0001Q!\n\u0001D\u0001\"a\u0001\u0001\u0001\u0004%\ta\u0018\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0001\u0003\u000fAq!a\u0003\u0001A\u0003&\u0001\r\u0003\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0001`\u0011%\ty\u0001\u0001a\u0001\n\u0003\t\t\u0002C\u0004\u0002\u0016\u0001\u0001\u000b\u0015\u00021\t\u0011\u0005]\u0001\u00011A\u0005\u0002}C\u0011\"!\u0007\u0001\u0001\u0004%\t!a\u0007\t\u000f\u0005}\u0001\u0001)Q\u0005A\"A\u0011\u0011\u0005\u0001A\u0002\u0013\u0005q\fC\u0005\u0002$\u0001\u0001\r\u0011\"\u0001\u0002&!9\u0011\u0011\u0006\u0001!B\u0013\u0001\u0007\"CA\u0016\u0001\u0001\u0007I\u0011AA\u0017\u0011%\t)\u0004\u0001a\u0001\n\u0003\t9\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0015BA\u0018\u0011%\ti\u0004\u0001a\u0001\n\u0003\ty\u0004C\u0005\u0002H\u0001\u0001\r\u0011\"\u0001\u0002J!A\u0011Q\n\u0001!B\u0013\t\t\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!a \u0001\t\u0003\ty\u0006C\u0004\u0002\u0002\u0002!\t!a\u0018\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002`!9\u0011Q\u0011\u0001\u0005\u0002\u0005}\u0003bBAD\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u0013\u0003A\u0011AA\u0017\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0015\t)d'A\u0002m_\u001eT\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r3\u0014aB7fiJL7m]\u0005\u0003\u000b\n\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0011!\u0018.\\3\u0011\u0005!\u0013V\"A%\u000b\u0005)[\u0015!B;uS2\u001c(B\u0001'N\u0003\u0019\u0019w.\\7p]*\u0011qG\u0014\u0006\u0003\u001fB\u000ba!\u00199bG\",'\"A)\u0002\u0007=\u0014x-\u0003\u0002T\u0013\n!A+[7f\u00039\u0019G.Z1oKJlU\r\u001e:jGN\u0004\"AV,\u000e\u0003QJ!\u0001\u0017\u001b\u0003#1{wm\u00117fC:,'/T3ue&\u001c7/\u0001\u0004=S:LGO\u0010\u000b\u00047rk\u0006C\u0001,\u0001\u0011\u001515\u00011\u0001H\u0011\u0015!6\u00011\u0001V\u0003%\u0019H/\u0019:u)&lW-F\u0001a!\tY\u0014-\u0003\u0002cy\t!Aj\u001c8h\u0003)\u0019H/\u0019:u)&lW\rI\u0001\u0010[\u0006\u00048i\\7qY\u0016$X\rV5nK\u0006\u0019R.\u00199D_6\u0004H.\u001a;f)&lWm\u0018\u0013fcR\u0011qM\u001b\t\u0003w!L!!\u001b\u001f\u0003\tUs\u0017\u000e\u001e\u0005\bW\u001e\t\t\u00111\u0001a\u0003\rAH%M\u0001\u0011[\u0006\u00048i\\7qY\u0016$X\rV5nK\u0002\nq!\u001a8e)&lW-A\u0006f]\u0012$\u0016.\\3`I\u0015\fHCA4q\u0011\u001dY'\"!AA\u0002\u0001\f\u0001\"\u001a8e)&lW\rI\u0001\nEf$Xm\u001d*fC\u0012\fQBY=uKN\u0014V-\u00193`I\u0015\fHCA4v\u0011\u001dYW\"!AA\u0002\u0001\f!BY=uKN\u0014V-\u00193!\u00031\u0011\u0017\u0010^3t/JLG\u000f^3o\u0003A\u0011\u0017\u0010^3t/JLG\u000f^3o?\u0012*\u0017\u000f\u0006\u0002hu\"91\u000eEA\u0001\u0002\u0004\u0001\u0017!\u00042zi\u0016\u001cxK]5ui\u0016t\u0007%\u0001\u0007nCB\u0014\u0015\u0010^3t%\u0016\fG-\u0001\tnCB\u0014\u0015\u0010^3t%\u0016\fGm\u0018\u0013fcR\u0011qm \u0005\bWN\t\t\u00111\u0001a\u00035i\u0017\r\u001d\"zi\u0016\u001c(+Z1eA\u0005yQ.\u00199NKN\u001c\u0018mZ3t%\u0016\fG-A\nnCBlUm]:bO\u0016\u001c(+Z1e?\u0012*\u0017\u000fF\u0002h\u0003\u0013Aqa\u001b\f\u0002\u0002\u0003\u0007\u0001-\u0001\tnCBlUm]:bO\u0016\u001c(+Z1eA\u0005aQ.Z:tC\u001e,7OU3bI\u0006\u0001R.Z:tC\u001e,7OU3bI~#S-\u001d\u000b\u0004O\u0006M\u0001bB6\u001a\u0003\u0003\u0005\r\u0001Y\u0001\u000e[\u0016\u001c8/Y4fgJ+\u0017\r\u001a\u0011\u0002'%tg/\u00197jI6+7o]1hKN\u0014V-\u00193\u0002/%tg/\u00197jI6+7o]1hKN\u0014V-\u00193`I\u0015\fHcA4\u0002\u001e!91\u000eHA\u0001\u0002\u0004\u0001\u0017\u0001F5om\u0006d\u0017\u000eZ'fgN\fw-Z:SK\u0006$\u0007%A\bnKN\u001c\u0018mZ3t/JLG\u000f^3o\u0003MiWm]:bO\u0016\u001cxK]5ui\u0016tw\fJ3r)\r9\u0017q\u0005\u0005\bW~\t\t\u00111\u0001a\u0003AiWm]:bO\u0016\u001cxK]5ui\u0016t\u0007%A\tck\u001a4WM]+uS2L'0\u0019;j_:,\"!a\f\u0011\u0007m\n\t$C\u0002\u00024q\u0012a\u0001R8vE2,\u0017!\u00062vM\u001a,'/\u0016;jY&T\u0018\r^5p]~#S-\u001d\u000b\u0004O\u0006e\u0002\u0002C6#\u0003\u0003\u0005\r!a\f\u0002%\t,hMZ3s+RLG.\u001b>bi&|g\u000eI\u0001\u000e_\u001a47/\u001a;NCB4U\u000f\u001c7\u0016\u0005\u0005\u0005\u0003cA\u001e\u0002D%\u0019\u0011Q\t\u001f\u0003\u000f\t{w\u000e\\3b]\u0006\trN\u001a4tKRl\u0015\r\u001d$vY2|F%Z9\u0015\u0007\u001d\fY\u0005\u0003\u0005lK\u0005\u0005\t\u0019AA!\u00039ygMZ:fi6\u000b\u0007OR;mY\u0002\nAB]3bI6+7o]1hKN$RaZA*\u00037Bq!!\u0004(\u0001\u0004\t)\u0006E\u0002<\u0003/J1!!\u0017=\u0005\rIe\u000e\u001e\u0005\u0007e\u001e\u0002\r!!\u0016\u0002\u001d%tg/\u00197jI6+7o]1hKR\tq-\u0001\bsK\u000e|\u0007/_'fgN\fw-Z:\u0015\u000b\u001d\f)'a\u001a\t\u000f\u0005\u0005\u0012\u00061\u0001\u0002V!1q/\u000ba\u0001\u0003+\n\u0011#\u001b8eKblUm]:bO\u0016\u001c(+Z1e)\r9\u0017Q\u000e\u0005\b\u0003_R\u0003\u0019AA+\u0003\u0011\u0019\u0018N_3\u0002\u001d%tG-\u001a=CsR,7OU3bIR\u0019q-!\u001e\t\u000f\u0005=4\u00061\u0001\u0002V\u0005I\u0011N\u001c3fq\u0012{g.\u001a\u000b\u0004O\u0006m\u0004bBA?Y\u0001\u0007\u0011\u0011I\u0001\u0010SN|eMZ:fi6\u000b\u0007OR;mY\u0006\u0001b/\u00197jI\u0006$\u0018n\u001c8QCN\u001cX\rZ\u0001\u0012m\u0006d\u0017\u000eZ1uS>t\u0017IY8si\u0016$\u0017\u0001\u0005<bY&$\u0017\r^5p]\u001a\u000b\u0017\u000e\\3e\u0003\u001d\tG\u000e\u001c#p]\u0016\f1\"\u001a7baN,GmU3dg\u0006\u0001R\r\\1qg\u0016$\u0017J\u001c3fqN+7m\u001d")
public class CleanerStats
implements KafkaMetricsGroup {
    private final Time time;
    private final LogCleanerMetrics cleanerMetrics;
    private final long startTime;
    private long mapCompleteTime;
    private long endTime;
    private long bytesRead;
    private long bytesWritten;
    private long mapBytesRead;
    private long mapMessagesRead;
    private long messagesRead;
    private long invalidMessagesRead;
    private long messagesWritten;
    private double bufferUtilization;
    private boolean offsetMapFull;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public long startTime() {
        return this.startTime;
    }

    public long mapCompleteTime() {
        return this.mapCompleteTime;
    }

    public void mapCompleteTime_$eq(long x$1) {
        this.mapCompleteTime = x$1;
    }

    public long endTime() {
        return this.endTime;
    }

    public void endTime_$eq(long x$1) {
        this.endTime = x$1;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public void bytesWritten_$eq(long x$1) {
        this.bytesWritten = x$1;
    }

    public long mapBytesRead() {
        return this.mapBytesRead;
    }

    public void mapBytesRead_$eq(long x$1) {
        this.mapBytesRead = x$1;
    }

    public long mapMessagesRead() {
        return this.mapMessagesRead;
    }

    public void mapMessagesRead_$eq(long x$1) {
        this.mapMessagesRead = x$1;
    }

    public long messagesRead() {
        return this.messagesRead;
    }

    public void messagesRead_$eq(long x$1) {
        this.messagesRead = x$1;
    }

    public long invalidMessagesRead() {
        return this.invalidMessagesRead;
    }

    public void invalidMessagesRead_$eq(long x$1) {
        this.invalidMessagesRead = x$1;
    }

    public long messagesWritten() {
        return this.messagesWritten;
    }

    public void messagesWritten_$eq(long x$1) {
        this.messagesWritten = x$1;
    }

    public double bufferUtilization() {
        return this.bufferUtilization;
    }

    public void bufferUtilization_$eq(double x$1) {
        this.bufferUtilization = x$1;
    }

    public boolean offsetMapFull() {
        return this.offsetMapFull;
    }

    public void offsetMapFull_$eq(boolean x$1) {
        this.offsetMapFull = x$1;
    }

    public void readMessages(int messagesRead, int bytesRead) {
        this.messagesRead_$eq(this.messagesRead() + (long)messagesRead);
        this.bytesRead_$eq(this.bytesRead() + (long)bytesRead);
        this.cleanerMetrics.bytesReadPerSec().mark((long)bytesRead);
    }

    public void invalidMessage() {
        this.invalidMessagesRead_$eq(this.invalidMessagesRead() + 1L);
    }

    public void recopyMessages(int messagesWritten, int bytesWritten) {
        this.messagesWritten_$eq(this.messagesWritten() + (long)messagesWritten);
        this.bytesWritten_$eq(this.bytesWritten() + (long)bytesWritten);
        this.cleanerMetrics.bytesWrittenPerSec().mark((long)bytesWritten);
    }

    public void indexMessagesRead(int size) {
        this.mapMessagesRead_$eq(this.mapMessagesRead() + (long)size);
    }

    public void indexBytesRead(int size) {
        this.mapBytesRead_$eq(this.mapBytesRead() + (long)size);
        this.cleanerMetrics.offsetIndexBytesPerSec().mark((long)size);
    }

    public void indexDone(boolean isOffsetMapFull) {
        this.offsetMapFull_$eq(isOffsetMapFull);
        this.mapCompleteTime_$eq(this.time.milliseconds());
        if (this.offsetMapFull()) {
            this.cleanerMetrics.offsetMapFilledRatePerSec().mark();
        }
    }

    public void validationPassed() {
        this.cleanerMetrics.validationPassedPerSec().mark();
    }

    public void validationAborted() {
        this.cleanerMetrics.validationAbortedPerSec().mark();
    }

    public void validationFailed() {
        this.cleanerMetrics.validationFailedPerSec().mark();
    }

    public void allDone() {
        this.endTime_$eq(this.time.milliseconds());
    }

    public double elapsedSecs() {
        return (double)(this.endTime() - this.startTime()) / 1000.0;
    }

    public double elapsedIndexSecs() {
        return (double)(this.mapCompleteTime() - this.startTime()) / 1000.0;
    }

    public CleanerStats(Time time, LogCleanerMetrics cleanerMetrics) {
        this.time = time;
        this.cleanerMetrics = cleanerMetrics;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.startTime = time.milliseconds();
        this.mapCompleteTime = -1L;
        this.endTime = -1L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.mapBytesRead = 0L;
        this.mapMessagesRead = 0L;
        this.messagesRead = 0L;
        this.invalidMessagesRead = 0L;
        this.messagesWritten = 0L;
        this.bufferUtilization = 0.0;
        this.offsetMapFull = false;
    }
}

