/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.availability.FilesWrapper;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType;
import kafka.log.IndexSearchType$KEY$;
import kafka.log.IndexSearchType$VALUE$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$;
import org.apache.kafka.common.utils.ByteBufferUnmapper;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f!\u0002!B\u0003\u00031\u0005\u0002C+\u0001\u0005\u0003\u0007I\u0011\u0002,\t\u0011i\u0003!\u00111A\u0005\nmC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Ka\u0016\u0005\tS\u0002\u0011)\u0019!C\u0001U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011i\u0004!\u0011!Q\u0001\n]D\u0001b\u001f\u0001\u0003\u0006\u0004%\tA\u001e\u0005\ty\u0002\u0011\t\u0011)A\u0005o\")Q\u0010\u0001C\u0001}\"Q\u0011Q\u0002\u0001A\u0002\u0003\u0007I\u0011\u00026\t\u0017\u0005=\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0003\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013Y\u0007BBA\r\u0001\u0019E\u0001\u000f\u0003\u0004\u0002\u001c\u0001!\t\u0002\u001d\u0005\n\u0003;\u0001!\u0019!C\t\u0003?A\u0001\"!\u000e\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003o\u0001\u0001\u0019!C\t\u0003sA\u0011\"a\u0012\u0001\u0001\u0004%\t\"!\u0013\t\u0011\u00055\u0003\u0001)Q\u0005\u0003wAq!!\u0015\u0001A\u0003&\u0011\u000f\u0003\u0005\u0002V\u0001\u0001\r\u0011\"\u0005q\u0011%\t9\u0006\u0001a\u0001\n#\tI\u0006C\u0004\u0002^\u0001\u0001\u000b\u0015B9\t\r\u0005\u0005\u0004\u0001\"\u0001w\u0011\u0019\t\u0019\u0007\u0001C\u0001-\"1\u0011Q\r\u0001\u0005\u0002ADa!a\u001a\u0001\t\u0003\u0001\bBBA5\u0001\u0011\u0005!\u000eC\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\tY\t\u0001C\u0001\u0003\u000bCa!!$\u0001\t\u0003\u0001\bbBAH\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003#\u0003A\u0011AAC\u0011\u001d\t\u0019\n\u0001D\u0001\u0003\u000bCq!!&\u0001\r#\t)\tC\u0004\u0002\u0018\u00021\t!!'\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\u0006\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003[\u0003A\u0011CAC\u0011!\ty\u000b\u0001C\t\u0003\u0006\u0015\u0005bBAY\u0001\u0011E\u00111\u0017\u0005\b\u0003C\u0004a\u0011CAr\u0011\u001d\tI\u0010\u0001C\t\u0003wDqAa\u0004\u0001\t#\u0011\t\u0002C\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9!Q\u0007\u0001\u0005\n\t]\u0002b\u0002B!\u0001\u0011%!1I\u0004\b\u0005\u001b\n\u0005\u0012\u0001B(\r\u0019\u0001\u0015\t#\u0001\u0003R!1QP\u000fC\u0001\u0005KB\u0011Ba\u001a;\u0005\u0004%\tE!\u001b\t\u0011\t\u0005%\b)A\u0005\u0005WB\u0011Ba!;#\u0003%\tA!\"\t\u0013\tm%(%A\u0005\u0002\tu%!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002C\u0007\u0006\u0019An\\4\u000b\u0003\u0011\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u000f>\u0003\"\u0001S'\u000e\u0003%S!AS&\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tq\u0015J\u0001\u0004PE*,7\r\u001e\t\u0003!Nk\u0011!\u0015\u0006\u0003%.\u000b!![8\n\u0005Q\u000b&!C\"m_N,\u0017M\u00197f\u0003\u0015yf-\u001b7f+\u00059\u0006C\u0001)Y\u0013\tI\u0016K\u0001\u0003GS2,\u0017!C0gS2,w\fJ3r)\ta&\r\u0005\u0002^A6\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tgL\u0001\u0003V]&$\bbB2\u0003\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0014AB0gS2,\u0007\u0005\u000b\u0002\u0004MB\u0011QlZ\u0005\u0003Qz\u0013\u0001B^8mCRLG.Z\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$X#A6\u0011\u0005uc\u0017BA7_\u0005\u0011auN\\4\u0002\u0017\t\f7/Z(gMN,G\u000fI\u0001\r[\u0006D\u0018J\u001c3fqNK'0Z\u000b\u0002cB\u0011QL]\u0005\u0003gz\u00131!\u00138u\u00035i\u0017\r_%oI\u0016D8+\u001b>fA\u0005\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\u0016\u0003]\u0004\"!\u0018=\n\u0005et&a\u0002\"p_2,\u0017M\\\u0001\u0013M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\b%\u0001\u0005xe&$\u0018M\u00197f\u0003%9(/\u001b;bE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\f\u007f\u0006\r\u0011QAA\u0004\u0003\u0013\tY\u0001E\u0002\u0002\u0002\u0001i\u0011!\u0011\u0005\u0006+2\u0001\ra\u0016\u0005\u0006S2\u0001\ra\u001b\u0005\b_2\u0001\n\u00111\u0001r\u0011\u001d)H\u0002%AA\u0002]DQa\u001f\u0007A\u0002]\fqa\u00187f]\u001e$\b.A\u0006`Y\u0016tw\r\u001e5`I\u0015\fHc\u0001/\u0002\u0014!91MDA\u0001\u0002\u0004Y\u0017\u0001C0mK:<G\u000f\u001b\u0011)\u0005=1\u0017!C3oiJL8+\u001b>f\u00031yv/\u0019:n\u000b:$(/[3t\u0003\u0011awnY6\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003ci!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003W\ti#\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\fL\u0003\u0011)H/\u001b7\n\t\u0005M\u0012Q\u0005\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\t5l\u0017\r]\u000b\u0003\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003Z\u0015a\u00018j_&!\u0011QIA \u0005Ai\u0015\r\u001d9fI\nKH/\u001a\"vM\u001a,'/\u0001\u0005n[\u0006\u0004x\fJ3r)\ra\u00161\n\u0005\tGV\t\t\u00111\u0001\u0002<\u0005)Q.\\1qA!\u0012aCZ\u0001\f?6\f\u00070\u00128ue&,7\u000f\u000b\u0002\u0018M\u0006Aq,\u001a8ue&,7/\u0001\u0007`K:$(/[3t?\u0012*\u0017\u000fF\u0002]\u00037BqaY\r\u0002\u0002\u0003\u0007\u0011/A\u0005`K:$(/[3tA!\u0012!DZ\u0001\u0007SN4U\u000f\u001c7\u0002\t\u0019LG.Z\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001c\u0018aB3oiJLWm]\u0001\u0007Y\u0016tw\r\u001e5\u0002\u001fU\u0004H-\u0019;f!\u0006\u0014XM\u001c;ESJ$2\u0001XA8\u0011\u0019\t\t\b\ta\u0001/\u0006I\u0001/\u0019:f]R$\u0015N]\u0001\u0007e\u0016\u001c\u0018N_3\u0015\u0007]\f9\b\u0003\u0004\u0002z\u0005\u0002\r!]\u0001\b]\u0016<8+\u001b>f\u0003!\u0011XM\\1nKR{Gc\u0001/\u0002\u0000!1\u0011\u0011\u0011\u0012A\u0002]\u000b\u0011AZ\u0001\u0006M2,8\u000f\u001b\u000b\u00029\u0006qA-\u001a7fi\u0016Le-\u0012=jgR\u001cH#A<\u0002\u001fQ\u0014\u0018.\u001c+p-\u0006d\u0017\u000eZ*ju\u0016\f1b]5{K&s')\u001f;fg\u0006)1\r\\8tK\u0006a1\r\\8tK\"\u000bg\u000e\u001a7fe\u0006Y1/\u00198jif\u001c\u0005.Z2l\u0003!!(/\u001e8dCR,\u0017A\u0003;sk:\u001c\u0017\r^3U_R\u0019A,a'\t\r\u0005u5\u00061\u0001l\u0003\u0019ygMZ:fi\u0006)!/Z:fi\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$HcA9\u0002&\"1\u0011QT\u0017A\u0002-\fqbY1o\u0003B\u0004XM\u001c3PM\u001a\u001cX\r\u001e\u000b\u0004o\u0006-\u0006BBAO]\u0001\u00071.\u0001\btC\u001a,gi\u001c:dKVsW.\u00199\u0002\u0015\u0019|'oY3V]6\f\u0007/A\u0005nCf\u0014W\rT8dWV!\u0011QWA_)\u0011\t9,!7\u0015\t\u0005e\u0016q\u001a\t\u0005\u0003w\u000bi\f\u0004\u0001\u0005\u000f\u0005}\u0016G1\u0001\u0002B\n\tA+\u0005\u0003\u0002D\u0006%\u0007cA/\u0002F&\u0019\u0011q\u00190\u0003\u000f9{G\u000f[5oOB\u0019Q,a3\n\u0007\u00055gLA\u0002B]fD\u0001\"!52\t\u0003\u0007\u00111[\u0001\u0004MVt\u0007#B/\u0002V\u0006e\u0016bAAl=\nAAHY=oC6,g\bC\u0004\u0002\u001eE\u0002\r!a7\u0011\t\u0005\r\u0012Q\\\u0005\u0005\u0003?\f)C\u0001\u0003M_\u000e\\\u0017A\u00039beN,WI\u001c;ssR1\u0011Q]Av\u0003k\u0004B!!\u0001\u0002h&\u0019\u0011\u0011^!\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010C\u0004\u0002nJ\u0002\r!a<\u0002\r\t,hMZ3s!\u0011\ti$!=\n\t\u0005M\u0018q\b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bBBA|e\u0001\u0007\u0011/A\u0001o\u0003aa\u0017M]4fgRdun^3s\u0005>,h\u000eZ*m_R4uN\u001d\u000b\bc\u0006u(\u0011\u0001B\u0003\u0011\u001d\typ\ra\u0001\u0003_\f1!\u001b3y\u0011\u0019\u0011\u0019a\ra\u0001W\u00061A/\u0019:hKRDqAa\u00024\u0001\u0004\u0011I!\u0001\u0007tK\u0006\u00148\r[#oi&$\u0018\u0010\u0005\u0003\u0002\u0002\t-\u0011b\u0001B\u0007\u0003\ny\u0011J\u001c3fqN+\u0017M]2i)f\u0004X-A\rt[\u0006dG.Z:u+B\u0004XM\u001d\"pk:$7\u000b\\8u\r>\u0014HcB9\u0003\u0014\tU!q\u0003\u0005\b\u0003\u007f$\u0004\u0019AAx\u0011\u0019\u0011\u0019\u0001\u000ea\u0001W\"9!q\u0001\u001bA\u0002\t%\u0011!E5oI\u0016D8\u000b\\8u%\u0006tw-\u001a$peRA!Q\u0004B\u0012\u0005K\u00119\u0003E\u0003^\u0005?\t\u0018/C\u0002\u0003\"y\u0013a\u0001V;qY\u0016\u0014\u0004bBA\u0000k\u0001\u0007\u0011q\u001e\u0005\u0007\u0005\u0007)\u0004\u0019A6\t\u000f\t\u001dQ\u00071\u0001\u0003\n\u0005\t2m\\7qCJ,\u0017J\u001c3fq\u0016sGO]=\u0015\u000fE\u0014iC!\r\u00034!9!q\u0006\u001cA\u0002\u0005\u0015\u0018AC5oI\u0016DXI\u001c;ss\"1!1\u0001\u001cA\u0002-DqAa\u00027\u0001\u0004\u0011I!\u0001\rs_VtG\rR8x]R{W\t_1di6+H\u000e^5qY\u0016$R!\u001dB\u001d\u0005{AaAa\u000f8\u0001\u0004\t\u0018A\u00028v[\n,'\u000f\u0003\u0004\u0003@]\u0002\r!]\u0001\u0007M\u0006\u001cGo\u001c:\u0002\u0015Q|'+\u001a7bi&4X\r\u0006\u0003\u0003F\t-\u0003\u0003B/\u0003HEL1A!\u0013_\u0005\u0019y\u0005\u000f^5p]\"1\u0011Q\u0014\u001dA\u0002-\fQ\"\u00112tiJ\f7\r^%oI\u0016D\bcAA\u0001uM)!Ha\u0015\u0003ZA\u0019QL!\u0016\n\u0007\t]cL\u0001\u0004B]f\u0014VM\u001a\t\u0005\u00057\u0012\t'\u0004\u0002\u0003^)\u0019!qL\"\u0002\u000bU$\u0018\u000e\\:\n\t\t\r$Q\f\u0002\b\u0019><w-\u001b8h)\t\u0011y%\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"Aa\u001b\u0011\t\t5$1\u0010\b\u0005\u0005_\u00129\bE\u0002\u0003ryk!Aa\u001d\u000b\u0007\tUT)\u0001\u0004=e>|GOP\u0005\u0004\u0005sr\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003~\t}$AB*ue&twMC\u0002\u0003zy\u000b1\u0002\\8hO\u0016\u0014h*Y7fA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"Aa\"+\u0007E\u0014Ii\u000b\u0002\u0003\fB!!Q\u0012BL\u001b\t\u0011yI\u0003\u0003\u0003\u0012\nM\u0015!C;oG\",7m[3e\u0015\r\u0011)JX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BM\u0005\u001f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0014\u0016\u0004o\n%\u0005")
public abstract class AbstractIndex
implements Closeable {
    private volatile File _file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean fileAlreadyExists;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;

    public static boolean $lessinit$greater$default$4() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return AbstractIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ fatal_this = abstractIndex$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void fatal(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ fatal_this = abstractIndex$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ error_this = abstractIndex$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            error_this.logger().underlying().error(error_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void error(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ error_this = abstractIndex$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            error_this.logger().underlying().error(error_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ warn_this = abstractIndex$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void warn(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ warn_this = abstractIndex$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ info_this = abstractIndex$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void info(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ info_this = abstractIndex$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ debug_this = abstractIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void debug(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ debug_this = abstractIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return AbstractIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return AbstractIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ trace_this = abstractIndex$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            trace_this.logger().underlying().trace(trace_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void trace(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ trace_this = abstractIndex$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            trace_this.logger().underlying().trace(trace_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    private File _file() {
        return this._file;
    }

    private void _file_$eq(File x$1) {
        this._file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean fileAlreadyExists() {
        return this.fileAlreadyExists;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public File file() {
        return this._file();
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    public void updateParentDir(File parentDir) {
        this._file_$eq(new File(parentDir, this.file().getName()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean resize(int newSize) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = AbstractIndex.$anonfun$resize$1(this, newSize);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath(), (boolean)false);
        }
        finally {
            this._file_$eq(f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void flush() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            AbstractIndex.$anonfun$flush$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return FilesWrapper.deleteIfExists((Path)this.file().toPath());
    }

    /*
     * WARNING - void declaration
     */
    public void trimToValidSize() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.resize(this.entrySize() * this._entries());
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    /*
     * WARNING - void declaration
     */
    public void closeHandler() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.safeForceUnmap();
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset) {
        Option<Object> relativeOffset = this.toRelative(offset);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringBuilder(32).append("Integer overflow for offset: ").append(offset).append(" (").append(this.file().getAbsoluteFile()).append(")").toString());
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset) {
        return this.toRelative(offset).isDefined();
    }

    public void safeForceUnmap() {
        block4: {
            if (this.mmap() != null) {
                try {
                    this.forceUnmap();
                    return;
                }
                catch (Throwable t) {
                    AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
                    if (abstractIndex$ == null) {
                        throw null;
                    }
                    AbstractIndex$ error_this = abstractIndex$;
                    if (!error_this.logger().underlying().isErrorEnabled()) break block4;
                    error_this.logger().underlying().error(error_this.msgWithLogIdent(AbstractIndex.$anonfun$safeForceUnmap$1(this)), t);
                    return;
                }
            }
        }
    }

    public void forceUnmap() {
        try {
            ByteBufferUnmapper.unmap((String)this.file().getAbsolutePath(), (ByteBuffer)this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS || OperatingSystem.IS_ZOS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS || OperatingSystem.IS_ZOS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, IndexSearchType searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, IndexSearchType searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, IndexSearchType searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, IndexSearchType searchEntity) {
        int n;
        if (IndexSearchType$KEY$.MODULE$.equals(searchEntity)) {
            n = Long.compare(indexEntry.indexKey(), target);
        } else if (IndexSearchType$VALUE$.MODULE$.equals(searchEntity)) {
            n = Long.compare(indexEntry.indexValue(), target);
        } else {
            throw new MatchError((Object)searchEntity);
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset) {
        long relativeOffset = offset - this.baseOffset();
        if (relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    public static final /* synthetic */ String $anonfun$resize$2(AbstractIndex $this, int roundedNewSize$1) {
        return new StringBuilder(51).append("Index ").append($this.file().getAbsolutePath()).append(" was not resized because it already has size ").append(roundedNewSize$1).toString();
    }

    public static final /* synthetic */ String $anonfun$resize$3(AbstractIndex $this, int roundedNewSize$1) {
        return new StringBuilder(40).append("Resized ").append($this.file().getAbsolutePath()).append(" to ").append(roundedNewSize$1).append(", position is ").append($this.mmap().position()).append(" ").append("and limit is ").append($this.mmap().limit()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resize$1(AbstractIndex $this, int newSize$1) {
        boolean bl;
        int roundedNewSize = $this.roundDownToExactMultiple(newSize$1, $this.entrySize());
        if ($this._length() == (long)roundedNewSize) {
            AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
            if (abstractIndex$ == null) {
                throw null;
            }
            AbstractIndex$ debug_this = abstractIndex$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(AbstractIndex.$anonfun$resize$2($this, roundedNewSize)));
            }
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile($this.file(), "rw");
        try {
            int position = $this.mmap().position();
            if (OperatingSystem.IS_WINDOWS || OperatingSystem.IS_ZOS) {
                $this.safeForceUnmap();
            }
            raf.setLength(roundedNewSize);
            $this._length_$eq(roundedNewSize);
            $this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
            $this._maxEntries = $this.mmap().limit() / $this.entrySize();
            $this.mmap().position(position);
            AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
            if (abstractIndex$ == null) {
                throw null;
            }
            AbstractIndex$ debug_this = abstractIndex$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(AbstractIndex.$anonfun$resize$3($this, roundedNewSize)));
            }
            bl = true;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
        }
        return bl;
    }

    public static final /* synthetic */ MappedByteBuffer $anonfun$flush$1(AbstractIndex $this) {
        return $this.mmap().force();
    }

    public static final /* synthetic */ String $anonfun$safeForceUnmap$1(AbstractIndex $this) {
        return new StringBuilder(22).append("Error unmapping index ").append($this.file()).toString();
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, IndexSearchType searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = lo + hi + 1 >>> 1;
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    public AbstractIndex(File _file, long baseOffset, int maxIndexSize, boolean fileAlreadyExists, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this._file = _file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.fileAlreadyExists = fileAlreadyExists;
        this.writable = writable;
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            MappedByteBuffer idx;
            if (!fileAlreadyExists && raf.length() > 0L) {
                throw new IllegalStateException(new StringBuilder(56).append("Non-empty index file ").append(this.file()).append(" already exists while it shouldn't.").toString());
            }
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid max index size: ").append(maxIndexSize).toString());
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer mappedByteBuffer2 = idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            if (newlyCreated) {
                idx.position(0);
            } else {
                idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            }
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

