/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.events.HealthCheckEvent$;
import kafka.durability.events.serdes.BaseInfo;
import kafka.durability.events.serdes.HealthCheck;
import org.apache.kafka.common.TopicIdPartition;
import scala.Enumeration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u000b\u0016\u0001qA\u0011\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0017\t\u00139\u0002!\u0011!Q\u0001\n=*\u0004\"\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u00188\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!Q1A\u0005\u0002yB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"A!\t\u0001B\u0001B\u0003%\u0011\bC\u0003D\u0001\u0011\u0005A\tC\u0003N\u0001\u0011%a\nC\u0003X\u0001\u0011\u0005\u0003\fC\u0003Z\u0001\u0011\u0005#\fC\u0003l\u0001\u0011\u0005CnB\u0003v+!\u0005aOB\u0003\u0015+!\u0005q\u000fC\u0003D!\u0011\u00051\u0010C\u0003}!\u0011\u0005Q\u0010\u0003\u0004}!\u0011\u0005\u0011Q\u0002\u0002\u0011\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u0012<f]RT!AF\f\u0002\r\u00154XM\u001c;t\u0015\tA\u0012$\u0001\u0006ekJ\f'-\u001b7jifT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ#\u0003\u0002!+\t9\u0012IY:ue\u0006\u001cG\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"aI\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\r\r|W.\\8o\u0015\tQrE\u0003\u0002)S\u00051\u0011\r]1dQ\u0016T\u0011AK\u0001\u0004_J<\u0017B\u0001\u0017%\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0003\u0002\"?\u00059a/\u001a:tS>t\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$aA%oi&\u0011afH\u0001\u0006KB|7\r[\u0005\u0003m}\tQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007C\u0001\u0019;\u0013\tY\u0014G\u0001\u0003M_:<\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\tEJ|7.\u001a:JIV\tq&A\u0005ce>\\WM]%eA\u0005IA/[7f'R\fW\u000e]\u000b\u0002s\u0005QA/[7f'R\fW\u000e\u001d\u0011\u0002\rqJg.\u001b;?)!)ei\u0012%J\u0015.c\u0005C\u0001\u0010\u0001\u0011\u0015\t#\u00021\u0001#\u0011\u0015q#\u00021\u00010\u0011\u00151$\u00021\u00010\u0011\u0015A$\u00021\u0001:\u0011\u0015a$\u00021\u0001:\u0011\u0015i$\u00021\u00010\u0011\u0015\u0001%\u00021\u0001:\u0003%\u0019XM]5bY&TX\rF\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0002oS>T\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001bA\f\u0017\u0010\\8bI\n+hMZ3s+\u0005y\u0015!C3wK:$H+\u001f9f+\u0005Y\u0006C\u0001/i\u001d\tifM\u0004\u0002_K:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003En\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005aI\u0012B\u0001\f\u0018\u0013\t9W#A\nEkJ\f'-\u001b7jif,e/\u001a8u)f\u0004X-\u0003\u0002jU\n\u0019B)\u001e:bE&d\u0017\u000e^=Fm\u0016tG\u000fV=qK*\u0011q-F\u0001\ti>\u001cFO]5oOR\tQ\u000e\u0005\u0002oe:\u0011q\u000e\u001d\t\u0003AFJ!!]\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u0019HO\u0001\u0004TiJLgn\u001a\u0006\u0003cF\n\u0001\u0003S3bYRD7\t[3dW\u00163XM\u001c;\u0011\u0005y\u00012C\u0001\ty!\t\u0001\u00140\u0003\u0002{c\t1\u0011I\\=SK\u001a$\u0012A^\u0001\u0006CB\u0004H.\u001f\u000b\u000f\u000bz\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0011\u0015y(\u00031\u0001#\u0003\tIG\rC\u0003/%\u0001\u0007q\u0006C\u00037%\u0001\u0007q\u0006C\u00039%\u0001\u0007\u0011\bC\u0003=%\u0001\u0007\u0011\bC\u0003>%\u0001\u0007q\u0006C\u0003A%\u0001\u0007\u0011\bF\u0003F\u0003\u001f\t\t\u0002C\u0003\u0000'\u0001\u0007!\u0005C\u0004\u0002\u0014M\u0001\r!!\u0006\u0002\t\u0011\fG/\u0019\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D\u000b\u0002\rM,'\u000fZ3t\u0013\u0011\ty\"!\u0007\u0003\u0017!+\u0017\r\u001c;i\u0007\",7m\u001b")
public class HealthCheckEvent
extends AbstractDurabilityEvent {
    private final long highWatermark;
    private final long logStartOffset;
    private final int brokerId;
    private final long timeStamp;

    public static HealthCheckEvent apply(TopicIdPartition topicIdPartition, HealthCheck healthCheck) {
        return HealthCheckEvent$.MODULE$.apply(topicIdPartition, healthCheck);
    }

    public static HealthCheckEvent apply(TopicIdPartition topicIdPartition, int n, int n2, long l, long l2, int n3, long l3) {
        return HealthCheckEvent$.MODULE$.apply(topicIdPartition, n, n2, l, l2, n3, l3);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    private ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        HealthCheck.startHealthCheck(builder);
        HealthCheck.addBrokerId(builder, this.brokerId());
        HealthCheck.addTimeStamp(builder, this.timeStamp());
        int info = BaseInfo.createBaseInfo(builder, super.version(), super.epoch(), this.highWatermark, this.logStartOffset);
        HealthCheck.addInfo(builder, info);
        int entryId = HealthCheck.endHealthCheck(builder);
        builder.finish(entryId);
        return HealthCheck.getRootAsHealthCheck(builder.dataBuffer()).getByteBuffer().duplicate();
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.serialize();
    }

    @Override
    public Enumeration.Value eventType() {
        return DurabilityEventType$.MODULE$.HealthCheckType();
    }

    public String toString() {
        return new StringBuilder(100).append("[TopicIdPartition: ").append(super.topicIdPartition()).append(", version: ").append(super.version()).append(", epoch: ").append(super.epoch()).append(", highWatermark: ").append(this.highWatermark).append(",").append(" logStartOffset: ").append(this.logStartOffset).append(", brokerId: ").append(this.brokerId()).append(", timeStamp: ").append(this.timeStamp()).append("]").toString();
    }

    public HealthCheckEvent(TopicIdPartition topicIdPartition, int version, int epoch, long highWatermark, long logStartOffset, int brokerId, long timeStamp) {
        this.highWatermark = highWatermark;
        this.logStartOffset = logStartOffset;
        this.brokerId = brokerId;
        this.timeStamp = timeStamp;
        super(topicIdPartition, epoch, version);
    }
}

