/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.DataBalanceManager;
import kafka.controller.NoOpDataBalanceManager;
import kafka.server.KafkaConfig;
import kafka.zk.BrokerInfo;
import org.apache.kafka.common.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class DataBalanceManager$ {
    public static DataBalanceManager$ MODULE$;
    private final Logger log;

    static {
        new DataBalanceManager$();
    }

    private Logger log() {
        return this.log;
    }

    public DataBalanceManager apply(KafkaConfig kafkaConfig, BrokerInfo initialBrokerInfo) {
        String dataBalancerClassName = (String)Option$.MODULE$.apply((Object)kafkaConfig.getString("confluent.balancer.class")).filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataBalanceManager$.$anonfun$apply$1(x$1))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "io.confluent.databalancer.SbcDataBalanceManager");
        this.log().info(new StringBuilder(38).append("DataBalancer: attempting startup with ").append(dataBalancerClassName).toString());
        try {
            Endpoint interBrokerEndpoint = initialBrokerInfo.broker().endPoint(kafkaConfig.interBrokerListenerName()).toJava();
            return (DataBalanceManager)Class.forName(dataBalancerClassName).getConstructor(KafkaConfig.class, Endpoint.class).newInstance(kafkaConfig, interBrokerEndpoint);
        }
        catch (ClassNotFoundException e) {
            this.log().error(new StringBuilder(49).append("DataBalancer: Unable to load data balancer class ").append(dataBalancerClassName).toString());
            return new NoOpDataBalanceManager(dataBalancerClassName, e);
        }
        catch (Exception e) {
            this.log().error(new StringBuilder(51).append("DataBalancer: Data balancer class load of ").append(dataBalancerClassName).append(" failed: ").toString(), (Throwable)e);
            return new NoOpDataBalanceManager(dataBalancerClassName, e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    private DataBalanceManager$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(DataBalanceManager.class);
    }
}

