/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.Optional;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.common.TenantHelpers;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogConfig;
import kafka.zk.TopicZNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.Tuple2;

public class TopicPartitionChangeEvent
extends MetadataCollectorEvent {
    private final String topic;
    private final String logicalClusterId;
    private final int newPartition;

    public TopicPartitionChangeEvent(ZKTopicMetadataCollector collector, String logicalClusterId, String topic, int newPartition, Time time) {
        super(collector, time);
        this.logicalClusterId = logicalClusterId;
        this.topic = topic;
        this.newPartition = newPartition;
    }

    public void run() throws Exception {
        ZKTopicMetadataCollectorContext context = this.context();
        LOG.debug("Updating Topic partitions for topic {} with new partitions {}", (Object)this.topic, (Object)this.newPartition);
        MetadataEvent metadataEvent = context.localStore().metadataEvent(this.topic);
        Timestamp observeTimestamp = Timestamps.fromNanos((long)this.eventObserveTime);
        if (metadataEvent != null) {
            TopicMetadata topicMetadata = TopicMetadata.newBuilder().mergeFrom(metadataEvent.getTopicMetadata()).setPartitionsCount(this.newPartition).setUpdateTime(observeTimestamp).build();
            metadataEvent = MetadataEvent.newBuilder().setTopicMetadata(topicMetadata).build();
        } else {
            Optional<LogConfig> logConfig = this.getLogConfigsForTopic(context, this.topic);
            if (logConfig.isPresent()) {
                int replicas;
                Uuid id = null;
                if (!context.cacheInitialized() && context.topicInfo(this.topic) != null) {
                    TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(this.topic);
                    id = topicInfo.topicId();
                    replicas = topicInfo.replicationFactors();
                } else {
                    TopicZNode.TopicIdReplicaAssignment topicIdReplicaAssignment = this.getTopicIdReplicaAssignmentFromZk(context, this.topic);
                    if (topicIdReplicaAssignment.topicId().isEmpty() || topicIdReplicaAssignment.assignment().isEmpty()) {
                        LOG.debug("Ignoring Event {} due to topic doesn't exist in zk", (Object)this);
                        return;
                    }
                    id = (Uuid)topicIdReplicaAssignment.topicId().get();
                    replicas = ((ReplicaAssignment)((Tuple2)topicIdReplicaAssignment.assignment().head())._2).replicas().size();
                }
                metadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfig.get(), TenantHelpers.extractLogicalName(this.topic), id, this.newPartition, replicas, null, observeTimestamp);
            }
        }
        context.localStore().addMetadataEvent(this.logicalClusterId, this.topic, metadataEvent);
        MetadataChange topicMetadataChange = MetadataEventUtils.topicUpdateEvent(this.logicalClusterId, metadataEvent);
        this.emitDeltaEvent(context, topicMetadataChange);
    }

    public String toString() {
        return "TopicPartitionChangeEvent(topic=" + this.topic + ", newPartitions=" + this.newPartition + ')';
    }
}

