/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.common.TenantHelpers;
import kafka.log.LogConfig;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;

public class TopicConfigChangeEvent
extends MetadataCollectorEvent {
    private final String logicalClusterId;
    private final String topic;
    private final LogConfig newConfig;

    public TopicConfigChangeEvent(ZKTopicMetadataCollector collector, String logicalClusterId, String topic, LogConfig newConfig, Time time) {
        super(collector, time);
        this.logicalClusterId = logicalClusterId;
        this.topic = topic;
        this.newConfig = newConfig;
    }

    public void run() throws Exception {
        int replicas;
        int partitions;
        Uuid id;
        ZKTopicMetadataCollectorContext context = this.context();
        LOG.debug("Updating Topic Config for topic {} with new config {}", (Object)this.topic, (Object)this.newConfig);
        MetadataEvent metadataEvent = context.localStore().metadataEvent(this.topic);
        Timestamp observeTimestamp = Timestamps.fromNanos((long)this.eventObserveTime);
        if (metadataEvent != null) {
            TopicMetadata topicMetadata = metadataEvent.getTopicMetadata();
            id = Uuid.fromString((String)topicMetadata.getTopicId());
            partitions = topicMetadata.getPartitionsCount();
            replicas = topicMetadata.getReplicationFactor();
        } else if (!context.cacheInitialized() && context.topicInfo(this.topic) != null) {
            TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(this.topic);
            id = topicInfo.topicId();
            partitions = topicInfo.partitions();
            replicas = topicInfo.replicationFactors();
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignore {} because topic id is not available in local cache or initial snapshot", (Object)this);
            }
            return;
        }
        metadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(this.newConfig, TenantHelpers.extractLogicalName(this.topic), id, partitions, replicas, null, observeTimestamp);
        context.localStore().addMetadataEvent(this.logicalClusterId, this.topic, metadataEvent);
        MetadataChange topicMetadataChange = MetadataEventUtils.topicUpdateEvent(this.logicalClusterId, metadataEvent);
        this.emitDeltaEvent(context, topicMetadataChange);
    }

    public String toString() {
        return "TopicConfigChangeEvent(topic=" + this.topic + ", retentionMs=" + this.newConfig.getLong(LogConfig.RetentionMsProp()) + ", retentionBytes=" + this.newConfig.getLong(LogConfig.RetentionBytesProp()) + ", keySchemaValidation=" + this.newConfig.getBoolean(LogConfig.KeySchemaValidationEnableProp()) + ", valueSchemaValidation=" + this.newConfig.getBoolean(LogConfig.ValueSchemaValidationEnableProp()) + ", cleanupPolicy=" + this.newConfig.getList(LogConfig.CleanupPolicyProp()) + ')';
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof CollectorContextNotInitializedException) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignore {} because it's a non-active collector", (Object)this);
            }
        } else {
            LOG.error("Unexpected error handling {}", (Object)this, (Object)e);
            this.recordEventHandleError();
        }
    }
}

