/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;

public class SnapshotEvent
extends MetadataCollectorEvent {
    public SnapshotEvent(ZKTopicMetadataCollector collector, Time time) {
        super(collector, time);
    }

    public void run() throws Exception {
        ZKTopicMetadataCollectorContext context = this.context();
        for (String logicalCluster : context.localStore().logicalClusters()) {
            Set<String> topics = context.localStore().topics(logicalCluster);
            int maxTopicsPerPage = Math.min(topics.size(), context.config().maxTopicsInSnapshot);
            int numberOfPages = topics.size() / context.config().maxTopicsInSnapshot + 1;
            int page = 0;
            ArrayList<MetadataEvent> metadataEvents = new ArrayList<MetadataEvent>(maxTopicsPerPage);
            LOG.debug("Creating Snapshot for tenant {} with {} topics, {} pages and {} total", new Object[]{logicalCluster, topics.size(), page, numberOfPages});
            for (String topic : topics) {
                metadataEvents.add(context.localStore().metadataEvent(topic));
                if (metadataEvents.size() < maxTopicsPerPage) continue;
                MetadataChange metadataChange = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
                this.emitSnapshotEvent(context, metadataChange, page, numberOfPages);
                metadataEvents = new ArrayList(maxTopicsPerPage);
                ++page;
            }
        }
        long currNs = this.time.nanoseconds();
        context.catalogMetrics().snapshotEmittingDelayMsMetric.update(TimeUnit.MILLISECONDS.convert(currNs - context.lastSnapshotNs(), TimeUnit.NANOSECONDS));
        context.setLastSnapshotNs(currNs);
        context.eventQueue().scheduleDeferred("SNAPSHOT_EVENT", (Function<OptionalLong, OptionalLong>)new EventQueue.DeadlineFunction(currNs + TimeUnit.NANOSECONDS.convert(context.config().snapshotIntervalSec, TimeUnit.SECONDS)), new SnapshotEvent(this.collector, this.time));
    }
}

