/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.availability.NetworkAvailabilityManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.availability.AutomaticDemotionStatus;
import kafka.availability.Demoted$;
import kafka.availability.Demoting$;
import kafka.availability.Describing$;
import kafka.availability.HealthSamplesWindow;
import kafka.availability.NetworkHealthManager$;
import kafka.availability.NetworkHealthManagerConfig;
import kafka.availability.NetworkHealthStatus;
import kafka.availability.NetworkHealthy$;
import kafka.availability.NetworkUnhealthy$;
import kafka.availability.Promoted$;
import kafka.availability.Promoting$;
import kafka.availability.Sampling$;
import kafka.availability.Unknown$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.common.message.AlterLeadershipPriorityRequestData;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.message.DescribeLeadershipPriorityResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityResponse;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityRequest;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001B(Q\u0001UC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005}\u0001\t\u0015\r\u0011\"\u0003~\u0011%\t\u0019\u0001\u0001B\u0001B\u0003%a\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u0013\u0005M\u0001\u00011A\u0005\u0002\u0005U\u0001\"CA\u0012\u0001\u0001\u0007I\u0011AA\u0013\u0011!\t\t\u0004\u0001Q!\n\u0005]\u0001\"CA\u001e\u0001\u0001\u0007I\u0011AA\u001f\u0011%\t)\u0005\u0001a\u0001\n\u0003\t9\u0005\u0003\u0005\u0002L\u0001\u0001\u000b\u0015BA \u0011%\ty\u0005\u0001a\u0001\n\u0003\t\t\u0006C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0001\u0002\\!A\u0011q\f\u0001!B\u0013\t\u0019\u0006C\u0005\u0002d\u0001\u0001\r\u0011\"\u0001\u0002f!I\u0011Q\u000e\u0001A\u0002\u0013\u0005\u0011q\u000e\u0005\t\u0003g\u0002\u0001\u0015)\u0003\u0002h!I\u0011q\u000f\u0001A\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003w\u0002\u0001\u0019!C\u0001\u0003{Bq!!!\u0001A\u0003&Q\u000eC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002\b\"A\u0011\u0011\u0014\u0001!\u0002\u0013\tI\tC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002\u0016!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002\u0018!I\u0011Q\u0015\u0001A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0001\"!,\u0001A\u0003&\u0011q\u0003\u0005\n\u0003_\u0003!\u0019!C\u0005\u0003cC\u0001\"!/\u0001A\u0003%\u00111\u0017\u0005\n\u0003w\u0003!\u0019!C\u0005\u0003{C\u0001\"a6\u0001A\u0003%\u0011q\u0018\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\ti\u000e\u0001C!\u00037Dq!a8\u0001\t\u0003\nY\u000eC\u0004\u0002b\u0002!\t!!\u001a\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u00111\u001e\u0001\u0005\n\u0005m\u0007bBAw\u0001\u0011%\u00111\u001c\u0005\b\u0003_\u0004A\u0011BAn\u0011\u001d\t\t\u0010\u0001C\u0005\u000374a!a=\u0001\t\u0005U\bBCA\u007fW\t\u0005\t\u0015!\u0003\u0002\u0000\"9\u0011QA\u0016\u0005\u0002\t\u0015\u0001b\u0002B\u0007W\u0011\u0005#q\u0002\u0005\b\u0005CYC\u0011IAn\u0011\u001d\u0011\u0019c\u000bC\u0005\u0005KAqA!\u000b,\t\u0013\u0011YC\u0002\u0004\u00030\u0001!!\u0011\u0007\u0005\u000b\u0005g\u0011$\u0011!Q\u0001\n\u0005}\u0002BCA\u007fe\t\u0005\t\u0015!\u0003\u0002\u0000\"9\u0011Q\u0001\u001a\u0005\u0002\tU\u0002b\u0002B\u0007e\u0011\u0005#Q\b\u0005\b\u0005C\u0011D\u0011IAn\u0011\u001d\u0011\tE\rC\u0005\u0005\u0007BqA!\u00133\t\u0013\u0011Y\u0005C\u0004\u0003R\u0001!IAa\u0015\t\u000f\te\u0005\u0001\"\u0011\u0002\\\"9!1\u0014\u0001\u0005B\tu\u0005b\u0002B^\u0001\u0011\u0005#Q\u0018\u0005\b\u0005\u0013\u0004A\u0011\tBf\u000f\u001d\u0011\u0019\u000e\u0015E\u0001\u0005+4aa\u0014)\t\u0002\t]\u0007bBA\u0003\u0001\u0012\u0005!q\u001c\u0005\b\u0005C\u0004E\u0011\u0001Br\u0011%\u0019Y\u0002\u0011b\u0001\n\u0003\u0019i\u0002\u0003\u0005\u0004$\u0001\u0003\u000b\u0011BB\u0010\u0011%\u0019)\u0003\u0011b\u0001\n\u0003\u0019i\u0002\u0003\u0005\u0004(\u0001\u0003\u000b\u0011BB\u0010\u0011%\u0019I\u0003\u0011b\u0001\n\u0003\u0019i\u0002\u0003\u0005\u0004,\u0001\u0003\u000b\u0011BB\u0010\u0011%\u0019i\u0003\u0011b\u0001\n\u0003\u0019i\u0002\u0003\u0005\u00040\u0001\u0003\u000b\u0011BB\u0010\u0011%\u0019\t\u0004\u0011b\u0001\n\u0003\u0019i\u0002\u0003\u0005\u00044\u0001\u0003\u000b\u0011BB\u0010\u0011%\u0019)\u0004\u0011b\u0001\n\u0003\u00199\u0004\u0003\u0005\u0004D\u0001\u0003\u000b\u0011BB\u001d\u0005QqU\r^<pe.DU-\u00197uQ6\u000bg.Y4fe*\u0011\u0011KU\u0001\rCZ\f\u0017\u000e\\1cS2LG/\u001f\u0006\u0002'\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001W9\n\u0004\"a\u0016.\u000e\u0003aS!!\u0017*\u0002\u000bU$\u0018\u000e\\:\n\u0005mC&AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"!\u00181\u000e\u0003yS!a\u0018*\u0002\rM,'O^3s\u0013\t\tgL\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KJ\u000bq!\\3ue&\u001c7/\u0003\u0002hI\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002A\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003;*L!a\u001b0\u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u00059|W\"\u0001)\n\u0005A\u0004&A\u0007(fi^|'o\u001b%fC2$\b.T1oC\u001e,'oQ8oM&<\u0017A\u00078fi^|'o[!wC&d\u0017MY5mSRLX*\u00198bO\u0016\u0014\bCA:{\u001b\u0005!(BA)v\u0015\t\u0019fO\u0003\u0002xq\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002s\u0006\u0011\u0011n\\\u0005\u0003wR\u0014!DT3uo>\u00148.\u0011<bS2\f'-\u001b7jifl\u0015M\\1hKJ\f\u0011b]2iK\u0012,H.\u001a:\u0016\u0003y\u0004\"aV@\n\u0007\u0005\u0005\u0001LA\u0005TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\rqJg.\u001b;?))\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003]\u0002AQ\u0001\u001b\u0004A\u0002%DQ\u0001\u001c\u0004A\u00025DQ!\u001d\u0004A\u0002IDQ\u0001 \u0004A\u0002y\fA\u0002^8uC2\u001c\u0016-\u001c9mKN,\"!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q!!!\b\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u0005\u00121\u0004\u0002\u0005\u0019>tw-\u0001\tu_R\fGnU1na2,7o\u0018\u0013fcR!\u0011qEA\u0017!\u0011\tI\"!\u000b\n\t\u0005-\u00121\u0004\u0002\u0005+:LG\u000fC\u0005\u00020!\t\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u001bQ|G/\u00197TC6\u0004H.Z:!Q\rI\u0011Q\u0007\t\u0005\u00033\t9$\u0003\u0003\u0002:\u0005m!\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002;\t\u0014xn[3s\u0003V$x.\\1uS\u000e$U-\\8uS>t7\u000b^1ukN,\"!a\u0010\u0011\u00079\f\t%C\u0002\u0002DA\u0013q#Q;u_6\fG/[2EK6|G/[8o'R\fG/^:\u0002C\t\u0014xn[3s\u0003V$x.\\1uS\u000e$U-\\8uS>t7\u000b^1ukN|F%Z9\u0015\t\u0005\u001d\u0012\u0011\n\u0005\n\u0003_Y\u0011\u0011!a\u0001\u0003\u007f\taD\u0019:pW\u0016\u0014\u0018)\u001e;p[\u0006$\u0018n\u0019#f[>$\u0018n\u001c8Ti\u0006$Xo\u001d\u0011)\u00071\t)$A\noKR<xN]6IK\u0006dG\u000f[*uCR,8/\u0006\u0002\u0002TA\u0019a.!\u0016\n\u0007\u0005]\u0003KA\nOKR<xN]6IK\u0006dG\u000f[*uCR,8/A\foKR<xN]6IK\u0006dG\u000f[*uCR,8o\u0018\u0013fcR!\u0011qEA/\u0011%\tyCDA\u0001\u0002\u0004\t\u0019&\u0001\u000boKR<xN]6IK\u0006dG\u000f[*uCR,8\u000f\t\u0015\u0004\u001f\u0005U\u0012AI5t\u000bb$XM\u001d8bY:+Go^8sW6KG/[4bi&|g.\u00128bE2,G-\u0006\u0002\u0002hA!\u0011\u0011DA5\u0013\u0011\tY'a\u0007\u0003\u000f\t{w\u000e\\3b]\u00061\u0013n]#yi\u0016\u0014h.\u00197OKR<xN]6NSRLw-\u0019;j_:,e.\u00192mK\u0012|F%Z9\u0015\t\u0005\u001d\u0012\u0011\u000f\u0005\n\u0003_\t\u0012\u0011!a\u0001\u0003O\n1%[:FqR,'O\\1m\u001d\u0016$xo\u001c:l\u001b&$\u0018nZ1uS>tWI\\1cY\u0016$\u0007\u0005K\u0002\u0013\u0003k\taaY8oM&<W#A7\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002(\u0005}\u0004\u0002CA\u0018)\u0005\u0005\t\u0019A7\u0002\u000f\r|gNZ5hA!\u001aQ#!\u000e\u0002+\u0005,Ho\\7bi&\u001cG)Z7pi&|g\u000eT8dWV\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0015\u0001\u00026bm\u0006LA!a&\u0002\u000e\n1qJ\u00196fGR\fa#Y;u_6\fG/[2EK6|G/[8o\u0019>\u001c7\u000eI\u0001\u0017aJ,gOT3uo>\u00148\u000eS3bYRD7i\\;oi\u0006Q\u0002O]3w\u001d\u0016$xo\u001c:l\u0011\u0016\fG\u000e\u001e5D_VtGo\u0018\u0013fcR!\u0011qEAQ\u0011%\ty#GA\u0001\u0002\u0004\t9\"A\fqe\u00164h*\u001a;x_J\\\u0007*Z1mi\"\u001cu.\u001e8uA\u0005A\u0012N\\2p[&tw\r\u0016:bM\u001aL7\rU3s'\u0006l\u0007\u000f\\3\u00029%t7m\\7j]\u001e$&/\u00194gS\u000e\u0004VM]*b[BdWm\u0018\u0013fcR!\u0011qEAV\u0011%\ty\u0003HA\u0001\u0002\u0004\t9\"A\rj]\u000e|W.\u001b8h)J\fgMZ5d!\u0016\u00148+Y7qY\u0016\u0004\u0013A\u00075fC2$\b.\u001f(fi^|'o[*b[BdWmV5oI><XCAAZ!\rq\u0017QW\u0005\u0004\u0003o\u0003&a\u0005%fC2$\bnU1na2,7oV5oI><\u0018a\u00075fC2$\b.\u001f(fi^|'o[*b[BdWmV5oI><\b%\u0001\nfqB|g.\u001a8uS\u0006d')Y2l_\u001a4WCAA`!\u0011\t\t-a5\u000e\u0005\u0005\r'bA-\u0002F*!\u0011qYAe\u0003\u0019\u0019w.\\7p]*\u00191+a3\u000b\t\u00055\u0017qZ\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0017aA8sO&!\u0011Q[Ab\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002'\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\u0011\u0002\u001bI,Wn\u001c<f\u001b\u0016$(/[2t)\t\t9#A\u0003ti\u0006\u0014H/\u0001\u0005tQV$Hm\\<o\u0003aI7O\u0011:pW\u0016\u0014h*\u001a;x_J\\WK\u001c5fC2$\b._\u0001'[\u0006L(-\u001a+sC:\u001c\u0018\u000e^5p]\u0006+Ho\\7bi&\u001cG)Z7pi&|gn\u0015;biV\u001cH\u0003BA4\u0003ODq!!;'\u0001\u0004\ty$\u0001\u0007uCJ<W\r^*uCR,8/\u0001\u0004eK6|G/Z\u0001\baJ|Wn\u001c;f\u0003\t\u001a\u0007.Z2l\u001d\u0016$xo\u001c:l\u0011\u0016\fG\u000e\u001e5B]\u0012l\u0015-\u001f2f\u001b&$\u0018nZ1uK\u0006\u0011\"/\u001e8EKN\u001c'/\u001b2f%\u0016\fX/Z:u\u0005%\"Um]2sS\n,G*Z1eKJ\u001c\b.\u001b9Qe&|'/\u001b;z%\u0016\u001c\bo\u001c8tK\"\u000bg\u000e\u001a7feN\u00191&a>\u0011\u0007u\u000bI0C\u0002\u0002|z\u0013!eQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018A\u0003:fiJL8i\\;oiB!\u0011\u0011\u0004B\u0001\u0013\u0011\u0011\u0019!a\u0007\u0003\u0007%sG\u000f\u0006\u0003\u0003\b\t-\u0001c\u0001B\u0005W5\t\u0001\u0001C\u0004\u0002~6\u0002\r!a@\u0002\u0015=t7i\\7qY\u0016$X\r\u0006\u0003\u0002(\tE\u0001b\u0002B\n]\u0001\u0007!QC\u0001\te\u0016\u001c\bo\u001c8tKB!!q\u0003B\u000f\u001b\t\u0011IB\u0003\u0003\u0003\u001c\u0005%\u0017aB2mS\u0016tGo]\u0005\u0005\u0005?\u0011IB\u0001\bDY&,g\u000e\u001e*fgB|gn]3\u0002\u0013=tG+[7f_V$\u0018\u0001H:dQ\u0016$W\u000f\\3SKR\u0014\u0018\u0010R3tGJL'-\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003O\u00119\u0003C\u0004\u0002~B\u0002\r!a@\u0002)I,GO]=EKN\u001c'/\u001b2f%\u0016\fX/Z:u)\u0011\t9C!\f\t\u000f\u0005u\u0018\u00071\u0001\u0002\u0000\n1\u0013\t\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f*fgB|gn]3IC:$G.\u001a:\u0014\u0007I\n90A\u0010fqB,7\r^3e\u0003V$x.\\1uS\u000e$U-\\8uS>t7\u000b^1ukN$bAa\u000e\u0003:\tm\u0002c\u0001B\u0005e!9!1G\u001bA\u0002\u0005}\u0002bBA\u007fk\u0001\u0007\u0011q \u000b\u0005\u0003O\u0011y\u0004C\u0004\u0003\u0014Y\u0002\rA!\u0006\u00023M\u001c\u0007.\u001a3vY\u0016\u0014V\r\u001e:z\u00032$XM\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003O\u0011)Ea\u0012\t\u000f\tM\u0002\b1\u0001\u0002@!9\u0011Q \u001dA\u0002\u0005}\u0018!\u0005:fiJL\u0018\t\u001c;feJ+\u0017/^3tiR1\u0011q\u0005B'\u0005\u001fBqAa\r:\u0001\u0004\ty\u0004C\u0004\u0002~f\u0002\r!a@\u0002U\t,\u0018\u000e\u001c3BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5usJ+\u0017/^3ti\n+\u0018\u000e\u001c3feR!!Q\u000bB5!\u0011\u00119Fa\u0019\u000f\t\te#qL\u0007\u0003\u00057RAA!\u0018\u0002F\u0006A!/Z9vKN$8/\u0003\u0003\u0003b\tm\u0013AH!mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9Qe&|'/\u001b;z%\u0016\fX/Z:u\u0013\u0011\u0011)Ga\u001a\u0003\u000f\t+\u0018\u000e\u001c3fe*!!\u0011\rB.\u0011\u001d\u0011YG\u000fa\u0001\u0005[\n\u0011\u0003\u001d:j_JLG/_(qKJ\fG/[8o!\u0011\u0011yGa%\u000f\t\tE$Q\u0012\b\u0005\u0005g\u0012II\u0004\u0003\u0003v\t\u001de\u0002\u0002B<\u0005\u000bsAA!\u001f\u0003\u0004:!!1\u0010BA\u001b\t\u0011iHC\u0002\u0003\u0000Q\u000ba\u0001\u0010:p_Rt\u0014BAAi\u0013\u0011\ti-a4\n\u0007M\u000bY-\u0003\u0003\u0003\u001c\u0005%\u0017\u0002\u0002BF\u00053\tQ!\u00193nS:LAAa$\u0003\u0012\u0006Y\u0012\t\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/_*qK\u000eTAAa#\u0003\u001a%!!Q\u0013BL\u0005U\u0001&/[8sSRLx\n]3sCRLwN\\#ok6TAAa$\u0003\u0012\u00061Am\\,pe.\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003 B1!\u0011\u0015BT\u0005Wk!Aa)\u000b\t\t\u0015\u00161D\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BU\u0005G\u00131aU3u!\u0011\u0011iK!.\u000f\t\t=&\u0011\u0017\t\u0005\u0005w\nY\"\u0003\u0003\u00034\u0006m\u0011A\u0002)sK\u0012,g-\u0003\u0003\u00038\ne&AB*ue&twM\u0003\u0003\u00034\u0006m\u0011a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\u0011\t9Ca0\t\u000f\t\u0005W\b1\u0001\u0003D\u0006Ia.Z<D_:4\u0017n\u001a\t\u0004;\n\u0015\u0017b\u0001Bd=\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005\u001d\"Q\u001aBi\u0011\u001d\u0011yM\u0010a\u0001\u0005\u0007\f\u0011b\u001c7e\u0007>tg-[4\t\u000f\t\u0005g\b1\u0001\u0003D\u0006!b*\u001a;x_J\\\u0007*Z1mi\"l\u0015M\\1hKJ\u0004\"A\u001c!\u0014\u0007\u0001\u0013I\u000e\u0005\u0003\u0002\u001a\tm\u0017\u0002\u0002Bo\u00037\u0011a!\u00118z%\u00164GC\u0001Bk\u0003\u0015\t\u0007\u000f\u001d7z)A\tIA!:\u0003h\nE(\u0011`B\u0002\u0007\u001f\u0019I\u0002C\u0004\u0002x\t\u0003\rAa1\t\u000f\t%(\t1\u0001\u0003l\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u00042!\u0018Bw\u0013\r\u0011yO\u0018\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\t\rq\u0014\u0005\u0019\u0001Bz!\r9&Q_\u0005\u0004\u0005oD&AD&bM.\f7k\u00195fIVdWM\u001d\u0005\b\u0005w\u0014\u0005\u0019\u0001B\u007f\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0005'q`\u0005\u0005\u0007\u0003\t\u0019M\u0001\u0003US6,\u0007BB3C\u0001\u0004\u0019)\u0001\u0005\u0003\u0004\b\r-QBAB\u0005\u0015\r)\u0017QY\u0005\u0005\u0007\u001b\u0019IAA\u0004NKR\u0014\u0018nY:\t\u000f\rE!\t1\u0001\u0004\u0014\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0007\u00033\u0019)Ba+\n\t\r]\u00111\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bE\u0014\u0005\u0019\u0001:\u0002=\u0005+Ho\\7bi&\u001c\u0017\t\u001c;fe2+\u0017\rZ3sg\"L\u0007OU3bg>tWCAB\u0010!\u0011\tYi!\t\n\t\t]\u0016QR\u0001 \u0003V$x.\\1uS\u000e\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004(+Z1t_:\u0004\u0013!\b%fC2$\b.\u001f(fi^|'o[\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0002=!+\u0017\r\u001c;is:+Go^8sW\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!G%oG>l\u0017N\\4Ue\u00064g-[2NKR\u0014\u0018n\u0019(b[\u0016\f!$\u00138d_6Lgn\u001a+sC\u001a4\u0017nY'fiJL7MT1nK\u0002\n\u0011%Q;u_6\fG/[2EK6|G/[8o'R\fG/^:NKR\u0014\u0018n\u0019(b[\u0016\f!%Q;u_6\fG/[2EK6|G/[8o'R\fG/^:NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\b(fi^|'o\u001b%fC2$\bn\u0015;biV\u001cX*\u001a;sS\u000et\u0015-\\3\u0002=9+Go^8sW\"+\u0017\r\u001c;i'R\fG/^:NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0007s\u0001baa\u000f\u0004B\r}QBAB\u001f\u0015\u0011\u0019yDa)\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002BU\u0007{\taCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\t")
public class NetworkHealthManager
extends ShutdownableThread
implements BrokerReconfigurable,
KafkaMetricsGroup {
    public final BrokerToControllerChannelManager kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager;
    private final NetworkAvailabilityManager networkAvailabilityManager;
    private final Scheduler kafka$availability$NetworkHealthManager$$scheduler;
    private volatile long totalSamples;
    private volatile AutomaticDemotionStatus brokerAutomaticDemotionStatus;
    private volatile NetworkHealthStatus networkHealthStatus;
    private volatile boolean isExternalNetworkMitigationEnabled;
    private volatile NetworkHealthManagerConfig config;
    private final Object kafka$availability$NetworkHealthManager$$automaticDemotionLock;
    private long prevNetworkHealthCount;
    private long incomingTrafficPerSample;
    private final HealthSamplesWindow healthyNetworkSampleWindow;
    private final ExponentialBackoff kafka$availability$NetworkHealthManager$$exponentialBackoff;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return NetworkHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    public static String NetworkHealthStatusMetricName() {
        return NetworkHealthManager$.MODULE$.NetworkHealthStatusMetricName();
    }

    public static String AutomaticDemotionStatusMetricName() {
        return NetworkHealthManager$.MODULE$.AutomaticDemotionStatusMetricName();
    }

    public static String IncomingTrafficMetricName() {
        return NetworkHealthManager$.MODULE$.IncomingTrafficMetricName();
    }

    public static String HealthyNetworkCountMetricName() {
        return NetworkHealthManager$.MODULE$.HealthyNetworkCountMetricName();
    }

    public static String AutomaticAlterLeadershipReason() {
        return NetworkHealthManager$.MODULE$.AutomaticAlterLeadershipReason();
    }

    public static NetworkHealthManager apply(KafkaConfig kafkaConfig, MetadataCache metadataCache, KafkaScheduler kafkaScheduler, Time time, Metrics metrics, Option<String> option, NetworkAvailabilityManager networkAvailabilityManager) {
        return NetworkHealthManager$.MODULE$.apply(kafkaConfig, metadataCache, kafkaScheduler, time, metrics, option, networkAvailabilityManager);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    public Scheduler kafka$availability$NetworkHealthManager$$scheduler() {
        return this.kafka$availability$NetworkHealthManager$$scheduler;
    }

    public long totalSamples() {
        return this.totalSamples;
    }

    public void totalSamples_$eq(long x$1) {
        this.totalSamples = x$1;
    }

    public AutomaticDemotionStatus brokerAutomaticDemotionStatus() {
        return this.brokerAutomaticDemotionStatus;
    }

    public void brokerAutomaticDemotionStatus_$eq(AutomaticDemotionStatus x$1) {
        this.brokerAutomaticDemotionStatus = x$1;
    }

    public NetworkHealthStatus networkHealthStatus() {
        return this.networkHealthStatus;
    }

    public void networkHealthStatus_$eq(NetworkHealthStatus x$1) {
        this.networkHealthStatus = x$1;
    }

    public boolean isExternalNetworkMitigationEnabled() {
        return this.isExternalNetworkMitigationEnabled;
    }

    public void isExternalNetworkMitigationEnabled_$eq(boolean x$1) {
        this.isExternalNetworkMitigationEnabled = x$1;
    }

    public NetworkHealthManagerConfig config() {
        return this.config;
    }

    public void config_$eq(NetworkHealthManagerConfig x$1) {
        this.config = x$1;
    }

    public Object kafka$availability$NetworkHealthManager$$automaticDemotionLock() {
        return this.kafka$availability$NetworkHealthManager$$automaticDemotionLock;
    }

    private long prevNetworkHealthCount() {
        return this.prevNetworkHealthCount;
    }

    private void prevNetworkHealthCount_$eq(long x$1) {
        this.prevNetworkHealthCount = x$1;
    }

    private long incomingTrafficPerSample() {
        return this.incomingTrafficPerSample;
    }

    private void incomingTrafficPerSample_$eq(long x$1) {
        this.incomingTrafficPerSample = x$1;
    }

    private HealthSamplesWindow healthyNetworkSampleWindow() {
        return this.healthyNetworkSampleWindow;
    }

    public ExponentialBackoff kafka$availability$NetworkHealthManager$$exponentialBackoff() {
        return this.kafka$availability$NetworkHealthManager$$exponentialBackoff;
    }

    private void removeMetrics() {
        this.removeMetric(NetworkHealthManager$.MODULE$.HealthyNetworkCountMetricName(), this.removeMetric$default$2());
        this.removeMetric(NetworkHealthManager$.MODULE$.IncomingTrafficMetricName(), this.removeMetric$default$2());
        this.removeMetric(NetworkHealthManager$.MODULE$.AutomaticDemotionStatusMetricName(), this.removeMetric$default$2());
        this.removeMetric(NetworkHealthManager$.MODULE$.NetworkHealthStatusMetricName(), this.removeMetric$default$2());
    }

    @Override
    public void start() {
        this.kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.start();
        super.start();
    }

    @Override
    public void shutdown() {
        this.removeMetrics();
        this.kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.shutdown();
        super.shutdown();
    }

    public boolean isBrokerNetworkUnhealthy() {
        long prevCount = this.prevNetworkHealthCount();
        long connections = this.networkAvailabilityManager.connectionPings();
        long externalNetworkRequests = this.networkAvailabilityManager.externalRequests();
        this.prevNetworkHealthCount_$eq(connections + externalNetworkRequests);
        this.incomingTrafficPerSample_$eq(this.prevNetworkHealthCount() - prevCount);
        return this.incomingTrafficPerSample() <= 0L;
    }

    public boolean kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(AutomaticDemotionStatus targetStatus) {
        Object object = this.kafka$availability$NetworkHealthManager$$automaticDemotionLock();
        synchronized (object) {
            boolean bl;
            if (targetStatus.canTransitionFrom(this.brokerAutomaticDemotionStatus())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Transitioned from ").append(this.brokerAutomaticDemotionStatus()).append(" to ").append(targetStatus).append(".").toString());
                this.brokerAutomaticDemotionStatus_$eq(targetStatus);
                bl = true;
            } else {
                AutomaticDemotionStatus automaticDemotionStatus = this.brokerAutomaticDemotionStatus();
                if (automaticDemotionStatus == null || !automaticDemotionStatus.equals(targetStatus)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Could not transition from ").append(this.brokerAutomaticDemotionStatus()).append(" to ").append(targetStatus).append(".").toString());
                    bl = false;
                } else {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    private void demote() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Starting demotion for broker ").append(this.config().brokerId()).toString());
        this.kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)this.kafka$availability$NetworkHealthManager$$buildAlterLeadershipPriorityRequestBuilder(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE), new AlterLeadershipPriorityResponseHandler(this, Demoting$.MODULE$, 0));
    }

    private void promote() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Starting promotion for broker ").append(this.config().brokerId()).toString());
        this.kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)this.kafka$availability$NetworkHealthManager$$buildAlterLeadershipPriorityRequestBuilder(AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE), new AlterLeadershipPriorityResponseHandler(this, Promoting$.MODULE$, 0));
    }

    private void checkNetworkHealthAndMaybeMitigate() {
        this.healthyNetworkSampleWindow().addSample(this.isBrokerNetworkUnhealthy() ? 0 : 1);
        this.healthyNetworkSampleWindow().maybeShrinkSampleWindow(this.config().networkHealthManagerNetworkSampleWindowSize());
        if (this.healthyNetworkSampleWindow().countedSamples() >= this.config().networkHealthManagerMinHealthyNetworkSamples()) {
            NetworkHealthStatus networkHealthStatus = this.networkHealthStatus();
            NetworkHealthy$ networkHealthy$ = NetworkHealthy$.MODULE$;
            if (networkHealthStatus == null ? networkHealthy$ != null : !networkHealthStatus.equals(networkHealthy$)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("NetworkHealthStatus transitioned to NetworkHealthy on ").append(this.config().brokerId()).append(". ").append("If network mitigation is enabled, the broker will promote itself.").toString());
                this.healthyNetworkSampleWindow().reset();
            }
            this.networkHealthStatus_$eq(NetworkHealthy$.MODULE$);
        } else if (this.healthyNetworkSampleWindow().size() == this.config().networkHealthManagerNetworkSampleWindowSize()) {
            NetworkHealthStatus networkHealthStatus = this.networkHealthStatus();
            NetworkUnhealthy$ networkUnhealthy$ = NetworkUnhealthy$.MODULE$;
            if (networkHealthStatus == null ? networkUnhealthy$ != null : !networkHealthStatus.equals(networkUnhealthy$)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("NetworkHealthStatus transitioned to NetworkUnhealthy on ").append(this.config().brokerId()).append(". ").append("If network mitigation is enabled, the broker will demote itself.").toString());
                this.healthyNetworkSampleWindow().reset();
            }
            this.networkHealthStatus_$eq(NetworkUnhealthy$.MODULE$);
        }
        if (this.healthyNetworkSampleWindow().size() == 0 && this.config().isNetworkHealthManagerMitigationEnabled()) {
            NetworkHealthStatus networkHealthStatus = this.networkHealthStatus();
            if (NetworkUnhealthy$.MODULE$.equals(networkHealthStatus)) {
                if (this.kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Demoting$.MODULE$)) {
                    this.demote();
                    return;
                }
            } else if (NetworkHealthy$.MODULE$.equals(networkHealthStatus) && this.kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Promoting$.MODULE$)) {
                this.promote();
                return;
            }
        }
    }

    private void runDescribeRequest() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Sending DescribeLeadershipPriority request for broker ").append(this.config().brokerId()).append(".").toString());
        this.kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)new DescribeLeadershipPriorityRequest.Builder(), new DescribeLeadershipPriorityResponseHandler(this, 0));
    }

    public AlterLeadershipPriorityRequest.Builder kafka$availability$NetworkHealthManager$$buildAlterLeadershipPriorityRequestBuilder(AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperation) {
        AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum = priorityOperation;
        AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum2 = AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE;
        short oldestAllowedVersion = !(priorityOperationEnum != null ? !priorityOperationEnum.equals(priorityOperationEnum2) : priorityOperationEnum2 != null) ? (short)1 : 0;
        return new AlterLeadershipPriorityRequest.Builder(oldestAllowedVersion, new AlterLeadershipPriorityRequestData().setBrokerIds(Collections.singletonList(Predef$.MODULE$.int2Integer(this.config().brokerId()))).setReason(NetworkHealthManager$.MODULE$.AutomaticAlterLeadershipReason()).setPriorityOperationCode(priorityOperation.id()).setForce(false));
    }

    @Override
    public void doWork() {
        this.pause(this.config().networkHealthManagerSampleDurationMs(), TimeUnit.MILLISECONDS);
        this.totalSamples_$eq(this.totalSamples() + 1L);
        AutomaticDemotionStatus automaticDemotionStatus = this.brokerAutomaticDemotionStatus();
        Unknown$ unknown$ = Unknown$.MODULE$;
        if (!(automaticDemotionStatus != null ? !automaticDemotionStatus.equals(unknown$) : unknown$ != null) && this.kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Describing$.MODULE$)) {
            this.runDescribeRequest();
        }
        this.checkNetworkHealthAndMaybeMitigate();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return NetworkHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(new NetworkHealthManagerConfig(newConfig));
        this.isExternalNetworkMitigationEnabled_$eq(this.config().isNetworkHealthManagerMitigationEnabled());
    }

    public final /* synthetic */ int kafka$availability$NetworkHealthManager$$$anonfun$new$1() {
        return this.healthyNetworkSampleWindow().countedSamples();
    }

    public final /* synthetic */ long kafka$availability$NetworkHealthManager$$$anonfun$new$2() {
        return this.incomingTrafficPerSample();
    }

    public final /* synthetic */ int kafka$availability$NetworkHealthManager$$$anonfun$new$3() {
        return this.brokerAutomaticDemotionStatus().id();
    }

    public final /* synthetic */ int kafka$availability$NetworkHealthManager$$$anonfun$new$4() {
        return this.networkHealthStatus().id();
    }

    public NetworkHealthManager(BrokerToControllerChannelManager brokerToControllerChannelManager, NetworkHealthManagerConfig initialConfig, NetworkAvailabilityManager networkAvailabilityManager, Scheduler scheduler) {
        this.kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager = brokerToControllerChannelManager;
        this.networkAvailabilityManager = networkAvailabilityManager;
        this.kafka$availability$NetworkHealthManager$$scheduler = scheduler;
        super("NetworkHealthManager", true);
        KafkaMetricsGroup.$init$(this);
        this.totalSamples = 0L;
        this.brokerAutomaticDemotionStatus = Unknown$.MODULE$;
        this.networkHealthStatus = Sampling$.MODULE$;
        this.isExternalNetworkMitigationEnabled = initialConfig.isNetworkHealthManagerMitigationEnabled();
        this.config = initialConfig;
        this.kafka$availability$NetworkHealthManager$$automaticDemotionLock = new Object();
        this.prevNetworkHealthCount = 0L;
        this.incomingTrafficPerSample = 0L;
        this.healthyNetworkSampleWindow = new HealthSamplesWindow();
        this.kafka$availability$NetworkHealthManager$$exponentialBackoff = new ExponentialBackoff((long)this.config().automaticLeadershipPriorityRetryBackoffMs(), 2, 10000L, 0.0);
        this.newGauge(NetworkHealthManager$.MODULE$.HealthyNetworkCountMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ NetworkHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$NetworkHealthManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(NetworkHealthManager$.MODULE$.IncomingTrafficMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ NetworkHealthManager $outer;

            public final long value() {
                return this.$outer.kafka$availability$NetworkHealthManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(NetworkHealthManager$.MODULE$.AutomaticDemotionStatusMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ NetworkHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$NetworkHealthManager$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(NetworkHealthManager$.MODULE$.NetworkHealthStatusMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ NetworkHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$NetworkHealthManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    private class AlterLeadershipPriorityResponseHandler
    extends ControllerRequestCompletionHandler {
        private final AutomaticDemotionStatus expectedAutomaticDemotionStatus;
        private final int retryCount;
        public final /* synthetic */ NetworkHealthManager $outer;

        public void onComplete(ClientResponse response) {
            Object object = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                AutomaticDemotionStatus automaticDemotionStatus = this.expectedAutomaticDemotionStatus;
                AutomaticDemotionStatus automaticDemotionStatus2 = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                if (!(automaticDemotionStatus == null ? automaticDemotionStatus2 != null : !automaticDemotionStatus.equals(automaticDemotionStatus2))) {
                    if (response.authenticationException() != null) {
                        this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("AlterLeadershipPriority request failed for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" with an ").append("authentication exception.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.authenticationException());
                        this.scheduleRetryAlterRequest(this.expectedAutomaticDemotionStatus, this.retryCount);
                    } else if (response.versionMismatch() != null) {
                        this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("AlterLeadershipPriority request failed for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" with invalid version exception.").toString());
                        this.scheduleRetryAlterRequest(this.expectedAutomaticDemotionStatus, this.retryCount);
                    } else {
                        AlterLeadershipPriorityResponseData alterLeadershipPriorityResponseData = ((AlterLeadershipPriorityResponse)response.responseBody()).data();
                        if (alterLeadershipPriorityResponseData.errorCode() != 0) {
                            this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("AlterLeadershipPriority request for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" returned ").append("with error ").append(Errors.forCode((short)alterLeadershipPriorityResponseData.errorCode())).append(".").toString());
                            this.scheduleRetryAlterRequest(this.expectedAutomaticDemotionStatus, this.retryCount);
                        } else {
                            this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("AlterLeadershipPriority request for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" successfully completed.").toString());
                            AutomaticDemotionStatus automaticDemotionStatus3 = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                            if (Demoting$.MODULE$.equals(automaticDemotionStatus3)) {
                                this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Demoted$.MODULE$);
                            } else if (Promoting$.MODULE$.equals(automaticDemotionStatus3)) {
                                this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Promoted$.MODULE$);
                            }
                        }
                    }
                    return;
                }
                this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(137).append("Demotion status changed while AlterLeadershipPriority request for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" request was in flight. ").append("Expected ").append($this.expectedAutomaticDemotionStatus).append(" but was ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus()).append(". Abandoning request.").toString());
                return;
            }
        }

        @Override
        public void onTimeout() {
            Object object = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                AutomaticDemotionStatus automaticDemotionStatus = this.expectedAutomaticDemotionStatus;
                AutomaticDemotionStatus automaticDemotionStatus2 = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                if (!(automaticDemotionStatus == null ? automaticDemotionStatus2 != null : !automaticDemotionStatus.equals(automaticDemotionStatus2))) {
                    this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("AlterLeadershipPriority request for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" timed out.").toString());
                    this.scheduleRetryAlterRequest(this.expectedAutomaticDemotionStatus, this.retryCount);
                    return;
                }
                this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(151).append("Demotion status changed while AlterLeadershipPriority request for ").append($this.expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" was in flight and request timed out. ").append("Expected ").append($this.expectedAutomaticDemotionStatus).append(" but was ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus()).append(". Abandoning request.").toString());
                return;
            }
        }

        private void scheduleRetryAlterRequest(AutomaticDemotionStatus expectedAutomaticDemotionStatus, int retryCount) {
            Object object = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                long delayMs = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$exponentialBackoff().backoff((long)retryCount);
                this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$scheduler().schedule("send-alter-leadership", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.retryAlterRequest(expectedAutomaticDemotionStatus, retryCount), delayMs, -1L, TimeUnit.MILLISECONDS);
                return;
            }
        }

        private void retryAlterRequest(AutomaticDemotionStatus expectedAutomaticDemotionStatus, int retryCount) {
            Object object = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                AutomaticDemotionStatus automaticDemotionStatus = this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                if (!(automaticDemotionStatus != null ? !automaticDemotionStatus.equals(expectedAutomaticDemotionStatus) : expectedAutomaticDemotionStatus != null)) {
                    this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Retrying AlterLeadershipPriority request for ").append(expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(".").toString());
                    AutomaticDemotionStatus automaticDemotionStatus2 = expectedAutomaticDemotionStatus;
                    Demoting$ demoting$ = Demoting$.MODULE$;
                    AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOp = !(automaticDemotionStatus2 != null ? !automaticDemotionStatus2.equals(demoting$) : demoting$ != null) ? AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE : AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE;
                    this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$buildAlterLeadershipPriorityRequestBuilder(priorityOp), new AlterLeadershipPriorityResponseHandler(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer(), expectedAutomaticDemotionStatus, retryCount + 1));
                } else {
                    this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Did not retry AlterLeadershipPriority request for ").append(expectedAutomaticDemotionStatus).append(" broker ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" ").append("since the status changed. Expected ").append(expectedAutomaticDemotionStatus).append(" but was ").append(this.kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus()).append(".").toString());
                }
                return;
            }
        }

        public /* synthetic */ NetworkHealthManager kafka$availability$NetworkHealthManager$AlterLeadershipPriorityResponseHandler$$$outer() {
            return this.$outer;
        }

        public AlterLeadershipPriorityResponseHandler(NetworkHealthManager $outer, AutomaticDemotionStatus expectedAutomaticDemotionStatus, int retryCount) {
            this.expectedAutomaticDemotionStatus = expectedAutomaticDemotionStatus;
            this.retryCount = retryCount;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class DescribeLeadershipPriorityResponseHandler
    extends ControllerRequestCompletionHandler {
        private final int retryCount;
        public final /* synthetic */ NetworkHealthManager $outer;

        public void onComplete(ClientResponse response) {
            Object object = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                AutomaticDemotionStatus automaticDemotionStatus = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                Describing$ describing$ = Describing$.MODULE$;
                if (!(automaticDemotionStatus == null ? describing$ != null : !automaticDemotionStatus.equals(describing$))) {
                    if (response.authenticationException() != null) {
                        this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("DescribeLeadershipPriority request failed for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" with an authentication exception.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.authenticationException());
                        this.scheduleRetryDescribeRequest(this.retryCount);
                    } else if (response.versionMismatch() != null) {
                        this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("DescribeLeadershipPriority request failed for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" with invalid version exception.").toString());
                        this.scheduleRetryDescribeRequest(this.retryCount);
                    } else {
                        DescribeLeadershipPriorityResponseData describeLeadershipPriorityResponseData = ((DescribeLeadershipPriorityResponse)response.responseBody()).data();
                        if (describeLeadershipPriorityResponseData.errorCode() != 0) {
                            this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("DescribeLeadershipPriority request for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append("  returned with error ").append(Errors.forCode((short)describeLeadershipPriorityResponseData.errorCode())).append(".").toString());
                            this.scheduleRetryDescribeRequest(this.retryCount);
                        } else {
                            DescribeLeadershipPriorityResponseData.DemotedBroker reasons;
                            Option demotedBrokerReasons = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describeLeadershipPriorityResponseData.demotedBrokers()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeLeadershipPriorityResponseHandler.$anonfun$onComplete$6(this, x$1)));
                            if (demotedBrokerReasons instanceof Some && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((reasons = (DescribeLeadershipPriorityResponseData.DemotedBroker)((Some)demotedBrokerReasons).value()).reasons()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DescribeLeadershipPriorityResponseHandler.$anonfun$onComplete$7(x$2)))) {
                                this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Demoted$.MODULE$);
                            } else {
                                this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$maybeTransitionAutomaticDemotionStatus(Promoted$.MODULE$);
                            }
                        }
                    }
                    return;
                }
                this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Demotion status changed while DescribeLeadershipPriority request for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" request was in flight. ").append("Expected Describing but was ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus()).append(". Abandoning request.").toString());
                return;
            }
        }

        @Override
        public void onTimeout() {
            Object object = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                AutomaticDemotionStatus automaticDemotionStatus = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                Describing$ describing$ = Describing$.MODULE$;
                if (!(automaticDemotionStatus == null ? describing$ != null : !automaticDemotionStatus.equals(describing$))) {
                    this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("DescribeLeadershipPriority request for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" timed out.").toString());
                    this.scheduleRetryDescribeRequest(this.retryCount);
                    return;
                }
                this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(164).append("Demotion status changed while DescribeLeadershipPriority request for  broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" request was in flight and timed out. ").append("Expected Describing but was ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus()).append(". Abandoning request.").toString());
                return;
            }
        }

        private void scheduleRetryDescribeRequest(int retryCount) {
            Object object = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                long delayMs = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$exponentialBackoff().backoff((long)retryCount);
                this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$scheduler().schedule("send-describe-leadership", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.retryDescribeRequest(retryCount), delayMs, -1L, TimeUnit.MILLISECONDS);
                return;
            }
        }

        private void retryDescribeRequest(int retryCount) {
            Object object = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$automaticDemotionLock();
            synchronized (object) {
                AutomaticDemotionStatus automaticDemotionStatus = this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().brokerAutomaticDemotionStatus();
                Describing$ describing$ = Describing$.MODULE$;
                if (!(automaticDemotionStatus != null ? !automaticDemotionStatus.equals(describing$) : describing$ != null)) {
                    this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Retrying DescribeLeadershipPriority request for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(".").toString());
                    this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().kafka$availability$NetworkHealthManager$$brokerToControllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)new DescribeLeadershipPriorityRequest.Builder(), new DescribeLeadershipPriorityResponseHandler(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer(), retryCount + 1));
                } else {
                    this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Did not retry DescribeLeadershipPriority for broker ").append(this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId()).append(" request since the status changed.").toString());
                }
                return;
            }
        }

        public /* synthetic */ NetworkHealthManager kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onComplete$6(DescribeLeadershipPriorityResponseHandler $this, DescribeLeadershipPriorityResponseData.DemotedBroker x$1) {
            return x$1.brokerId() == $this.kafka$availability$NetworkHealthManager$DescribeLeadershipPriorityResponseHandler$$$outer().config().brokerId();
        }

        public static final /* synthetic */ boolean $anonfun$onComplete$7(DescribeLeadershipPriorityResponseData.Reason x$2) {
            String string = x$2.reason();
            String string2 = NetworkHealthManager$.MODULE$.AutomaticAlterLeadershipReason();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public DescribeLeadershipPriorityResponseHandler(NetworkHealthManager $outer, int retryCount) {
            this.retryCount = retryCount;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

