/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AclCommand;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.io.StdIn$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Properties$;

public final class AclCommand$
implements Logging {
    public static AclCommand$ MODULE$;
    private final String AuthorizerDeprecationMessage;
    private final ResourcePatternFilter ClusterResourceFilter;
    private final String kafka$admin$AclCommand$$Newline;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AclCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String AuthorizerDeprecationMessage() {
        return this.AuthorizerDeprecationMessage;
    }

    public ResourcePatternFilter ClusterResourceFilter() {
        return this.ClusterResourceFilter;
    }

    public String kafka$admin$AclCommand$$Newline() {
        return this.kafka$admin$AclCommand$$Newline;
    }

    public void main(String[] args) {
        AclCommand.AclCommandService aclCommandService;
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manage acls on kafka.");
        opts.checkArgs();
        if (opts.options().has(opts.bootstrapServerOpt())) {
            aclCommandService = new AclCommand.AdminClientService(opts);
        } else {
            String authorizerClassName = opts.options().has(opts.authorizerOpt()) ? (String)opts.options().valueOf(opts.authorizerOpt()) : AclAuthorizer.class.getName();
            aclCommandService = new AclCommand.AuthorizerService(authorizerClassName, opts);
        }
        AclCommand.AdminClientService aclCommandService2 = aclCommandService;
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).addAcls();
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).removeAcls();
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).listAcls();
            }
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(35).append("Error while executing ACL command: ").append(e.getMessage()).toString());
            Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public scala.collection.immutable.Set<Uuid> kafka$admin$AclCommand$$getClusterLinkIds(AclCommand.AclCommandOptions opts) {
        if (opts.options().has(opts.linkIdOpt())) {
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.linkIdOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)s -> Uuid.fromString((String)s.trim()), Buffer$.MODULE$.canBuildFrom())).toSet();
        }
        return Predef$.MODULE$.Set().empty();
    }

    /*
     * WARNING - void declaration
     */
    public Map<ResourcePattern, scala.collection.immutable.Set<AccessControlEntry>> kafka$admin$AclCommand$$getResourceToAcls(AclCommand.AclCommandOptions opts) {
        void var3_3;
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        if (!patternType.isSpecific()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringBuilder(70).append("A '--resource-pattern-type' value of '").append(patternType).append("' is not valid when adding acls.").toString());
        }
        Map resourceToAcl = (Map)this.kafka$admin$AclCommand$$getResourceFilterToAcls(opts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ResourcePatternFilter filter = (ResourcePatternFilter)x0$1._1();
            scala.collection.immutable.Set acls = (scala.collection.immutable.Set)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(filter.resourceType(), filter.name(), filter.patternType())), (Object)acls);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        if (resourceToAcl.values().exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isEmpty()))) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        return var3_3;
    }

    public Map<ResourcePatternFilter, scala.collection.immutable.Set<AccessControlEntry>> kafka$admin$AclCommand$$getResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef resourceToAcls = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus(this.getCliResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus((GenTraversableOnce)this.getConsumerResourceFilterToAcls(opts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                ResourcePatternFilter k = (ResourcePatternFilter)x0$1._1();
                scala.collection.immutable.Set v = (scala.collection.immutable.Set)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)((Map)resourceToAcls$5.elem).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
                return tuple2;
            }, Map$.MODULE$.canBuildFrom()));
        }
        this.validateOperation(opts, (Map<ResourcePatternFilter, scala.collection.immutable.Set<AccessControlEntry>>)((Map)resourceToAcls.elem));
        return (Map)resourceToAcls.elem;
    }

    private Map<ResourcePatternFilter, scala.collection.immutable.Set<AccessControlEntry>> getProducerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        scala.collection.immutable.Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)filters.filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$1(x$23)));
        scala.collection.immutable.Set transactionalIds = (scala.collection.immutable.Set)filters.filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$2(x$24)));
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        scala.collection.immutable.Set<AccessControlEntry> topicAcls = this.getAcl(opts, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE}))));
        scala.collection.immutable.Set<AccessControlEntry> transactionalIdAcls = this.getAcl(opts, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$25 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$25), (Object)topicAcls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)transactionalIds.map((Function1 & Serializable & scala.Serializable)x$26 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$26), (Object)transactionalIdAcls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)(enableIdempotence ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ClusterResourceFilter()), this.getAcl(opts, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.IDEMPOTENT_WRITE})))))})) : Predef$.MODULE$.Map().empty()));
    }

    private Map<ResourcePatternFilter, scala.collection.immutable.Set<AccessControlEntry>> getConsumerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        scala.collection.immutable.Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)filters.filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$1(x$27)));
        scala.collection.immutable.Set groups = (scala.collection.immutable.Set)filters.filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$2(x$28)));
        scala.collection.immutable.Set<AccessControlEntry> acls = this.getAcl(opts, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$29 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$29), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)groups.map((Function1 & Serializable & scala.Serializable)x$30 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$30), MODULE$.getAcl(opts, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}))))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private Map<ResourcePatternFilter, scala.collection.immutable.Set<AccessControlEntry>> getCliResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        scala.collection.immutable.Set<AccessControlEntry> acls = this.getAcl(opts);
        return ((TraversableOnce)this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2()).map((Function1 & Serializable & scala.Serializable)x$31 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$31), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Set<AccessControlEntry> getAcl(AclCommand.AclCommandOptions opts, scala.collection.immutable.Set<AclOperation> operations) {
        scala.collection.immutable.Set<KafkaPrincipal> allowedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.allowPrincipalsOpt());
        scala.collection.immutable.Set<KafkaPrincipal> deniedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.denyPrincipalsOpt());
        scala.collection.immutable.Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        scala.collection.immutable.Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        scala.collection.immutable.Set<Uuid> linkIds = this.kafka$admin$AclCommand$$getClusterLinkIds(opts);
        HashSet acls = new HashSet();
        if (allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty()) {
            acls.$plus$plus$eq(this.getAcls(allowedPrincipals, AclPermissionType.ALLOW, operations, allowedHosts, linkIds));
        }
        if (deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty()) {
            acls.$plus$plus$eq(this.getAcls(deniedPrincipals, AclPermissionType.DENY, operations, deniedHosts, linkIds));
        }
        return acls.toSet();
    }

    private scala.collection.immutable.Set<AccessControlEntry> getAcl(AclCommand.AclCommandOptions opts) {
        scala.collection.immutable.Set operations = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)operation -> SecurityUtils.operation((String)operation.trim()), Buffer$.MODULE$.canBuildFrom())).toSet();
        return this.getAcl(opts, (scala.collection.immutable.Set<AclOperation>)operations);
    }

    public scala.collection.immutable.Set<AccessControlEntry> getAcls(scala.collection.immutable.Set<KafkaPrincipal> principals, AclPermissionType permissionType, scala.collection.immutable.Set<AclOperation> operations, scala.collection.immutable.Set<String> hosts, scala.collection.immutable.Set<Uuid> linkIds) {
        return (scala.collection.immutable.Set)principals.flatMap((Function1 & Serializable & scala.Serializable)principal -> (scala.collection.immutable.Set)operations.flatMap((Function1 & Serializable & scala.Serializable)operation -> (scala.collection.immutable.Set)hosts.map((Function1 & Serializable & scala.Serializable)host -> new AccessControlEntry(principal.toString(), host, operation, permissionType, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)linkIds).asJava()), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Set<Uuid> getAcls$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    private scala.collection.immutable.Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(hostOptionSpec)) {
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.trim(), Buffer$.MODULE$.canBuildFrom())).toSet();
        }
        if (opts.options().has(principalOptionSpec)) {
            return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{AclEntry$.MODULE$.WildcardHost()}));
        }
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<KafkaPrincipal> kafka$admin$AclCommand$$getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(principalOptionSpec)) {
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)s -> SecurityUtils.parseKafkaPrincipal((String)s.trim()), Buffer$.MODULE$.canBuildFrom())).toSet();
        }
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<ResourcePatternFilter> kafka$admin$AclCommand$$getResourceFilter(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        ObjectRef resourceFilters = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            opts.options().valuesOf(opts.topicOpt()).forEach(topic -> {
                resourceFilters$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), patternType));
            });
        }
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.LITERAL;
        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
            if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
                resourceFilters.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)resourceFilters.elem).$plus((Object)this.ClusterResourceFilter());
            }
        }
        if (opts.options().has(opts.groupOpt())) {
            opts.options().valuesOf(opts.groupOpt()).forEach(group -> {
                resourceFilters$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.GROUP, group.trim(), patternType));
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            opts.options().valuesOf(opts.transactionalIdOpt()).forEach(transactionalId -> {
                resourceFilters$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, patternType));
            });
        }
        if (opts.options().has(opts.delegationTokenOpt())) {
            opts.options().valuesOf(opts.delegationTokenOpt()).forEach(token -> {
                resourceFilters$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), patternType));
            });
        }
        if (opts.options().has(opts.userPrincipalOpt())) {
            opts.options().valuesOf(opts.userPrincipalOpt()).forEach(user -> {
                resourceFilters$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.USER, user.trim(), patternType));
            });
        }
        if (((scala.collection.immutable.Set)resourceFilters.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return (scala.collection.immutable.Set)resourceFilters.elem;
    }

    private boolean getResourceFilter$default$2() {
        return true;
    }

    public boolean kafka$admin$AclCommand$$confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println((Object)msg);
        return StdIn$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, Map<ResourcePatternFilter, scala.collection.immutable.Set<AccessControlEntry>> resourceToAcls) {
        resourceToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$8 != null))).foreach((Function1 & Serializable & scala.Serializable)x$34 -> {
            AclCommand$.$anonfun$validateOperation$2(opts, x$34);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$1(ResourcePatternFilter x$23) {
        ResourceType resourceType = x$23.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$2(ResourcePatternFilter x$24) {
        ResourceType resourceType = x$24.resourceType();
        ResourceType resourceType2 = ResourceType.TRANSACTIONAL_ID;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$1(ResourcePatternFilter x$27) {
        ResourceType resourceType = x$27.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$2(ResourcePatternFilter x$28) {
        ResourceType resourceType = x$28.resourceType();
        ResourceType resourceType2 = ResourceType.GROUP;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateOperation$2(AclCommand.AclCommandOptions opts$2, Tuple2 x$34) {
        if (x$34 != null) {
            ResourcePatternFilter resource = (ResourcePatternFilter)x$34._1();
            scala.collection.immutable.Set acls = (scala.collection.immutable.Set)x$34._2();
            scala.collection.immutable.Set validOps = (scala.collection.immutable.Set)AclEntry$.MODULE$.supportedOperations(resource.resourceType()).$plus((Object)AclOperation.ALL);
            if (((TraversableOnce)((Subtractable)acls.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.operation(), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)validOps)).nonEmpty()) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$2.parser(), new StringBuilder(39).append("ResourceType ").append(resource.resourceType()).append(" only supports operations ").append(validOps.mkString(",")).toString());
            }
        } else {
            throw new MatchError(null);
        }
    }

    private AclCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.AuthorizerDeprecationMessage = "Warning: support for ACL configuration directly through the authorizer is deprecated and will be removed in a future release. Please use --bootstrap-server instead to set ACLs through the admin client.";
        this.ClusterResourceFilter = new ResourcePatternFilter(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.kafka$admin$AclCommand$$Newline = Properties$.MODULE$.lineSeparator();
    }
}

