/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AbstractLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.MetadataPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001C\u0005\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0005e!)!\n\u0001C\u0005\u0017\")\u0011\u000f\u0001C\u0005e\")\u0011\u0010\u0001C\u0001=\tY\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d+fgRT!AC\u0006\u0002\u00115,G/\u00193bi\u0006T!\u0001D\u0007\u0002\rM,'O^3s\u0015\tqq\"A\u0003lC\u001a\\\u0017MC\u0001\u0011\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005I\u0011!\u0005;fgR<U\r\u001e+pa&\u001cG)\u001a7uCR\tq\u0004\u0005\u0002\u0015A%\u0011\u0011%\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0003GA\u0011A%L\u0007\u0002K)\u0011aeJ\u0001\u0004CBL'B\u0001\u0015*\u0003\u001dQW\u000f]5uKJT!AK\u0016\u0002\u000b),h.\u001b;\u000b\u00031\n1a\u001c:h\u0013\tqSE\u0001\u0003UKN$\u0018!\u0006;fgR4\u0015N\u001c3TiJ\f\u0017PU3qY&\u001c\u0017m\u001d\u0015\u0003\u0007\r\nq!\\8dW2{w\rF\u00024u\u0015\u0003\"\u0001\u000e\u001d\u000e\u0003UR!AN\u001c\u0002\u00071|wMC\u0001\u000f\u0013\tITGA\u0006BEN$(/Y2u\u0019><\u0007\"B\u001e\u0005\u0001\u0004a\u0014a\u0002;pa&\u001c\u0017\n\u001a\t\u0003{\rk\u0011A\u0010\u0006\u0003\u007f\u0001\u000baaY8n[>t'B\u0001\bB\u0015\t\u00115&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\tz\u0012A!V;jI\")a\t\u0002a\u0001\u000f\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u001fI\u0013\tIeH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015Q|\u0007/[2J[\u0006<W\r\u0006\u0003M%N\u0003\u0007CA'Q\u001b\u0005q%BA(A\u0003\u0015IW.Y4f\u0013\t\tfJ\u0001\u0006U_BL7-S7bO\u0016DQaO\u0003A\u0002qBQ\u0001V\u0003A\u0002U\u000bQ\u0001^8qS\u000e\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u0016\u001b\u0005I&B\u0001.\u0012\u0003\u0019a$o\\8u}%\u0011A,F\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]+!)\u0011-\u0002a\u0001E\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\tY\u001bW\r[\u0005\u0003I~\u00131!T1q!\t!b-\u0003\u0002h+\t\u0019\u0011J\u001c;\u0011\u0007%tWM\u0004\u0002kY:\u0011\u0001l[\u0005\u0002-%\u0011Q.F\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0007OA\u0002TKFT!!\\\u000b\u0002\u0017Q|\u0007/[2t\u00136\fw-\u001a\u000b\u0003gZ\u0004\"!\u0014;\n\u0005Ut%a\u0003+pa&\u001c7/S7bO\u0016DQa\u001e\u0004A\u0002a\fa\u0001^8qS\u000e\u001c\bcA5o\u0019\u0006IC/Z:u%\u0016dw.\u00193Va\u0012\fG/\u001a3GS2,7oV5uQ>,HoQ8oM&<7\t[1oO\u0016D#aB>\u0011\u0005\u0011b\u0018BA?&\u0005!!\u0015n]1cY\u0016$\u0007FA\u0004$\u0001")
public class BrokerMetadataPublisherTest {
    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        AbstractLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        AbstractLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        AbstractLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        AbstractLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        AbstractLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), LeaderRecoveryState.RECOVERED, 0, 0));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        return new TopicImage(topic, topicId, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRegistrations).asJava(), null);
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map namesMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new TopicsImage((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)idsMap).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)namesMap).asJava(), Collections.emptyMap(), Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Disabled
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)new BrokerMetadataPublisher(broker.config(), broker.metadataCache(), broker.logManager(), broker.replicaManager(), broker.groupCoordinator(), broker.transactionCoordinator(), broker.clientQuotaMetadataManager(), broker.featureCache(), broker.dynamicConfigHandlers().toMap(Predef$.MODULE$.$conforms()), Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.empty()));
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$4());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }
}

