/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.InitiateShutdownResponse;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Predef;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\t\u0013\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013\u0005S\u0005\u0003\u0004-\u0001\u0001\u0006IA\n\u0005\n[\u0001\u0001\r\u00111A\u0005\u00029B\u0011B\r\u0001A\u0002\u0003\u0007I\u0011A\u001a\t\u0013e\u0002\u0001\u0019!A!B\u0013y\u0003\"\u0003\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0001<\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005C\u0001\u0001\u0007\t\u0011)Q\u0005y!91\t\u0001b\u0001\n\u0003!\u0005BB)\u0001A\u0003%Q\tC\u0003S\u0001\u0011\u00053\u000bC\u0003g\u0001\u0011\u0005s\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0004\u0002&\u0001!\t!a\n\t\r\u0005E\u0002\u0001\"\u0001<\u0005\u0019Je.\u001b;jCR,7\u000b[;uI><hNU3rk\u0016\u001cH/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003'Q\taa]3sm\u0016\u0014(BA\u000b\u0017\u0003\u0015Y\u0017MZ6b\u0015\u00059\u0012\u0001B;oSR\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\u00111#\b\u0006\u0002+%\u0011q\u0004\b\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011AE\u0001\fEJ|7.\u001a:D_VtG/F\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\rIe\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\u0007EJ|7.\u001a:\u0016\u0003=\u0002\"a\u0007\u0019\n\u0005Eb\"aC&bM.\f'I]8lKJ\f!B\u0019:pW\u0016\u0014x\fJ3r)\t!t\u0007\u0005\u0002(k%\u0011a\u0007\u000b\u0002\u0005+:LG\u000fC\u00049\u000b\u0005\u0005\t\u0019A\u0018\u0002\u0007a$\u0013'A\u0004ce>\\WM\u001d\u0011\u0002\u0017\t\u0014xn[3s\u000bB|7\r[\u000b\u0002yA\u0011q%P\u0005\u0003}!\u0012A\u0001T8oO\u0006y!M]8lKJ,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u00025\u0003\"9\u0001\bCA\u0001\u0002\u0004a\u0014\u0001\u00042s_.,'/\u00129pG\"\u0004\u0013AB3ySR,G-F\u0001F!\t1u*D\u0001H\u0015\tA\u0015*\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0015.\u000b!bY8oGV\u0014(/\u001a8u\u0015\taU*\u0001\u0003vi&d'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!\u001e\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003iQCQ!\u0016\u0007A\u0002Y\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003/\u0002l\u0011\u0001\u0017\u0006\u00033j\u000b1!\u00199j\u0015\tYF,A\u0004kkBLG/\u001a:\u000b\u0005us\u0016!\u00026v]&$(\"A0\u0002\u0007=\u0014x-\u0003\u0002b1\nAA+Z:u\u0013:4w\u000e\u000b\u0002\rGB\u0011q\u000bZ\u0005\u0003Kb\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001\u001b)\u00055I\u0007CA,k\u0013\tY\u0007LA\u0005BMR,'/R1dQ\u0006YB/Z:u\u0013:LG/[1uKNCW\u000f\u001e3po:\u0014V-];fgR$\"\u0001\u000e8\t\u000b=t\u0001\u0019\u00019\u0002\rE,xN];n!\t\t\bP\u0004\u0002smB\u00111\u000fK\u0007\u0002i*\u0011Q\u000fG\u0001\u0007yI|w\u000e\u001e \n\u0005]D\u0013A\u0002)sK\u0012,g-\u0003\u0002zu\n11\u000b\u001e:j]\u001eT!a\u001e\u0015)\r9a\u0018\u0011BA\u0006!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u0011A\u0014xN^5eKJT1!a\u0001[\u0003\u0019\u0001\u0018M]1ng&\u0019\u0011q\u0001@\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ti!!\u0005\"\u0005\u0005=\u0011A\u0001>lC\t\t\u0019\"A\u0003le\u00064G\u000fK\u0004\u000f\u0003/\ty\"!\t\u0011\t\u0005e\u00111D\u0007\u0003\u0003\u0003IA!!\b\u0002\u0002\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003G\t\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003=#Xm\u001d;J]&$\u0018.\u0019;f'\",H\u000fZ8x]J+\u0017/^3tiJ+G/\u001e:ogN#\u0018\r\\3Ce>\\WM]#q_\u000eDW\t_2faRLwN\\%g\u0005J|7.\u001a:Fa>\u001c\u0007.S:Ti\u0006dW\rF\u00025\u0003SAQa\\\bA\u0002ADca\u0004?\u0002\n\u00055B\u0006BA\u0007\u0003#AsaDA\f\u0003?\t\t#\u0001\tti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ\u0002")
public class InitiateShutdownRequestIntegrationTest
extends BaseRequestTest {
    private final int brokerCount;
    private KafkaBroker broker;
    private long brokerEpoch;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public KafkaBroker broker() {
        return this.broker;
    }

    public void broker_$eq(KafkaBroker x$1) {
        this.broker = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public void brokerEpoch_$eq(long x$1) {
        this.brokerEpoch = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Exit.setExitProcedure((x$1, x$2) -> {
            this.exited().set(true);
            throw new Exception();
        });
        this.broker_$eq((KafkaBroker)this.brokers().head());
        this.brokerEpoch_$eq(this.broker().brokerEpoch());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInitiateShutdownRequest(String quorum) {
        InitiateShutdownRequest shutdownReq = (InitiateShutdownRequest)new InitiateShutdownRequest.Builder(this.brokerEpoch()).build();
        InitiateShutdownResponse shutdownResponse = (InitiateShutdownResponse)this.connectAndReceive((AbstractRequest)shutdownReq, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitiateShutdownResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shutdownResponse.data().errorCode());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!InitiateShutdownRequestIntegrationTest.$anonfun$testInitiateShutdownRequest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)InitiateShutdownRequestIntegrationTest.$anonfun$testInitiateShutdownRequest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInitiateShutdownRequestReturnsStaleBrokerEpochExceptionIfBrokerEpochIsStale(String quorum) {
        InitiateShutdownRequest shutdownReq = (InitiateShutdownRequest)new InitiateShutdownRequest.Builder(this.staleBrokerEpoch()).build();
        InitiateShutdownResponse shutdownResponse = (InitiateShutdownResponse)this.connectAndReceive((AbstractRequest)shutdownReq, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitiateShutdownResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.STALE_BROKER_EPOCH.code(), (short)shutdownResponse.data().errorCode());
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Shutdown should not have been initiated");
    }

    /*
     * WARNING - void declaration
     */
    public long staleBrokerEpoch() {
        void var1_1;
        long staleEpoch = this.brokerEpoch() - 1L;
        if (staleEpoch == -1L) {
            return staleEpoch - 1L;
        }
        return (long)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$testInitiateShutdownRequest$1(InitiateShutdownRequestIntegrationTest $this) {
        return $this.exited().get();
    }

    public static final /* synthetic */ String $anonfun$testInitiateShutdownRequest$2() {
        return "Shutdown should have been initiated";
    }

    public InitiateShutdownRequestIntegrationTest() {
        this.brokerCount = 1;
    }
}

