/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.controller;

import integration.kafka.server.TestDataBalancer;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.common.TopicsMetadataSnapshot;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.DataBalanceManager;
import kafka.controller.DataBalanceManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.requests.ApiError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\b\u0011\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u00191\u0004\u0001)A\u0005_!9q\u0007\u0001b\u0001\n\u0003A\u0004BB \u0001A\u0003%\u0011\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003j\u0001\u0011\u0005!\u000eC\u0003w\u0001\u0011\u0005!\u000eC\u0003y\u0001\u0011\u0005!\u000eC\u0003{\u0001\u0011\u0005!\u000eC\u0003}\u0001\u0011%Q\u0010C\u0004\u0002\u0010\u0001!I!!\u0005\u0003-\u0011\u000bG/\u0019\"bY\u0006t7-Z'b]\u0006<WM\u001d+fgRT!!\u0005\n\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0014)\u0005)1.\u00194lC*\tQ#\u0001\u0003v]&$8\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0011\u0003\u0019\u0019wN\u001c4jOV\tA\u0005\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!Q\u000f^5m\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\u0015A\u0013x\u000e]3si&,7/A\u0004d_:4\u0017n\u001a\u0011\u0002!\u0015D\b/Z2uK\u0012,e\u000e\u001a9pS:$X#A\u0018\u0011\u0005A\"T\"A\u0019\u000b\u0005I\u001a\u0014aB2mkN$XM\u001d\u0006\u0002'%\u0011Q'\r\u0002\t\u000b:$\u0007k\\5oi\u0006\tR\r\u001f9fGR,G-\u00128ea>Lg\u000e\u001e\u0011\u0002#%t\u0017\u000e^5bY\n\u0013xn[3s\u0013:4w.F\u0001:!\tQT(D\u0001<\u0015\ta4'\u0001\u0002{W&\u0011ah\u000f\u0002\u000b\u0005J|7.\u001a:J]\u001a|\u0017AE5oSRL\u0017\r\u001c\"s_.,'/\u00138g_\u0002\n!\u0004^3ti\n\u000bG.\u00198dKJ\u001cF/\u0019;vg\u000e\u000bG\u000e\u001c2bG.$\"AQ0\u0015\u0007\r3U\u000b\u0005\u0002\u001a\t&\u0011QI\u0007\u0002\u0005+:LG\u000fC\u0003H\u0011\u0001\u0007\u0001*A\u0003feJ|'\u000f\u0005\u0002J'6\t!J\u0003\u0002L\u0019\u0006A!/Z9vKN$8O\u0003\u0002N\u001d\u000611m\\7n_:T!aE(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003)*\u0013\u0001\"\u00119j\u000bJ\u0014xN\u001d\u0005\u0006-\"\u0001\raV\u0001\ngR\fG/^:PaR\u00042!\n-[\u0013\tIfE\u0001\u0005PaRLwN\\1m!\tYV,D\u0001]\u0015\ti5'\u0003\u0002_9\n\t#)\u00197b]\u000e,'o\u0015;biV\u001cH)Z:de&\u0004H/[8o\u0013:$XM\u001d8bY\")\u0001\r\u0003a\u0001C\u0006I1\u000f^1ukN\u0014VM\u001a\t\u0004E\u001eTV\"A2\u000b\u0005\u0011,\u0017AB1u_6L7M\u0003\u0002gM\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005!\u001c'aD!u_6L7MU3gKJ,gnY3\u0002?Q,7\u000f\u001e#bi\u0006\u0014\u0015\r\\1oG\u0016\u00148I]3bi&|gnU;dG\u0016\u001c8\u000fF\u0001DQ\tIA\u000e\u0005\u0002ni6\taN\u0003\u0002pa\u0006\u0019\u0011\r]5\u000b\u0005E\u0014\u0018a\u00026va&$XM\u001d\u0006\u0003gF\u000bQA[;oSRL!!\u001e8\u0003\tQ+7\u000f^\u0001>i\u0016\u001cH\u000fR1uC\n\u000bG.\u00198dKJ\u001cE.Y:t\u0019>\fGMR1jYV\u0014XMU3ukJt7/\u0012=qK\u000e$X\r\u001a\"bY\u0006t7-\u001a:Ti\u0006$Xo\u001d\u0015\u0003\u00151\f1\u000b^3ti\u0012\u000bG/\u0019\"bY\u0006t7-\u001a:DY\u0006\u001c8\u000fT8bI\u001a\u000b\u0017\u000e\\;sKJ+G/\u001e:og\u0016C\b/Z2uK\u0012,\u0005pY3qi&|gN\u0012:p[6+G\u000f[8eg\u000e\u000bG\u000e\\3e\u0005f\\\u0015MZ6b\u0003BL\u0007FA\u0006m\u0003%#Xm\u001d;ECR\f')\u00197b]\u000e,'o\u00117bgNdu.\u00193GC&dWO]3SKN,H\u000e^:J]:{w\n\u001d$s_6\u001cuN\u001c;s_2dWM]%om>\\W\rZ'fi\"|Gm\u001d\u0015\u0003\u00191\fqC^1mS\u0012$\u0015\r^1CC2\fgnY3NC:\fw-\u001a:\u0015\u0003y\u00042a`A\u0006\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB:feZ,'OC\u0002\u0014\u0003\u000fQ!!!\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0005\u0003\u001b\t\tA\u0001\tUKN$H)\u0019;b\u0005\u0006d\u0017M\\2fe\u0006I\u0012N\u001c<bY&$G)\u0019;b\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s)\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\t\t2'\u0003\u0003\u0002\u001c\u0005]!A\u0005#bi\u0006\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\u0004")
public class DataBalanceManagerTest {
    private final Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2081", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
    private final EndPoint expectedEndpoint = EndPoint$.MODULE$.createEndPoint("PLAINTEXT://localhost:7078", Option$.MODULE$.empty());
    private final BrokerInfo initialBrokerInfo = BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{this.expectedEndpoint()}), Option$.MODULE$.empty()), ApiVersion$.MODULE$.latestVersion(), -1);

    public Properties config() {
        return this.config;
    }

    public EndPoint expectedEndpoint() {
        return this.expectedEndpoint;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void testBalancerStatusCallback(AtomicReference<BalancerStatusDescriptionInternal> statusRef, ApiError error, Optional<BalancerStatusDescriptionInternal> statusOpt) {
        statusRef.set(statusOpt.get());
    }

    @Test
    public void testDataBalancerCreationSuccess() {
        TestDataBalancer testDataBalancer = this.validDataBalanceManager();
        Endpoint actualBootstrapServerEndpoint = testDataBalancer.bootstrapServerEndpoint();
        Assertions.assertEquals((Object)this.expectedEndpoint().host(), (Object)actualBootstrapServerEndpoint.host());
        Assertions.assertEquals((int)this.expectedEndpoint().port(), (int)actualBootstrapServerEndpoint.port());
        Assertions.assertEquals((Object)this.expectedEndpoint().securityProtocol(), (Object)actualBootstrapServerEndpoint.securityProtocol());
        AtomicReference currentStatus = new AtomicReference();
        AtomicReference testBalancerStatus = new AtomicReference();
        testDataBalancer.balancerStatus((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal>)((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback)(error, statusOpt) -> this.testBalancerStatusCallback(currentStatus, error, statusOpt)));
        Assertions.assertNotNull(currentStatus.get());
        Assertions.assertNull(testBalancerStatus.get());
        new TestDataBalancer().balancerStatus((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal>)((ClusterBalanceManager.BalanceManagerStatusQueryClientCallback)(error, statusOpt) -> this.testBalancerStatusCallback(testBalancerStatus, error, statusOpt)));
        Assertions.assertEquals(testBalancerStatus.get(), currentStatus.get(), (String)new StringBuilder(66).append("Test balancer status ").append(testBalancerStatus.get()).append(" doesn't match that of instantiated balancer ").append(currentStatus.get()).toString());
    }

    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedBalancerStatus() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManager();
        AtomicReference managerStatus = new AtomicReference();
        Assertions.assertNull(managerStatus.get());
        dataBalanceManager.balancerStatus((error, statusOpt) -> this.testBalancerStatusCallback(managerStatus, error, statusOpt));
        Assertions.assertNotNull(managerStatus.get());
        Assertions.assertEquals((Object)BalancerStatus.LOAD_FAILURE, (Object)((BalancerStatusDescriptionInternal)managerStatus.get()).balancerStatus());
    }

    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManager();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataBalanceManager.scheduleZkBrokerRemoval((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).map((Function1 & Serializable & scala.Serializable)x -> DataBalanceManagerTest.$anonfun$testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi$2(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava(), true, (TopicsMetadataSnapshot)Mockito.mock(TopicsMetadataSnapshot.class), (AliveBrokersMetadata)AliveBrokersSnapshot.EMPTY_SNAPSHOT, error -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataBalanceManager.brokerRemovals((error, resultOpt) -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataBalanceManager.brokerAdditions((error, resultOpt) -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataBalanceManager.evenClusterLoadStatus((error, resultOpt) -> {}), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    @Test
    public void testDataBalancerClassLoadFailureResultsInNoOpFromControllerInvokedMethods() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManager();
        dataBalanceManager.onElection((AliveBrokersMetadata)new AliveBrokersSnapshot((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)2L))}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().empty()).asJava()));
        dataBalanceManager.onResignation();
        dataBalanceManager.shutdown();
        dataBalanceManager.updateConfig((KafkaConfig)Mockito.mock(KafkaConfig.class), (KafkaConfig)Mockito.mock(KafkaConfig.class));
        dataBalanceManager.onBrokersStartup((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava(), (AliveBrokersMetadata)AliveBrokersSnapshot.EMPTY_SNAPSHOT);
        dataBalanceManager.onBrokersFailure((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava());
    }

    private TestDataBalancer validDataBalanceManager() {
        this.config().put("confluent.balancer.class", TestDataBalancer.class.getCanonicalName());
        return (TestDataBalancer)DataBalanceManager$.MODULE$.apply(KafkaConfig$.MODULE$.fromProps(this.config()), this.initialBrokerInfo());
    }

    private DataBalanceManager invalidDataBalanceManager() {
        this.config().put("confluent.balancer.class", "InvalidClassName -- This will throw an error on instantiation");
        return DataBalanceManager$.MODULE$.apply(KafkaConfig$.MODULE$.fromProps(this.config()), this.initialBrokerInfo());
    }

    public static final /* synthetic */ Integer $anonfun$testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

