/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.balancer.BrokerRemovalCommand$;
import kafka.admin.balancer.BrokerRemovalCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsResult;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.clients.admin.RemoveBrokersResult;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\u0010 \u0005!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u00015\u0011\u0019Q\u0004\u0001)A\u0005k!91\b\u0001b\u0001\n\u0003!\u0004B\u0002\u001f\u0001A\u0003%Q\u0007C\u0004>\u0001\t\u0007I\u0011\u0001\u001b\t\ry\u0002\u0001\u0015!\u00036\u0011\u001dy\u0004A1A\u0005\u0002\u0001Ca!\u0013\u0001!\u0002\u0013\t\u0005b\u0002&\u0001\u0005\u0004%\ta\u0013\u0005\u0007+\u0002\u0001\u000b\u0011\u0002'\t\u000bY\u0003A\u0011B,\t\u000b=\u0004A\u0011\u00019\t\u000b}\u0004A\u0011\u00019\t\r\u0005\r\u0001\u0001\"\u0001q\u0011\u0019\t9\u0001\u0001C\u0001a\"1\u00111\u0002\u0001\u0005\u0002ADa!a\u0004\u0001\t\u0003\u0001\bBBA\n\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002\u0018\u0001!\t\u0001\u001d\u0005\u0007\u00037\u0001A\u0011\u00019\t\r\u0005}\u0001\u0001\"\u0001q\u0011\u0019\t\u0019\u0003\u0001C\u0001a\"9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K\u0012\u0001D\u0011:pW\u0016\u0014(+Z7pm\u0006d7i\\7nC:$G+Z:u\u0015\t\u0001\u0013%\u0001\u0005cC2\fgnY3s\u0015\t\u00113%A\u0003bI6LgN\u0003\u0002%K\u0005)1.\u00194lC*\ta%\u0001\u0003v]&$8\u0001A\n\u0003\u0001%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001 \u0003)\u0011'o\\6fe&#w,M\u000b\u0002kA\u0011!FN\u0005\u0003o-\u00121!\u00138u\u0003-\u0011'o\\6fe&#w,\r\u0011\u0002\u0015\t\u0014xn[3s\u0013\u0012|&'A\u0006ce>\\WM]%e?J\u0002\u0013aC:uCJ$H+[7f\u001bN\fAb\u001d;beR$\u0016.\\3Ng\u0002\n\u0001\u0003\\1tiV\u0003H-\u0019;f)&lW-T:\u0002#1\f7\u000f^+qI\u0006$X\rV5nK6\u001b\b%A\bc_>$8\u000f\u001e:baN+'O^3s+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u0004\u0013!\u00032s_.,'/\u00133t+\u0005a\u0005cA'Q%6\taJ\u0003\u0002P\u000b\u0006!Q\u000f^5m\u0013\t\tfJ\u0001\u0003MSN$\bC\u0001\"T\u0013\t!6IA\u0004J]R,w-\u001a:\u0002\u0015\t\u0014xn[3s\u0013\u0012\u001c\b%A\u000fsK6|g/\u00197PaRLwN\\:Be\u001e,X.\u001a8u\u001b\u0006$8\r[3s)\tA&\u000eE\u0002Z=\u0002l\u0011A\u0017\u0006\u00037r\u000bq!\\8dW&$xNC\u0001^\u0003\ry'oZ\u0005\u0003?j\u0013q\"\u0011:hk6,g\u000e^'bi\u000eDWM\u001d\t\u0003C\"l\u0011A\u0019\u0006\u0003E\rT!\u0001Z3\u0002\u000f\rd\u0017.\u001a8ug*\u0011AE\u001a\u0006\u0003Or\u000ba!\u00199bG\",\u0017BA5c\u0005Q\u0011V-\\8wK\n\u0013xn[3sg>\u0003H/[8og\")1N\u0004a\u0001Y\u00061R\r\u001f9fGR,Gm\u00155pk2$7\u000b[;uI><h\u000e\u0005\u0002+[&\u0011an\u000b\u0002\b\u0005>|G.Z1o\u0003q!Xm\u001d;EK2,G/\u001a\"s_.,'/S:Tk\u000e\u001cWm]:gk2$\u0012!\u001d\t\u0003UIL!a]\u0016\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001fU\u0004\"A^?\u000e\u0003]T!\u0001_=\u0002\u0007\u0005\u0004\u0018N\u0003\u0002{w\u00069!.\u001e9ji\u0016\u0014(B\u0001?]\u0003\u0015QWO\\5u\u0013\tqxO\u0001\u0003UKN$\u0018!\n;fgR$U\r\\3uK6+H\u000e^5qY\u0016\u0014%o\\6feNL5oU;dG\u0016\u001c8OZ;mQ\t\u0001R/A\u001cuKN$H)\u001a7fi\u0016lU\u000f\u001c;ja2,'I]8lKJ\u001cx+\u001b;i\u001d>\u001c\u0006.\u001e;e_^tg\t\\1h\u0013N\u001cVoY2fgN4W\u000f\u001c\u0015\u0003#U\f\u0001\u0005^3ti\u0012+G.\u001a;f\u0005J|7.\u001a:`i\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u0012!#^\u0001\u001ai\u0016\u001cH\u000fR3tGJL'-\u001a\"s_.,'OU3n_Z\fG\u000e\u000b\u0002\u0014k\u00061D/Z:u\t\u0016\u001c8M]5cK\n\u0013xn[3s%\u0016lwN^1m\u001f:d\u0017p\u00155poN$\u0006.Z*qK\u000eLg-[3e\u0005J|7.\u001a:JI\"\u0012A#^\u0001&i\u0016\u001cH\u000fR3tGJL'-\u001a\"s_.,'OU3n_Z\fGn]#naRL(+Z:vYRD#!F;\u0002cQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Ce>\\WM\u001d*f[>4\u0018\r\\:TQ><8o\u00159fG&4\u0017.\u001a3Ce>\\WM]%eg\"\u0012a#^\u00018i\u0016\u001cH\u000fR3tGJL'-\u001a\"s_.,'OU3n_Z\fGn\u00155po:\u001cX)\u001c9us6+7o]1hK>sgj\u001c:f[>4\u0018\r\\:)\u0005])\u0018a\u0004;fgR\u0014\u0015\rZ\"p[6\fg\u000eZ:)\u0005a)\u0018a\u0006;fgRl\u0015n]:j]\u001e\u0014V-];je\u0016$\u0017I]4tQ\tIR/\u0001\u0006sk:\u001cu.\\7b]\u0012$b!a\u000b\u0002@\u0005%\u0003\u0003BA\u0017\u0003wqA!a\f\u00028A\u0019\u0011\u0011G\u0016\u000e\u0005\u0005M\"bAA\u001bO\u00051AH]8pizJ1!!\u000f,\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001*!\u0010\u000b\u0007\u0005e2\u0006C\u0004\u0002Bi\u0001\r!a\u0011\u0002\t\u0005\u0014xm\u001d\t\u0006U\u0005\u0015\u00131F\u0005\u0004\u0003\u000fZ#!B!se\u0006L\bbBA&5\u0001\u0007\u0011QJ\u0001\u0010[>\u001c7.\u00113nS:\u001cE.[3oiB\u0019\u0011-a\u0014\n\u0007\u0005E#M\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u001f\t\u0014xn[3s'V\u00147\u000f\u001e:j]\u001e$B!a\u000b\u0002X!1\u0011\u0011L\u000eA\u0002U\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u001bg\",H\u000fZ8x]N\u001b\u0007.\u001a3vY\u0016$7+\u001e2TiJLgn\u001a\u000b\u0005\u0003W\ty\u0006\u0003\u0004\u0002bq\u0001\r\u0001\\\u0001\u0012g\",H\u000fZ8x]N\u001b\u0007.\u001a3vY\u0016$\u0017AD2pk:$8+\u001e2tiJLgn\u001a\u000b\u0006k\u0005\u001d\u00141\u000e\u0005\b\u0003Sj\u0002\u0019AA\u0016\u0003\r\u0019HO\u001d\u0005\b\u0003[j\u0002\u0019AA\u0016\u0003\u0019\u0019XOY*ue\u0002")
public final class BrokerRemovalCommandTest {
    private final int brokerId_1;
    private final int brokerId_2;
    private final int startTimeMs;
    private final int lastUpdateTimeMs;
    private final String bootstrapServer;
    private final java.util.List<Integer> brokerIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)this.brokerId_1()), (List)Nil$.MODULE$)).asJava();

    public int brokerId_1() {
        return this.brokerId_1;
    }

    public int brokerId_2() {
        return this.brokerId_2;
    }

    public int startTimeMs() {
        return this.startTimeMs;
    }

    public int lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public java.util.List<Integer> brokerIds() {
        return this.brokerIds;
    }

    private ArgumentMatcher<RemoveBrokersOptions> removalOptionsArgumentMatcher(boolean expectedShouldShutdown) {
        return new ArgumentMatcher<RemoveBrokersOptions>(null, expectedShouldShutdown){
            private final boolean expectedShouldShutdown$1;

            public boolean matches(RemoveBrokersOptions options) {
                return options.shouldShutdownBrokers() == this.expectedShouldShutdown$1;
            }
            {
                this.expectedShouldShutdown$1 = expectedShouldShutdown$1;
            }
        };
    }

    @Test
    public void testDeleteBrokerIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        boolean expectedShouldShutdown = true;
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn(this.brokerIds());
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)))).thenReturn((Object)removeBrokersResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-id", Integer.toString(this.brokerId_1())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq(this.brokerIds()), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(10).append("brokers [").append(this.brokerId_1()).append("]").toString()), (String)new StringBuilder(40).append("Output should contain broker ").append(this.brokerId_1()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteMultipleBrokersIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        boolean expectedShouldShutdown = true;
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        java.util.List brokerIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId_1(), this.brokerId_2()})).map((Function1 & Serializable & scala.Serializable)x -> BrokerRemovalCommandTest.$anonfun$testDeleteMultipleBrokersIsSuccessful$1(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava();
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn((Object)brokerIds);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)))).thenReturn((Object)removeBrokersResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-ids", "0 , 1"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq((Object)brokerIds), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(12).append("brokers [").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append("]").toString()), (String)new StringBuilder(43).append("Output should contain brokers ").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        boolean expectedShouldShutdown = false;
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)))).thenReturn((Object)removeBrokersResult);
        java.util.List brokerIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId_1(), this.brokerId_2()})).map((Function1 & Serializable & scala.Serializable)x -> BrokerRemovalCommandTest.$anonfun$testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful$1(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava();
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn((Object)brokerIds);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-ids", "0 , 1", "--no-shutdown"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq((Object)brokerIds), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(12).append("brokers [").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append("]").toString()), (String)new StringBuilder(43).append("Output should contain brokers ").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteBroker_throwsException() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)deleteBrokerResult.get()).thenThrow(BrokerRemovalInProgressException.class);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.any(RemoveBrokersOptions.class))).thenReturn((Object)removeBrokersResult);
        Assertions.assertThrows(AdminCommandFailedException.class, () -> this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-id", Integer.toString(this.brokerId_1())}), admin), () -> new StringBuilder(32).append("Broker ").append(this.brokerId_1()).append(" is already being removed").toString());
    }

    @Test
    public void testDescribeBrokerRemoval() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.INSUFFICIENT_REBALANCE_PLAN_METRICS, "Cannot compute plan!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerReplicaExclusionStatus.ERROR, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerReplicaExclusionStatus.ERROR, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(33).append("Output should contain ").append(this.brokerSubstring(this.brokerId_1())).append(". Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(33).append("Output should contain ").append(this.brokerSubstring(this.brokerId_2())).append(". Output - ").append(output).toString());
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BrokerShutdownStatus.COMPLETED.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, PartitionReassignmentsStatus.IN_PROGRESS.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BrokerReplicaExclusionStatus.ERROR.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, opError.errorMessage()), (String)output);
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the correct general operation status");
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(true)), (String)"Output should contain the shutdown scheduled flag");
    }

    @Test
    public void testDescribeBrokerRemovalOnlyShowsTheSpecifiedBrokerId() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, Optional.empty(), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-id", Integer.toString(this.brokerId_1())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(22).append("Output should contain ").append(this.brokerId_1()).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(25).append("Output shouldn't contain ").append(this.brokerSubstring(this.brokerId_2())).toString());
        Assertions.assertFalse((boolean)output.contains(opError.errorMessage()), (String)"Output shouldn't contain the operation error for other brokers");
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.COMPLETED.toString()), (String)"Output should contain the shutdown sub task status");
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the general status SUCCESS");
    }

    @Test
    public void testDescribeBrokerRemovalsEmptyResult() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(new HashMap());
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-ids", "0 , 1, 2"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains("No broker removals in progress"), (String)new StringBuilder(57).append("Output should mention that no removals are in progress - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains("0, 1, 2"), (String)new StringBuilder(46).append("Output should contain broker ids 0, 1 and 2 - ").append(output).toString());
    }

    @Test
    public void testDescribeBrokerRemovalsShowsSpecifiedBrokerIds() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, Optional.empty(), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.FAILED, BrokerShutdownStatus.ERROR, PartitionReassignmentsStatus.ERROR, BrokerReplicaExclusionStatus.CANCELED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-ids", "0 , 1, 2"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(35).append("Output should contain broker id ").append(this.brokerId_1()).append(" - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(35).append("Output should contain broker id ").append(this.brokerId_2()).append(" - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(2)), (String)new StringBuilder(36).append("Output should contain broker id 2 - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains("no removal operations"), (String)new StringBuilder(72).append("Output should contain no removal operations described for broker id 2 - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(opError.errorMessage()), (String)new StringBuilder(66).append("Output should contain the operation error for specified brokers - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.COMPLETED.toString()), (String)new StringBuilder(63).append("Output should contain the shutdown sub task status COMPLETED - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(PartitionReassignmentsStatus.COMPLETED.toString()), (String)new StringBuilder(77).append("Output should contain the partition reassignment sub task status COMPLETED - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)new StringBuilder(51).append("Output should contain the general status SUCCESS - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(false)), (String)new StringBuilder(52).append("Output should contain the shutdown scheduled flag - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.ERROR.toString()), (String)new StringBuilder(59).append("Output should contain the shutdown sub task status ERROR - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(PartitionReassignmentsStatus.ERROR.toString()), (String)new StringBuilder(73).append("Output should contain the partition reassignment sub task status ERROR - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.FAILED.toString()), (String)new StringBuilder(50).append("Output should contain the general status FAILED - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(true)), (String)new StringBuilder(52).append("Output should contain the shutdown scheduled flag - ").append(output).toString());
    }

    @Test
    public void testDescribeBrokerRemovalShownsEmptyMessageOnNoremovals() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, null, (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-id", Integer.toString(this.brokerId_1())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(42).append("No broker removals in progress for broker ").append(this.brokerId_1()).toString()), (String)"Error message should be shown");
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(25).append("Output shouldn't contain ").append(this.brokerSubstring(this.brokerId_2())).toString());
    }

    @Test
    public void testBadCommands() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--not-a-command"})).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--describe"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--broker-id", "1", "--broker-ids", "1, 2, 3"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--broker-id", "1", "--broker-ids", "1, 2, 3"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--describe"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--broker-id", Integer.toString(this.brokerId_1()), "--delete"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
    }

    /*
     * WARNING - void declaration
     */
    public String runCommand(String[] args, ConfluentAdmin mockAdminClient) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> BrokerRemovalCommand$.MODULE$.run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), (Option)new Some((Object)mockAdminClient));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private String brokerSubstring(int brokerId) {
        return new StringBuilder(7).append("Broker ").append(brokerId).toString();
    }

    private String shutdownScheduledSubString(boolean shutdownScheduled) {
        return new StringBuilder(20).append("Shutdown Scheduled: ").append(shutdownScheduled).toString();
    }

    private int countSubstring(String str, String subStr) {
        return new StringOps(Predef$.MODULE$.augmentString(subStr)).r().findAllMatchIn((CharSequence)str).length();
    }

    public static final /* synthetic */ Integer $anonfun$testDeleteMultipleBrokersIsSuccessful$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public BrokerRemovalCommandTest() {
        this.brokerId_1 = 0;
        this.brokerId_2 = 1;
        this.startTimeMs = 1000101;
        this.lastUpdateTimeMs = 11313215;
        this.bootstrapServer = "localhost:9092";
    }
}

