/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.TimeUnit;
import kafka.utils.MockTime;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019\u0011\u0005\u0001)A\u0005\u007f!91\t\u0001b\u0001\n\u0013q\u0004B\u0002#\u0001A\u0003%q\bC\u0004F\u0001\t\u0007I\u0011\u0002 \t\r\u0019\u0003\u0001\u0015!\u0003@\u0011\u001d9\u0005A1A\u0005\n!Ca\u0001\u0016\u0001!\u0002\u0013I\u0005\"B+\u0001\t\u00031\u0006\"B3\u0001\t\u00031\u0006\"B4\u0001\t\u00031\u0006\"B5\u0001\t\u00031\u0006\"B6\u0001\t\u00031\u0006\"B7\u0001\t\u00031\u0006\"B8\u0001\t\u00031\u0006\"B9\u0001\t\u00031\u0006\"B:\u0001\t\u00031\u0006\"B;\u0001\t\u00031\u0006\"B<\u0001\t\u00031\u0006\"B=\u0001\t\u00031\u0006\"B>\u0001\t\u00031\u0006\"B?\u0001\t\u00031\u0006\"B@\u0001\t\u00031\u0006BBA\u0002\u0001\u0011\u0005a\u000b\u0003\u0004\u0002\b\u0001!\tA\u0016\u0005\u0007\u0003\u0017\u0001A\u0011\u0001,\t\r\u0005=\u0001\u0001\"\u0001W\u0011\u0019\t\u0019\u0002\u0001C\u0001-\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u001c\u0001\u0011%\u0011\u0011\b\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!a\u0018\u0001\t\u0013\t\t\u0007C\u0004\u0002j\u0001!I!a\u001b\u0003\u001dE+x\u000e^1Vi&d7\u000fV3ti*\u0011\u0001&K\u0001\u0006kRLGn\u001d\u0006\u0002U\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000e\t\u0003m\u0001i\u0011aJ\u0001\u0005i&lW-F\u0001:!\t1$(\u0003\u0002<O\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0006ok6\u001c\u0016-\u001c9mKN,\u0012a\u0010\t\u0003]\u0001K!!Q\u0018\u0003\u0007%sG/A\u0006ok6\u001c\u0016-\u001c9mKN\u0004\u0013aD:b[BdWmV5oI><8+Z2\u0002!M\fW\u000e\u001d7f/&tGm\\<TK\u000e\u0004\u0013!E7bqRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0006\u0011R.\u0019=UQJ|G\u000f\u001e7f)&lW-T:!\u0003)iW\r\u001e:jG:\u000bW.Z\u000b\u0002\u0013B\u0011!JU\u0007\u0002\u0017*\u0011A*T\u0001\u0007G>lWn\u001c8\u000b\u0005)r%BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001eL!aU&\u0003\u00155+GO]5d\u001d\u0006lW-A\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013a\n;fgR$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/Z#rk\u0006d7/U;pi\u0006$\u0012a\u0016\t\u0003]aK!!W\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0019m\u0003\"\u0001X2\u000e\u0003uS!AX0\u0002\u0007\u0005\u0004\u0018N\u0003\u0002aC\u00069!.\u001e9ji\u0016\u0014(B\u00012Q\u0003\u0015QWO\\5u\u0013\t!WL\u0001\u0003UKN$\u0018A\n;fgR$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/\u001a\"fY><\u0018+^8uC\"\u0012QbW\u0001'i\u0016\u001cH\u000f\u00165s_R$H.\u001a+j[\u0016|%m]3sm\u0016$'+\u0019;f\u0003\n|g/Z)v_R\f\u0007F\u0001\b\\\u00039\"Xm\u001d;C_VtG-\u001a3UQJ|G\u000f\u001e7f)&lWm\u00142tKJ4X\r\u001a*bi\u0016,\u0015/^1mgF+x\u000e^1)\u0005=Y\u0016!\f;fgR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/\u001a\"fY><\u0018+^8uC\"\u0012\u0001cW\u00018i\u0016\u001cHOQ8v]\u0012,G\r\u00165s_R$H.\u001a+j[\u0016|%m]3sm\u0016$'+\u0019;f\u0003\n|g/Z)v_R\f')\u001a7po2KW.\u001b;)\u0005EY\u0016a\u000e;fgR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/Z!c_Z,\u0017+^8uC\u0006\u0013wN^3MS6LG\u000f\u000b\u0002\u00137\u00061D/Z:u)\"\u0014x\u000e\u001e;mKRKW.\u001a+ie><8/\u0012=dKB$\u0018n\u001c8JMB\u0013xN^5eK\u0012tuN\u001c*bi\u0016lU\r\u001e:jG\"\u00121cW\u0001>i\u0016\u001cHOQ8v]\u0012,G\r\u00165s_R$H.\u001a+j[\u0016$\u0006N]8xg\u0016C8-\u001a9uS>t\u0017J\u001a)s_ZLG-\u001a3O_:\u0014\u0016\r^3NKR\u0014\u0018n\u0019\u0015\u0003)m\u000b\u0001\u0007^3tiR{7.\u001a8Ck\u000e\\W\r\u001e+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0016\u000bX/\u00197[KJ|\u0007FA\u000b\\\u0003A\"Xm\u001d;U_.,gNQ;dW\u0016$H\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3BE>4XMW3s_\"\u0012acW\u00011i\u0016\u001cH\u000fV8lK:\u0014UoY6fiRC'o\u001c;uY\u0016$\u0016.\\3PEN,'O^3e%\u0006$XMQ3m_^TVM]8)\u0005]Y\u0016a\u000e;fgR$vn[3o\u0005V\u001c7.\u001a;C_VtG-\u001a3UQJ|G\u000f\u001e7f)&lWm\u00142tKJ4X\r\u001a*bi\u0016,\u0015/^1m5\u0016\u0014x\u000e\u000b\u0002\u00197\u00069D/Z:u)>\\WM\u001c\"vG.,GOQ8v]\u0012,G\r\u00165s_R$H.\u001a+j[\u0016|%m]3sm\u0016$'+\u0019;f\u0003\n|g/\u001a.fe>D#!G.\u0002\u0003R,7\u000f\u001e+pW\u0016t')^2lKR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/\u001a\"fY><(,\u001a:p\u0005\u0016dwn\u001e'j[&$\bF\u0001\u000e\\\u0003\u0005#Xm\u001d;U_.,gNQ;dW\u0016$(i\\;oI\u0016$G\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3CK2|wOW3s_\u0006\u0013wN^3MS6LG\u000f\u000b\u0002\u001c7\u0006\tE/Z:u)>\\WM\u001c\"vG.,G\u000f\u00165s_R$H.\u001a+j[\u0016$\u0006N]8xg\u0016C8-\u001a9uS>t\u0017J\u001a)s_ZLG-\u001a3O_:\u0014\u0016\r^3NKR\u0014\u0018n\u0019\u0015\u00039m\u000b\u0001\n^3tiR{7.\u001a8Ck\u000e\\W\r\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,G\u000b\u001b:poN,\u0005pY3qi&|g.\u00134Qe>4\u0018\u000eZ3e\u001d>t'+\u0019;f\u001b\u0016$(/[2)\u0005uY\u0016\u0001\u0013;fgR$vn[3o\u0005V\u001c7.\u001a;UQJ|G\u000f\u001e7f)&lW\r\u00165s_^\u001cX\t_2faRLwN\\%g!J|g/\u001b3fI:{g\u000eV8lK:\u0014UoY6fi6+GO]5dQ\tq2,A(uKN$Hk\\6f]\n+8m[3u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.\u001a+ie><8/\u0012=dKB$\u0018n\u001c8JMB\u0013xN^5eK\u0012tuN\u001c+pW\u0016t')^2lKRlU\r\u001e:jG\"\u0012qdW\u0001\u0018cV|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0002\"a\u0007\u0002(\u0005E\u0012Q\u0007\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E&\u0002\u000f5,GO]5dg&!\u0011QEA\u0010\u0005]\tVo\u001c;b-&|G.\u0019;j_:,\u0005pY3qi&|g\u000eC\u0004\u0002*\u0001\u0002\r!a\u000b\u0002\u001b=\u00147/\u001a:wK\u00124\u0016\r\\;f!\rq\u0013QF\u0005\u0004\u0003_y#A\u0002#pk\ndW\rC\u0004\u00024\u0001\u0002\r!a\u000b\u0002\u000bE,x\u000e^1\t\u000bu\u0002\u0003\u0019A \u0002\u0019QD'o\u001c;uY\u0016$\u0016.\\3\u0015\u0011\u0005m\u0012\u0011IA\"\u0003\u000b\u00022ALA\u001f\u0013\r\tyd\f\u0002\u0005\u0019>tw\rC\u0004\u0002*\u0005\u0002\r!a\u000b\t\u000f\u0005M\u0012\u00051\u0001\u0002,!)Q(\ta\u0001\u007f\u0005\u0019\"m\\;oI\u0016$G\u000b\u001b:piRdW\rV5nKRQ\u00111HA&\u0003\u001b\ny%!\u0015\t\u000f\u0005%\"\u00051\u0001\u0002,!9\u00111\u0007\u0012A\u0002\u0005-\u0002\"B\u001f#\u0001\u0004y\u0004bBA*E\u0001\u0007\u00111H\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nK\u0006\u0011Co\\6f]\n+8m[3u#V|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0002\"a\u0007\u0002Z\u0005m\u0013Q\f\u0005\b\u0003S\u0019\u0003\u0019AA\u0016\u0011\u001d\t\u0019d\ta\u0001\u0003WAQ!P\u0012A\u0002}\nq\u0003^8lK:\u0014UoY6fiRC'o\u001c;uY\u0016$\u0016.\\3\u0015\u0011\u0005m\u00121MA3\u0003OBq!!\u000b%\u0001\u0004\tY\u0003C\u0004\u00024\u0011\u0002\r!a\u000b\t\u000bu\"\u0003\u0019A \u0002=Q|7.\u001a8Ck\u000e\\W\r\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,GCCA\u001e\u0003[\ny'!\u001d\u0002t!9\u0011\u0011F\u0013A\u0002\u0005-\u0002bBA\u001aK\u0001\u0007\u00111\u0006\u0005\u0006{\u0015\u0002\ra\u0010\u0005\b\u0003'*\u0003\u0019AA\u001e\u0001")
public class QuotaUtilsTest {
    private final MockTime time = new MockTime();
    private final int numSamples;
    private final int sampleWindowSec;
    private final int maxThrottleTimeMs;
    private final MetricName metricName = new MetricName("test-metric", "groupA", "testA", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());

    private MockTime time() {
        return this.time;
    }

    private int numSamples() {
        return this.numSamples;
    }

    private int sampleWindowSec() {
        return this.sampleWindowSec;
    }

    private int maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName metricName() {
        return this.metricName;
    }

    @Test
    public void testThrottleTimeObservedRateEqualsQuota() {
        int numSamples = 10;
        double observedValue = 16.5;
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples));
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples + 1));
    }

    @Test
    public void testThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 20.4;
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleTimeObservedRateAboveQuota() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)2000L, (long)this.throttleTime(observedValue, quota, 3));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateEqualsQuota() {
        double observedValue = 18.2;
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 22.4;
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples() + 1, this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaBelowLimit() {
        double quota = 50.0;
        double observedValue = 55.0;
        Assertions.assertEquals((long)100L, (long)this.boundedThrottleTime(observedValue, quota, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaAboveLimit() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)this.maxThrottleTimeMs(), (long)this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.throttleTime(new QuotaViolationException(testMetric, 10.0, 20.0), this.time().milliseconds()));
    }

    @Test
    public void testBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.boundedThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs(), this.time().milliseconds()));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateEqualZero() {
        int refillRate = 5;
        boolean observedValue = false;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketThrottleTime((double)observedValue, refillRate, this.numSamples()));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketThrottleTime((double)observedValue, refillRate, this.numSamples() + 1));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateAboveZero() {
        int observedValue = 3;
        int refillRate = 5;
        Assertions.assertTrue((this.tokenBucketThrottleTime(observedValue, refillRate, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.tokenBucketThrottleTime(observedValue, refillRate, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateBelowZero() {
        int refillRate = 5;
        int observedValue = -10;
        Assertions.assertEquals((long)2000L, (long)this.tokenBucketThrottleTime(observedValue, refillRate, this.numSamples()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateEqualZero() {
        int refillRate = 5;
        boolean observedValue = false;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime((double)observedValue, refillRate, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime((double)observedValue, refillRate, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateAboveZero() {
        int observedValue = 3;
        int refillRate = 5;
        Assertions.assertTrue((this.tokenBucketBoundedThrottleTime(observedValue, refillRate, this.numSamples(), this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.tokenBucketBoundedThrottleTime(observedValue, refillRate, this.numSamples() + 1, this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateBelowZeroBelowLimit() {
        int refillRate = 5;
        int observedValue = -1;
        Assertions.assertEquals((long)200L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateBelowZeroAboveLimit() {
        int refillRate = 5;
        int observedValue = -10;
        Assertions.assertEquals((long)this.maxThrottleTimeMs(), (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.tokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0)));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketThrottleTimeThrowsExceptionIfProvidedNonTokenBucketMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.tokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0)));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeThrowsExceptionIfProvidedNonTokenBucketMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs()));
    }

    private QuotaViolationException quotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long throttleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.throttleTime(e, this.time().milliseconds());
    }

    private long boundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, maxThrottleTime, this.time().milliseconds());
    }

    private QuotaViolationException tokenBucketQuotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new TokenBucket(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long tokenBucketThrottleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.tokenBucketQuotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.tokenBucketThrottleTime(e);
    }

    private long tokenBucketBoundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.tokenBucketQuotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(e, maxThrottleTime);
    }

    public QuotaUtilsTest() {
        this.numSamples = 10;
        this.sampleWindowSec = 1;
        this.maxThrottleTimeMs = 500;
    }
}

