/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import kafka.tools.NoOpMessageFormatter;
import kafka.utils.Exit$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.MockDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005\u0002IBQa\u0011\u0001\u0005\u0002IBQ\u0001\u0013\u0001\u0005\u0002IBQA\u0013\u0001\u0005\u0002IBQ\u0001\u0014\u0001\u0005\u0002IBQA\u0014\u0001\u0005\u0002IBQ\u0001\u0015\u0001\u0005\u0002IBQA\u0015\u0001\u0005\u0002IBQ\u0001\u0016\u0001\u0005\u0002IBQA\u0016\u0001\u0005\u0002IBQ\u0001\u0017\u0001\u0005\u0002IBQA\u0017\u0001\u0005\u0002IBQ\u0001\u0018\u0001\u0005\u0002IBQA\u0018\u0001\u0005\u0002IBQ\u0001\u0019\u0001\u0005\u0002IBQA\u0019\u0001\u0005\u0002IBQ\u0001\u001a\u0001\u0005\u0002IBQA\u001a\u0001\u0005\u0002IBQ\u0001\u001b\u0001\u0005\u0002IBQA\u001b\u0001\u0005\u0002IBQ\u0001\u001c\u0001\u0005\u0002IBQA\u001c\u0001\u0005\u0002IBQ\u0001\u001d\u0001\u0005\u0002IBQA\u001d\u0001\u0005\u0002IBQ\u0001\u001e\u0001\u0005\u0002IBQA\u001e\u0001\u0005\u0002IBQ\u0001\u001f\u0001\u0005\u0002IBQA\u001f\u0001\u0005\u0002IBQ\u0001 \u0001\u0005\u0002IBQA \u0001\u0005\u0002I\u00121cQ8og>dWmQ8ogVlWM\u001d+fgRT!AI\u0012\u0002\u000bQ|w\u000e\\:\u000b\u0003\u0011\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0018\u0011\u0005A\u0002Q\"A\u0011\u0002\u000bM,G/\u001e9\u0015\u0003M\u0002\"\u0001\u000b\u001b\n\u0005UJ#\u0001B+oSRD#AA\u001c\u0011\u0005a\nU\"A\u001d\u000b\u0005iZ\u0014aA1qS*\u0011A(P\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqt(A\u0003kk:LGOC\u0001A\u0003\ry'oZ\u0005\u0003\u0005f\u0012!BQ3g_J,W)Y2i\u0003=\u001a\bn\\;mIRC'o\\<US6,w.\u001e;Fq\u000e,\u0007\u000f^5p]^CWM\u001c+j[\u0016|W\u000f^%t%\u0016\f7\r[3eQ\t\u0019Q\t\u0005\u00029\r&\u0011q)\u000f\u0002\u0005)\u0016\u001cH/\u0001\u0014tQ>,H\u000e\u001a*fg\u0016$XK\\\"p]N,X.\u001a3PM\u001a\u001cX\r^:CK\u001a|'/Z#ySRD#\u0001B#\u0002CMDw.\u001e7e\u0019&l\u0017\u000e\u001e*fC\u0012\u001cHk\\'bq6+7o]1hK2KW.\u001b;)\u0005\u0015)\u0015aI:i_VdGm\u0015;pa^CWM\\(viB,Ho\u00115fG.,%O]8s\r\u0006LGn\u001d\u0015\u0003\r\u0015\u000b1e\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3D_:\u001cX/\\3s-\u0006d\u0017\u000eZ\"p]\u001aLw\r\u000b\u0002\b\u000b\u0006Q2\u000f[8vY\u0012\u0004\u0016M]:f\u0013:\u001cG.\u001e3f\u0003J<W/\\3oi\"\u0012\u0001\"R\u0001\u001dg\"|W\u000f\u001c3QCJ\u001cXm\u00165ji\u0016d\u0017n\u001d;Be\u001e,X.\u001a8uQ\tIQ)A\u0018tQ>,H\u000eZ%h]>\u0014Xm\u00165ji\u0016d\u0017n\u001d;Be\u001e,X.\u001a8u\u0013\u001aLen\u00197vI\u0016\u001c\u0006/Z2jM&,G\r\u000b\u0002\u000b\u000b\u0006Q4\u000f[8vY\u0012\u0004\u0016M]:f-\u0006d\u0017\u000eZ*j[BdWmQ8ogVlWM\u001d,bY&$7i\u001c8gS\u001e<\u0016\u000e\u001e5Ok6,'/[2PM\u001a\u001cX\r\u001e\u0015\u0003\u0017\u0015\u000b\u0011f\u001d5pk2$W\t_5u\u001f:,fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>t\u0007F\u0001\u0007F\u0003e\u001a\bn\\;mIB\u000b'o]3WC2LGmU5na2,7i\u001c8tk6,'OV1mS\u0012\u001cuN\u001c4jO^KG\u000f[*ue&twm\u00144gg\u0016$\bFA\u0007F\u0003]\u001a\bn\\;mIB\u000b'o]3WC2LGmQ8ogVlWM]\"p]\u001aLwmV5uQ\u0006+Ho\\(gMN,GOU3tKRd\u0015\r^3ti\"\u0012a\"R\u0001:g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5BkR|wJ\u001a4tKR\u0014Vm]3u\u000b\u0006\u0014H.[3ti\"\u0012q\"R\u0001Jg\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5BkR|wJ\u001a4tKR\u0014Vm]3u\u0003:$W*\u0019;dQ&twM\u0012:p[\n+w-\u001b8oS:<\u0007F\u0001\tF\u0003=\u001a\bn\\;mIB\u000b'o]3WC2LGmQ8ogVlWM]\"p]\u001aLwmV5uQ:{wJ\u001a4tKR\u0014Vm]3uQ\t\tR)A$tQ>,H\u000eZ#ySR|e.\u00138wC2LGmQ8oM&<w+\u001b;i\u0003V$xn\u00144gg\u0016$(+Z:fi\u0006sGmQ8oM2L7\r^5oO\u001a\u0013x.\u001c\"fO&tg.\u001b8hQ\t\u0011R)\u0001\u000etQ>,H\u000e\u001a)beN,7i\u001c8gS\u001e\u001chI]8n\r&dW\r\u000b\u0002\u0014\u000b\u0006QsM]8va&#7\u000f\u0015:pm&$W\rZ%o\t&4g-\u001a:f]R\u0004F.Y2fg6+8\u000f^'bi\u000eD\u0007F\u0001\u000bF\u0003E\"Xm\u001d;DkN$x.\u001c)s_B,'\u000f^=TQ>,H\u000e\u001a\"f!\u0006\u001c8/\u001a3U_\u000e{gNZ5hkJ,W*\u001a;i_\u0012D#!F#\u0002YMDw.\u001e7e!\u0006\u00148/Z$s_V\u0004\u0018\n\u001a$s_6\u0014UmZ5o]&twmR5wK:$vnZ3uQ\u0016\u0014\bF\u0001\fF\u00031\u001a\bn\\;mI\u0016C\u0018\u000e^(o\u000fJ|W\u000f]%e\u0003:$\u0007+\u0019:uSRLwN\\$jm\u0016tGk\\4fi\",'\u000f\u000b\u0002\u0018\u000b\u0006\u00113\u000f[8vY\u0012,\u00050\u001b;P]>3gm]3u/&$\bn\\;u!\u0006\u0014H/\u001b;j_:D#\u0001G#\u00027Q,7\u000f\u001e#fM\u0006,H\u000e^'fgN\fw-\u001a$pe6\fG\u000f^3sQ\tIR)\u0001\ruKN$hj\\(q\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;uKJD#AG#\u0002IMDw.\u001e7e\u000bbLG/\u00134O_R{\u0007/[2Pe\u001aKG\u000e^3s'B,7-\u001b4jK\u0012D#aG#\u0002IMDw.\u001e7e\u000bbLG/\u00134U_BL7-\u00118e\u0013:\u001cG.\u001e3f'B,7-\u001b4jK\u0012D#\u0001H#\u0002MMDw.\u001e7e\u000bbLG/\u00134U_BL7-\u00118e/\"LG/\u001a7jgR\u001c\u0006/Z2jM&,G\r\u000b\u0002\u001e\u000b\u0006!B/Z:u\u00072LWM\u001c;JI>3XM\u001d:jI\u0016D#AH#\u0002'Q,7\u000f\u001e#fM\u0006,H\u000e^\"mS\u0016tG/\u00133)\u0005})\u0005")
public class ConsoleConsumerTest {
    @BeforeEach
    public void setup() {
        ConsoleConsumer$.MODULE$.messageCount_$eq(0);
    }

    @Test
    public void shouldThrowTimeoutExceptionWhenTimeoutIsReached() {
        String topic = "test";
        MockTime time = new MockTime();
        int timeoutMs = 1000;
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)mockConsumer.poll(Duration.ofMillis(timeoutMs))).thenAnswer(x$1 -> {
            time.sleep(timeoutMs / 2 + 1);
            return ConsumerRecords.EMPTY;
        });
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, mockConsumer, (long)timeoutMs, (Time)time);
        Assertions.assertThrows(TimeoutException.class, () -> consumer.receive());
    }

    @Test
    public void shouldResetUnConsumedOffsetsBeforeExit() {
        String topic = "test";
        int maxMessages = 123;
        int totalMessages = 700;
        Long startOffset = Predef$.MODULE$.long2Long(0L);
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Consumer)mockConsumer, ConsoleConsumer.ConsumerWrapper$.MODULE$.$lessinit$greater$default$6(), ConsoleConsumer.ConsumerWrapper$.MODULE$.$lessinit$greater$default$7());
        mockConsumer.rebalance((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        mockConsumer.updateBeginningOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)startOffset), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)startOffset)}))).asJava());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> mockConsumer.addRecord(new ConsumerRecord(topic, i % 2, (long)(i / 2), (Object)"key".getBytes(), (Object)"value".getBytes())));
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(maxMessages), formatter, consumer, System.out, false);
        Assertions.assertEquals((long)totalMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        consumer.resetUnconsumedOffsets();
        Assertions.assertEquals((long)maxMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)maxMessages))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
    }

    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)messageLimit))).receive();
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)messageLimit))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        consumer.cleanup();
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((PrintStream)Mockito.verify((Object)printStream)).checkError();
        consumer.cleanup();
    }

    @Test
    public void shouldParseValidConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseIncludeArgument() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--include", "includeTest*", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"includeTest*", (Object)config.includedTopicsArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseWhitelistArgument() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--whitelist", "whitelistTest*", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"whitelistTest*", (Object)config.includedTopicsArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldIgnoreWhitelistArgumentIfIncludeSpecified() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--include", "includeTest*", "--whitelist", "whitelistTest*", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"includeTest*", (Object)config.includedTopicsArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assertions.assertEquals((long)3L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$2, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(BoxesRunTime.unboxToInt((Object)x$2), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithStringOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--property", "print.value=false"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((DefaultMessageFormatter)config.formatter()).printValue()));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithNoOffsetReset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$3, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(BoxesRunTime.unboxToInt((Object)x$3), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"});
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            Assertions.assertThrows(IllegalArgumentException.class, () -> ConsoleConsumer$.MODULE$.consumerProps(config));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("request.timeout.ms=1000\n".getBytes());
        propsStream.write("group.id=group1".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
        Assertions.assertEquals((Object)"group1", (Object)config.consumerProps().getProperty("group.id"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$4, message) -> ConsoleConsumerTest.$anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(BoxesRunTime.unboxToInt((Object)x$4), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        ObjectRef args = ObjectRef.create((Object)((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()})));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=test-group".getBytes());
        propsStream.close();
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig((String[])args.elem);
        Properties props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig((String[])args$2.elem));
        args.elem = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"});
        config = new ConsoleConsumer.ConsumerConfig((String[])args.elem);
        props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testCustomPropertyShouldBePassedToConfigureMethod() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--property", "key.deserializer.my-props=abc"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertTrue((boolean)(config.formatter() instanceof DefaultMessageFormatter));
        Assertions.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assertions.assertTrue((boolean)(formatter.keyDeserializer().get() instanceof MockDeserializer));
        Assertions.assertEquals((int)1, (int)((MockDeserializer)formatter.keyDeserializer().get()).configs.size());
        Assertions.assertEquals((Object)"abc", ((MockDeserializer)formatter.keyDeserializer().get()).configs.get("my-props"));
        Assertions.assertTrue((boolean)((MockDeserializer)formatter.keyDeserializer().get()).isKey);
    }

    @Test
    public void shouldParseGroupIdFromBeginningGivenTogether() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((long)-2L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group"});
        config = new ConsoleConsumer.ConsumerConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnGroupIdAndPartitionGivenTogether() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$5, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(BoxesRunTime.unboxToInt((Object)x$5), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--partition", "0"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitOnOffsetWithoutPartition() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$6, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnOffsetWithoutPartition$1(BoxesRunTime.unboxToInt((Object)x$6), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--offset", "10"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testDefaultMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        DefaultMessageFormatter formatter = new DefaultMessageFormatter();
        HashMap<String, String> configs = new HashMap<String, String>();
        formatter.configure(configs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"value\n", (Object)out.toString());
        configs.put("print.key", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"key\tvalue\n", (Object)out.toString());
        configs.put("print.partition", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"Partition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.timestamp", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.offset", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        out = new ByteArrayOutputStream();
        ConsumerRecord record2 = new ConsumerRecord("topic", 0, 123L, 123L, TimestampType.CREATE_TIME, -1, -1, (Object)"key".getBytes(), (Object)"value".getBytes(), (Headers)new RecordHeaders(), Optional.empty());
        formatter.writeTo(record2, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        formatter.close();
    }

    @Test
    public void testNoOpMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        NoOpMessageFormatter formatter = new NoOpMessageFormatter();
        formatter.configure(new HashMap());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"", (Object)out.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitIfNoTopicOrFilterSpecified() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$7, message) -> ConsoleConsumerTest.$anonfun$shouldExitIfNoTopicOrFilterSpecified$1(BoxesRunTime.unboxToInt((Object)x$7), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitIfTopicAndIncludeSpecified() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$8, message) -> ConsoleConsumerTest.$anonfun$shouldExitIfTopicAndIncludeSpecified$1(BoxesRunTime.unboxToInt((Object)x$8), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--include", "includeTest*"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldExitIfTopicAndWhitelistSpecified() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$9, message) -> ConsoleConsumerTest.$anonfun$shouldExitIfTopicAndWhitelistSpecified$1(BoxesRunTime.unboxToInt((Object)x$9), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--whitelist", "whitelistTest*"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumer.ConsumerConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testClientIdOverride() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--consumer-property", "client.id=consumer-1"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"consumer-1", (Object)consumerProperties.getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assertions.assertEquals((Object)"console-consumer", (Object)consumerProperties.getProperty("client.id"));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(int x$2, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(int x$3, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(int x$4, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(int x$5, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnOffsetWithoutPartition$1(int x$6, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitIfNoTopicOrFilterSpecified$1(int x$7, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitIfTopicAndIncludeSpecified$1(int x$8, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitIfTopicAndWhitelistSpecified$1(int x$9, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

