/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001\u0002\u000b\u0016\u0001qAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005B!Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004=\u0001\u0001\u0006I!\r\u0005\b{\u0001\u0011\r\u0011\"\u00011\u0011\u0019q\u0004\u0001)A\u0005c!9q\b\u0001b\u0001\n\u0003\u0001\u0005B\u0002%\u0001A\u0003%\u0011\tC\u0004J\u0001\t\u0007I\u0011\u0001&\t\rE\u0003\u0001\u0015!\u0003L\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015A\u0007\u0001\"\u0001[\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u0015\t\b\u0001\"\u0003s\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0005\u0002L\u0001\t\n\u0011\"\u0003\u0002N!9\u00111\r\u0001\u0005\n\u0005\u0015$!\b+jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:|eM\u001a7j]\u0016$Vm\u001d;\u000b\u0005Y9\u0012!\u0002;pa&\u001c'B\u0001\r\u001a\u0003\u0011!\u0018.\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\u0011\u0001%G\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\tz\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005)\u0012a\u00032s_.,'oQ8v]R,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0004\u0013:$\u0018A\u0002;pa&\u001c\u0017'F\u00012!\t\u0011\u0014H\u0004\u00024oA\u0011AgK\u0007\u0002k)\u0011agG\u0001\u0007yI|w\u000e\u001e \n\u0005aZ\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0016\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\u0005uS\u0016\u0014Hk\u001c9jGV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!AO\"\u0002\u0015QLWM\u001d+pa&\u001c\u0007%A\u0003qe>\u00048/F\u0001L!\tau*D\u0001N\u0015\tqU)\u0001\u0003vi&d\u0017B\u0001)N\u0005)\u0001&o\u001c9feRLWm]\u0001\u0007aJ|\u0007o\u001d\u0011\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001+X!\tQS+\u0003\u0002WW\t!QK\\5u\u0011\u0015A6\u00021\u0001L\u0003)\u0001(o\u001c9feRLWm]\u0001\u000faJ,\u0007/\u0019:f\r>\u0014H+Z:u)\u0005!\u0006F\u0001\u0007]!\tif-D\u0001_\u0015\ty\u0006-A\u0002ba&T!!\u00192\u0002\u000f),\b/\u001b;fe*\u00111\rZ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001dt&A\u0003\"fM>\u0014X-R1dQ\u00061C/Z:u\u0003J\u001c\u0007.\u001b<fe^CWM\u001c+jKJ\u0004\u0016M\u001d;ji&|g.S:PM\u001ad\u0017N\\3)\u00055Q\u0007CA/l\u0013\tagL\u0001\u0003UKN$\u0018\u0001\u0007<fe&4\u00170T1uKJL\u0017\r\\5{CRLwN\u001c'bOR\u0011Ak\u001c\u0005\u0006a:\u0001\r!K\u0001\tEJ|7.\u001a:JI\u000692M]3bi\u0016\u001cVmY8oIRKWM]3e)>\u0004\u0018n\u0019\u000b\u0007g~\f\t\"!\u0006\u0011\t)\"\u0018F^\u0005\u0003k.\u0012a\u0001V;qY\u0016\u0014\u0004CA<~\u001b\u0005A(BA={\u0003\u0019\u0019w.\\7p]*\u0011!d\u001f\u0006\u0003y\u0012\fa!\u00199bG\",\u0017B\u0001@y\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!\u0001\u0010\u0001\u0004\t\u0019!A\u0003bI6Lg\u000e\u0005\u0003\u0002\u0006\u00055QBAA\u0004\u0015\u0011\t\t!!\u0003\u000b\u0007\u0005-!0A\u0004dY&,g\u000e^:\n\t\u0005=\u0011q\u0001\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\u0007\u0003'y\u0001\u0019A\u0015\u0002+\u0015D\b/Z2uK\u0012$\u0016.\u001a:QCJ$\u0018\u000e^5p]\"9\u0011qC\bA\u0002\u0005e\u0011AC1tg&<g.\\3oiB)\u00111DA\u0013S9!\u0011QDA\u0011\u001d\r!\u0014qD\u0005\u0002Y%\u0019\u00111E\u0016\u0002\u000fA\f7m[1hK&!\u0011qEA\u0015\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r2&A\u000bhKR$\u0016.\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0015\u0007%\ny\u0003C\u0004\u00022A\u0001\r!a\r\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA\u001b\u0003oi\u0011aF\u0005\u0004\u0003s9\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003m\t\u0007\u000f]3oI6+7o]1hKN\fe\u000e\u001a,fe&4\u0017\u0010V5feR9A+a\u0010\u0002D\u0005\u001d\u0003BBA!#\u0001\u0007\u0011&\u0001\u0005mK\u0006$WM]%e\u0011\u0019\t)%\u0005a\u0001m\u0006\u0011A\u000f\u001d\u0005\t\u0003\u0013\n\u0002\u0013!a\u0001S\u0005Ya.^7TK\u001elWM\u001c;t\u0003\u0015\n\u0007\u000f]3oI6+7o]1hKN\fe\u000e\u001a,fe&4\u0017\u0010V5fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002P)\u001a\u0011&!\u0015,\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0018,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\n9FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQC]3bgNLwM\u001c+jKJ\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002h\u0005%\u0004C\u0002\u0016u\u00033\tI\u0002C\u0004\u0002\u0002M\u0001\r!a\u0001")
public class TierTopicPartitionOfflineTest
extends BaseRequestTest {
    private final String topic1;
    private final String topic2;
    private final String tierTopic;
    private final Properties props = new Properties();

    @Override
    public int brokerCount() {
        return 6;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String tierTopic() {
        return this.tierTopic;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    @BeforeEach
    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.bytes", "1");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverWhenTierPartitionIsOffline() {
        void var4_4;
        void var12_12;
        void var11_11;
        void var3_3;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        ConfluentAdmin admin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        Tuple2<List<Object>, List<Object>> tuple2 = this.reassignTierPartition((Admin)admin);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List replicasTierStatePartition0 = (List)tuple2._1();
        List replicasTierStatePartition1 = (List)tuple2._2();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        int leader1 = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)var3_3)}))), this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        AbstractLog log1 = (AbstractLog)((KafkaServer)this.serverForId(leader1).get()).replicaManager().getLog(tp1).get();
        int tierStatePartitionForTopic1 = this.getTierTopicPartition((TopicIdPartition)log1.topicIdPartition().get());
        int tierStatePartitionForTopic2 = tierStatePartitionForTopic1 == 0 ? 1 : 0;
        Tuple2<Object, TopicPartition> tuple22 = this.createSecondTieredTopic((Admin)admin, tierStatePartitionForTopic2, (List<Object>)var3_3);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        TopicPartition tp2 = (TopicPartition)tuple22._2();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$1(log1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$2(tp1, leader1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AbstractLog log2 = (AbstractLog)((KafkaServer)this.serverForId((int)var11_11).get()).replicaManager().getLog((TopicPartition)var12_12).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$3(log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$4((TopicPartition)var12_12, (int)var11_11));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        var4_4.foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$5(this, (List)var3_3, arg_0)));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "tier topic partition 1 is now offline");
        if (tierStatePartitionForTopic1 == 0) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), tp1.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), var12_12.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            this.verifyMaterializationLag((int)var11_11);
            this.appendMessagesAndVerifyTier(leader1, tp1, this.appendMessagesAndVerifyTier$default$3());
            return;
        }
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), tp1.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), var12_12.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        this.verifyMaterializationLag(leader1);
        this.appendMessagesAndVerifyTier((int)var11_11, (TopicPartition)var12_12, this.appendMessagesAndVerifyTier$default$3());
    }

    private void verifyMaterializationLag(int brokerId) {
        MetricName maxListeningMs = ((TierTopicConsumer)((KafkaServer)this.serverForId((int)brokerId).get()).replicaManager().tierReplicaComponents().logComponents().topicConsumerOpt().get()).maxListeningMsMetricName;
        DoubleRef curr = DoubleRef.create((double)0.0);
        DoubleRef prev = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
            Thread.sleep(5000L);
            prev$1.elem = curr$1.elem;
            curr$1.elem = BoxesRunTime.unboxToDouble((Object)((KafkaServer)this.serverForId(brokerId).get()).metrics().metric(maxListeningMs).metricValue());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("curr: ").append(curr$1.elem).append(" prev ").append(prev$1.elem).toString());
            Predef$.MODULE$.assert(curr$1.elem >= prev$1.elem);
        });
    }

    private Tuple2<Object, TopicPartition> createSecondTieredTopic(Admin admin, int expectedTierPartition, List<Object> assignment) {
        boolean done = false;
        int idx = -1;
        int leader = 0;
        ObjectRef name = ObjectRef.create((Object)"");
        while (!done) {
            name.elem = new StringBuilder(1).append(this.topic2()).append("-").append(Integer.toString(++idx)).toString();
            leader = BoxesRunTime.unboxToInt((Object)this.createTopic((String)name.elem, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), assignment)}))), this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            AbstractLog log = (AbstractLog)((KafkaServer)this.serverForId(leader).get()).replicaManager().getLog(new TopicPartition((String)name.elem, 0)).get();
            int toTierPart = this.getTierTopicPartition((TopicIdPartition)log.topicIdPartition().get());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Created TopicPartition ").append((String)name$1.elem).append(" that will append metadata to tier partition ").append(toTierPart).append(". Expected tier partition: ").append(expectedTierPartition).toString());
            if (toTierPart != expectedTierPartition) {
                admin.deleteTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)((String)name.elem), (List)Nil$.MODULE$)).asJavaCollection()).all().get(500L, TimeUnit.MILLISECONDS);
                continue;
            }
            done = true;
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)leader), (Object)new TopicPartition((String)name.elem, 0));
    }

    private int getTierTopicPartition(TopicIdPartition topicIdPartition) {
        return new TierTopicPartitioner(2).partitionId(topicIdPartition);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMessagesAndVerifyTier(int leaderId, TopicPartition tp, int numSegments) {
        AbstractLog log = (AbstractLog)((KafkaServer)this.serverForId(leaderId).get()).replicaManager().getLog(tp).get();
        int numMessages = 50;
        IntRef totalMessages = IntRef.create((int)0);
        long oldLogEndOffset = log.logEndOffset();
        int initTotalSegments = log.numberOfSegments();
        while (log.numberOfSegments() <= initTotalSegments + numSegments) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), tp.topic(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages.elem += numMessages;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 90000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$appendMessagesAndVerifyTier$1(log, oldLogEndOffset, totalMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$appendMessagesAndVerifyTier$2(tp, leaderId, oldLogEndOffset, log, initTotalSegments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private int appendMessagesAndVerifyTier$default$3() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<List<Object>, List<Object>> reassignTierPartition(Admin admin) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$1(this, admin)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.Map tierTopicDesc = (java.util.Map)admin.describeTopics(Collections.singletonList(this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
        List replicasForTierStatePartition0 = (List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)tierTopicDesc.get(this.tierTopic())).partitions().get(0)).replicas()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()), List$.MODULE$.canBuildFrom());
        ListBuffer replicasForTierStatePartition1 = (ListBuffer)new ListBuffer().$plus$plus((GenTraversableOnce)((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToInteger((int)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$4(server)), Buffer$.MODULE$.canBuildFrom())).toList().filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)id -> replicasForTierStatePartition0.contains((Object)BoxesRunTime.boxToInteger((int)id))));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("replicasForTierStatePartition0 ").append(replicasForTierStatePartition0).append(" replicasForTierStatePartition1 ").append(replicasForTierStatePartition1).toString());
        TopicPartition tierPartition1 = new TopicPartition(this.tierTopic(), 1);
        java.util.Map reassignments = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierPartition1), Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicasForTierStatePartition1.toList().map((Function1 & Serializable & scala.Serializable)id -> TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$7(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom())).asJava())))}))).asJava();
        admin.alterPartitionReassignments(reassignments).all().get(500L, TimeUnit.MILLISECONDS);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$8(admin)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$10(this, admin, replicasForTierStatePartition1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return new Tuple2((Object)replicasForTierStatePartition0, (Object)replicasForTierStatePartition1.toList());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverWhenTierPartitionIsOffline$1(AbstractLog log1$1) {
        TierPartitionStatus tierPartitionStatus = log1$1.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testArchiverWhenTierPartitionIsOffline$2(TopicPartition tp1$1, int leader1$1) {
        return new StringBuilder(62).append("Timeout waiting for tier partition status of ").append(tp1$1).append(" to be ONLINE on ").append(leader1$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverWhenTierPartitionIsOffline$3(AbstractLog log2$1) {
        TierPartitionStatus tierPartitionStatus = log2$1.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testArchiverWhenTierPartitionIsOffline$4(TopicPartition tp2$1, int leader2$1) {
        return new StringBuilder(62).append("Timeout waiting for tier partition status of ").append(tp2$1).append(" to be ONLINE on ").append(leader2$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testArchiverWhenTierPartitionIsOffline$5(TierTopicPartitionOfflineTest $this, List replicasTierStatePartition0$1, int id) {
        if (!replicasTierStatePartition0$1.contains((Object)BoxesRunTime.boxToInteger((int)id))) {
            ((KafkaServer)$this.serverForId(id).get()).shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndVerifyTier$1(AbstractLog log$1, long oldLogEndOffset$1, IntRef totalMessages$1) {
        return log$1.logEndOffset() == oldLogEndOffset$1 + (long)totalMessages$1.elem && log$1.tierPartitionState().numSegments() >= log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndVerifyTier$2(TopicPartition tp$1, int leaderId$1, long oldLogEndOffset$1, AbstractLog log$1, int initTotalSegments$1) {
        return new StringBuilder(177).append("Timeout waiting for all messages to be written and tiered for ").append(tp$1).append(". LeaderId=").append(leaderId$1).append(", old logEndOffset: ").append(oldLogEndOffset$1).append(", new logEndOffset: ").append(log$1.logEndOffset()).append(", ").append("old numOfSegments: ").append(initTotalSegments$1).append(", new numOfSegments: ").append(log$1.numberOfSegments()).append(", tiered numSegments: ").append(log$1.tierPartitionState().numSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$1(TierTopicPartitionOfflineTest $this, Admin admin$1) {
        try {
            admin$1.describeTopics(Collections.singletonList($this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$2() {
        return "Tier topic was not created within timeout";
    }

    public static final /* synthetic */ int $anonfun$reassignTierPartition$4(KafkaServer server) {
        return server.config().brokerId();
    }

    public static final /* synthetic */ Integer $anonfun$reassignTierPartition$7(int id) {
        return BoxesRunTime.boxToInteger((int)id);
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$8(Admin admin$1) {
        return ((java.util.Map)admin$1.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$9() {
        return "Timed out waiting for reassignment to complete";
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$10(TierTopicPartitionOfflineTest $this, Admin admin$1, ListBuffer replicasForTierStatePartition1$1) {
        java.util.Map tierTopicDesc = (java.util.Map)admin$1.describeTopics(Collections.singletonList($this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
        List list = replicasForTierStatePartition1$1.toList();
        Object object = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)tierTopicDesc.get($this.tierTopic())).partitions().get(1)).replicas()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()), List$.MODULE$.canBuildFrom());
        return !(list != null ? !list.equals(object) : object != null);
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$12() {
        return "Unexpected assignment";
    }

    public TierTopicPartitionOfflineTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
        this.tierTopic = "_confluent-tier-state";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataMaxPollMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierArchiverNumThreadsProp(), "1");
    }
}

