/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.server.InternalAdmin;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001\u0002\u001e<\u0001\tCQ!\u0013\u0001\u0005\u0002)+A!\u0014\u0001\u0001\u001d\u0016!!\f\u0001\u0001\\\u0011\u001dq\u0006A1A\u0005\n}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B6\t\u000fI\u0004!\u0019!C\u0005?\"11\u000f\u0001Q\u0001\n\u0001Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004}\u0001\u0001\u0006IA\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\tY\u0001\u0001Q\u0001\n}D\u0011\"!\u0004\u0001\u0005\u0004%I!a\u0004\t\u0011\u0005]\u0001\u0001)A\u0005\u0003#A\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A\u0001\"!\n\u0001\u0005\u0004%Ia\u0018\u0005\b\u0003O\u0001\u0001\u0015!\u0003a\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\u0017\u0011%\tY\u0005\u0001b\u0001\n\u0013\ti\u0005C\u0004\u0002P\u0001\u0001\u000b\u0011B.\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0003bBA+\u0001\u0001\u0006IA\u0014\u0005\n\u0003/\u0002!\u0019!C\u0005\u0003'Bq!!\u0017\u0001A\u0003%a\nC\u0005\u0002\\\u0001\u0011\r\u0011\"\u0003\u0002^!A\u00111\u000e\u0001!\u0002\u0013\ty\u0006C\u0005\u0002n\u0001\u0001\r\u0011\"\u0003\u0002p!I\u0011q\u0010\u0001A\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002r!I\u0011q\u0012\u0001C\u0002\u0013%\u0011\u0011\u0013\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u0014\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAV\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003[\u0003A\u0011AAR\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!!3\u0001\t\u0003\t\t\fC\u0004\u0002T\u0002!\t!!-\t\u000f\u0005]\u0007\u0001\"\u0001\u00022\"9\u00111\u001c\u0001\u0005\u0002\u0005E\u0006bBAp\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003G\u0004A\u0011AAY\u0011\u001d\t9\u000f\u0001C\u0001\u0003cCq!a;\u0001\t\u0003\t\t\fC\u0004\u0002p\u0002!\t!!-\t\u000f\u0005M\b\u0001\"\u0001\u00022\"9\u0011q\u001f\u0001\u0005\u0002\u0005E\u0006bBA~\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003\u007f\u0004A\u0011AAY\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqA!\b\u0001\t\u0013\u0011y\u0002C\u0005\u0003:\u0001\t\n\u0011\"\u0003\u0003<!9!\u0011\u000b\u0001\u0005\n\u0005E\u0006b\u0002B*\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0005+\u0002A\u0011\u0002B,\u0005Q!\u0016.\u001a:U_BL7-T1oC\u001e,'\u000fV3ti*\u0011A(P\u0001\u0006i>\u0004\u0018n\u0019\u0006\u0003}}\nA\u0001^5fe*\t\u0001)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017B\u0011A\nA\u0007\u0002w\t\u00012i\u001c8tk6,'oU;qa2LWM\u001d\t\u0005\u001fJ#F+D\u0001Q\u0015\t\tV(\u0001\u0004dY&,g\u000e^\u0005\u0003'B\u0013A#T8dW\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\bc\u0001#V/&\u0011a+\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\tbK!!W#\u0003\t\tKH/\u001a\u0002\u0011!J|G-^2feN+\b\u000f\u001d7jKJ\u0004Ba\u0014/U)&\u0011Q\f\u0015\u0002\u0015\u001b>\u001c7\u000e\u0015:pIV\u001cWM]*vaBd\u0017.\u001a:\u0002\u0013\rdWo\u001d;fe&#W#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001\u00027b]\u001eT\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n11\u000b\u001e:j]\u001e\f!b\u00197vgR,'/\u00133!\u0003\u001d!X-\u001c9ESJ,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0012\f!![8\n\u0005Al'\u0001\u0002$jY\u0016\f\u0001\u0002^3na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u001cX#\u0001<\u0011\u0007]T\b-D\u0001y\u0015\tIH-\u0001\u0003vi&d\u0017BA>y\u0005%\t%O]1z\u0019&\u001cH/\u0001\u0005m_\u001e$\u0015N]:!\u0003A!\u0018.\u001a:Ti\u0006$XMR3uG\",'/F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003{\u00059a-\u001a;dQ\u0016\u0014\u0018\u0002BA\u0005\u0003\u0007\u0011\u0001\u0003V5feN#\u0018\r^3GKR\u001c\u0007.\u001a:\u0002#QLWM]*uCR,g)\u001a;dQ\u0016\u0014\b%\u0001\fuS\u0016\u0014Hk\u001c9jG:+X\u000eU1si&$\u0018n\u001c8t+\t\t\t\u0002E\u0002E\u0003'I1!!\u0006F\u0005\u0015\u0019\u0006n\u001c:u\u0003]!\u0018.\u001a:U_BL7MT;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\fuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h+\t\ti\u0002E\u0002M\u0003?I1!!\t<\u0005Y!\u0016.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0017a\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4!\u00035!\u0018.\u001a:U_BL7MT1nK\u0006qA/[3s)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013a\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA\u0017!\u00159\u0018qFA\u001a\u0013\r\t\t\u0004\u001f\u0002\u0004'\u0016$\b\u0003BA\u001b\u0003\u000bj!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0007G>lWn\u001c8\u000b\u0007\u0001\u000biD\u0003\u0003\u0002@\u0005\u0005\u0013AB1qC\u000eDWM\u0003\u0002\u0002D\u0005\u0019qN]4\n\t\u0005\u001d\u0013q\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003Q!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8tA\u0005\u0001\u0002O]8ek\u000e,'oU;qa2LWM]\u000b\u00027\u0006\t\u0002O]8ek\u000e,'oU;qa2LWM\u001d\u0011\u0002/A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014X#\u0001(\u00021A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\fdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006A2-\u0019;dQV\u00048i\u001c8tk6,'oU;qa2LWM\u001d\u0011\u0002\u001b%tG/\u001a:oC2\fE-\\5o+\t\ty\u0006\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)gP\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005%\u00141\r\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u0002\u001d%tG/\u001a:oC2\fE-\\5oA\u00059B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dWm]\u000b\u0003\u0003c\u0002B\u0001R+\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002zu\nQa\u001d;bi\u0016LA!! \u0002x\t1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-A\u000euS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)\u001b7fg~#S-\u001d\u000b\u0005\u0003\u0007\u000bI\tE\u0002E\u0003\u000bK1!a\"F\u0005\u0011)f.\u001b;\t\u0013\u0005-u$!AA\u0002\u0005E\u0014a\u0001=%c\u0005AB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dWm\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003'\u0003B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033{\u0014!B;uS2\u001c\u0018\u0002BAO\u0003/\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0010G\",7m[:v[\u0016s\u0017M\u00197fIV\u0011\u0011Q\u0015\t\u0004\t\u0006\u001d\u0016bAAU\u000b\n9!i\\8mK\u0006t\u0017AD2p[B\f7\r^#oC\ndW\rZ\u0001\u000fG2,\u0017M\\;q\u000b:\f'\r\\3e\u0003!!X-\u0019:e_^tGCAABQ\r1\u0013Q\u0017\t\u0005\u0003o\u000b)-\u0004\u0002\u0002:*!\u00111XA_\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u007f\u000b\t-A\u0004kkBLG/\u001a:\u000b\t\u0005\r\u0017\u0011I\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u000f\fILA\u0005BMR,'/R1dQ\u0006QB/Z:u\u0003\u0012$W*\u001a;bI\u0006$\u0018MQ3g_J,'+Z1es\"\u001aq%!4\u0011\t\u0005]\u0016qZ\u0005\u0005\u0003#\fIL\u0001\u0003UKN$\u0018a\b;fgR$U\u000f\u001d7jG\u0006$XMU3rk\u0016\u001cHOQ3g_J,'+Z1es\"\u001a\u0001&!4\u0002]Q,7\u000f\u001e*fiJLxJ\\+oW:|wO\\#yG\u0016\u0004H/[8o\tV\u0014\u0018N\\4U_BL7m\u0011:fCRLwN\u001c\u0015\u0004S\u00055\u0017a\t;fgR\u0004\u0016M\u001d;ji&|g.\u001a:TKR,\bo\u00165f]R{\u0007/[2Fq&\u001cHo\u001d\u0015\u0004U\u00055\u0017a\u0005;fgR\u0014V\r\u001e:jK\u0012lUm]:bO\u0016\u001c\bfA\u0016\u0002N\u0006QD/Z:u\r\u0016t7-\u001b8h-&\f\u0007+\u0019:uSRLwN\u001c$f]\u000e,WI^3oi>sW)\u001c9usRKWM\u001d)beRLG/[8o'R\fG/\u001a\u0015\u0004Y\u00055\u0017!\u0010;fgR4UM\\2j]\u001e4\u0016.\u0019)beRLG/[8o\r\u0016t7-Z#wK:$xJ\u001c(p]\u0016k\u0007\u000f^=US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0007fA\u0017\u0002N\u00061D/Z:u\rV$XO]3NKN\u001c\u0018mZ3GK:\u001cW\rZ!gi\u0016\u0014\b+\u0019:uSRLwN\u001c#fY\u0016$X\r\u0015:f\u0013:LG/[1uK\"\u001aa&!4\u0002GQ,7\u000f^*fi\u0016\u0013(o\u001c:QCJ$\u0018\u000e^5p]N$UO]5oO\u001a+gnY5oO\"\u001aq&!4\u0002?Q,7\u000f\u001e*fG>4XM],iS2,7)\u0019;dQV\u00048i\u001c8tk6,'\u000fK\u00021\u0003\u001b\fa\u0005^3ti\"\u000bg\u000e\u001a7j]\u001e4uN\u001d*fgR|'/Z(o\u001d>tWI\u001d:peN#\u0018\r^;tQ\r\t\u0014QZ\u00015i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/T3tg\u0006<Wm\u001d)pgR\u001cF/\u0019;f\r\u0016t7-\u001b8h\tV\u0014\u0018N\\4P]2Lg.Z*uCR,\u0007f\u0001\u001a\u0002N\u0006QE/Z:u)J\fgn]5uS>tgI]8n\u0007\u0006$8\r[;q\u0007>t7/^7feR{\u0007K]5nCJL8i\u001c8tk6,'/\u00138FeJ|'o\u0015;bi\u0016$\u0006.\u001a8SK\u000e|g/\u001a:zQ\r\u0019\u0014QZ\u0001\u000bC\u0012$'+\u001a9mS\u000e\fGCBAB\u0005\u000f\u0011\u0019\u0002C\u0004\u0003\nQ\u0002\rAa\u0003\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003\u0002B\u0007\u0005\u001fi\u0011!P\u0005\u0004\u0005#i$\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\u0011)\u0002\u000ea\u0001\u0005/\t\u0011\u0003^5feR{\u0007/[2D_:\u001cX/\\3s!\ra%\u0011D\u0005\u0004\u00057Y$!\u0005+jKJ$v\u000e]5d\u0007>t7/^7fe\u0006\u00192/\u001a;vaRKWM]\"p[B|g.\u001a8ugR1!\u0011\u0005B\u001a\u0005k\u0001\u0012\u0002\u0012B\u0012\u0005/\u00119C!\f\n\u0007\t\u0015RI\u0001\u0004UkBdWm\r\t\u0005\u0005\u001b\u0011I#C\u0002\u0003,u\u0012!\u0003V5feJ+\u0007\u000f\\5dC6\u000bg.Y4feB\u0019AJa\f\n\u0007\tE2H\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\"I\u0011\u0011D\u001b\u0011\u0002\u0003\u0007\u0011Q\u0004\u0005\b\u0005o)\u0004\u0019AAS\u0003-\u0011WmY8nKJ+\u0017\rZ=\u0002;M,G/\u001e9US\u0016\u00148i\\7q_:,g\u000e^:%I\u00164\u0017-\u001e7uIE*\"A!\u0010+\t\u0005u!qH\u0016\u0003\u0005\u0003\u0002BAa\u0011\u0003N5\u0011!Q\t\u0006\u0005\u0005\u000f\u0012I%A\u0005v]\u000eDWmY6fI*\u0019!1J#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003P\t\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006IRn\u001c<f%\u0016\u001cwN\u001d3t)>\fE\u000e\\\"p]N,X.\u001a:t\u0003q\u0011Xm]3oIB\u0013XM^5pkN\u0004&o\u001c3vG\u0016\u0014V-];fgR\faBY3d_6,\u0017I]2iSZ,'\u000f\u0006\u0006\u0002\u0004\ne#1\fB3\u0005SBqA!\u0003:\u0001\u0004\u0011Y\u0001C\u0004\u0003^e\u0002\rAa\u0018\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0004\t\n\u0005\u0014b\u0001B2\u000b\n\u0019\u0011J\u001c;\t\u000f\t\u001d\u0014\b1\u0001\u0003.\u0005\u0001B/[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u0005\b\u0005+I\u0004\u0019\u0001B\f\u0001")
public class TierTopicManagerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final short tierTopicNumPartitions = (short)7;
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final kafka.utils.MockTime time = new kafka.utils.MockTime();

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private InternalAdmin internalAdmin() {
        return this.internalAdmin;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private kafka.utils.MockTime time() {
        return this.time;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean compactEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    @AfterEach
    public void teardown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            TierTopicManagerTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        Mockito.framework().clearInlineMocks();
        Utils.delete((File)new File(this.logDir()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddMetadataBeforeReady() {
        void var6_6;
        void var5_5;
        int epoch = 0;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo_1", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(topicIdPartition_1, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_1.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_1), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        tierTopicConsumer2.register(topicIdPartition_1, clientCtx_1);
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.immigratingPartitions().size());
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("foo_2", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(topicIdPartition_2, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_2.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_2), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        tierTopicConsumer2.register(topicIdPartition_2, clientCtx_2);
        Assertions.assertEquals((int)2, (int)tierTopicConsumer2.immigratingPartitions().size());
        CompletableFuture future_1 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_1);
        CompletableFuture future_2 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_2);
        Assertions.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$1(this, (TierTopicConsumer)tierTopicConsumer2, future_1, future_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_1.get());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_2.get());
        Assertions.assertEquals((int)2, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateRequestBeforeReady() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int epoch = 0;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        UUID objectId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, epoch, objectId, 0);
        CompletableFuture oldInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
        CompletableFuture newInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (TierPartitionState.AppendResult)oldInitLeaderResult.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierTopicManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151))).getCause() instanceof TierMetadataFatalException));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        Assertions.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$2(this, (TierTopicConsumer)tierTopicConsumer2, newInitLeaderResult)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, newInitLeaderResult.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryOnUnknownExceptionDuringTopicCreation() {
        void var5_5;
        void var4_4;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var4_4;
        void tierTopicManager2 = var5_5;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new TimeoutException("timeout when creating topic")}).thenThrow(new Throwable[]{new AdminOperationException("admin operation exception")}).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)1))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)2))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertTrue((boolean)tierTopicManager2.isReady());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)3))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        Assertions.assertEquals((int)this.tierTopicNumPartitions(), (int)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionerSetupWhenTopicExists() {
        void var6_6;
        void var5_5;
        int existingPartitions = this.tierTopicNumPartitions() - 2;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)existingPartitions));
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertTrue((boolean)tierTopicManager2.isReady());
        Assertions.assertEquals((int)existingPartitions, (int)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetriedMessages() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, initiateResult.get());
        this.resendPreviousProduceRequest();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        CompletableFuture completeResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        tierTopicConsumer2.doWork();
        Assertions.assertFalse((boolean)completeResult.isDone(), (String)"Upload complete result should not have been completed by materialization of UploadInitiate");
        Assertions.assertEquals((long)1L, (long)tierTopicConsumer2.numListeners());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnEmptyTierPartitionState() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        CompletableFuture partitionFenceFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionFence);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(this, (TierTopicConsumer)tierTopicConsumer2, partitionFenceFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnNonEmptyTierPartitionState() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var7_7;
        void tierTopicManager2 = var8_8;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadCompleteFuture.get());
        Assertions.assertEquals((Object)uploadInitiate.objectId(), (Object)((TierLogSegment)this.tierPartitionStateFiles()[0].metadata(100L).get()).objectId());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture partitionFenceFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionFence);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)partitionFenceFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFutureMessageFencedAfterPartitionDeletePreInitiate() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeletePreInitiate partitionDeletePreInitiate = new TierPartitionDeletePreInitiate(topicIdPartition, UUID.randomUUID());
        CompletableFuture partitionDeletePreInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionDeletePreInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)partitionDeletePreInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, partitionDeletePreInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierSegmentUploadInitiate newUploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 101L, 200L, 200L, 200L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture newUploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)newUploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)newUploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, newUploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID());
        CompletableFuture deleteInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)deleteInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)deleteInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, deleteInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetErrorPartitionsDuringFencing() {
        void var6_6;
        void var5_5;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResultFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$1(this, (TierTopicConsumer)tierTopicConsumer2, initiateResultFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, initiateResultFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverWhileCatchupConsumer() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, state.lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenThrow(new Throwable[]{new IOException("couldn't fetch")}).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerPartitions().size());
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$1(this, (TierTopicConsumer)tierTopicConsumer2, uploadCompleteFuture, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)2))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlingForRestoreOnNonErrorStatus() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        state.flush();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
        ByteBuffer restoreBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)restoreBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$1(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessMessagesPostStateFencingDuringOnlineState() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)1))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(this, (TierTopicConsumer)tierTopicConsumer2, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerPartitions().size());
        CompletableFuture becomeArchiverFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, becomeArchiverFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(MergedLog$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(21).append("TierTopicManagerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    private Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> setupTierComponents(TierTopicManagerConfig tierTopicManagerConfig, boolean becomeReady) {
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(tierTopicManagerConfig, this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), new TierTopicManagerCommitter(tierTopicManagerConfig, new LogDirFailureChannel(1)), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TierReplicaManager tierReplicaManager = new TierReplicaManager();
        TierTopicManager tierTopicManager = new TierTopicManager(tierTopicManagerConfig, tierTopicConsumer, this.producerSupplier(), () -> this.internalAdmin());
        if (becomeReady) {
            Assertions.assertTrue((boolean)tierTopicManager.tryBecomeReady(false));
        }
        return new Tuple3((Object)tierTopicConsumer, (Object)tierReplicaManager, (Object)tierTopicManager);
    }

    private TierTopicManagerConfig setupTierComponents$default$1() {
        return this.tierTopicManagerConfig();
    }

    private void moveRecordsToAllConsumers() {
        this.primaryConsumerSupplier().moveRecordsFromProducer();
        this.catchupConsumerSupplier().moveRecordsFromProducer();
    }

    private void resendPreviousProduceRequest() {
        MockProducer<byte[], byte[]> mockProducer = this.producerSupplier().producer();
        ProducerRecord lastSentRecord = (ProducerRecord)mockProducer.history().get(mockProducer.history().size() - 1);
        this.producerSupplier().producer().send(lastSentRecord);
        this.moveRecordsToAllConsumers();
    }

    /*
     * WARNING - void declaration
     */
    private void becomeArchiver(TopicIdPartition topicIdPartition, int leaderEpoch, TierTopicManager tierTopicManager, TierTopicConsumer tierTopicConsumer) {
        CompletableFuture becomeArchiverFuture = tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$becomeArchiver$1(this, tierTopicConsumer, becomeArchiverFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$becomeArchiver$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFuture.get());
    }

    public static final /* synthetic */ void $anonfun$teardown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testAddMetadataBeforeReady$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$1, CompletableFuture future_1$1, CompletableFuture future_2$1) {
        $this.primaryConsumerSupplier().moveRecordsFromProducer();
        tierTopicConsumer$1.doWork();
        return future_1$1.isDone() && future_2$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testAddMetadataBeforeReady$2() {
        return "Timed out waiting for futures to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testDuplicateRequestBeforeReady$2(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$2, CompletableFuture newInitLeaderResult$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$2.doWork();
        return newInitLeaderResult$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testDuplicateRequestBeforeReady$3() {
        return "Timed out waiting to become archiver";
    }

    public static final /* synthetic */ boolean $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$3, CompletableFuture partitionFenceFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$3.doWork();
        return partitionFenceFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2() {
        return "Timed out trying to finish TierPartitionFence";
    }

    public static final /* synthetic */ boolean $anonfun$testSetErrorPartitionsDuringFencing$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$4, CompletableFuture initiateResultFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$4.doWork();
        return initiateResultFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testSetErrorPartitionsDuringFencing$2() {
        return "Timed out trying to finish TierSegmentUploadInitiate";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoverWhileCatchupConsumer$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$5, CompletableFuture uploadCompleteFuture$1, CompletableFuture uploadInitiateFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$5.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            if (uploadCompleteFuture$1.isDone() && uploadInitiateFuture$1.isDone()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRecoverWhileCatchupConsumer$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testHandlingForRestoreOnNonErrorStatus$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$6) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$6.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testHandlingForRestoreOnNonErrorStatus$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$7) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$7.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8, CompletableFuture uploadInitiateFuture$2) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        return uploadInitiateFuture$2.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2() {
        return "Timed out waiting for upload initiate future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$becomeArchiver$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$9, CompletableFuture becomeArchiverFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$9.doWork();
        return becomeArchiverFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$becomeArchiver$2() {
        return "Timed out waiting to become archiver";
    }

    public TierTopicManagerTest() {
        this.clusterId = "mycluster";
    }
}

