/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.log.MergedLog$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.TierMetadataDeserializationException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001B\u00193\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005+A\u0001\u0012\u0001\u0001\u000b\u0016!\u0011\u000b\u0001\u0001S\u0011\u001d)\u0006A1A\u0005\nYCaa\u0018\u0001!\u0002\u00139\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011\u00022\t\u000f%\u0004!\u0019!C\u0005-\"1!\u000e\u0001Q\u0001\n]Cqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004t\u0001\u0001\u0006I!\u001c\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019I\b\u0001)A\u0005m\"9!\u0010\u0001b\u0001\n\u0013Y\bBB@\u0001A\u0003%A\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003W\u0011\u001d\ty\u0001\u0001Q\u0001\n]C\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005E\u0002\u0001)A\u0005\u0003+A\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005u\u0002\u0001)A\u0005\u0003oA\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u000f\u0005U\u0003\u0001)A\u0005%\"I\u0011q\u000b\u0001C\u0002\u0013%\u0011\u0011\f\u0005\b\u00037\u0002\u0001\u0015!\u0003F\u0011%\ti\u0006\u0001b\u0001\n\u0013\tI\u0006C\u0004\u0002`\u0001\u0001\u000b\u0011B#\t\u0013\u0005\u0005\u0004A1A\u0005\n\u0005\r\u0004\u0002CA7\u0001\u0001\u0006I!!\u001a\t\u0013\u0005=\u0004A1A\u0005\n\u0005E\u0004\u0002CA?\u0001\u0001\u0006I!a\u001d\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0005\u0002CAE\u0001\u0001\u0006I!a!\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0005bBA[\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003\u007f\u0003A\u0011AAG\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u001bCq!a2\u0001\t\u0003\ti\tC\u0004\u0002L\u0002!\t!!$\t\u000f\u0005=\u0007\u0001\"\u0001\u0002\u000e\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007b\u0002B\u0003\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0005U!\u0016.\u001a:U_BL7mQ8ogVlWM\u001d+fgRT!a\r\u001b\u0002\u000bQ|\u0007/[2\u000b\u0005U2\u0014\u0001\u0002;jKJT\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0003\"a\u0011\u0001\u000e\u0003I\u0012\u0001cQ8ogVlWM]*vaBd\u0017.\u001a:\u0011\t\u0019K5jS\u0007\u0002\u000f*\u0011\u0001\nN\u0001\u0007G2LWM\u001c;\n\u0005);%\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0002<\u0019:K!!\u0014\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005mz\u0015B\u0001)=\u0005\u0011\u0011\u0015\u0010^3\u0003!A\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003\u0002$T\u0017.K!\u0001V$\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s\u0003%\u0019G.^:uKJLE-F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003mC:<'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013aa\u0015;sS:<\u0017AC2mkN$XM]%eA\u00059A/Z7q\t&\u0014X#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\\\u0016AA5p\u0013\t9GM\u0001\u0003GS2,\u0017\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\u0001\\8h\t&\u00148/F\u0001n!\rq\u0017oV\u0007\u0002_*\u0011\u0001oW\u0001\u0005kRLG.\u0003\u0002s_\nI\u0011I\u001d:bs2K7\u000f^\u0001\tY><G)\u001b:tA\u00051B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7/F\u0001w!\tYt/\u0003\u0002yy\t)1\u000b[8si\u00069B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0015i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u001a:\u0016\u0003q\u0004\"aQ?\n\u0005y\u0014$\u0001\u0006+jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:,'/A\u000buS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tWM\u001d\u0011\u0002-QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e,\"!!\u0002\u0011\u0007\r\u000b9!C\u0002\u0002\nI\u0012a\u0003V5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017nZ\u0001\u0018i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jO\u0002\nQ\u0002^5feR{\u0007/[2OC6,\u0017A\u0004;jKJ$v\u000e]5d\u001d\u0006lW\rI\u0001\u0014i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003+\u0001RA\\A\f\u00037I1!!\u0007p\u0005\r\u0019V\r\u001e\t\u0005\u0003;\ti#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0019\u0019w.\\7p]*\u0019q'!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0012aA8sO&!\u0011qFA\u0010\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fA\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013!\u0003;jKJ$v\u000e]5d+\t\t9\u0004E\u0002D\u0003sI1!a\u000f3\u0005QIe.\u001b;jC2L'0\u001a3US\u0016\u0014Hk\u001c9jG\u0006QA/[3s)>\u0004\u0018n\u0019\u0011\u0002!QLWM]*uCR,g)\u001a;dQ\u0016\u0014XCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%i\u00059a-\u001a;dQ\u0016\u0014\u0018\u0002BA'\u0003\u000f\u0012\u0001\u0003V5feN#\u0018\r^3GKR\u001c\u0007.\u001a:\u0002#QLWM]*uCR,g)\u001a;dQ\u0016\u0014\b%\u0001\tqe>$WoY3s'V\u0004\b\u000f\\5feV\t!+A\tqe>$WoY3s'V\u0004\b\u000f\\5fe\u0002\nq\u0003\u001d:j[\u0006\u0014\u0018pQ8ogVlWM]*vaBd\u0017.\u001a:\u0016\u0003\u0015\u000b\u0001\u0004\u001d:j[\u0006\u0014\u0018pQ8ogVlWM]*vaBd\u0017.\u001a:!\u0003]\u0019\u0017\r^2ikB\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'/\u0001\rdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002\n\u0011\u0004^5feR{\u0007/[2NC:\fw-\u001a:D_6l\u0017\u000e\u001e;feV\u0011\u0011Q\r\t\u0005\u0003O\nI'D\u00015\u0013\r\tY\u0007\u000e\u0002\u001a)&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cu.\\7jiR,'/\u0001\u000euS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{W.\\5ui\u0016\u0014\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005M\u0004\u0003BA;\u0003sj!!a\u001e\u000b\t\u0005=\u0014qD\u0005\u0005\u0003w\n9HA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0011\u0003^5feR{\u0007/[2D_:\u001cX/\\3s+\t\t\u0019\tE\u0002D\u0003\u000bK1!a\"3\u0005E!\u0016.\u001a:U_BL7mQ8ogVlWM]\u0001\u0013i&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\b%A\u0003tKR,\b\u000f\u0006\u0002\u0002\u0010B\u00191(!%\n\u0007\u0005MEH\u0001\u0003V]&$\bf\u0001\u0014\u0002\u0018B!\u0011\u0011TAT\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015aA1qS*!\u0011\u0011UAR\u0003\u001dQW\u000f]5uKJTA!!*\u0002*\u0005)!.\u001e8ji&!\u0011\u0011VAN\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000fG2,\u0017M\\;q\u001b>\u001c7.\u001b;pQ\r9\u0013q\u0016\t\u0005\u00033\u000b\t,\u0003\u0003\u00024\u0006m%!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;Q_2dG)\u001e:bi&|gn\u001d\u0015\u0004Q\u0005e\u0006\u0003BAM\u0003wKA!!0\u0002\u001c\n!A+Z:u\u0003Y!Xm\u001d;SK\u001eL7\u000f^3s!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0015\u0002:\u0006yB/Z:u\tV\u0004H.[2bi\u0016\u0014VmZ5ti\u0016\u0014\b+\u0019:uSRLwN\\:)\u0007)\nI,\u0001\u001cuKN$\bK]5nCJL8i\u001c8tk6,'oU3fWN$v\u000eT1ti\u000e{W.\\5ui\u0016$wJ\u001a4tKR|en\u0015;beR,\b\u000fK\u0002,\u0003s\u000ba\u0003^3ti6\u000bG/\u001a:jC2L'0\u0019;j_:d\u0015m\u001a\u0015\u0004Y\u0005e\u0016a\u0005;fgR\u001c\u0015\r^2ikB\u001cu.\u001c9mKR,\u0007fA\u0017\u0002:\u0006)B/Z:u\u001b\u0006DX*\u0019;fe&\fG.\u001b>f\u0019\u0006<G\u0003BAH\u0003/Dq!!7/\u0001\u0004\tY.A\bdQ\u0016\u001c7n];n\u000b:\f'\r\\3e!\rY\u0014Q\\\u0005\u0004\u0003?d$a\u0002\"p_2,\u0017M\u001c\u0015\b]\u0005\r\u00181_A{!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003[\fy*\u0001\u0004qCJ\fWn]\u0005\u0005\u0003c\f9OA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005]\u0018\u0011`\r\u0002\u0003e\t\u0001\u0001K\u0002/\u0003{\u0004B!a@\u0003\u00025\u0011\u00111^\u0005\u0005\u0005\u0007\tYOA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f1\u0003^3ti\u001e\u000b'OY1hK\"\u000bg\u000e\u001a7j]\u001eD3aLA]\u0003!9W\r^*uCR,GC\u0004B\u0007\u00053\u0011\u0019C!\n\u00030\t}\"\u0011\t\t\u0005\u0005\u001f\u0011)\"\u0004\u0002\u0003\u0012)\u0019!1\u0003\u001b\u0002\u000bM$\u0018\r^3\n\t\t]!\u0011\u0003\u0002\u0017\r&dW\rV5feB\u000b'\u000f^5uS>t7\u000b^1uK\"9!1\u0004\u0019A\u0002\tu\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\u0011\t9Ga\b\n\u0007\t\u0005BG\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011q\u0010\u0019A\u0002\u0005\r\u0005b\u0002B\u0014a\u0001\u0007!\u0011F\u0001\nGRD8\u000b^1ukN\u0004BAa\u0004\u0003,%!!Q\u0006B\t\u0005M!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^;t\u0011\u001d\u0011\t\u0004\ra\u0001\u0005g\t\u0011b]2iK\u0012,H.\u001a:\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000f7\u0003\u0015)H/\u001b7t\u0013\u0011\u0011iDa\u000e\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bbBAma\u0001\u0007\u00111\u001c\u0005\b\u0005\u0007\u0002\u0004\u0019\u0001B#\u0003\u0011!\u0018.\\3\u0011\t\t\u001d#1J\u0007\u0003\u0005\u0013RAA!\u000f\u0002 %!!Q\nB%\u0005\u0011!\u0016.\\3")
public class TierTopicConsumerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final short tierTopicNumPartitions = (short)10;
    private final TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner = new TierTopicPartitioner((int)this.tierTopicNumPartitions());
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName = TierTopic.topicName((String)"");
    private final java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (int)this.tierTopicNumPartitions());
    private final InitializedTierTopic tierTopic = (InitializedTierTopic)Mockito.mock(InitializedTierTopic.class);
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final TierTopicManagerCommitter tierTopicManagerCommitter = (TierTopicManagerCommitter)Mockito.mock(TierTopicManagerCommitter.class);
    private final Metrics metrics = new Metrics();
    private final TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.of(this.metrics()), (Time)new MockTime());

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName;
    }

    private java.util.Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private InitializedTierTopic tierTopic() {
        return this.tierTopic;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private TierTopicManagerCommitter tierTopicManagerCommitter() {
        return this.tierTopicManagerCommitter;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.tierTopic().numPartitions()).thenReturn((Object)OptionalInt.of(this.tierTopicNumPartitions()));
        Mockito.when((Object)this.tierTopic().topicName()).thenReturn((Object)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName());
        Mockito.when((Object)this.tierTopic().toTierTopicPartition((TopicIdPartition)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TopicPartition>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public TopicPartition answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartition((TopicIdPartition)((TopicIdPartition)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopic().toTierTopicPartitions((Collection)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<java.util.Set<TopicPartition>>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public java.util.Set<TopicPartition> answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartitions((Collection)((Collection)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn(null);
    }

    @AfterEach
    public void cleanupMockito() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void testPollDurations() {
        Consumer primary = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)primary.poll(Duration.ofMillis(0L))).thenReturn((Object)new ConsumerRecords(new HashMap()));
        TierTopicConsumer tierTopicConsumerWithMock = new TierTopicConsumer(this.tierTopicManagerConfig(), (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, primary){
            private final Consumer primary$1;

            public Consumer<byte[], byte[]> get() {
                return this.primary$1;
            }
            {
                this.primary$1 = primary$1;
            }
        }, this.catchupConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        tierTopicConsumerWithMock.register(tp_1, ctx_1);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.INIT);
        tierTopicConsumerWithMock.register(tp_2, ctx_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.immigratingPartitions().keySet()).asScala());
        tierTopicConsumerWithMock.initialize(this.tierTopic());
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.atLeastOnce())).assign((Collection)ArgumentMatchers.any());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.atLeastOnce())).seekToBeginning((Collection)ArgumentMatchers.any());
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ofMillis(0L));
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ofMillis(5L));
    }

    @Test
    public void testRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_4 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_4.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        TopicIdPartition tp_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_5 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_5.status()).thenReturn((Object)TierPartitionStatus.ERROR);
        TopicIdPartition tp_6 = new TopicIdPartition("foo-6", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_6 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_6.status()).thenReturn((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        this.tierTopicConsumer().register(tp_4, ctx_4);
        this.tierTopicConsumer().register(tp_5, ctx_5);
        this.tierTopicConsumer().register(tp_6, ctx_6);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2, tp_3, tp_4, tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4, tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_5, (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_6, (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_5, (VerificationMode)Mockito.times((int)5))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_6, (VerificationMode)Mockito.times((int)5))).status();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_3});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_4});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_5});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_6});
        Assertions.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4, tp_5, tp_6}))).asJava()), (Object)this.catchupConsumerSupplier().consumers().get(0).assignment());
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)this.primaryConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testDuplicateRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-1");
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-2");
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-3");
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TierTopicConsumer.ClientCtx ctx_new = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_new.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-new");
        Mockito.when((Object)ctx_new.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(tp_1));
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(tp_2));
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_3, ctx_3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierTopicConsumer().register(tp_1, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierTopicConsumer().register(tp_2, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierTopicConsumer().register(tp_3, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    @Test
    public void testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup() {
        scala.collection.mutable.Set committedOffsetMap = (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch((long)tierTopicPartition.partition() + 100L, Optional.of(Predef$.MODULE$.int2Integer(3)))), Set$.MODULE$.canBuildFrom());
        committedOffsetMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            return ongoingStubbing;
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assertions.assertNotNull((Object)this.tierTopicConsumer().tierTopic());
        Consumer<byte[], byte[]> primaryConsumer = this.primaryConsumerSupplier().consumers().get(0);
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)primaryConsumer.assignment());
        committedOffsetMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TierTopicConsumerTest.$anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(primaryConsumer, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMaterializationLag() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)ctx_1.materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)30L));
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)ctx_2.materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        ((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            return ongoingStubbing;
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.metrics().metric(this.tierTopicConsumer().maxTierLagMetricName).metricValue());
    }

    @Test
    public void testCatchupComplete() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        ((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            return ongoingStubbing;
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Consumer<byte[], byte[]> catchupConsumer = this.catchupConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(catchupConsumer.assignment()).asScala();
        Assertions.assertEquals((int)2, (int)assignment.size());
        assignment.foreach((Function1 & Serializable & scala.Serializable)assignedPartition -> {
            catchupConsumer.seek(assignedPartition, 50L);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        catchupConsumer.seek((TopicPartition)assignment.last(), 150L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).completeCatchup();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMaxMaterializeLag(boolean checksumEnabled) {
        kafka.utils.MockTime time = new kafka.utils.MockTime();
        TopicIdPartition tp_1 = new TopicIdPartition("lag_test", UUID.randomUUID(), 0);
        FileTierPartitionState state_1 = this.getState(tp_1, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, time.scheduler(), checksumEnabled, (Time)time);
        TopicIdPartition tp_2 = new TopicIdPartition("lag_test2", UUID.randomUUID(), 0);
        FileTierPartitionState state_2 = this.getState(tp_2, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, time.scheduler(), checksumEnabled, (Time)time);
        TopicIdPartition tp_3 = new TopicIdPartition("lag_test3", UUID.randomUUID(), 0);
        FileTierPartitionState state_3 = this.getState(tp_3, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, time.scheduler(), checksumEnabled, (Time)time);
        TopicIdPartition tp_4 = new TopicIdPartition("lag_test4", UUID.randomUUID(), 0);
        FileTierPartitionState state_4 = this.getState(tp_4, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, time.scheduler(), checksumEnabled, (Time)time);
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((long)0L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.materializeUptoOffset(100L);
        state_2.materializeUptoOffset(101L);
        state_3.materializeUptoOffset(102L);
        state_4.materializeUptoOffset(103L);
        Assertions.assertEquals((long)103L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.close();
        state_2.close();
        state_3.close();
        state_4.close();
    }

    @Test
    public void testGarbageHandling() {
        ConsumerRecord garbageRecord = new ConsumerRecord("foo-1", 0, 1L, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> AbstractTierMetadata.deserialize((byte[])((byte[])garbageRecord.key()), (byte[])((byte[])garbageRecord.value()), (long)garbageRecord.timestamp()), ClassTag$.MODULE$.apply(TierMetadataDeserializationException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
    }

    private FileTierPartitionState getState(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, TierPartitionStatus ctxStatus, Scheduler scheduler, boolean checksumEnabled, Time time) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(MergedLog$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, scheduler, checksumEnabled, false, false, time);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        TierTopicConsumer.ClientCtx clientCtx = new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState, ctxStatus){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;
            private final TierPartitionStatus ctxStatus$1;

            public String id() {
                return new StringBuilder(22).append("TierTopicConsumerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.ctxStatus$1;
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
                this.ctxStatus$1 = ctxStatus$1;
            }
        };
        tierTopicConsumer.register(topicIdPartition, clientCtx);
        return tierPartitionState;
    }

    public static final /* synthetic */ void $anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(Consumer primaryConsumer$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tierTopicPartition = (TopicPartition)x0$2._1();
            Assertions.assertEquals((long)((OffsetAndEpoch)x0$2._2()).offset(), (long)primaryConsumer$1.position(tierTopicPartition));
            return;
        }
        throw new MatchError(null);
    }

    public TierTopicConsumerTest() {
        this.clusterId = "mycluster";
    }
}

