/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import kafka.server.InternalAdmin;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.topic.TierCatchupConsumer;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\u000b\u0016\u0001qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u00049\u0001\u0001\u0006I!\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u0002#\u0001A\u0003%\u0011\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\rM\u0003\u0001\u0015!\u0003H\u0011\u001d!\u0006A1A\u0005\nUCa!\u0017\u0001!\u0002\u00131\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007?\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0001\u0004A\u0011A1\t\u000bI\u0004A\u0011A1\t\u000b]\u0004A\u0011A1\t\u000be\u0004A\u0011A1\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \t9B+[3s\u0007\u0006$8\r[;q\u0007>t7/^7feR+7\u000f\u001e\u0006\u0003-]\tQ\u0001^8qS\u000eT!\u0001G\r\u0002\tQLWM\u001d\u0006\u00025\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011!F\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u001cX#A\u0015\u0011\u0007)\nDG\u0004\u0002,_A\u0011AfH\u0007\u0002[)\u0011afG\u0001\u0007yI|w\u000e\u001e \n\u0005Az\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t\u00191+\u001a;\u000b\u0005Az\u0002CA\u001b7\u001b\u00059\u0012BA\u001c\u0018\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]N\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001<!\tqB(\u0003\u0002>?\t)1\u000b[8si\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013!\u0003;jKJ$v\u000e]5d+\u0005\t\u0005C\u0001\u0014C\u0013\t\u0019UCA\u0005US\u0016\u0014Hk\u001c9jG\u0006QA/[3s)>\u0004\u0018n\u0019\u0011\u0002!A\u0014x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A$\u0011\t![U*T\u0007\u0002\u0013*\u0011!jF\u0001\u0007G2LWM\u001c;\n\u00051K%\u0001F'pG.\u0004&o\u001c3vG\u0016\u00148+\u001e9qY&,'\u000fE\u0002\u001f\u001dBK!aT\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005y\t\u0016B\u0001* \u0005\u0011\u0011\u0015\u0010^3\u0002#A\u0014x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%\u0001\td_:\u001cX/\\3s'V\u0004\b\u000f\\5feV\ta\u000b\u0005\u0003I/6k\u0015B\u0001-J\u0005QiunY6D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006\t2m\u001c8tk6,'oU;qa2LWM\u001d\u0011\u0002\u001f\r\fGo\u00195va\u000e{gn];nKJ,\u0012\u0001\u0018\t\u0003MuK!AX\u000b\u0003'QKWM]\"bi\u000eDW\u000f]\"p]N,X.\u001a:\u0002!\r\fGo\u00195va\u000e{gn];nKJ\u0004\u0013!B:fiV\u0004H#\u00012\u0011\u0005y\u0019\u0017B\u00013 \u0005\u0011)f.\u001b;)\u000591\u0007CA4q\u001b\u0005A'BA5k\u0003\r\t\u0007/\u001b\u0006\u0003W2\fqA[;qSR,'O\u0003\u0002n]\u0006)!.\u001e8ji*\tq.A\u0002pe\u001eL!!\u001d5\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\tuKN$8\u000b^1si\u000e{gn];nKJD#a\u0004;\u0011\u0005\u001d,\u0018B\u0001<i\u0005\u0011!Vm\u001d;\u0002\u001fQ,7\u000f\u001e+ss\u000e{W\u000e\u001d7fi\u0016D#\u0001\u0005;\u0002\u0011Q,7\u000f\u001e)pY2D#!\u0005;\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000fF\u0002~\u00037\u0001RA`A\u0004\u0003\u0013i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003vi&d'BAA\u0003\u0003\u0011Q\u0017M^1\n\u0005Iz\b\u0003BA\u0006\u0003/i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0007G>lWn\u001c8\u000b\u0007i\t\u0019BC\u0002\u0002\u00169\fa!\u00199bG\",\u0017\u0002BA\r\u0003\u001b\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003(%\u0001\u0007\u0011&A\rv]\u0012,'\u000f\\=j]\u001e\u001c\u0015\r^2ikB\u001cuN\\:v[\u0016\u0014XCAA\u0011!\u0019\t\u0019#!\fN\u001b6\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0005d_:\u001cX/\\3s\u0015\u0011\tY#!\u0005\u0002\u000f\rd\u0017.\u001a8ug&!\u0011qFA\u0013\u0005!\u0019uN\\:v[\u0016\u0014\b")
public class TierCatchupConsumerTest {
    private final scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions = TierTestUtils$.MODULE$.randomTopicIdPartitions(3, 5);
    private final short numPartitions = (short)5;
    private final TierTopic tierTopic = new TierTopic("namespace");
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> consumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", TierTopicManager.partitions((String)this.tierTopic().topicName(), (int)this.numPartitions()), this.producerSupplier().producer());
    private final TierCatchupConsumer catchupConsumer = new TierCatchupConsumer(this.consumerSupplier());

    private scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions() {
        return this.topicIdPartitions;
    }

    private short numPartitions() {
        return this.numPartitions;
    }

    private TierTopic tierTopic() {
        return this.tierTopic;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    private TierCatchupConsumer catchupConsumer() {
        return this.catchupConsumer;
    }

    @BeforeEach
    public void setup() {
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic(this.tierTopic().topicName(), (int)this.numPartitions(), (short)1, TierTopic.topicConfig()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()));
        this.tierTopic().initialize(internalAdmin, (int)this.numPartitions(), (short)1);
    }

    @Test
    public void testStartConsumer() {
        Set<TopicPartition> tierTopicPartitions = this.assignment(this.topicIdPartitions());
        this.catchupConsumer().doStart(tierTopicPartitions);
        Assertions.assertTrue((boolean)this.catchupConsumer().active());
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        scala.collection.immutable.Set<TopicIdPartition> newTopicPartitions = TierTestUtils$.MODULE$.randomTopicIdPartitions(3, 2);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.catchupConsumer().doStart(this.assignment(newTopicPartitions)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierCatchupConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        Assertions.assertTrue((boolean)this.catchupConsumer().active());
    }

    @Test
    public void testTryComplete() {
        Set<TopicPartition> currentAssignment = this.assignment(this.topicIdPartitions());
        Consumer primaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        this.catchupConsumer().doStart(currentAssignment);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(currentAssignment).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 10L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertFalse((boolean)this.catchupConsumer().tryComplete(primaryConsumer));
        Assertions.assertTrue((boolean)this.catchupConsumer().active());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(currentAssignment).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 20L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertTrue((boolean)this.catchupConsumer().tryComplete(primaryConsumer));
        Assertions.assertFalse((boolean)this.catchupConsumer().active());
    }

    @Test
    public void testPoll() {
        Set<TopicPartition> currentAssignment = this.assignment(this.topicIdPartitions());
        Consumer primaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        Assertions.assertEquals(null, (Object)this.catchupConsumer().poll(Duration.ZERO));
        this.catchupConsumer().doStart(currentAssignment);
        ConsumerRecords records = this.catchupConsumer().poll(Duration.ZERO);
        Assertions.assertEquals((int)0, (int)records.count());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(currentAssignment).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 20L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertTrue((boolean)this.catchupConsumer().tryComplete(primaryConsumer));
        Assertions.assertEquals(null, (Object)this.catchupConsumer().poll(Duration.ZERO));
    }

    private Set<TopicPartition> assignment(scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions) {
        return this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(topicIdPartitions).asJava());
    }

    private Consumer<byte[], byte[]> underlyingCatchupConsumer() {
        return this.catchupConsumer().consumer();
    }
}

