/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleanerMetrics$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.CompactionTaskQueue;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierCompactionMetrics$;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0010!\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019a\u0005\u0001)A\u0005\u007f!9Q\n\u0001b\u0001\n\u0013q\u0005B\u0002*\u0001A\u0003%q\nC\u0004T\u0001\t\u0007I\u0011\u0001+\t\rm\u0003\u0001\u0015!\u0003V\u0011\u001da\u0006A1A\u0005\u00029Ca!\u0018\u0001!\u0002\u0013y\u0005b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007Q\u0002\u0001\u000b\u0011\u00021\t\u000f%\u0004!\u0019!C\u0001\u001d\"1!\u000e\u0001Q\u0001\n=Cqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004}\u0001\u0001\u0006I!\u001c\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t)\u0001\u0001Q\u0001\n}D\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0017Aq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u00024\u0001!\t!!\u0006\t\u000f\u0005]\u0002\u0001\"\u0001\u0002\u0016!9\u00111\b\u0001\u0005\u0002\u0005U\u0001bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003;\u0002A\u0011BA0\u0011%\t9\tAI\u0001\n\u0013\tI\tC\u0005\u0002 \u0002\t\n\u0011\"\u0003\u0002\n\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013%\u0011\u0011\u0012\u0002\u0018\u0007>l\u0007/Y2uS>tG+Y:l#V,W/\u001a+fgRT!!\t\u0012\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002$I\u0005)A/Y:lg*\u0011QEJ\u0001\u0005i&,'OC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0007\u0005\u00024\u00015\t\u0001%A\u0002dib,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0011\nqAZ3uG\",'/\u0003\u0002<q\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006!1\r\u001e=!\u0003\u0011!\u0018.\\3\u0016\u0003}\u0002\"\u0001\u0011&\u000e\u0003\u0005S!AQ\"\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0011+\u0015AB2p[6|gN\u0003\u0002(\r*\u0011q\tS\u0001\u0007CB\f7\r[3\u000b\u0003%\u000b1a\u001c:h\u0013\tY\u0015I\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001C7bqR\u000b7o[:\u0016\u0003=\u0003\"a\u000b)\n\u0005Ec#aA%oi\u0006IQ.\u0019=UCN\\7\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-'\u0003\u0019\u0019XM\u001d<fe&\u0011!l\u0016\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001D5p\u0005V4g-\u001a:TSj,\u0017!D5p\u0005V4g-\u001a:TSj,\u0007%A\u0006xe&$XMQ;gM\u0016\u0014X#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017a\u00018j_*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\roJLG/\u001a\"vM\u001a,'\u000fI\u0001\u0016M\u0016t7-\u001a3TK\u001elWM\u001c;t\t\u0016d\u0017-_'t\u0003Y1WM\\2fIN+w-\\3oiN$U\r\\1z\u001bN\u0004\u0013a\u00039sS>\u0014\u0018\u000e^=NCB,\u0012!\u001c\t\u0005]N,\u00180D\u0001p\u0015\t\u0001\u0018/A\u0004nkR\f'\r\\3\u000b\u0005Id\u0013AC2pY2,7\r^5p]&\u0011Ao\u001c\u0002\u0004\u001b\u0006\u0004\bC\u0001<x\u001b\u0005!\u0013B\u0001=%\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u00024u&\u00111\u0010\t\u0002\u000f)&,'\u000fT8h)>\u001cE.Z1o\u00031\u0001(/[8sSRLX*\u00199!\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN,\u0012a \t\u0004g\u0005\u0005\u0011bAA\u0002A\t)B+[3s\u0007>l\u0007/Y2uS>tW*\u001a;sS\u000e\u001c\u0018A\u0006;jKJ\u001cu.\u001c9bGRLwN\\'fiJL7m\u001d\u0011\u0002'\r|W\u000e]1di&|g\u000eV1tWF+X-^3\u0016\u0005\u0005-\u0001cA\u001a\u0002\u000e%\u0019\u0011q\u0002\u0011\u0003'\r{W\u000e]1di&|g\u000eV1tWF+X-^3\u0002)\r|W\u000e]1di&|g\u000eV1tWF+X-^3!\u0003Q!Xm\u001d;Q_2dG+Y:l\u001fJ$WM]5oOR\u0011\u0011q\u0003\t\u0004W\u0005e\u0011bAA\u000eY\t!QK\\5uQ\r1\u0012q\u0004\t\u0005\u0003C\ty#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\r\t\u0007/\u001b\u0006\u0005\u0003S\tY#A\u0004kkBLG/\u001a:\u000b\u0007\u00055\u0002*A\u0003kk:LG/\u0003\u0003\u00022\u0005\r\"\u0001\u0002+fgR\f1\u0004^3ti\u0006#GMU3qY\u0006\u001cWm]#ySN$\u0018N\\4UCN\\\u0007fA\f\u0002 \u0005qA/Z:u%\u0016lwN^3UCN\\\u0007f\u0001\r\u0002 \u0005AB/Z:u!>dG\u000eV1tWNluN]3UQ\u0006tW*\u0019=)\u0007e\ty\"\u0001\u0007tG\",G-\u001e7j]\u001e4e\u000e\u0006\u0004\u0002D\u0005%\u00131\u000b\t\u0005W\u0005\u0015\u00130C\u0002\u0002H1\u0012aa\u00149uS>t\u0007bBA&5\u0001\u0007\u0011QJ\u0001\u0005i\u0006\u001c8\u000eE\u00024\u0003\u001fJ1!!\u0015!\u00059\u0019u.\u001c9bGRLwN\u001c+bg.Dq!!\u0016\u001b\u0001\u0004\t9&A\u0002o_^\u00042aKA-\u0013\r\tY\u0006\f\u0002\u0005\u0019>tw-A\u0006va\u0012\fG/\u001a*bi&|GCEA\f\u0003C\n)'a\u001c\u0002t\u0005]\u00141PA@\u0003\u0007Ca!a\u0019\u001c\u0001\u0004)\u0018\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\t9g\u0007a\u0001\u0003S\nq\"\u001a4gS\u000eLWM\\2z%\u0006$\u0018n\u001c\t\u0004W\u0005-\u0014bAA7Y\t1Ai\\;cY\u0016Dq!!\u001d\u001c\u0001\u0004\tI'\u0001\nnS:,eMZ5dS\u0016t7-\u001f*bi&|\u0007bBA;7\u0001\u0007\u0011\u0011N\u0001\u000fG2,\u0017M\\1cY\u0016\u0014\u0016\r^5p\u0011\u001d\tIh\u0007a\u0001\u0003S\n\u0011#\\5o\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p\u0011%\tih\u0007I\u0001\u0002\u0004\t9&A\u000efCJd\u0017.Z:u\r&\u00148\u000f\u001e\"bi\u000eDG+[7fgR\fW\u000e\u001d\u0005\n\u0003\u0003[\u0002\u0013!a\u0001\u0003/\nQbY8na\u0006\u001cG/[8o\u0019\u0006<\u0007\"CAC7A\u0005\t\u0019AA,\u0003Ai\u0017\r_\"p[B\f7\r^5p]2\u000bw-A\u000bva\u0012\fG/\u001a*bi&|G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005-%\u0006BA,\u0003\u001b[#!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033c\u0013AC1o]>$\u0018\r^5p]&!\u0011QTAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016kB$\u0017\r^3SCRLw\u000e\n3fM\u0006,H\u000e\u001e\u00138\u0003U)\b\u000fZ1uKJ\u000bG/[8%I\u00164\u0017-\u001e7uIa\u0002")
public class CompactionTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final Time time = new MockTime();
    private final int maxTasks;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final int ioBufferSize;
    private final ByteBuffer writeBuffer = ByteBuffer.allocate(this.ioBufferSize());
    private final int fencedSegmentsDelayMs;
    private final Map<TopicIdPartition, TierLogToClean> priorityMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final TierCompactionMetrics tierCompactionMetrics = new TierCompactionMetrics(new LogCleanerMetrics(LogCleanerMetrics$.MODULE$.$lessinit$greater$default$1()), TierCompactionMetrics$.MODULE$.apply$default$2());
    private final CompactionTaskQueue compactionTaskQueue = new CompactionTaskQueue(this.ctx(), this.maxTasks(), this.time(), (Function2 & Serializable & scala.Serializable)(task, now) -> CompactionTaskQueueTest.$anonfun$compactionTaskQueue$1(this, task, BoxesRunTime.unboxToLong((Object)now)), this.tierCompactionMetrics());

    private CancellationContext ctx() {
        return this.ctx;
    }

    private Time time() {
        return this.time;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public int ioBufferSize() {
        return this.ioBufferSize;
    }

    public ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    public int fencedSegmentsDelayMs() {
        return this.fencedSegmentsDelayMs;
    }

    private Map<TopicIdPartition, TierLogToClean> priorityMap() {
        return this.priorityMap;
    }

    private TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    private CompactionTaskQueue compactionTaskQueue() {
        return this.compactionTaskQueue;
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TopicIdPartition partition_6 = new TopicIdPartition("foo-6", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_5, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_6, 0));
        this.updateRatio(partition_1, 0.15, 0.1, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_2, 0.25, 0.1, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_3, 0.3, 0.5, 0.8, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_4, 0.35, 0.5, 0.7, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_5, 0.0, 0.5, 0.0, 0.75, 101L, 0L, 100L);
        this.updateRatio(partition_6, 0.0, 0.5, 0.0, 0.75, 101L, 1000L, this.updateRatio$default$8());
        List tasks = (List)this.compactionTaskQueue().poll().get();
        Assertions.assertEquals((Object)new .colon.colon((Object)partition_5, (List)new .colon.colon((Object)partition_2, (List)new .colon.colon((Object)partition_1, (List)new .colon.colon((Object)partition_3, (List)Nil$.MODULE$)))), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicIdPartition(), List$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAddReplacesExistingTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 1));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 2));
        this.compactionTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$1(partition_1, partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(partition_1));
        this.compactionTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            CompactionTaskQueueTest.$anonfun$testRemoveTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        this.compactionTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(partition_3));
        this.compactionTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            CompactionTaskQueueTest.$anonfun$testRemoveTask$3(partition_2, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPollTasksMoreThanMax() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TopicIdPartition partition_6 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_5, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_6, 0));
        this.updateRatio(partition_1, 0.6, 0.5, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_2, 0.7, 0.5, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_3, 0.8, 0.5, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_4, 0.9, 0.5, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_5, 0.95, 0.5, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.updateRatio(partition_6, 0.97, 0.5, 0.1, 0.75, this.updateRatio$default$6(), this.updateRatio$default$7(), this.updateRatio$default$8());
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_5, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_6, 0));
        Assertions.assertEquals((Object)new .colon.colon((Object)partition_6, (List)new .colon.colon((Object)partition_5, (List)new .colon.colon((Object)partition_4, (List)new .colon.colon((Object)partition_3, (List)new .colon.colon((Object)partition_2, (List)Nil$.MODULE$))))), (Object)((List)this.compactionTaskQueue().poll().get()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.topicIdPartition(), List$.MODULE$.canBuildFrom()));
    }

    private Option<TierLogToClean> schedulingFn(CompactionTask task, long now) {
        return this.priorityMap().get((Object)task.topicIdPartition());
    }

    private void updateRatio(TopicIdPartition topicIdPartition, double efficiencyRatio, double minEfficiencyRatio, double cleanableRatio, double minCleanableRatio, long earliestFirstBatchTimestamp, long compactionLag, long maxCompactionLag) {
        this.priorityMap().update((Object)topicIdPartition, (Object)TierTestUtils$.MODULE$.tierLogToClean(topicIdPartition, this.time(), efficiencyRatio, minEfficiencyRatio, cleanableRatio, minCleanableRatio, earliestFirstBatchTimestamp, compactionLag, maxCompactionLag));
    }

    private long updateRatio$default$6() {
        return Long.MIN_VALUE;
    }

    private long updateRatio$default$7() {
        return 0L;
    }

    private long updateRatio$default$8() {
        return Long.MAX_VALUE;
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$2(TopicIdPartition partition_1$1, CompactionTask x$2) {
        TopicIdPartition topicIdPartition = x$2.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_1$1) : partition_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$3(TopicIdPartition partition_2$1, CompactionTask x$3) {
        TopicIdPartition topicIdPartition = x$3.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_2$1) : partition_2$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$4(TopicIdPartition partition_3$1, CompactionTask x$4) {
        TopicIdPartition topicIdPartition = x$4.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_3$1) : partition_3$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$5(TopicIdPartition partition_4$1, CompactionTask x$5) {
        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_4$1) : partition_4$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testAddReplacesExistingTask$1(TopicIdPartition partition_1$1, TopicIdPartition partition_2$1, TopicIdPartition partition_3$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((int)1, (int)((CompactionTask)tasks.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$2(partition_1$1, x$2))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((CompactionTask)tasks.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$3(partition_2$1, x$3))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)2, (int)((CompactionTask)tasks.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$4(partition_3$1, x$4))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((CompactionTask)tasks.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$5(partition_4$1, x$5))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)4, (int)tasks.size());
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$1(TopicIdPartition partition_2$2, TopicIdPartition partition_3$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$2, partition_3$2, partition_4$2})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$3(TopicIdPartition partition_2$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$2, partition_4$2})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public CompactionTaskQueueTest() {
        this.maxTasks = 5;
        this.ioBufferSize = 1024;
        this.fencedSegmentsDelayMs = 61000;
    }
}

