/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u001b7\u0001}BQA\u0012\u0001\u0005\u0002\u001dC\u0011B\u0013\u0001A\u0002\u0003\u0007I\u0011A&\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0006\"C-\u0001\u0001\u0004\u0005\t\u0015)\u0003M\u0011\u001dQ\u0006A1A\u0005\u0002mCaA\u0019\u0001!\u0002\u0013a\u0006bB2\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B3\t\u000f9\u0004!\u0019!C\u0001_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000f\u0003\u0004}\u0001\u0001\u0006IA\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u001d\tY\u0001\u0001Q\u0001\n}D\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005]\u0001\u0001)A\u0005\u0003#A\u0011\"!\u0007\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005%\u0002\u0001)A\u0005\u0003;A\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\t\u0011\u0005m\u0002\u0001)A\u0005\u0003_A\u0011\"!\u0010\u0001\u0001\u0004%\t!a\u0010\t\u0013\u00055\u0003\u00011A\u0005\u0002\u0005=\u0003\u0002CA*\u0001\u0001\u0006K!!\u0011\t\u0013\u0005U\u0003A1A\u0005\u0002\u0005]\u0003\u0002CA3\u0001\u0001\u0006I!!\u0017\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005%\u0004\u0002CA:\u0001\u0001\u0006I!a\u001b\t\u0013\u0005U\u0004A1A\u0005\u0002\u0005]\u0004\u0002CAC\u0001\u0001\u0006I!!\u001f\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005%\u0005\u0002CAR\u0001\u0001\u0006I!a#\t\u0013\u0005\u0015\u0006A1A\u0005\u0002\u0005\u001d\u0006\u0002CA\\\u0001\u0001\u0006I!!+\t\u0017\u0005e\u0006\u00011AA\u0002\u0013\u0005\u00111\u0018\u0005\f\u0003+\u0004\u0001\u0019!a\u0001\n\u0003\t9\u000eC\u0006\u0002\\\u0002\u0001\r\u0011!Q!\n\u0005u\u0006\"CAo\u0001\t\u0007I\u0011AAp\u0011!\tI\u000f\u0001Q\u0001\n\u0005\u0005\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u000b\u0001A\u0011AAw\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003[DqA!\u0007\u0001\t\u0003\ti\u000fC\u0004\u0003\u001e\u0001!\t!!<\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002n\"9!Q\u0005\u0001\u0005\u0002\u00055\bb\u0002B\u0015\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005[\u0001A\u0011AAw\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0003[DqA!\u000e\u0001\t\u0003\ti\u000fC\u0004\u0003:\u0001!\t!!<\t\u000f\tu\u0002\u0001\"\u0001\u0002n\"9!\u0011\t\u0001\u0005\n\t\r#!\u0006+jKJ\f%o\u00195jm\u0016\u00148\u000b^1uKR+7\u000f\u001e\u0006\u0003oa\nq!\u0019:dQ&4XM\u0003\u0002:u\u0005)A/Y:lg*\u00111\bP\u0001\u0005i&,'OC\u0001>\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\ta'A\u0002dib,\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fj\nqAZ3uG\",'/\u0003\u0002R\u001d\n\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u000691\r\u001e=`I\u0015\fHC\u0001+X!\t\tU+\u0003\u0002W\u0005\n!QK\\5u\u0011\u001dA6!!AA\u00021\u000b1\u0001\u001f\u00132\u0003\u0011\u0019G\u000f\u001f\u0011\u0002\u00115|7m\u001b+j[\u0016,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?r\nQ!\u001e;jYNL!!\u00190\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u001bQLWM\u001d+pa&\u001cg*Y7f+\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0011a\u0017M\\4\u000b\u0003)\fAA[1wC&\u0011An\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u001dQLWM\u001d+pa&\u001cg*Y7fA\u00051B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7/F\u0001q!\t\t\u0015/\u0003\u0002s\u0005\n)1\u000b[8si\u00069B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7\u000fI\u0001\bY><G)\u001b:t+\u00051\bcA<{K6\t\u0001P\u0003\u0002zS\u0006!Q\u000f^5m\u0013\tY\bPA\u0005BeJ\f\u0017\u0010T5ti\u0006AAn\\4ESJ\u001c\b%A\tpE*,7\r^*u_J,7i\u001c8gS\u001e,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u001e\u0002\u000bM$xN]3\n\t\u0005%\u00111\u0001\u0002\"\u001b>\u001c7.\u00138NK6|'/\u001f+jKJ|%M[3diN#xN]3D_:4\u0017nZ\u0001\u0013_\nTWm\u0019;Ti>\u0014XmQ8oM&<\u0007%A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f+\t\t\t\u0002\u0005\u0003\u0002\u0002\u0005M\u0011\u0002BA\u000b\u0003\u0007\u00111$T8dW&sW*Z7pef$\u0016.\u001a:PE*,7\r^*u_J,\u0017\u0001\u0005;jKJ|%M[3diN#xN]3!\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM]\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003GQ\u0014!\u0002;pa&\u001c\u0017\u0002BA\u0014\u0003C\u0011\u0011\u0003V5feR{\u0007/[2D_:\u001cX/\\3s\u0003I!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\u0011\u00023QLWM\u001d)beRLG/[8o'R\fG/\u001a$bGR|'/_\u000b\u0003\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kQ\u0014!B:uCR,\u0017\u0002BA\u001d\u0003g\u0011\u0011\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ss\u0006QB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r\u0006\u001cGo\u001c:zA\u0005\u0019B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgV\u0011\u0011\u0011\t\t\u0006\u0003\u0006\r\u0013qI\u0005\u0004\u0003\u000b\u0012%!B!se\u0006L\b\u0003BA\u0019\u0003\u0013JA!a\u0013\u00024\t\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003]!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3t?\u0012*\u0017\u000fF\u0002U\u0003#B\u0001\u0002\u0017\f\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0015i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002#QLWM\u001d'pO\u000e{W\u000e]8oK:$8/\u0006\u0002\u0002ZA!\u00111LA1\u001b\t\tiFC\u0002\u0002`q\n1\u0001\\8h\u0013\u0011\t\u0019'!\u0018\u0003#QKWM\u001d'pO\u000e{W\u000e]8oK:$8/\u0001\nuS\u0016\u0014Hj\\4D_6\u0004xN\\3oiN\u0004\u0013A\u0005;jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!a\u001b\u0011\t\u00055\u0014qN\u0007\u0002u%\u0019\u0011\u0011\u000f\u001e\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0015E2|7m[5oOR\u000b7o[#yK\u000e,Ho\u001c:\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}\u00040\u0001\u0006d_:\u001cWO\u001d:f]RLA!a!\u0002~\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002+\tdwnY6j]\u001e$\u0016m]6Fq\u0016\u001cW\u000f^8sA\u0005!A/[7f+\t\tY\t\u0005\u0003\u0002\u000e\u0006}UBAAH\u0015\ry\u0016\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0004d_6lwN\u001c\u0006\u0004{\u0005]%\u0002BAM\u00037\u000ba!\u00199bG\",'BAAO\u0003\ry'oZ\u0005\u0005\u0003C\u000byI\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013aC7bq^\u000b\u0017\u000e\u001e+j[\u0016,\"!!+\u0011\t\u0005-\u00161W\u0007\u0003\u0003[SA!a,\u00022\u0006AA-\u001e:bi&|gNC\u0002\u0002\u0000\tKA!!.\u0002.\nqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001D7bq^\u000b\u0017\u000e\u001e+j[\u0016\u0004\u0013\u0001\u00032zi\u0016\u0014\u0016\r^3\u0016\u0005\u0005u\u0006\u0003BA`\u0003#l!!!1\u000b\t\u0005\r\u0017QY\u0001\u0005G>\u0014XM\u0003\u0003\u0002H\u0006%\u0017aB7fiJL7m\u001d\u0006\u0005\u0003\u0017\fi-\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003\u001f\f1aY8n\u0013\u0011\t\u0019.!1\u0003\u000b5+G/\u001a:\u0002\u0019\tLH/\u001a*bi\u0016|F%Z9\u0015\u0007Q\u000bI\u000e\u0003\u0005YG\u0005\u0005\t\u0019AA_\u0003%\u0011\u0017\u0010^3SCR,\u0007%A\buS\u0016\u0014H+Y:lg\u000e{gNZ5h+\t\t\t\u000f\u0005\u0003\u0002d\u0006\u0015X\"\u0001\u001d\n\u0007\u0005\u001d\bHA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003A!\u0018.\u001a:UCN\\7oQ8oM&<\u0007%A\u0003tKR,\u0006\u000fF\u0001UQ\r9\u0013\u0011\u001f\t\u0005\u0003g\u0014\t!\u0004\u0002\u0002v*!\u0011q_A}\u0003\r\t\u0007/\u001b\u0006\u0005\u0003w\fi0A\u0004kkBLG/\u001a:\u000b\t\u0005}\u00181T\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u0007\t)P\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004Q\t%\u0001\u0003BAz\u0005\u0017IAA!\u0004\u0002v\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0019i\u0016\u001cH/Q<bSRLgn\u001a'fC\u0012,'OU3tk2$\bfA\u0015\u0003\u0014A!\u00111\u001fB\u000b\u0013\u0011\u00119\"!>\u0003\tQ+7\u000f^\u0001;i\u0016\u001cHOR1jY\u0016$\u0017J\\5u\u0019\u0016\fG-\u001a:SKR\u0014\u0018\u0010\u00165f]J+7\u000f^8sKR\u0013\u0018nZ4fe&twMQ3g_J,G*Z1eKJD3A\u000bB\n\u00035\"Xm\u001d;GC&dW\r\u001a'fC\u0012,'OU3tk2$h)Y5mK\u0012\u0014Vm\u001d;pe\u0016tUm^3s\u000bB|7\r\u001b\u0015\u0004W\tM\u0011!\f;fgR4\u0015-\u001b7fI2+\u0017\rZ3s%\u0016\u001cX\u000f\u001c;GC&dW\r\u001a*fgR|'/Z#rk\u0006dW\t]8dQ\"\u001aAFa\u0005\u0002[Q,7\u000f\u001e$bS2,G\rT3bI\u0016\u0014(+Z:vYR4\u0015-\u001b7fIJ+7\u000f^8sK2{w/\u001a:Fa>\u001c\u0007\u000eK\u0002.\u0005'\ta\u0004^3ti\u0006;\u0018-\u001b;j]\u001edU-\u00193feJ+7/\u001e7u\r\u0016t7-\u001a3)\u00079\u0012\u0019\"\u0001\u000euKN$(+Z:u_J,g)\u001a8dK\u0012,\u0005pY3qi&|g\u000eK\u00020\u0005'\ta\u0003^3ti\n+gm\u001c:f+Bdw.\u00193GK:\u001cW\r\u001a\u0015\u0004a\tM\u0011A\t;fgR\u0014UMZ8sKV\u0003Hn\\1e%\u0016$(/_,iK:tunU3h[\u0016tG\u000fK\u00022\u0005'\t1\u0005^3ti\n+gm\u001c:f+Bdw.\u00193BIZ\fgnY3t)>tU\r\u001f;Ti\u0006$X\rK\u00023\u0005'\t!\u0005^3ti\n+gm\u001c:f+Bdw.\u00193Pm\u0016\u0014H.\u00199qS:<7+Z4nK:$\bfA\u001a\u0003\u0014\u0005A2M]3bi\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0019\u0005\u001d#Q\tB+\u0005?\u0012yG!\u001f\t\u000f\t\u001dC\u00071\u0001\u0003J\u0005\u0019A-\u001b:\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u0014j\u0003\tIw.\u0003\u0003\u0003T\t5#\u0001\u0002$jY\u0016DqAa\u00165\u0001\u0004\u0011I&\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B!\u0011Q\u000eB.\u0013\r\u0011iF\u000f\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:DqA!\u00195\u0001\u0004\u0011\u0019'\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0005\u0005K\u0012Y'\u0004\u0002\u0003h)\u0019!\u0011\u000e\u001f\u0002\rM,'O^3s\u0013\u0011\u0011iGa\u001a\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0011\u001d\u0011\t\b\u000ea\u0001\u0005g\na\u0002^5fe&tw-\u00128bE2,G\rE\u0002B\u0005kJ1Aa\u001eC\u0005\u001d\u0011un\u001c7fC:DqAa\u001f5\u0001\u0004\u0011\u0019(\u0001\bd_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3")
public class TierArchiverStateTest {
    private CancellationContext ctx;
    private final MockTime mockTime = new MockTime();
    private final String tierTopicName;
    private final short tierTopicNumPartitions;
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(System.getProperty("java.io.tmpdir")));
    private final MockInMemoryTierObjectStoreConfig objectStoreConfig = new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1));
    private final MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), this.objectStoreConfig());
    private final TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private TierPartitionState[] tierPartitionStates = (TierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(TierPartitionState.class));
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), this.tierPartitionStateFactory());
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final ScheduledExecutorService blockingTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Time time = Time.SYSTEM;
    private final FiniteDuration maxWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private Meter byteRate;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, TierTasksConfig$.MODULE$.$lessinit$greater$default$4(), TierTasksConfig$.MODULE$.$lessinit$greater$default$5(), TierTasksConfig$.MODULE$.$lessinit$greater$default$6(), TierTasksConfig$.MODULE$.$lessinit$greater$default$7(), TierTasksConfig$.MODULE$.$lessinit$greater$default$8(), TierTasksConfig$.MODULE$.$lessinit$greater$default$9());

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public String tierTopicName() {
        return this.tierTopicName;
    }

    public short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public MockInMemoryTierObjectStoreConfig objectStoreConfig() {
        return this.objectStoreConfig;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierPartitionState[] tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public void tierPartitionStates_$eq(TierPartitionState[] x$1) {
        this.tierPartitionStates = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public Time time() {
        return this.time;
    }

    public FiniteDuration maxWaitTime() {
        return this.maxWaitTime;
    }

    public Meter byteRate() {
        return this.byteRate;
    }

    public void byteRate_$eq(Meter x$1) {
        this.byteRate = x$1;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    @BeforeEach
    public void setUp() {
        this.ctx_$eq(CancellationContext.newContext());
        KafkaMetricsGroup$.MODULE$.removeMetric("TierArchiver.UploadRate", KafkaMetricsGroup$.MODULE$.removeMetric$default$2());
        this.byteRate_$eq(KafkaMetricsGroup$.MODULE$.newMeter("TierArchiver.UploadRate", "bytes", TimeUnit.SECONDS, KafkaMetricsGroup$.MODULE$.newMeter$default$4()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void tearDown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.delete();
            return BoxedUnit.UNIT;
        });
        this.ctx().cancel();
    }

    @Test
    public void testAwaitingLeaderResult() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        new Properties().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = this.createTierPartitionState(new File(this.logDirs().get(0)), topicIdPartition, logDirFailureChannel, true, false);
        this.tierReplicaManager().becomeLeader(tierPartitionState, 1);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 0, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testFailedInitLeaderRetryThenRestoreTriggeringBeforeLeader() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ERROR).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Future failedResultNextStage = failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResultAgain = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultNextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResultAgain.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED as status is still ERROR");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeLeader as correct epoch was never established in initial BeforeLeader");
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should correctly transition into BeforeUpload");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreNewerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        ArchiveTask resultCancelled = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)resultCancelled.ctx().isCancelled(), (String)"We are the stale leader and the task should be cancelled");
        Assertions.assertTrue((boolean)(resultCancelled.state() instanceof FailedState), (String)"We are the stale leader and the task should remain in FailedState");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreEqualEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreLowerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testAwaitingLeaderResultFenced() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrError((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), topicIdPartition, (TierTopicAppender)tierTopicManager, 1, replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testRestoreFencedException() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.RESTORE_FENCED));
        int x$1 = 150;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16, x$17);
        File logDir = Paths.get(TestUtils$.MODULE$.tempDir().getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MergedLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 300000, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), this.tierLogComponents(), logDirFailureChannel, LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertThrows(TierArchiverRestoreFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadFenced() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadRetryWhenNoSegment() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)List$.MODULE$.empty());
        Mockito.when((Object)log.activeSegment()).thenReturn(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testBeforeUploadAdvancesToNextState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        int x$1 = 150;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16, x$17);
        File logDir = Paths.get(TestUtils$.MODULE$.tempDir().getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MergedLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 300000, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), this.tierLogComponents(), logDirFailureChannel, LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16());
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to AfterUpload");
    }

    @Test
    public void testBeforeUploadOverlappingSegment() {
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16, x$17);
        File logDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        TopicPartition topicPartition = MergedLog$.MODULE$.parseTopicPartitionName(logDir);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = this.createTierPartitionState(logDir, topicIdPartition, logDirFailureChannel, true, false);
        tierPartitionState.beginCatchup();
        tierPartitionState.onCatchUpComplete();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionStateFactory().mayEnableTiering(topicPartition, logConfig))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicIdPartition.topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        long x$20 = 0L;
        long x$21 = 0L;
        MockScheduler x$22 = this.mockTime().scheduler();
        BrokerTopicStats x$23 = new BrokerTopicStats();
        Metrics x$24 = new Metrics();
        MockTime x$25 = this.mockTime();
        int x$26 = 300000;
        int x$27 = 3600000;
        int x$28 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        TierLogComponents x$30 = this.tierLogComponents();
        boolean x$31 = true;
        boolean x$32 = true;
        None$ x$33 = None$.MODULE$;
        LogOffsetsListener x$34 = MergedLog$.MODULE$.apply$default$17();
        Option x$35 = MergedLog$.MODULE$.apply$default$18();
        MergedLog log = MergedLog$.MODULE$.apply(logDir, logConfig, x$20, x$21, (Scheduler)x$22, x$23, x$24, (Time)x$25, x$26, x$27, x$28, logDirFailureChannel, x$30, x$31, (Option)x$33, x$32, x$34, x$35);
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, 0, UUID.randomUUID(), 0L, 60L, 15000L, 15000L, 1000, TierTestUtils$.MODULE$.uploadWithMetadata$default$10(), TierTestUtils$.MODULE$.uploadWithMetadata$default$11(), TierTestUtils$.MODULE$.uploadWithMetadata$default$12(), TierTestUtils$.MODULE$.uploadWithMetadata$default$13(), TierTestUtils$.MODULE$.uploadWithMetadata$default$14());
        int newTierEpoch = 1;
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, newTierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        log.updateHighWatermark(log.logEndOffset());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(null, tierPartitionState){
            private final TierPartitionState tierPartitionState$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                AbstractTierMetadata metadata = (AbstractTierMetadata)invocation.getArgument(0);
                return CompletableFuture.completedFuture(this.tierPartitionState$1.append(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(newTierEpoch), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to Upload");
    }

    private TierPartitionState createTierPartitionState(File dir, TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean tieringEnabled, boolean compactEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, logDirFailureChannel, topicIdPartition.topicPartition(), tieringEnabled, (Scheduler)this.mockTime().scheduler(), false, compactEnabled, false, (Time)this.mockTime());
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates_$eq((TierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(TierPartitionState.class)));
        return tierPartitionState;
    }

    public TierArchiverStateTest() {
        this.tierTopicName = "_confluent-tier-state";
        this.tierTopicNumPartitions = 1;
    }
}

