/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.SegmentDeletion$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001\u0002\u00192\u0001iBQ!\u0011\u0001\u0005\u0002\tC\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001$\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0006\"\u0003-\u0001\u0001\u0004\u0005\t\u0015)\u0003H\u0011\u001dI\u0006\u00011A\u0005\u0004iCq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011\r\u0003\u0004d\u0001\u0001\u0006Ka\u0017\u0005\nI\u0002\u0001\r\u00111A\u0005\u0002\u0015D\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011A6\t\u00135\u0004\u0001\u0019!A!B\u00131\u0007b\u00028\u0001\u0005\u0004%\ta\u001c\u0005\u0007m\u0002\u0001\u000b\u0011\u00029\t\u000f]\u0004\u0001\u0019!C\u0001q\"Aq\u0010\u0001a\u0001\n\u0003\t\t\u0001C\u0004\u0002\u0006\u0001\u0001\u000b\u0015B=\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u0017\u0005M\u0001\u00011AA\u0002\u0013\u0005\u0011Q\u0003\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0003\t)\u0003C\u0006\u0002*\u0001\u0001\r\u0011!Q!\n\u0005]\u0001bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0001\u0003+A1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00020!Y\u00111\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\f\u0011%\t)\u0004\u0001b\u0001\n\u0003\t9\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001d\u0011%\t9\u0005\u0001b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA&\u0011%\tI\u0006\u0001b\u0001\n\u0003\tY\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA/\u0011%\tY\u0007\u0001b\u0001\n\u0003\ti\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA8\u0011%\ti\b\u0001b\u0001\n\u0003\ty\b\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BAA\u0011%\ty\t\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAJ\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!a/\u0001\t\u0003\ty\nC\u0004\u0002F\u0002!I!a2\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\u001a1\u0011Q \u0001\u0001\u0003\u007fDa!\u0011\u0015\u0005\u0002\te\u0001b\u0002B\u0010Q\u0011\u0005#\u0011\u0005\u0005\b\u0005\u000fBC\u0011\tB%\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001bBqA!\"\u0001\t\u0003\u00119\tC\u0004\u0003\u0016\u0002!\tAa&\t\u000f\t\u0015\u0006\u0001\"\u0001\u0003(\nQ\u0012I]2iSZ,G+Y:l\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011!gM\u0001\bCJ\u001c\u0007.\u001b<f\u0015\t!T'A\u0003uCN\\7O\u0003\u00027o\u0005!A/[3s\u0015\u0005A\u0014!B6bM.\f7\u0001A\n\u0003\u0001m\u0002\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001D!\t!\u0005!D\u00012\u0003!)\u00070Z2vi>\u0014X#A$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015AC2p]\u000e,(O]3oi*\u0011A*T\u0001\u0005kRLGNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005AK%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0019\u0015DXmY;u_J|F%Z9\u0015\u0005M3\u0006C\u0001\u001fU\u0013\t)VH\u0001\u0003V]&$\bbB,\u0004\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014!C3yK\u000e,Ho\u001c:!\u0003\t)7-F\u0001\\!\taf,D\u0001^\u0015\tQU(\u0003\u0002`;\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007K\u000e|F%Z9\u0015\u0005M\u0013\u0007bB,\u0007\u0003\u0003\u0005\raW\u0001\u0004K\u000e\u0004\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\u00051\u0007CA4i\u001b\u0005)\u0014BA56\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\u000bu_BL7-\u00133QCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0003'2DqaV\u0005\u0002\u0002\u0003\u0007a-A\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a]\u001c\u0002\u000f\rdWo\u001d;fe&\u0011QO\u001d\u0002\n!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003\u0019\u0019wN\u001c4jOV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}o\u000511/\u001a:wKJL!A`>\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fHcA*\u0002\u0004!9qKDA\u0001\u0002\u0004I\u0018aB2p]\u001aLw\rI\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\"!a\u0003\u0011\u0007i\fi!C\u0002\u0002\u0010m\u0014\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%\u0001\u0004u[B$\u0015N]\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;i\u0015AA5p\u0013\u0011\t\t#a\u0007\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fHcA*\u0002(!AqkEA\u0001\u0002\u0004\t9\"A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003)awn\u001a#je~#S-\u001d\u000b\u0004'\u0006E\u0002\u0002C,\u0017\u0003\u0003\u0005\r!a\u0006\u0002\u000f1|w\rR5sA\u0005AQn\\2l)&lW-\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@]\nQ!\u001e;jYNLA!a\u0011\u0002>\tAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u0005IB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z+\t\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t&N\u0001\u0006gR\fG/Z\u0005\u0005\u0003+\nyEA\rUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JL\u0018A\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pef\u0004\u0013!\u0005;jKJdunZ\"p[B|g.\u001a8ugV\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M\u001c\u0002\u00071|w-\u0003\u0003\u0002h\u0005\u0005$!\u0005+jKJdunZ\"p[B|g.\u001a8ug\u0006\u0011B/[3s\u0019><7i\\7q_:,g\u000e^:!\u0003I!(/\u00198tSRLwN\\,bSR$\u0016.\\3\u0016\u0005\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005UT,\u0001\u0005ekJ\fG/[8o\u0013\u0011\tI(a\u001d\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0019BO]1og&$\u0018n\u001c8XC&$H+[7fA\u0005\u0019B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgV\u0011\u0011\u0011\u0011\t\u0007\u0011\u0006\re-a\"\n\u0007\u0005\u0015\u0015JA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!!\u0014\u0002\n&!\u00111RA(\u0005I!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0002)QLWM\u001d)beRLG/[8o'R\fG/Z:!\u0003=!\u0018.\u001a:UCN\\7oQ8oM&<WCAAJ!\u0011\t)*a&\u000e\u0003MJ1!!'4\u0005=!\u0016.\u001a:UCN\\7oQ8oM&<\u0017\u0001\u0005;jKJ$\u0016m]6t\u0007>tg-[4!\u0003\u0015\u0019X\r^;q)\u0005\u0019\u0006f\u0001\u0013\u0002$B!\u0011QUA\\\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016aA1qS*!\u0011QVAX\u0003\u001dQW\u000f]5uKJTA!!-\u00024\u0006)!.\u001e8ji*\u0011\u0011QW\u0001\u0004_J<\u0017\u0002BA]\u0003O\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007fA\u0013\u0002@B!\u0011QUAa\u0013\u0011\t\u0019-a*\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u00077pOB\u0013xN^5eS:<'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014HCBAe\u0003\u001f\f\t\u000eE\u0002{\u0003\u0017L1!!4|\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQ\u0001\u001a\u0014A\u0002\u0019Dq!a5'\u0001\u0004\t).A\u0006bEN$(/Y2u\u0019><\u0007\u0003BA0\u0003/LA!!7\u0002b\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003a\u0019'/Z1uKRKWM\u001d)beRLG/[8o'R\fG/\u001a\u000b\r\u0003\u000f\u000by.!9\u0002l\u0006U\u0018\u0011 \u0005\u0006I\u001e\u0002\rA\u001a\u0005\b\u0003G<\u0003\u0019AAs\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYB\u0019!0a:\n\u0007\u0005%8P\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\b\u0003[<\u0003\u0019AAx\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$\u0007c\u0001\u001f\u0002r&\u0019\u00111_\u001f\u0003\u000f\t{w\u000e\\3b]\"9\u0011q_\u0014A\u0002\u0005=\u0018AD2p[B\f7\r^#oC\ndW\r\u001a\u0005\b\u0003w<\u0003\u0019AAx\u00039\u0019G.Z1okB,e.\u00192mK\u0012\u0014A#T8dWRKWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148#\u0002\u0015\u0003\u0002\t5\u0001\u0003\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\u0007\t\u001dQ*\u0001\u0003mC:<\u0017\u0002\u0002B\u0006\u0005\u000b\u0011aa\u00142kK\u000e$\b\u0003\u0002B\b\u0005+i!A!\u0005\u000b\u0007\tMQ'A\u0003u_BL7-\u0003\u0003\u0003\u0018\tE!!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feR\u0011!1\u0004\t\u0004\u0005;AS\"\u0001\u0001\u0002\u0017\u0005$G-T3uC\u0012\fG/\u0019\u000b\u0005\u0005G\u00119\u0004E\u0003I\u0005K\u0011I#C\u0002\u0003(%\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\u0011YC!\r\u000f\t\u00055#QF\u0005\u0005\u0005_\ty%\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017\u0002\u0002B\u001a\u0005k\u0011A\"\u00119qK:$'+Z:vYRTAAa\f\u0002P!9!\u0011\b\u0016A\u0002\tm\u0012!B3oiJL\b\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\u0007\t\u0005S'\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005\u000b\u0012yD\u0001\u000bBEN$(/Y2u)&,'/T3uC\u0012\fG/Y\u0001\bSN\u0014V-\u00193z)\t\ty/A\fuKN$\u0018I]2iSZ,G+Y:l\u000b6\u0004H/\u001f'pOR91Ka\u0014\u0003R\tM\u0003bBAwY\u0001\u0007\u0011q\u001e\u0005\b\u0003od\u0003\u0019AAx\u0011\u001d\tY\u0010\fa\u0001\u0003_Ds\u0001\fB,\u0005O\u0012I\u0007\u0005\u0003\u0003Z\t\rTB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0011A\u0014xN^5eKJTAA!\u0019\u0002,\u00061\u0001/\u0019:b[NLAA!\u001a\u0003\\\tI1i\u001d<T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\t\u0005W\u0012yGa\u001d\u0003x\u0005\u0012!QN\u0001\u0012M\u0006d7/\u001a\u0017gC2\u001cX\r\f4bYN,\u0017E\u0001B9\u0003A1\u0017\r\\:fYQ\u0014X/\u001a\u0017gC2\u001cX-\t\u0002\u0003v\u0005\u0001BO];fY\u0019\fGn]3-M\u0006d7/Z\u0011\u0003\u0005s\nq\u0002\u001e:vK2\"(/^3-M\u0006d7/\u001a\u0015\u0004Y\tu\u0004\u0003\u0002B@\u0005\u0003k!Aa\u0018\n\t\t\r%q\f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018a\t;fgR\f%o\u00195jm\u0016$\u0016m]6Va2|\u0017\rZ:Qe>$WoY3s'R\fG/\u001a\u000b\b'\n%%1\u0012BG\u0011\u001d\ti/\fa\u0001\u0003_Dq!a>.\u0001\u0004\ty\u000fC\u0004\u0002|6\u0002\r!a<)\u000f5\u00129Fa\u001a\u0003\u00122B!1\u000eB8\u0005g\u00129\bK\u0002.\u0005{\nA\u0006^3ti\u0006\u00138\r[5wKJ\u0014V\r\u001e:jKN|enQ8oGV\u0014(/\u001a8u\t\u0016dW\r^3SK\u000e|'\u000fZ:\u0015\u000fM\u0013IJa'\u0003\u001e\"9\u0011Q\u001e\u0018A\u0002\u0005=\bbBA|]\u0001\u0007\u0011q\u001e\u0005\b\u0003wt\u0003\u0019AAxQ\u001dq#q\u000bB4\u0005Cc\u0003Ba\u001b\u0003p\tM$q\u000f\u0015\u0004]\tu\u0014\u0001\u000b;fgR\f%o\u00195jm\u0016\u0014X\t_2faRLwN\\(o!\u0006\u0014H/\u001b;j_:$U\r\\3uS>tGcB*\u0003*\n-&Q\u0016\u0005\b\u0003[|\u0003\u0019AAx\u0011\u001d\t9p\fa\u0001\u0003_Dq!a?0\u0001\u0004\ty\u000fK\u00040\u0005/\u00129G!--\u0011\t-$q\u000eB:\u0005oB3a\fB?Q\u001d\u0001!q\u0017B4\u0005{\u0003B!!*\u0003:&!!1XAT\u0005\r!\u0016mZ\u0011\u0003\u0005\u007f\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ArchiveTaskIntegrationTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private TopicIdPartition topicIdPartition;
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private File tmpDir;
    private File logDir;
    private final MockTime mockTime = new MockTime();
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, this.tierPartitionStateFactory());
    private final FiniteDuration transitionWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private final ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates = new ConcurrentHashMap();
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, TierTasksConfig$.MODULE$.$lessinit$greater$default$4(), TierTasksConfig$.MODULE$.$lessinit$greater$default$5(), TierTasksConfig$.MODULE$.$lessinit$greater$default$6(), TierTasksConfig$.MODULE$.$lessinit$greater$default$7(), TierTasksConfig$.MODULE$.$lessinit$greater$default$8(), TierTasksConfig$.MODULE$.$lessinit$greater$default$9());

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public FiniteDuration transitionWaitTime() {
        return this.transitionWaitTime;
    }

    public ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    @BeforeEach
    public void setup() {
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.executor_$eq(Executors.newFixedThreadPool(1));
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        TopicPartition topicPartition = MergedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        this.topicIdPartition_$eq(new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.executor().shutdownNow();
        this.brokerTopicStats().close();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.tierPartitionStates().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            ArchiveTaskIntegrationTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        this.tierPartitionStates().clear();
        Utils.delete((File)this.tmpDir());
        Utils.delete((File)this.logDir());
    }

    private ReplicaManager logProvidingReplicaManager(TopicIdPartition topicIdPartition, AbstractLog abstractLog) {
        return (ReplicaManager)Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)abstractLog)).getMock();
    }

    private TierPartitionState createTierPartitionState(TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(TestUtils$.MODULE$.tempDir(), logDirFailureChannel, topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled, compactEnabled, cleanupEnabled, (Time)this.mockTime());
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates().put(topicIdPartition, (TierPartitionState)tierPartitionState);
        return tierPartitionState;
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false"})
    public void testArchiveTaskEmptyLog(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        int x$1 = 0x500000;
        boolean x$2 = true;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$2, x$13, x$14, x$15, x$16, x$17);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$22 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$22, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        ArchiveTask nextState = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertTrue((boolean)(nextState.state() instanceof BeforeUpload), (String)"expected to be in BeforeUpload");
        Assertions.assertFalse((boolean)nextState.ctx().isCancelled(), (String)"expected task to not be cancelled");
        Assertions.assertEquals((Integer)tierObjectStore.getObjectCounts().getOrDefault(TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0)), (int)0, (String)"expected zero segments to be uploaded");
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false"})
    public void testArchiveTaskUploadsProducerState(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        int x$12 = 1024;
        long x$22 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$122 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$22, x$12, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$222 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$222, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        long pid1 = 1L;
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$34 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$36 = 0;
            byte x$38 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$39 = TestUtils$.MODULE$.records$default$3();
            long x$40 = TestUtils$.MODULE$.records$default$7();
            int x$41 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$34, x$38, x$39, pid1, x$36, i, x$40, x$41), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$1.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size(), (String)"expected 5 local log segments");
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size(), (String)"expected 4 tierable segments");
        List snapshotFiles = (List)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(log.producerStateManager().snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)x$2))), List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)4, (int)snapshotFiles.size(), (String)"expected to be able to use segment base offset to get snapshot files for 4 segments");
        ArchiveTask maybeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload.state().getClass(), (String)"expected successful transition to Upload");
        ArchiveTask maybeAfterUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(AfterUpload.class, maybeAfterUpload.state().getClass(), (String)"expected successful transition to afterUpload");
        ConcurrentHashMap objectCounts = tierObjectStore.getObjectCounts();
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.SEGMENT)), (String)"expected 1 segment file");
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.PRODUCER_STATE)), (String)"expected 1 producer state");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)maybeAfterUpload.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime())).state() instanceof BeforeUpload), (String)"expected successful transition to beforeUpload");
        Assertions.assertEquals((int)tierPartitionState.numSegments(), (int)1, (String)"expected 1 segment to be materialized");
        Assertions.assertTrue((boolean)((TierLogSegment)tierPartitionState.metadata(0L).get()).metadata().hasProducerState(), (String)"expected hasProducerState metadata flag to be set");
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false"})
    public void testArchiverRetriesOnConcurrentDeleteRecords(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        int x$1 = 1024;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$22 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$22, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$34 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$36 = 0;
            byte x$38 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$39 = TestUtils$.MODULE$.records$default$3();
            long x$40 = TestUtils$.MODULE$.records$default$7();
            int x$41 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$34, x$38, x$39, pid1, x$36, i, x$40, x$41), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$2.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        ArchiveTask maybeUpload_1 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        File segmentFileBeingUploaded = ((Upload)maybeUpload_1.state()).uploadableSegment().logSegmentFile();
        Assertions.assertEquals(Upload.class, maybeUpload_1.state().getClass());
        Assertions.assertEquals((Object)segmentFileBeingUploaded, (Object)((LogSegment)log.localLogSegments().head()).log().file());
        LogSegment newFirstSegment = (LogSegment)log.localLogSegments().toList().apply(3);
        File newFirstSegmentFile = newFirstSegment.log().file();
        log.maybeIncrementLogStartOffset(newFirstSegment.baseOffset() + 3L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        log.deleteOldSegments();
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        ArchiveTask maybeUpload_2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload_2.state().getClass());
        Assertions.assertEquals((Object)newFirstSegmentFile, (Object)((Upload)maybeUpload_2.state()).uploadableSegment().logSegmentFile());
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false"})
    public void testArchiverExceptionOnPartitionDeletion(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        int x$1 = 1024;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$22 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$22, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$34 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$36 = 0;
            byte x$38 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$39 = TestUtils$.MODULE$.records$default$3();
            long x$40 = TestUtils$.MODULE$.records$default$7();
            int x$41 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$34, x$38, x$39, pid1, x$36, i, x$40, x$41), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$3.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        log.renameDir(MergedLog$.MODULE$.logDeleteDirName(this.topicIdPartition().topicPartition()));
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        Predef$.MODULE$.assert(ctx.isCancelled());
        tierPartitionState.delete();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(TierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public class MockTierTopicManager
    implements TierTopicAppender {
        public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
            TierPartitionState tierPartitionState = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().topicIdPartition());
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState.append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch())))).toCompletableFuture();
        }

        public boolean isReady() {
            return true;
        }

        public /* synthetic */ ArchiveTaskIntegrationTest kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer() {
            return ArchiveTaskIntegrationTest.this;
        }

        public MockTierTopicManager() {
            if (ArchiveTaskIntegrationTest.this == null) {
                throw null;
            }
        }
    }
}

