/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.ChecksumMigration;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateTest;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\r\u001a\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000b\u0001\u0005B%BQ\u0001\r\u0001\u0005B%BQ!\r\u0001\u0005B%BQA\r\u0001\u0005\nMBQa\u0015\u0001\u0005\u0002QCQA\u0019\u0001\u0005\u0002QCQ\u0001\u001a\u0001\u0005\n\u0015DQa\u001f\u0001\u0005\u0002QCQ! \u0001\u0005\u0002QCQa \u0001\u0005\u0002QCa!a\u0001\u0001\t\u0003!\u0006BBA\u0004\u0001\u0011\u0005A\u000b\u0003\u0004\u0002\f\u0001!\t\u0001\u0016\u0005\u0007\u0003\u001f\u0001A\u0011\u0001+\t\r\u0005M\u0001\u0001\"\u0001U\u0011\u0019\t9\u0002\u0001C\u0001)\"1\u00111\u0004\u0001\u0005\u0002QCa!a\b\u0001\t\u0003!\u0006BBA\u0012\u0001\u0011\u0005A\u000b\u0003\u0004\u0002(\u0001!\t\u0001\u0016\u0005\u0007\u0003W\u0001A\u0011\u0001+\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\tAc)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XmQ8na\u0006\u001cG/\u00128bE2,G\rV3ti*\u0011!dG\u0001\u0006gR\fG/\u001a\u0006\u00039u\tA\u0001^5fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012$\u001b\u0005I\u0012B\u0001\u0013\u001a\u0005i1\u0015\u000e\\3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002#\u0001\u0005y1\r[3dWN,X.\u00128bE2,G-F\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u001d\u0011un\u001c7fC:\fabY8na\u0006\u001cG/\u00128bE2,G-\u0001\bdY\u0016\fg.\u001e9F]\u0006\u0014G.\u001a3\u00027\r|W\u000e]1sKRKWM]*uCR,g)\u001b7fg\"+G\u000e]3s)!!t'\u0011$L\u001b>\u000b\u0006CA\u00166\u0013\t1DF\u0001\u0003V]&$\b\"\u0002\u001d\u0006\u0001\u0004I\u0014\u0001D8mI\u0006cwm\u001c:ji\"l\u0007C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003!\u0019\u0007.Z2lgVl'B\u0001 \u001e\u0003\u0015)H/\u001b7t\u0013\t\u00015HA\u0005BY\u001e|'/\u001b;i[\")!)\u0002a\u0001\u0007\u0006aq\u000e\u001c3US\u0016\u0014X\t]8dQB\u00111\u0006R\u0005\u0003\u000b2\u00121!\u00138u\u0011\u00159U\u00011\u0001I\u00031yG\u000eZ#oI>3gm]3u!\tY\u0013*\u0003\u0002KY\t!Aj\u001c8h\u0011\u0015aU\u00011\u0001:\u00031qWm^!mO>\u0014\u0018\u000e\u001e5n\u0011\u0015qU\u00011\u0001D\u00031qWm\u001e+jKJ,\u0005o\\2i\u0011\u0015\u0001V\u00011\u0001I\u00031qWm^#oI>3gm]3u\u0011\u0015\u0011V\u00011\u0001+\u0003\u0019\u0011Xm];mi\u0006IB/Z:u\u0007>l\u0007/\u0019:f)&,'o\u0015;bi\u00164\u0015\u000e\\3t)\u0005!\u0004F\u0001\u0004W!\t9\u0006-D\u0001Y\u0015\tI&,A\u0002ba&T!a\u0017/\u0002\u000f),\b/\u001b;fe*\u0011QLX\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005D&\u0001\u0002+fgR\fa\u0002^3tiB\u0013x\u000e]3si&,7\u000f\u000b\u0002\b-\u0006Q\u0001O]8qKJ$\u0018.Z:\u0015\u0005\u0019t\u0007CA4m\u001b\u0005A'BA5k\u0003\u0011)H/\u001b7\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B8\t\u0001\u0004\u0001\u0018AD2iK\u000e\\7/^7D_:4\u0017n\u001a\t\u0003cbt!A\u001d<\u0011\u0005MdS\"\u0001;\u000b\u0005U|\u0012A\u0002\u001fs_>$h(\u0003\u0002xY\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9H&\u0001\u0011sK\u0006$wK]5uK\"+\u0017\rZ3s\u001f:d\u0017pV5uQ6KwM]1uS>t\u0007FA\u0005W\u0003Q!Xm\u001d;WC2LG-\u0019;f\u0007\",7m[:v[\"\u0012!BV\u0001\u000ei\u0016\u001cHoQ8na\u0006\u001cG/\u001a3)\u0005-1\u0016!\u0006;fgR\u001cu.\u001c9bGRLwN\u001c$f]\u000eLgn\u001a\u0015\u0003\u0019Y\u000b\u0011\u0005^3ti\u000e{W\u000e]1di&|gnQ8oGV\u0014(/\u001a8u\t\u0016dW\r^5p]ND#!\u0004,\u0002SQ,7\u000f\u001e$f]\u000e,\u0007K]5pe\u000e{W\u000e]1di\u0016$\u0017J\\5uS\u0006$XmV5uQ\u000e{W.\\5uQ\tqa+A\u0016uKN$8i\\7qC\u000e$\u0018n\u001c8Va2|\u0017\rZ%oSRL\u0017\r^3DQ\u0006Lg.\u001b8h'V\u001c7-Z:tQ\tya+A uKN$8i\\7qC\u000e$\u0018n\u001c8Va2|\u0017\rZ%oSRL\u0017\r^3DQ\u0006Lg.\u001b8h!J,g/[8vg>\u0013'.Z2u\u0013\u0012tu\u000e^#ya\u0016\u001cG/\u001a3)\u0005A1\u0016a\u0010;fgR\u001cu.\u001c9bGRLwN\\+qY>\fG-\u00138ji&\fG/Z\"iC&t\u0017N\\4Qe\u00164\u0018n\\;t\u001f\nTWm\u0019;JI:{G/T1uG\"Lgn\u001a\u0015\u0003#Y\u000bq\u0006^3tiV\u0003Hn\\1e\u0013:LG/[1uK\u000eC\u0017-\u001b8j]\u001e,\u0006\u000f\\8bIRK\b/\u001a(pi6\u000bGo\u00195j]\u001eD#A\u0005,\u0002mQ,7\u000f^\"p[B\f7\r^5p]V\u0003Hn\\1e\u0007>lW.\u001b;B]\u0012\u001cv/\u00199GK:\u001c\u0017N\\4Va2|\u0017\rZ%oSRL\u0017\r^3)\u0005M1\u0016!\u0010;fgR\u001cu.\u001c9bGRLwN\\+qY>\fGmQ8n[&$\u0018I\u001c3To\u0006\u0004x+\u001b;i\u001d>tW\t_5ti&twmU8ve\u000e,wJ\u00196fGR\u001c\bF\u0001\u000bW\u0003}\"Xm\u001d;D_6\u0004\u0018m\u0019;j_:,\u0006\u000f\\8bI\u000e{W.\\5u\u0003:$7k^1q/&$\bNT8o\u0007>tG/[4v_V\u001c8k\\;sG\u0016|%M[3diND#!\u0006,\u0002mQ,7\u000f^\"p[B\f7\r^5p]V\u0003Hn\\1e\u0007>lW.\u001b;B]\u0012\u001cv/\u00199XSRD\u0017*\u001c9pgNL'\r\\3PM\u001a\u001cX\r^:)\u0005Y1\u0016aD2iK\u000e\\\u0017J\u001c<be&\fg\u000e^:\u0015\u0007Q\n\u0019\u0004\u0003\u0004\u001b/\u0001\u0007\u0011Q\u0007\t\u0004E\u0005]\u0012bAA\u001d3\t\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0001")
public class FileTierPartitionStateCompactEnabledTest
extends FileTierPartitionStateTest {
    @Override
    public boolean checksumEnabled() {
        return true;
    }

    @Override
    public boolean compactEnabled() {
        return true;
    }

    @Override
    public boolean cleanupEnabled() {
        return true;
    }

    private void compareTierStateFilesHelper(Algorithm oldAlgorithm, int oldTierEpoch, long oldEndOffset, Algorithm newAlgorithm, int newTierEpoch, long newEndOffset, boolean result) {
        Path oldPath = new File(new StringBuilder(8).append("testFile").append(oldAlgorithm.suffix).toString()).toPath();
        Path newPath = new File(new StringBuilder(8).append("testFile").append(newAlgorithm.suffix).toString()).toPath();
        this.writeHeader$1(oldPath, oldAlgorithm, oldTierEpoch, oldEndOffset);
        this.writeHeader$1(newPath, newAlgorithm, newTierEpoch, newEndOffset);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)result), (Object)BoxesRunTime.boxToBoolean((boolean)ChecksumMigration.compareTierStateFiles((Path)oldPath, (Path)newPath)));
        Files.delete(oldPath);
        Files.delete(newPath);
    }

    @Test
    public void testCompareTierStateFiles() {
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 5, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 3, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(5, 30L, 3, 20L, false);
    }

    @Test
    public void testProperties() {
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("none, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, none")));
        java.util.List checksumFiles = KafkaConfig$.MODULE$.fromProps(this.properties("tierstate")).confluentConfig().checksumEnabledFiles();
        Assertions.assertEquals((int)1, (int)checksumFiles.size());
        Assertions.assertTrue((boolean)checksumFiles.contains("tierstate"));
    }

    /*
     * WARNING - void declaration
     */
    private Properties properties(String checksumConfig) {
        void var2_2;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "somewhere", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("confluent.checksum.enabled.files", checksumConfig);
        return var2_2;
    }

    @Test
    public void readWriteHeaderOnlyWithMigration() {
        Path flushedPath = Paths.get(this.state().flushedPath(), new String[0]);
        Path adlerChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.ADLER, (Path)flushedPath);
        Path nonChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.NO_CHECKSUM, (Path)flushedPath);
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)9, (int)this.state().tierEpoch());
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(false), (Time)this.time());
        Assertions.assertTrue((boolean)Files.notExists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void testValidateChecksum() {
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        int numSegments = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch, UUID.randomUUID(), i * 2, i * 2 + 1, 100);
            size$1.elem += i;
        });
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
    }

    @Test
    public void testCompacted() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        File parentDir = TestUtils$.MODULE$.tempDir();
        File dir = TestUtils$.MODULE$.randomPartitionLogDir(parentDir);
        TopicPartition tp = MergedLog$.MODULE$.parseTopicPartitionName(dir);
        TopicIdPartition tpid = new TopicIdPartition(tp.topic(), UUID.randomUUID(), tp.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        FileTierPartitionState state = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, this.cleanupEnabled(), (Time)this.time());
        state.setTopicId(tpid.topicId());
        state.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$2(op, state)));
                return;
            }
        });
        state.beginCatchup();
        state.onCatchUpComplete();
        ListBuffer rawObjectIds = new ListBuffer();
        state.append((AbstractTierMetadata)new TierTopicInitLeader(tpid, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(tpid, epoch, (UUID)rawObjectIds.last(), (long)offset$1.elem, (long)(offset$1.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadComplete(tpid, epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$1.elem += 2;
        });
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsToCompact = 3;
        List segmentsToClean = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)20, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).size());
        java.util.Set compactedObjectIds = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadata().objectId(), List$.MODULE$.canBuildFrom())).toSet()).asJava();
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(tpid, epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, compactedObjectIds, newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsAfter = numSegments - numSegmentsToCompact + 1;
        Assertions.assertEquals((int)numSegmentsAfter, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).size());
        Assertions.assertEquals((long)50L, (long)((TierLogSegment)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).next()).firstBatchTimestamp());
        Assertions.assertEquals((Object)compactInitiate.objectId(), (Object)((TierLogSegment)state.metadata(0L).get()).objectId());
        Assertions.assertEquals((Object)compactInitiate.objectId(), (Object)((TierLogSegment)state.metadata(3L).get()).objectId());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(compactedObjectIds).asScala()).toSet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state.compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        this.checkInvariants((TierPartitionState)state);
        ((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state.compactedSegments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$8(this, state, tpid, epoch, deletableSegment);
            return BoxedUnit.UNIT;
        });
        List segmentsToClean2 = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).slice(numSegmentsToCompact, numSegmentsToCompact + 2).toList();
        long firstBatchTimestamp2 = 50L;
        UUID newObjectId2 = UUID.randomUUID();
        long newBaseOffset2 = ((TierLogSegment)segmentsToClean2.head()).baseOffset();
        long newEndOffset2 = ((TierLogSegment)segmentsToClean2.last()).endOffset();
        long newMaxTimestamp2 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize2 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean2.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset2 = state.lastLocalMaterializedSrcOffsetAndEpoch();
        TierSegmentUploadInitiate compactInitiate2 = new TierSegmentUploadInitiate(tpid, epoch, newObjectId2, newBaseOffset2, newEndOffset2, newMaxTimestamp2, firstBatchTimestamp2, newSize2, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset2, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        TierTestUtils$.MODULE$.verifyFtpsEntries(state, null, null, this.cleanupEnabled(), this.time().milliseconds());
        List segments = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).toList();
        scala.collection.immutable.Set segmentsDeleted = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(TierTestUtils$.MODULE$.deletedSegments(state, TierTestUtils$.MODULE$.deletedSegments$default$2())).asScala()).toSet();
        state.close();
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, (List<TierLogSegment>)segments, (scala.collection.immutable.Set<UUID>)segmentsDeleted, this.cleanupEnabled(), this.time().milliseconds());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler(), false, this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());){
            reopenedState.checkInvariants();
            Assertions.assertEquals((int)numSegmentsAfter, (int)reopenedState.numSegments());
            Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(reopenedState.segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)reopenedState.totalSize());
            Assertions.assertEquals((long)50L, (long)((TierLogSegment)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(reopenedState.segments()).asScala()).next()).firstBatchTimestamp());
            Assertions.assertEquals((long)6L, (long)reopenedState.compactDirtyStartOffset());
            java.util.Set compactedObjectIds2 = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)segmentsToClean2.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.metadata().objectId(), List$.MODULE$.canBuildFrom())).toSet()).asJava();
            UUID completeMessageId2 = UUID.randomUUID();
            TierCompactionCommitAndSwap compactComplete2 = new TierCompactionCommitAndSwap(compactInitiate2, completeMessageId2, compactedObjectIds2, newEndOffset2, new CompactStats((long)newSize2, (long)newSize2, (long)newSize2));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)compactComplete2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.cleanupEnabled(), this.time().milliseconds());
            reopenedState.checkInvariants();
            Assertions.assertEquals((long)14L, (long)reopenedState.compactDirtyStartOffset());
            Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(compactedObjectIds2).asScala()).toSet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(reopenedState.compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        }
        state.close();
        dir.delete();
        parentDir.delete();
    }

    @Test
    public void testCompactionFencing() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$2.elem, (long)(offset$2.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$2.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertTrue((boolean)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet().contains((Object)compactInitiate.objectId()), (String)"compact initial segment should have been fenced");
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
    }

    @Test
    public void testCompactionConcurrentDeletions() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$3.elem, (long)(offset$3.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$3.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        TierLogSegment deletableSegment = (TierLogSegment)segmentsToClean.head();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.checkInvariants((TierPartitionState)this.state());
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.objectId(), List$.MODULE$.canBuildFrom())).toSet()).asJava(), newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testFencePriorCompactedInitiateWithCommit() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 50L, 10);
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)30L, (long)this.state().totalSize());
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        HashSet<UUID> compactedObjects = new HashSet<UUID>();
        compactedObjects.add(objectId1);
        compactedObjects.add(objectId2);
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        UUID objectIdCompacted = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectIdCompacted, 0L, 50L, 100L, 100L, 10, false, false, false, TierUploadType.Compaction, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, stateOffset, UUID.randomUUID(), compactedObjects, new HashSet(), 150L, new CompactStats(30L, 10L, 30L)), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)objectIdCompacted, (Object)((TierLogSegment)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).head()).objectId());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)151L, (long)this.state().compactDirtyStartOffset());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        this.deleteInitiateAndComplete(0, objectId1, this.time().milliseconds());
        this.deleteInitiateAndComplete(0, objectId2, this.time().milliseconds());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testCompactionUploadInitiateChainingSuccess() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 9L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.of(objectId4), 6L, 10L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotExpected() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.of(objectId4), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testUploadInitiateChainingUploadTypeNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)0, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapFencingUploadInitiate() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        new HashSet<UUID>().add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        HashSet<UUID> destObjects2 = new HashSet<UUID>();
        destObjects2.add(objectId5);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects2, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)3, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonExistingSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 20L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().appendUnhandled((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)2, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)2, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonContiguousSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId4);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 40L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithImpossibleOffsets() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        this.uploadInitateAndComplete(0, objectId5, 41L, 50L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId3);
        sourceObjects.add(objectId4);
        UUID objectId6 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId6);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId6, Optional.empty(), 0L, 41L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), this.cleanupEnabled(), (Time)this.time());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)5, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    public void checkInvariants(TierPartitionState state) {
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)state.totalSize());
        List objectIds = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.objectId()).toList();
        Assertions.assertTrue((boolean)((SetLike)objectIds.toSet().intersect((GenSet)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state.compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet())).isEmpty(), (String)"No compacted segment should be in segments list");
        Assertions.assertEquals((int)objectIds.size(), (int)objectIds.toSet().size(), (String)"segments should not be contained in log view twice");
    }

    private static final short superBlockLen$1(Algorithm algorithm) {
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            return 512;
        }
        return 0;
    }

    private final Header header$1(int tierEpoch, long endOffset) {
        return new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.INIT, -1L, endOffset, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY);
    }

    private final void writeHeader$1(Path path, Algorithm algorithm, int tierEpoch, long endOffset) {
        short superBlockLength = FileTierPartitionStateCompactEnabledTest.superBlockLen$1(algorithm);
        Files.deleteIfExists(path);
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        CheckedFileIO channel = CheckedFileIO.open((Path)path, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        FileTierPartitionState.writeHeader((CheckedFileIO)channel, (Header)this.header$1(tierEpoch, endOffset));
        channel.flush();
        Assertions.assertEquals((int)tierEpoch, (int)((Header)FileTierPartitionState.readHeader((CheckedFileIO)channel).get()).tierEpoch());
        channel.close();
    }

    private final void checkDifferentAlgorithmCombinations$1(int oldTierEpoch, long oldEndOffset, int newTierEpoch, long newEndOffset, boolean result) {
        new .colon.colon((Object)new Tuple2((Object)Algorithm.ADLER, (Object)Algorithm.NO_CHECKSUM), (List)new .colon.colon((Object)new Tuple2((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.ADLER), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)algo -> {
            this.compareTierStateFilesHelper((Algorithm)algo._1(), oldTierEpoch, oldEndOffset, (Algorithm)algo._2(), newTierEpoch, newEndOffset, result);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCompacted$2(TierPartitionState.RecoveryOperation op$1, FileTierPartitionState state$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append(state$1.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompacted$8(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState state$1, TopicIdPartition tpid$1, int epoch$2, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
    }
}

