/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import kafka.tier.fetcher.CancellationContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CancellationContextTest {
    @Test
    public void cancellationChain() {
        CancellationContext rootContext = CancellationContext.newContext();
        CancellationContext l1 = rootContext.subContext();
        CancellationContext l2 = l1.subContext();
        CancellationContext l3 = l2.subContext();
        l3.cancel();
        Assertions.assertTrue((boolean)l3.isCancelled(), (String)"Canceling a context works");
        Assertions.assertFalse((boolean)l2.isCancelled(), (String)"Canceling the lowest context does not cancel the higher contexts");
    }

    @Test
    public void testCancellationWithMultipleChildren() {
        CancellationContext rootContext = CancellationContext.newContext();
        CancellationContext l1 = rootContext.subContext();
        CancellationContext l2 = rootContext.subContext();
        CancellationContext l3 = rootContext.subContext();
        l2.cancel();
        Assertions.assertFalse((boolean)rootContext.isCancelled());
        Assertions.assertFalse((boolean)l1.isCancelled());
        Assertions.assertTrue((boolean)l2.isCancelled());
        Assertions.assertFalse((boolean)l3.isCancelled());
        rootContext.cancel();
        Assertions.assertTrue((boolean)rootContext.isCancelled());
        Assertions.assertTrue((boolean)l1.isCancelled());
        Assertions.assertTrue((boolean)l2.isCancelled());
        Assertions.assertTrue((boolean)l2.isCancelled());
    }
}

