/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupobjectlifecycle;

import com.google.cloud.storage.StorageException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupobjectlifecycle.ObjectStoreUtils;
import kafka.tier.backupobjectlifecycle.ObjectStoreUtilsContext;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00046\u0001\u0001\u0006I!\f\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0011\u0019a\u0004\u0001)A\u0005q!9Q\b\u0001b\u0001\n\u0003q\u0004BB#\u0001A\u0003%q\bC\u0004G\u0001\t\u0007I\u0011A$\t\rY\u0003\u0001\u0015!\u0003I\u0011\u001d9\u0006A1A\u0005\u0002aCaa\u0018\u0001!\u0002\u0013I\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007e\u0002\u0001\u000b\u0011\u00022\t\u000fM\u0004!\u0019!C\u0001i\"1\u0011\u0010\u0001Q\u0001\nUDqA\u001f\u0001C\u0002\u0013\u00051\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\n\u0003\u0003\u0001!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t\t\u0004\u0001C\u0001\u0003\u001fAq!!\u000e\u0001\t\u0003\ty\u0001C\u0004\u0002:\u0001!\t!a\u0004\u0003)=\u0013'.Z2u'R|'/Z+uS2\u001cH+Z:u\u0015\tQ2$A\u000bcC\u000e\\W\u000f]8cU\u0016\u001cG\u000f\\5gK\u000eL8\r\\3\u000b\u0005qi\u0012\u0001\u0002;jKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003e\tA!^;jIV\tQ\u0006\u0005\u0002/g5\tqF\u0003\u00021c\u0005!Q\u000f^5m\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\tU+\u0016\nR\u0001\u0006kVLG\rI\u0001\u0005iBLE-F\u00019!\tI$(D\u0001\u001c\u0013\tY4D\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006)A\u000f]%eA\u0005YqN\u00196fGR\u001cFo\u001c:f+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u001c\u0003\u0015\u0019Ho\u001c:f\u0013\t!\u0015IA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u00031y'M[3diN#xN]3!\u0003\u0015\u0001(o\u001c9t+\u0005A\u0005\u0003\u0002\u0018J\u0017.K!AS\u0018\u0003\u000f!\u000b7\u000f['baB\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u0012\u000e\u0003=S!\u0001U\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u00116%\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*$\u0003\u0019\u0001(o\u001c9tA\u00051!-\u001e4gKJ,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039F\n1A\\5p\u0013\tq6L\u0001\u0006CsR,')\u001e4gKJ\fqAY;gM\u0016\u0014\b%\u0001\u0007lKf\u001cHk\u001c#fY\u0016$X-F\u0001c!\rq3-Z\u0005\u0003I>\u0012\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u0005\u0019|gBA4n\u001d\tAGN\u0004\u0002jW:\u0011aJ[\u0005\u0002=%\u0011A$H\u0005\u0003\u0005nI!A\\!\u0002\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016L!\u0001]9\u0003\u001b-+\u00170\u00118e-\u0016\u00148/[8o\u0015\tq\u0017)A\u0007lKf\u001cHk\u001c#fY\u0016$X\rI\u0001\f_\nTW*\u001a;bI\u0006$\u0018-F\u0001v!\t1xO\u0004\u0002A[&\u0011\u00010\u001d\u0002\u0014\u001f\nTWm\u0019;Ti>\u0014X-T3uC\u0012\fG/Y\u0001\r_\nTW*\u001a;bI\u0006$\u0018\rI\u0001\te\u0016\u001c\bo\u001c8tKV\tA\u0010\u0005\u0002A{&\u0011a0\u0011\u0002\u0018)&,'o\u00142kK\u000e$8\u000b^8sKJ+7\u000f]8og\u0016\f\u0011B]3ta>t7/\u001a\u0011\u0002\u0007\r$\b0\u0006\u0002\u0002\u0006A\u0019!&a\u0002\n\u0007\u0005%\u0011DA\fPE*,7\r^*u_J,W\u000b^5mg\u000e{g\u000e^3yi\u0006!1\r\u001e=!\u0003e!Xm\u001d;MSN$8)\u00197m%\u0016$(/\u001f'p_B,e\u000eZ:\u0015\u0005\u0005E\u0001c\u0001\u0012\u0002\u0014%\u0019\u0011QC\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0004)\u0005e\u0001\u0003BA\u000e\u0003[i!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0004CBL'\u0002BA\u0012\u0003K\tqA[;qSR,'O\u0003\u0003\u0002(\u0005%\u0012!\u00026v]&$(BAA\u0016\u0003\ry'oZ\u0005\u0005\u0003_\tiB\u0001\u0003UKN$\u0018a\t;fgRd\u0015n\u001d;DC2d'+\u001a;ss2{w\u000e]#ySR\u001cxJ\\*vG\u000e,7o\u001d\u0015\u0004+\u0005e\u0011\u0001\r;fgR|%M[3diN#xN]3DC2d'+\u001a;ss2{w\u000e]#ySR\u001c\u0018I\u001a;fe6\u000b\u0007PU3ue&,7\u000fK\u0002\u0017\u00033\t!\u0006^3ti>\u0013'.Z2u'R|'/Z\"bY2\u0014V\r\u001e:z\u0019>|\u0007/\u0012=jiN|enU;dG\u0016\u001c8\u000fK\u0002\u0018\u00033\u0001")
public class ObjectStoreUtilsTest {
    private final UUID uuid = UUID.randomUUID();
    private final TopicIdPartition tpId = new TopicIdPartition("foo", this.uuid(), 0);
    private final TierObjectStore objectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final HashMap<String, String> props;
    private final ByteBuffer buffer;
    private final ArrayList<TierObjectStore.KeyAndVersion> keysToDelete;
    private final TierObjectStore.ObjectStoreMetadata objMetadata;
    private final TierObjectStoreResponse response;
    private final ObjectStoreUtilsContext ctx;

    public UUID uuid() {
        return this.uuid;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public TierObjectStore objectStore() {
        return this.objectStore;
    }

    public HashMap<String, String> props() {
        return this.props;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public ArrayList<TierObjectStore.KeyAndVersion> keysToDelete() {
        return this.keysToDelete;
    }

    public TierObjectStore.ObjectStoreMetadata objMetadata() {
        return this.objMetadata;
    }

    public TierObjectStoreResponse response() {
        return this.response;
    }

    public ObjectStoreUtilsContext ctx() {
        return this.ctx;
    }

    @Test
    public void testListCallRetryLoopEnds() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)10))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testListCallRetryLoopExitsOnSuccess() {
        HashMap listResponse = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(listResponse);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)3))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsAfterMaxRetries() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean())));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)10))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.objectStore().putBuf(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (ByteBuffer)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new StorageException(100, "retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.putBuf((ObjectStoreUtilsContext)this.ctx(), (String)"key", this.props(), (ByteBuffer)this.buffer()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)10))).putBuf("key", this.props(), this.buffer());
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)10))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.getObject((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.objMetadata(), (TierObjectStore.FileType)TierObjectStore.FileType.BACKUP_OBJECTS_LIST));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)10))).getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsOnSuccess() {
        HashMap returnValue = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(returnValue);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean())));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.objectStore().putBuf(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (ByteBuffer)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new StorageException(100, "retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.putBuf((ObjectStoreUtilsContext)this.ctx(), (String)"key", this.props(), (ByteBuffer)this.buffer());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).putBuf("key", this.props(), this.buffer());
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<TierObjectStoreResponse>(this){
            private final /* synthetic */ ObjectStoreUtilsTest $outer;

            public TierObjectStoreResponse answer(InvocationOnMock invocation) {
                return this.$outer.response();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ObjectStoreUtils.getObject((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.objMetadata(), (TierObjectStore.FileType)TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
    }

    public ObjectStoreUtilsTest() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.GCS);
        this.props = new HashMap();
        this.buffer = (ByteBuffer)Mockito.mock(ByteBuffer.class);
        this.keysToDelete = new ArrayList();
        this.keysToDelete().add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        this.objMetadata = (TierObjectStore.ObjectStoreMetadata)Mockito.mock(TierObjectStore.ObjectStoreMetadata.class);
        this.response = (TierObjectStoreResponse)Mockito.mock(TierObjectStoreResponse.class);
        this.ctx = new ObjectStoreUtilsContext(this.objectStore(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false));
    }
}

