/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u0013%A\u0005\u0003\u0004,\u0001\u0001\u0006I!\n\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019!\u0004\u0001)A\u0005]!IQ\u0007\u0001a\u0001\u0002\u0004%IA\u000e\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\n\u0001C\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u001c\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u0003N\u0011%y\u0005\u00011A\u0001B\u0003&\u0011\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003`\u0001\u0011\u0005\u0011\u000bC\u0003e\u0001\u0011\u0005\u0011\u000bC\u0003g\u0001\u0011%q\rC\u0004\u0002\u0016\u0001!I!a\u0006\t\u000f\u00055\u0002\u0001\"\u0003\u00020\tqB+[3s\u001f\nTWm\u0019;HCJ\u0014\u0017mZ3D_2dWm\u0019;peR+7\u000f\u001e\u0006\u0003)U\tA\u0001^5fe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002'\u0005\u0001B/[3s)>\u0004\u0018nY'b]\u0006<WM]\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001fE\u0001\u0006i>\u0004\u0018nY\u0005\u0003U\u001d\u0012\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002#QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b%\u0001\u0003uS6,W#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E*\u0012!B;uS2\u001c\u0018BA\u001a1\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-F\u00018!\tAT(D\u0001:\u0015\tQ4(\u0001\u0005nKR\fG-\u0019;b\u0015\taT#\u0001\u0004tKJ4XM]\u0005\u0003}e\u0012!c\u0013*bMRlU\r^1eCR\f7)Y2iK\u0006\tR.\u001a;bI\u0006$\u0018mQ1dQ\u0016|F%Z9\u0015\u0005\u0005#\u0005C\u0001\u000eC\u0013\t\u00195D\u0001\u0003V]&$\bbB#\b\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u001bi&,'o\u00142kK\u000e$x)\u0019:cC\u001e,7i\u001c7mK\u000e$xN]\u000b\u0002\u0013B\u0011!ES\u0005\u0003\u0017N\u0011!\u0004V5fe>\u0013'.Z2u\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_J\fa\u0004^5fe>\u0013'.Z2u\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_J|F%Z9\u0015\u0005\u0005s\u0005bB#\u000b\u0003\u0003\u0005\r!S\u0001\u001ci&,'o\u00142kK\u000e$x)\u0019:cC\u001e,7i\u001c7mK\u000e$xN\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003\u0005C#\u0001D*\u0011\u0005QkV\"A+\u000b\u0005Y;\u0016aA1qS*\u0011\u0001,W\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ6,A\u0003kk:LGOC\u0001]\u0003\ry'oZ\u0005\u0003=V\u0013!BQ3g_J,W)Y2i\u0003\u0015\"Xm\u001d;NCf\u0014W\r\u0015:f\u0013:LG/[1uKB\u000b'\u000f^5uS>tG)\u001a7fi&|g\u000e\u000b\u0002\u000eCB\u0011AKY\u0005\u0003GV\u0013A\u0001V3ti\u0006IB/Z:u\u001b\u0006L(-\u001a#fY\u0016$X\rU1si&$\u0018n\u001c8tQ\tq\u0011-A\nde\u0016\fG/Z'fi\u0006$\u0017\r^1J[\u0006<W\r\u0006\u0003ic\u0006\u0015\u0001CA5p\u001b\u0005Q'BA6m\u0003\u0015IW.Y4f\u0015\t1RN\u0003\u0002o7\u00061\u0011\r]1dQ\u0016L!\u0001\u001d6\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u0015\u0011x\u00021\u0001t\u0003-!x\u000e]5d\u00136\fw-Z:\u0011\u0007QdxP\u0004\u0002vu:\u0011a/_\u0007\u0002o*\u0011\u0001pF\u0001\u0007yI|w\u000e\u001e \n\u0003qI!a_\u000e\u0002\u000fA\f7m[1hK&\u0011QP \u0002\u0004'\u0016\f(BA>\u001c!\rI\u0017\u0011A\u0005\u0004\u0003\u0007Q'A\u0003+pa&\u001c\u0017*\\1hK\"9\u0011qA\bA\u0002\u0005%\u0011aE5nC\u001e,wJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=A.\u0001\u0003sC\u001a$\u0018\u0002BA\n\u0003\u001b\u0011ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007.A\u000ewKJLg-\u001f#fY\u0016$X\r\u0015:f\u0013:LG/[1uK\u000e\u000bG\u000e\u001c\u000b\u0006\u0003\u0006e\u00111\u0005\u0005\b\u00037\u0001\u0002\u0019AA\u000f\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eE\u0002#\u0003?I1!!\t\u0014\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002&A\u0001\r!a\n\u0002\u0017QLW.Z:DC2dW\r\u001a\t\u00045\u0005%\u0012bAA\u00167\t\u0019\u0011J\u001c;\u00021Y,'/\u001b4z\t\u0016dW\r^3J]&$\u0018.\u0019;f\u0007\u0006dG\u000eF\u0003B\u0003c\t\u0019\u0004C\u0004\u0002\u001cE\u0001\r!!\b\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002(\u0001")
public class TierObjectGarbageCollectorTest {
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final MockTime time = new MockTime();
    private KRaftMetadataCache metadataCache;
    private TierObjectGarbageCollector tierObjectGarbageCollector;

    private TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    private MockTime time() {
        return this.time;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(KRaftMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    private TierObjectGarbageCollector tierObjectGarbageCollector() {
        return this.tierObjectGarbageCollector;
    }

    private void tierObjectGarbageCollector_$eq(TierObjectGarbageCollector x$1) {
        this.tierObjectGarbageCollector = x$1;
    }

    @BeforeEach
    public void setup() {
        this.metadataCache_$eq(new KRaftMetadataCache(0));
        this.tierObjectGarbageCollector_$eq(new TierObjectGarbageCollector(this.tierTopicManager(), this.metadataCache(), (Time)this.time()));
    }

    @Test
    public void testMaybePreInitiatePartitionDeletion() {
        UUID topicId1 = UUID.randomUUID();
        UUID topicId2 = UUID.randomUUID();
        TopicIdPartition topic1_0 = new TopicIdPartition("topic1", topicId1, 0);
        TopicIdPartition topic1_1 = new TopicIdPartition("topic1", topicId1, 1);
        TopicIdPartition topic2_0 = new TopicIdPartition("topic2", topicId2, 0);
        TopicIdPartition topic2_1 = new TopicIdPartition("topic2", topicId2, 1);
        this.tierObjectGarbageCollector().addTopicPartition(topic1_0, new OffsetAndEpoch(0L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic1_1, new OffsetAndEpoch(1L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic2_0, new OffsetAndEpoch(2L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic2_1, new OffsetAndEpoch(3L, 0));
        TopicImage topicImage1 = new TopicImage("topic1", new Uuid(topicId1.getMostSignificantBits(), topicId1.getLeastSignificantBits()), null, null);
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)new .colon.colon((Object)topicImage1, (List)Nil$.MODULE$), new OffsetAndEpoch(0L, 0)));
        this.tierObjectGarbageCollector().maybePreInitiatePartitionDeletion();
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)0))).addMetadata((AbstractTierMetadata)ArgumentMatchers.any());
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)new .colon.colon((Object)topicImage1, (List)Nil$.MODULE$), new OffsetAndEpoch(5L, 0)));
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybePreInitiatePartitionDeletion();
        future.completeExceptionally(new Exception());
        this.verifyDeletePreInitiateCall(topic1_0, 0);
        this.verifyDeletePreInitiateCall(topic1_1, 0);
        this.verifyDeletePreInitiateCall(topic2_0, 1);
        this.verifyDeletePreInitiateCall(topic2_1, 1);
        future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybePreInitiatePartitionDeletion();
        future.complete(TierPartitionState.AppendResult.ACCEPTED);
        this.verifyDeletePreInitiateCall(topic1_0, 0);
        this.verifyDeletePreInitiateCall(topic1_1, 0);
        this.verifyDeletePreInitiateCall(topic2_0, 2);
        this.verifyDeletePreInitiateCall(topic2_1, 2);
    }

    @Test
    public void testMaybeDeletePartitions() {
        int deleteBackoffMs = 5;
        UUID topicId1 = UUID.randomUUID();
        TopicIdPartition topic1_0 = new TopicIdPartition("topic1", topicId1, 0);
        TopicIdPartition topic1_1 = new TopicIdPartition("topic1", topicId1, 1);
        TopicIdPartition topic1_2 = new TopicIdPartition("topic1", topicId1, 2);
        this.tierObjectGarbageCollector().addTopicPartition(topic1_0, new OffsetAndEpoch(0L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic1_1, new OffsetAndEpoch(1L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic1_2, new OffsetAndEpoch(2L, 0));
        this.tierObjectGarbageCollector().onPartitionDeletePreInitiate(topic1_0, this.time().milliseconds());
        this.tierObjectGarbageCollector().onPartitionDeletePreInitiate(topic1_1, this.time().milliseconds() + 5L);
        this.tierObjectGarbageCollector().onPartitionDeletePreInitiate(topic1_2, this.time().milliseconds() + 10L);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        this.verifyDeleteInitiateCall(topic1_0, 0);
        this.verifyDeleteInitiateCall(topic1_1, 0);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        this.time().sleep(6L);
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        future.complete(TierPartitionState.AppendResult.FENCED);
        this.verifyDeleteInitiateCall(topic1_0, 1);
        this.verifyDeleteInitiateCall(topic1_1, 0);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        this.tierObjectGarbageCollector().onPartitionDeleteInitiate(topic1_0);
        this.time().sleep(5L);
        future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        future.completeExceptionally(new Exception());
        this.verifyDeleteInitiateCall(topic1_0, 1);
        this.verifyDeleteInitiateCall(topic1_1, 1);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        future.complete(TierPartitionState.AppendResult.FENCED);
        this.verifyDeleteInitiateCall(topic1_0, 1);
        this.verifyDeleteInitiateCall(topic1_1, 2);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        this.tierObjectGarbageCollector().onPartitionDeleteInitiate(topic1_1);
        this.tierObjectGarbageCollector().onPartitionDeleteComplete(topic1_0);
        this.tierObjectGarbageCollector().onPartitionDeleteComplete(topic1_1);
    }

    private MetadataImage createMetadataImage(Seq<TopicImage> topicImages, OffsetAndEpoch imageOffsetAndEpoch) {
        return new MetadataImage(imageOffsetAndEpoch, FeaturesImage.EMPTY, ClusterImage.EMPTY, new TopicsImage((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicImages.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicImages.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava(), new HashMap(), new HashMap()), ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void verifyDeletePreInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeletePreInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$1;

            public boolean matches(TierPartitionDeletePreInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        }));
    }

    private void verifyDeleteInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeleteInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$2;

            public boolean matches(TierPartitionDeleteInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$2 = topicIdPartition$2;
            }
        }));
    }
}

