/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import javax.management.MBeanServer;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.InternalAdmin;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierIntegrationTest$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\r-f\u0001\u0002$H\u00011CQa\u0015\u0001\u0005\u0002QCqa\u0016\u0001C\u0002\u0013%\u0001\f\u0003\u0004`\u0001\u0001\u0006I!\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u0011\u0019\u0001\b\u0001)A\u0005E\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\bBB=\u0001A\u0003%1\u000fC\u0005{\u0001\u0001\u0007\t\u0019!C\u0001w\"Qq\u0010\u0001a\u0001\u0002\u0004%\t!!\u0001\t\u0015\u00055\u0001\u00011A\u0001B\u0003&A\u0010C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0001bCA\u0010\u0001\u0001\u0007\t\u0019!C\u0001\u0003CA1\"!\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0015\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%\t!!\u000f\t\u0017\u0005u\u0002\u00011A\u0001B\u0003&\u00111\u0006\u0005\f\u0003\u007f\u0001\u0001\u0019!a\u0001\n\u0003\t\t\u0005C\u0006\u0002P\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0003bCA+\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007B1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002Z!Y\u0011q\r\u0001A\u0002\u0003\u0007I\u0011AA5\u0011-\ti\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0017\t\u0017\u0005=\u0004\u00011AA\u0002\u0013\u0005\u0011\u0011\u000f\u0005\f\u0003\u007f\u0002\u0001\u0019!a\u0001\n\u0003\t\t\tC\u0006\u0002\u0006\u0002\u0001\r\u0011!Q!\n\u0005M\u0004\"CAD\u0001\u0001\u0007I\u0011AAE\u0011%\t\t\n\u0001a\u0001\n\u0003\t\u0019\n\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0015BAF\u0011%\tI\n\u0001a\u0001\n\u0003\tY\nC\u0005\u0002*\u0002\u0001\r\u0011\"\u0001\u0002,\"A\u0011q\u0016\u0001!B\u0013\ti\nC\u0006\u00022\u0002\u0001\r\u00111A\u0005\u0002\u0005M\u0006bCAj\u0001\u0001\u0007\t\u0019!C\u0001\u0003+D1\"!7\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00026\"Y\u00111\u001c\u0001A\u0002\u0003\u0007I\u0011AAo\u0011-\t)\u000f\u0001a\u0001\u0002\u0004%\t!a:\t\u0017\u0005-\b\u00011A\u0001B\u0003&\u0011q\u001c\u0005\f\u0003[\u0004\u0001\u0019!a\u0001\n\u0003\ty\u000fC\u0006\u0003\n\u0001\u0001\r\u00111A\u0005\u0002\t-\u0001b\u0003B\b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cD\u0011B!\u0005\u0001\u0005\u0004%\tAa\u0005\t\u0011\tm\u0001\u0001)A\u0005\u0005+A\u0011B!\b\u0001\u0005\u0004%\tAa\b\t\u0011\t\u001d\u0002\u0001)A\u0005\u0005CA\u0011B!\u000b\u0001\u0005\u0004%\tAa\u000b\t\u0011\tu\u0002\u0001)A\u0005\u0005[AqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0004\u0003J\u0001!\tA!\u0011\t\u000f\t-\u0003\u0001\"\u0001\u0003N!I!Q\f\u0001\u0012\u0002\u0013\u0005!q\f\u0005\n\u0005k\u0002\u0011\u0013!C\u0001\u0005?BqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003\u0016\u0002!\tA!\u001f\t\u000f\t}\u0005\u0001\"\u0001\u0003z!9!\u0011\u0016\u0001\u0005\u0002\te\u0004b\u0002BW\u0001\u0011\u0005!\u0011\u0010\u0005\b\u0005c\u0003A\u0011\u0001B=\u0011\u001d\u0011)\f\u0001C\u0001\u0005sBqA!/\u0001\t\u0013\u0011Y\fC\u0005\u0003L\u0002\t\n\u0011\"\u0003\u0003N\"9!\u0011\u001b\u0001\u0005\n\tM\u0007b\u0002Bz\u0001\u0011%!Q\u001f\u0005\b\u0007\u000f\u0001A\u0011\u0002B=\u0011\u001d\u0019I\u0001\u0001C\u0005\u0007\u0017Aqaa\f\u0001\t\u0013\u0019\t\u0004C\u0004\u00046\u0001!Iaa\u000e\t\u000f\r=\u0003\u0001\"\u0003\u0004R!91Q\u0010\u0001\u0005\n\r}\u0004bBBE\u0001\u0011%11\u0012\u0002\u0014)&,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0011&\u000bA\u0001^5fe*\t!*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0005C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002+B\u0011a\u000bA\u0007\u0002\u000f\u0006AQn\\2l)&lW-F\u0001Z!\tQV,D\u0001\\\u0015\ta\u0016*A\u0003vi&d7/\u0003\u0002_7\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00059An\\4ESJ\u001cX#\u00012\u0011\u0007\rD'.D\u0001e\u0015\t)g-\u0001\u0003vi&d'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u0005-tW\"\u00017\u000b\u000554\u0017\u0001\u00027b]\u001eL!a\u001c7\u0003\rM#(/\u001b8h\u0003!awn\u001a#jeN\u0004\u0013A\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A^$\u0002\u000bQ|\u0007/[2\n\u0005a,(A\u0006+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002/QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\tA\u0010\u0005\u0002u{&\u0011a0\u001e\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018!\u0006;jKJ$v\u000e]5d\u0007>t7/^7fe~#S-\u001d\u000b\u0005\u0003\u0007\tI\u0001E\u0002O\u0003\u000bI1!a\u0002P\u0005\u0011)f.\u001b;\t\u0011\u0005-\u0011\"!AA\u0002q\f1\u0001\u001f\u00132\u0003I!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\u0011\u0002#QLWM\u001d'pO\u000e{W\u000e]8oK:$8/\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a%\u000b1\u0001\\8h\u0013\u0011\ti\"a\u0006\u0003#QKWM\u001d'pO\u000e{W\u000e]8oK:$8/A\u000buS\u0016\u0014Hj\\4D_6\u0004xN\\3oiN|F%Z9\u0015\t\u0005\r\u00111\u0005\u0005\n\u0003\u0017a\u0011\u0011!a\u0001\u0003'\t!\u0003^5fe2{wmQ8na>tWM\u001c;tA\u00059A/Z7q\t&\u0014XCAA\u0016!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019M\u0006\u0011\u0011n\\\u0005\u0005\u0003k\tyC\u0001\u0003GS2,\u0017a\u0003;f[B$\u0015N]0%KF$B!a\u0001\u0002<!I\u00111B\b\u0002\u0002\u0003\u0007\u00111F\u0001\ti\u0016l\u0007\u000fR5sA\u0005IA/[3s)\u0006\u001c8n]\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013:\u0015!\u0002;bg.\u001c\u0018\u0002BA'\u0003\u000f\u0012\u0011\u0002V5feR\u000b7o[:\u0002\u001bQLWM\u001d+bg.\u001cx\fJ3r)\u0011\t\u0019!a\u0015\t\u0013\u0005-!#!AA\u0002\u0005\r\u0013A\u0003;jKJ$\u0016m]6tA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA.!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1\u0013\u000611/\u001a:wKJLA!!\u001a\u0002`\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!a\u0001\u0002l!I\u00111B\u000b\u0002\u0002\u0003\u0007\u00111L\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005yA/[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0006\u0002\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002z\u001d\u000bQa\u001d;pe\u0016LA!! \u0002x\tYRj\\2l\u0013:lU-\\8ssRKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5fe>\u0013'.Z2u'R|'/Z0%KF$B!a\u0001\u0002\u0004\"I\u00111\u0002\r\u0002\u0002\u0003\u0007\u00111O\u0001\u0011i&,'o\u00142kK\u000e$8\u000b^8sK\u0002\n\u0001\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;peV\u0011\u00111\u0012\t\u0004-\u00065\u0015bAAH\u000f\n\u0001C+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0003\u0011\"\u0018.\u001a:EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:`I\u0015\fH\u0003BA\u0002\u0003+C\u0011\"a\u0003\u001c\u0003\u0003\u0005\r!a#\u0002CQLWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002!QLWM]*uCR,g)\u001a;dQ\u0016\u0014XCAAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR\u000f\u00069a-\u001a;dQ\u0016\u0014\u0018\u0002BAT\u0003C\u0013\u0001\u0003V5feN#\u0018\r^3GKR\u001c\u0007.\u001a:\u0002)QLWM]*uCR,g)\u001a;dQ\u0016\u0014x\fJ3r)\u0011\t\u0019!!,\t\u0013\u0005-a$!AA\u0002\u0005u\u0015!\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3sA\u0005!An\\4t+\t\t)\f\u0005\u0004\u00028\u0006\u001d\u0017Q\u001a\b\u0005\u0003s\u000b\u0019M\u0004\u0003\u0002<\u0006\u0005WBAA_\u0015\r\tylS\u0001\u0007yI|w\u000e\u001e \n\u0003AK1!!2P\u0003\u001d\u0001\u0018mY6bO\u0016LA!!3\u0002L\n\u00191+Z9\u000b\u0007\u0005\u0015w\n\u0005\u0003\u0002\u0016\u0005=\u0017\u0002BAi\u0003/\u0011\u0011\"T3sO\u0016$Gj\\4\u0002\u00111|wm]0%KF$B!a\u0001\u0002X\"I\u00111B\u0011\u0002\u0002\u0003\u0007\u0011QW\u0001\u0006Y><7\u000fI\u0001\u0011i&,'\u000fV8qS\u000el\u0015M\\1hKJ,\"!a8\u0011\u0007Q\f\t/C\u0002\u0002dV\u0014\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002)QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\u0019!!;\t\u0013\u0005-A%!AA\u0002\u0005}\u0017!\u0005;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3sA\u0005\u00012m\u001c8tk6,'oU;qa2LWM]\u000b\u0003\u0003c\u0004\u0002\"a=\u0002z\u0006u\u0018Q`\u0007\u0003\u0003kT1!a>H\u0003\u0019\u0019G.[3oi&!\u00111`A{\u0005QiunY6D_:\u001cX/\\3s'V\u0004\b\u000f\\5feB)a*a@\u0003\u0004%\u0019!\u0011A(\u0003\u000b\u0005\u0013(/Y=\u0011\u00079\u0013)!C\u0002\u0003\b=\u0013AAQ=uK\u0006!2m\u001c8tk6,'oU;qa2LWM]0%KF$B!a\u0001\u0003\u000e!I\u00111B\u0014\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u0012G>t7/^7feN+\b\u000f\u001d7jKJ\u0004\u0013!D7bq^\u000b\u0017\u000e\u001e+j[\u0016l5/\u0006\u0002\u0003\u0016A\u0019aJa\u0006\n\u0007\teqJA\u0002J]R\fa\"\\1y/\u0006LG\u000fV5nK6\u001b\b%\u0001\nuS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XC\u0001B\u0011!\r1&1E\u0005\u0004\u0005K9%A\u0005+jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\f1\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n1\"\u001c\"fC:\u001cVM\u001d<feV\u0011!Q\u0006\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003\u0005o\tQA[1wCbLAAa\u000f\u00032\tYQJQ3b]N+'O^3s\u00031i')Z1o'\u0016\u0014h/\u001a:!\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$WC\u0001B\"!\rq%QI\u0005\u0004\u0005\u000fz%a\u0002\"p_2,\u0017M\\\u0001\u000fG2,\u0017M\\;q\u000b:\f'\r\\3e\u0003\u0015\u0019X\r^;q)\u0019\t\u0019Aa\u0014\u0003Z!I!\u0011K\u0019\u0011\u0002\u0003\u0007!1K\u0001\b]VlGj\\4t!\rY'QK\u0005\u0004\u0005/b'aB%oi\u0016<WM\u001d\u0005\n\u00057\n\u0004\u0013!a\u0001\u0005'\n!C\\;n\u0003J\u001c\u0007.\u001b<feRC'/Z1eg\u0006y1/\u001a;va\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003b)\"!1\u000bB2W\t\u0011)\u0007\u0005\u0003\u0003h\tETB\u0001B5\u0015\u0011\u0011YG!\u001c\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B8\u001f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM$\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD:fiV\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002\r\t,gm\u001c:f)\t\t\u0019\u0001K\u00025\u0005{\u0002BAa \u0003\u00126\u0011!\u0011\u0011\u0006\u0005\u0005\u0007\u0013))A\u0002ba&TAAa\"\u0003\n\u00069!.\u001e9ji\u0016\u0014(\u0002\u0002BF\u0005\u001b\u000bQA[;oSRT!Aa$\u0002\u0007=\u0014x-\u0003\u0003\u0003\u0014\n\u0005%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u00026\u00053\u0003BAa \u0003\u001c&!!Q\u0014BA\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u000buKN$\u0018I]2iSZ,'/S7nS\u001e\u0014\u0018\r^3)\u0007Y\u0012\u0019\u000b\u0005\u0003\u0003\u0000\t\u0015\u0016\u0002\u0002BT\u0005\u0003\u0013A\u0001V3ti\u0006\u0001C/Z:u\u0003J\u001c\u0007.\u001b<feV\u0003Hn\\1e\u0003:$W*\u0019;fe&\fG.\u001b>fQ\r9$1U\u0001Bi\u0016\u001cH/\u0011:dQ&4XM]+qY>\fG-\u00118e\u001b\u0006$XM]5bY&TXm\u00165f]^\u0013\u0018\u000e^3ICB\u0004XM\\:BMR,'OQ3d_6,G*Z1eKJD3\u0001\u000fBR\u00039\"Xm\u001d;Be\u000eD\u0017N^3s+Bdw.\u00193XSRDG*[7ji\u0016$W\u000b\u001d7pC\u0012\u001cuN\\2veJ,gnY=)\u0007e\u0012\u0019+\u0001\fuKN$\u0018I]2iSZ,'\u000fT1h\u001b\u0016$(/[2tQ\rQ$1U\u0001\u0013o\u0006LGOR8s\u00136l\u0017n\u001a:bi&|g\u000e\u0006\u0007\u0002\u0004\tu&q\u0018Bb\u0005\u000b\u00149\rC\u0004\u00022n\u0002\r!!.\t\u000f\t\u00057\b1\u0001\u0003\u0016\u0005YA.Z1eKJ,\u0005o\\2i\u0011\u001d\tyd\u000fa\u0001\u0003\u0007Bq!!<<\u0001\u0004\t\t\u0010C\u0005\u0003Jn\u0002\n\u00111\u0001\u0003D\u0005a!-Z2p[\u0016dU-\u00193fe\u0006ar/Y5u\r>\u0014\u0018*\\7jOJ\fG/[8oI\u0011,g-Y;mi\u0012*TC\u0001BhU\u0011\u0011\u0019Ea\u0019\u0002=\u0005\u00148\r[5wK\u0006sG-T1uKJL\u0017\r\\5{KVsG/\u001b7UeV,G\u0003CA\u0002\u0005+\u0014yN!=\t\u000f\t]W\b1\u0001\u0003Z\u0006!\u0001O]3e!\u0015q%1\u001cB\"\u0013\r\u0011in\u0014\u0002\n\rVt7\r^5p]BBqA!9>\u0001\u0004\u0011\u0019/A\u0002ng\u001e\u0004BA!:\u0003n:!!q\u001dBu!\r\tYlT\u0005\u0004\u0005W|\u0015A\u0002)sK\u0012,g-C\u0002p\u0005_T1Aa;P\u0011\u001d\ti/\u0010a\u0001\u0003c\fAF^1mS\u0012\fG/\u001a)beRLG/[8o'R\fG/Z\"p]R\f\u0017N\\3e\u0013:|%M[3diN#xN]3\u0015\r\u0005\r!q\u001fB}\u0011\u001d\tyG\u0010a\u0001\u0003gBq!!-?\u0001\u0004\u0011Y\u0010\u0005\u0004\u00028\nu8\u0011A\u0005\u0005\u0005\u007f\fYM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\t)ba\u0001\n\t\r\u0015\u0011q\u0003\u0002\f\u0003\n\u001cHO]1di2{w-A\ntKR,\b\u000fV5fe\u000e{W\u000e]8oK:$8/\u0001\u0006de\u0016\fG/\u001a'pON$Bb!\u0004\u0004\u0014\r]1\u0011EB\u0012\u0007K\u0001b!a.\u0004\u0010\u00055\u0017\u0002BB\t\u0003\u0017\u0014!\"\u00138eKb,GmU3r\u0011\u001d\u0019)\u0002\u0011a\u0001\u0005+\t\u0011A\u001c\u0005\b\u00073\u0001\u0005\u0019AB\u000e\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0002\u0016\ru\u0011\u0002BB\u0010\u0003/\u0011\u0011\u0002T8h\u0007>tg-[4\t\u000f\u0005\u001d\u0002\t1\u0001\u0002,!9\u0011q\u0002!A\u0002\u0005M\u0001bBB\u0014\u0001\u0002\u00071\u0011F\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\t\u0005u31F\u0005\u0005\u0007[\tyF\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0013[>\u001c7NU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0006\u0003\u0002\\\rM\u0002bBAY\u0003\u0002\u0007!1`\u0001\u0013oJLG/\u001a*fG>\u0014HMQ1uG\",7\u000f\u0006\u0007\u0002\u0004\re21HB\u001f\u0007\u000f\u001aY\u0005C\u0004\u0002\u001a\t\u0003\ra!\u0001\t\u000f\t\u0005'\t1\u0001\u0003\u0016!91q\b\"A\u0002\r\u0005\u0013A\u00032bg\u0016|eMZ:fiB\u0019aja\u0011\n\u0007\r\u0015sJ\u0001\u0003M_:<\u0007bBB%\u0005\u0002\u0007!QC\u0001\bE\u0006$8\r[3t\u0011\u001d\u0019iE\u0011a\u0001\u0005+\tqB]3d_J$7\u000fU3s\u0005\u0006$8\r[\u0001\u000eGJ,\u0017\r^3SK\u000e|'\u000fZ:\u0015\u0015\rM3\u0011NB;\u0007o\u001aI\b\u0005\u0003\u0004V\r\u0015TBAB,\u0015\u0011\u0019Ifa\u0017\u0002\rI,7m\u001c:e\u0015\u0011\u0019ifa\u0018\u0002\r\r|W.\\8o\u0015\rQ5\u0011\r\u0006\u0005\u0007G\u0012i)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0007O\u001a9FA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0007W\u001a\u0005\u0019AB7\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004Baa\u001c\u0004r5\u001111L\u0005\u0005\u0007g\u001aYF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\t\u00057\t1\u0001\u0003\u0016!91qH\"A\u0002\r\u0005\u0003bBB>\u0007\u0002\u0007!QC\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018aC7fiJL7MV1mk\u0016$ba!\u0011\u0004\u0002\u000e\u0015\u0005bBBB\t\u0002\u0007!1]\u0001\u000b[\u0016$(/[2UsB,\u0007bBBD\t\u0002\u0007!1]\u0001\u0005]\u0006lW-\u0001\nuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003BBG\u00073\u0003Baa$\u0004\u00166\u00111\u0011\u0013\u0006\u0004\u0007';\u0015!B:uCR,\u0017\u0002BBL\u0007#\u0013!\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1uK\"911T#A\u0002\r5\u0014!\u00039beRLG/[8oQ\u001d\u00011qTBS\u0007O\u0003BAa \u0004\"&!11\u0015BA\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0007S\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class TierIntegrationTest {
    private final MockTime mockTime = new MockTime(0L, 0L);
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils$.MODULE$.tempDir().getAbsolutePath()));
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, 1, 1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
    private TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MockTime mockTime() {
        return this.mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public void tierStateFetcher_$eq(TierStateFetcher x$1) {
        this.tierStateFetcher = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public MBeanServer mBeanServer() {
        return this.mBeanServer;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    public void setup(Integer numLogs, Integer numArchiverThreads) {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        int x$1 = 150;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16, x$17);
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(Predef$.MODULE$.Integer2int(numLogs));
        IndexedSeq<MergedLog> logs = this.createLogs(Predef$.MODULE$.Integer2int(numLogs), logConfig, tempDir, this.tierLogComponents(), logDirFailureChannel);
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)logs);
        Pool logPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.map((Function1 & Serializable & scala.Serializable)log -> (AbstractLog)logPool.put((Object)log.topicPartition(), log), IndexedSeq$.MODULE$.canBuildFrom());
        int x$18 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$19 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$20 = 20;
        int x$21 = 1;
        long x$22 = TierTasksConfig$.MODULE$.apply$default$4();
        long x$23 = TierTasksConfig$.MODULE$.apply$default$5();
        int x$24 = TierTasksConfig$.MODULE$.apply$default$6();
        boolean x$25 = TierTasksConfig$.MODULE$.apply$default$8();
        Option x$26 = TierTasksConfig$.MODULE$.apply$default$9();
        TierTasks tierTasks = new TierTasks(new TierTasksConfig(x$18, x$19, x$21, x$22, x$23, x$24, x$20, x$25, x$26), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.mockTime());
        this.tierTasks_$eq(tierTasks);
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq((Seq<MergedLog>)logs);
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$1() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(10);
    }

    @BeforeEach
    public void before() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @AfterEach
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$12 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$12);
        this.tierObjectStore().close();
        this.logs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.logDirs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TierIntegrationTest.$anonfun$teardown$2(path);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@After");
        Mockito.framework().clearInlineMocks();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverImmigrate() {
        this.setup(this.setup$default$1(), this.setup$default$2());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$testArchiverImmigrate$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$testArchiverImmigrate$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadAndMaterialize() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        void archiveAndMaterializeUntilTrue_consumerSupplier2;
        void archiveAndMaterializeUntilTrue_consumerSupplier3;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, numBatches, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$4(log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier3, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$5(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$7(log)));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier2, (Function0)archiveAndMaterializeUntilTrue_pred2)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$8(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier3 = this.consumerSupplier();
        String string3 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred3 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$10(log)));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred3)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$11(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadWithLimitedUploadConcurrency() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        int maxConcurrentUploads = 2;
        int nLogs = 3;
        this.setup(Predef$.MODULE$.int2Integer(nLogs), Predef$.MODULE$.int2Integer(maxConcurrentUploads));
        this.tierTasks().start();
        int batches = 3;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Expected all logs to eventually become tiered";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(x$3))) && this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
    }

    @Test
    public void testArchiverLagMetrics() {
        int numLogs = 5;
        int batches = 6;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.setup(Predef$.MODULE$.int2Integer(numLogs), this.setup$default$2());
        this.tierTasks().start();
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverLagMetrics$5(this, leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        this.mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertTrue((this.maxTimeLag$1() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.logs().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverLagMetrics$7(x$6)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), batches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)archivedBatches -> this.awaitMaterializeBatchAndAssertLag$1(archivedBatches));
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
                TierIntegrationTest.$anonfun$waitForImmigration$1(this, leaderEpoch, log);
                return BoxedUnit.UNIT;
            });
        }
        String string = "Expect leadership to materialize";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> logs.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$3(x$8)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$waitForImmigration$4(this, consumerSupplier, tierTasks, logs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$waitForImmigration$7(tierTasks));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean waitForImmigration$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void archiveAndMaterializeUntilTrue(Function0<Object> pred, String msg, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, pred)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void validatePartitionStateContainedInObjectStore(MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$1(tierObjectStore, log);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupTierComponents() {
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace), (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class)), this.tierStateFetcher(), Optional.empty(), (Time)this.mockTime()));
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenAnswer((Answer)new Answer<Object>(null){

            public int answer(InvocationOnMock invocation) {
                return BoxesRunTime.unboxToInt((Object)invocation.getArgument(1));
            }
        });
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), this.tierTopicConsumer(), producerSupplier, () -> internalAdmin));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), new TierPartitionStateFactory(true, this.checksumEnabled(), true, this.cleanupEnabled())));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$setupTierComponents$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$setupTierComponents$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private IndexedSeq<MergedLog> createLogs(int n, LogConfig logConfig, File tempDir, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)i -> TierIntegrationTest.$anonfun$createLogs$1(this, tempDir, logConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        void var2_2;
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(null, logs){
            private final Iterable logs$2;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$2.find((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$answer$1(target, log)));
            }

            public static final /* synthetic */ boolean $anonfun$answer$1(TopicPartition target$1, AbstractLog log) {
                TopicPartition topicPartition = log.topicPartition();
                return !(topicPartition != null ? !topicPartition.equals(target$1) : target$1 != null);
            }
            {
                this.logs$2 = logs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(org.apache.kafka.common.TopicPartition kafka.log.AbstractLog )}, serializedLambda);
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1 & Serializable & scala.Serializable)log -> {
            void var2_2;
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some(log));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
            Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
            return var2_2;
        }, Iterable$.MODULE$.canBuildFrom());
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer(x$10 -> partitions.iterator());
        return var2_2;
    }

    private void writeRecordBatches(AbstractLog log, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1 & Serializable & scala.Serializable)idx -> TierIntegrationTest.$anonfun$writeRecordBatches$1(this, log, leaderEpoch, baseOffset, recordsPerBatch, BoxesRunTime.unboxToInt((Object)idx)));
        log.flush(false);
        log.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    private MemoryRecords createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        scala.collection.immutable.IndexedSeq recList = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)x$11 -> TierIntegrationTest.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$11)), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
        byte x$3 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.records$default$3();
        long x$5 = TestUtils$.MODULE$.records$default$4();
        short x$6 = TestUtils$.MODULE$.records$default$5();
        int x$7 = TestUtils$.MODULE$.records$default$6();
        int x$8 = TestUtils$.MODULE$.records$default$8();
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(topicPartition, new MemoryRecords.RecordFilter(null){

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return MemoryRecords.readableRecords((ByteBuffer)filtered);
    }

    private long metricValue(String metricType, String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$metricValue$1(metricType, name, x0$1)))).values().head()).value());
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$tierPartitionState$1(partition, x$13))).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.tierPartitionState()).get();
    }

    public static final /* synthetic */ void $anonfun$teardown$2(String path) {
        Utils.delete((File)new File(path));
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$2(Set x$2) {
        return x$2.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$1(TierIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$2(x$2))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$3() {
        return "Archiver should process pending emigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$6(ArchiveTask task) {
        return task.state() instanceof BeforeUpload || task.state() instanceof AfterUpload;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$4(TierIntegrationTest $this) {
        $this.consumerSupplier().moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)tasks.forall((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$6(task))))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$7() {
        return "Archiver should process pending immigrations";
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$2(int leaderEpoch$1, MergedLog log) {
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$1, (String)new StringBuilder(43).append("topic manager should materialize entry for ").append(log.topicPartition()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 1;
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$5(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"batch 1: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"batch 1: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$7(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 2 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$8(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        Assertions.assertEquals((long)4L, (long)((TierLogSegment)tierPartitionState.metadata(6L).get()).baseOffset(), (String)"batch 2: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((tierPartitionState.committedEndOffset() >= 7L ? 1 : 0) != 0, (String)"batch 2: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$10(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 3 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$11(MergedLog log) {
        Assertions.assertEquals((long)8L, (long)((TierLogSegment)log.tierPartitionState().metadata(10L).get()).baseOffset(), (String)"batch 3: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 11L ? 1 : 0) != 0, (String)"batch 3: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() > 0 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"Segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"Segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(MergedLog x$3) {
        return x$3.tierableLogSegments().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(MergedLog log) {
        return log.tieredLogSegments().nonEmpty();
    }

    private final long totalLag$1() {
        return this.metricValue("TierArchiver", "TotalLag");
    }

    private final long maxTimeLag$1() {
        return this.metricValue("TierArchiver", "PartitionTimeLagMaxValue");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverLagMetrics$2(int archivedBatches$1, MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= archivedBatches$1 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ int $anonfun$testArchiverLagMetrics$3(MergedLog x$4) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$4.tierableLogSegments().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private final void awaitMaterializeBatchAndAssertLag$1(int archivedBatches) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = new StringBuilder(49).append("Should materialize segments for batch ").append(archivedBatches).append(" or greater").toString();
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverLagMetrics$2(archivedBatches, log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.logs().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverLagMetrics$3(x$4)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        if (this.totalLag$1() > 0L) {
            Assertions.assertTrue((this.maxTimeLag$1() > 0L ? 1 : 0) != 0);
        }
    }

    public static final /* synthetic */ void $anonfun$testArchiverLagMetrics$5(TierIntegrationTest $this, int leaderEpoch$4, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$4);
    }

    public static final /* synthetic */ int $anonfun$testArchiverLagMetrics$7(MergedLog x$6) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$6.tierableLogSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$waitForImmigration$1(TierIntegrationTest $this, int leaderEpoch$5, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$5);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$3(MergedLog x$8) {
        TierPartitionStatus tierPartitionStatus = x$8.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$6(ArchiveTask x$9) {
        return x$9.state() instanceof BeforeLeader;
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$5(Seq logs$1, Set tasks) {
        return tasks.size() == logs$1.size() && !tasks.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$6(x$9)));
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$4(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$1, TierTasks tierTasks$1, Seq logs$1) {
        consumerSupplier$1.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)tierTasks$1.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$5(logs$1, tasks))));
    }

    public static final /* synthetic */ String $anonfun$waitForImmigration$7(TierTasks tierTasks$1) {
        return new StringBuilder(28).append("Expect zero BeforeLeader in ").append(tierTasks$1.archiverTaskQueue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$archiveAndMaterializeUntilTrue$1(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$2, Function0 pred$1) {
        consumerSupplier$2.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return pred$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$2(MockInMemoryTierObjectStore tierObjectStore$1, TierLogSegment tierSegment) {
        Assertions.assertNotNull((Object)tierObjectStore$1.getObject((TierObjectStore.ObjectStoreMetadata)tierSegment.metadata(), TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1000)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$1(MockInMemoryTierObjectStore tierObjectStore$1, AbstractLog log) {
        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(log.tierPartitionState().segments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tierSegment -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$2(tierObjectStore$1, tierSegment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupTierComponents$2(TierIntegrationTest $this) {
        $this.tierTopicManager().tryBecomeReady(false);
        return $this.tierTopicManager().isReady();
    }

    public static final /* synthetic */ String $anonfun$setupTierComponents$3() {
        return "Timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$1(TierIntegrationTest $this, File tempDir$1, LogConfig logConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(12).append("tierlogtest-").append(i).toString()).toFile();
        logDir.mkdir();
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = $this.mockTime().scheduler();
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = new Metrics();
        MockTime x$8 = $this.mockTime();
        int x$9 = 300000;
        int x$10 = 3600000;
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        boolean x$14 = true;
        boolean x$15 = true;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = MergedLog$.MODULE$.apply$default$17();
        return MergedLog$.MODULE$.apply(logDir, logConfig$1, x$3, x$4, (Scheduler)x$5, x$6, x$7, (Time)x$8, x$9, x$10, x$11, logDirFailureChannel$1, tierLogComponents$1, x$14, (Option)x$16, x$15, x$18, (Option)x$17);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$writeRecordBatches$1(TierIntegrationTest $this, AbstractLog log$1, int leaderEpoch$6, long baseOffset$1, int recordsPerBatch$3, int idx) {
        MemoryRecords records = $this.createRecords(log$1.topicPartition(), leaderEpoch$6, baseOffset$1 + (long)(idx * recordsPerBatch$3), recordsPerBatch$3);
        return log$1.appendAsFollower(records);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$11) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$metricValue$1(String metricType$1, String name$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getType();
        if (string == null) {
            if (metricType$1 != null) {
                return false;
            }
        } else if (!string.equals(metricType$1)) return false;
        String string2 = metricName.getName();
        if (string2 == null) {
            if (name$1 == null) return true;
            return false;
        } else {
            if (!string2.equals(name$1)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$tierPartitionState$1(TopicPartition partition$1, MergedLog x$13) {
        TopicPartition topicPartition = x$13.topicPartition();
        return !(topicPartition != null ? !topicPartition.equals(partition$1) : partition$1 != null);
    }

    public TierIntegrationTest() {
        this.maxWaitTimeMs = 20000;
    }
}

