/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.FileTierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u00045\u0001\u0001\u0006I!\u000b\u0005\nk\u0001\u0001\r\u0011!Q!\nYBqa\u0010\u0001C\u0002\u0013E\u0003\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006{\u0002!\tA \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003\"CA/\u0001E\u0005I\u0011BA0\u0011\u001d\t)\b\u0001C\u0005\u0003oB\u0011\"!\"\u0001#\u0003%I!a\u0018\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011\u0011\u0013\u0001\u0005\n\u0005M%!\u0006+jKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u00031e\tA\u0001^5fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u001a\u0003\r\t\u0007/[\u0005\u0003E}\u0011a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003]\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001*!\tQ#'D\u0001,\u0015\taS&\u0001\u0004d_6lwN\u001c\u0006\u000359R!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO&\u00111g\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!C0uKN$\u0018J\u001c4p!\t9T(D\u00019\u0015\t\u0001\u0013H\u0003\u0002;w\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001f1\u0003\u0015QWO\\5u\u0013\tq\u0004H\u0001\u0005UKN$\u0018J\u001c4p\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u00131!\u00138u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003\u0015\u0019X\r^+q)\tQU\n\u0005\u0002C\u0017&\u0011Aj\u0011\u0002\u0005+:LG\u000fC\u0003O\u000f\u0001\u0007a'\u0001\u0005uKN$\u0018J\u001c4pQ\t9\u0001\u000b\u0005\u00028#&\u0011!\u000b\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0012;fgR,e.\u00192mK\u000e{W\u000e]1di&|g.\u00114uKJ,e.\u00192mKRKWM]!u\u0005J|7.\u001a:MKZ,GnV5uQRKWM]\"mK\u0006tWM]#oC\ndW\r\u0006\u0002K+\")a\u000b\u0003a\u0001/\u00061\u0011/^8sk6\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.D\u001b\u0005Y&B\u0001/\u001c\u0003\u0019a$o\\8u}%\u0011alQ\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_\u0007\"\"\u0001bY6m!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tA\u0017(\u0001\u0004qCJ\fWn]\u0005\u0003U\u0016\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH&A7\"\u00039\f!A_6)\t!\u0001H/\u001e\t\u0003cJl\u0011aZ\u0005\u0003g\u001e\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003Y\f\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003\r#Xm\u001d;F]\u0006\u0014G.Z\"p[B\f7\r^5p]\u00063G/\u001a:F]\u0006\u0014G.\u001a+jKJ\fEO\u0011:pW\u0016\u0014H*\u001a<fY:{G+[3s\u00072,\u0017M\\3s\u000b:\f'\r\\3\u0015\u0005)K\b\"\u0002,\n\u0001\u00049\u0006\u0006B\u0005dWnd\u0013!\u001c\u0015\u0005\u0013A$X/\u0001\u001duKN$H)[:bY2|w/\u001a3D_6\u0004\u0018m\u0019;EK2,G/Z\"iC:<Wm],ji\"$\u0016.\u001a:DY\u0016\fg.\u001a:GK\u0006$XO]3\u0015\u0005){\b\"\u0002,\u000b\u0001\u00049\u0006&\u0002\u0006dW\u0006\rA&A7)\t)\u0001H/^\u0001&i\u0016\u001cH\u000fR5tC\ndW\rV5fe&twm\u00165f]N+G/\u0011;U_BL7\rT3wK2$2ASA\u0006\u0011\u001516\u00021\u0001XQ\u0015Y1m[A\bY\u0005i\u0007\u0006B\u0006qiV\fa\u0005^3ti\u0012K7/\u00192mKRKWM]5oO^CWM\\*fi\u0006#(I]8lKJdUM^3m)\rQ\u0015q\u0003\u0005\u0006-2\u0001\ra\u0016\u0015\u0006\u0019\r\\\u00171\u0004\u0017\u0002[\"\"A\u0002\u001d;v\u0003q\"Xm\u001d;ESN\f'\r\\3US\u0016\u0014X\rZ*u_J\fw-Z!u\u0005J|7.\u001a:MKZ,G.\u00114uKJ,e.\u00192mS:<7\u000b^1uS\u000e\fG\u000e\\=\u0015\u0007)\u000b\u0019\u0003C\u0003W\u001b\u0001\u0007q\u000bK\u0003\u000eG.\f9\u0003L\u0001nQ\u0011i\u0001\u000f^;\u0002{Q,7\u000f\u001e#jg\u0006\u0014G.\u001a+jKJ,Gm\u0015;pe\u0006<W-\u0011;Ce>\\WM\u001d'fm\u0016d\u0017I\u001a;fe\u0016s\u0017M\u00197j]\u001e$\u0015P\\1nS\u000e\fG\u000e\\=\u0015\u0007)\u000by\u0003C\u0003W\u001d\u0001\u0007q\u000bK\u0003\u000fG.\f\u0019\u0004L\u0001nQ\u0011q\u0001\u000f^;\u0002KQ,7\u000f\u001e#jg\u0006\u0014G.\u001a+jKJ,Gm\u0015;pe\u0006<W-\u0011;Ce>\\WM\u001d'fm\u0016dGc\u0001&\u0002<!9\u0011QH\bA\u0002\u0005}\u0012\u0001F5t\tft\u0017-\\5dC2d\u00170\u00128bE2,G\rE\u0002C\u0003\u0003J1!a\u0011D\u0005\u001d\u0011un\u001c7fC:\f\u0011dZ3u)&,'/\u00128bE2,'I]8lKJ\u001cuN\u001c4jOR!\u0011\u0011JA-!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nQ!\u00193nS:T1!a\u0015.\u0003\u001d\u0019G.[3oiNLA!a\u0016\u0002N\tY1i\u001c8gS\u001e,e\u000e\u001e:z\u0011!\tY\u0006\u0005I\u0001\u0002\u00049\u0016AC3oi&$\u0018PT1nK\u0006\u0019s-\u001a;US\u0016\u0014XI\\1cY\u0016\u0014%o\\6fe\u000e{gNZ5hI\u0011,g-Y;mi\u0012\nTCAA1U\r9\u00161M\u0016\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005v]\u000eDWmY6fI*\u0019\u0011qN\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0005%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y\u0012\r\u001c;feRKWM]#oC\ndWM\u0011:pW\u0016\u00148i\u001c8gS\u001e$b!!\u001f\u0002\u0000\u0005\r\u0005\u0003BA&\u0003wJA!! \u0002N\t\u0011\u0012\t\u001c;fe\u000e{gNZ5hgJ+7/\u001e7u\u0011\u0019\t\tI\u0005a\u0001/\u0006I\u0001O]8q-\u0006dW/\u001a\u0005\t\u00037\u0012\u0002\u0013!a\u0001/\u0006)\u0013\r\u001c;feRKWM]#oC\ndWM\u0011:pW\u0016\u00148i\u001c8gS\u001e$C-\u001a4bk2$HEM\u0001\u0011C2$XM\u001d+pa&\u001c7i\u001c8gS\u001e$b!!\u001f\u0002\f\u0006=\u0005BBAG)\u0001\u0007q+A\u0004qe>\u00048*Z=\t\r\u0005\u0005E\u00031\u0001X\u00035\t7o]3si&sg/\u00197jIR\u0019!*!&\t\u000f\u0005]U\u00031\u0001\u0002z\u00051!/Z:vYR\u0004")
public class TierConfigurationTest
extends IntegrationTestHarness {
    private final TopicPartition topicPartition;
    private TestInfo _testInfo;
    private final int brokerCount;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        super.setUp(this._testInfo);
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$3, x$2, x$4, x$5);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()).all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$1(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testEnableCompactionAfterEnableTierAtBrokerLevelNoTierCleanerEnable(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), "true");
        super.setUp(this._testInfo);
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$3, x$2, x$4, x$5);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        try {
            this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()).all().get();
            Assertions.fail((String)"Alter should have failed");
        }
        catch (Exception exception) {}
        this.assertInvalid(this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()));
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelNoTierCleanerEnable$1(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDisallowedCompactDeleteChangesWithTierCleanerFeature(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        super.setUp(this._testInfo);
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        String x$1 = this.topicPartition().topic();
        int x$3 = 2;
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$4, x$3, topicConfig, x$5);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()).all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$2(this, broker);
            return BoxedUnit.UNIT;
        });
        this.assertInvalid(this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Delete()).append(",").append(LogConfig$.MODULE$.Compact()).toString()));
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$5(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDisableTieringWhenSetAtTopicLevel(String quorum) {
        super.setUp(this._testInfo);
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        String x$1 = this.topicPartition().topic();
        int x$3 = 2;
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$4, x$3, topicConfig, x$5);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig(LogConfig$.MODULE$.TierEnableProp(), "false").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$2(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDisableTieringWhenSetAtBrokerLevel(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp(this._testInfo);
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$3, x$2, x$4, x$5);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig(LogConfig$.MODULE$.TierEnableProp(), "false").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$2(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDisableTieredStorageAtBrokerLevelAfterEnablingStatically(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        super.setUp(this._testInfo);
        this.testDisableTieredStorageAtBrokerLevel(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDisableTieredStorageAtBrokerLevelAfterEnablingDynamically(String quorum) {
        super.setUp(this._testInfo);
        this.alterTierEnableBrokerConfig("true", this.alterTierEnableBrokerConfig$default$2()).all().get(5L, TimeUnit.SECONDS);
        this.testDisableTieredStorageAtBrokerLevel(true);
    }

    private void testDisableTieredStorageAtBrokerLevel(boolean isDynamicallyEnabled) {
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$3, x$2, x$4, x$5);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$1(this, broker);
            return BoxedUnit.UNIT;
        });
        int brokerToUpdate = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.alterTierEnableBrokerConfig("false", Integer.toString(brokerToUpdate)).all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$2(this, brokerToUpdate, isDynamicallyEnabled, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTierEnableBrokerConfig("false", this.alterTierEnableBrokerConfig$default$2()).all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$5(this, broker);
            return BoxedUnit.UNIT;
        });
        ConfigEntry tierEnableConfig = this.getTierEnableBrokerConfig(this.getTierEnableBrokerConfig$default$1());
        Assertions.assertFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(tierEnableConfig.value())).toBoolean());
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, (Object)tierEnableConfig.source());
    }

    private ConfigEntry getTierEnableBrokerConfig(String entityName) {
        ConfigEntry configEntry;
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, entityName.toString());
            configEntry = ((Config)((Map)adminClient.describeConfigs(Collections.singleton(brokerConfigResource)).all().get()).get(brokerConfigResource)).get(KafkaConfig$.MODULE$.TierEnableProp());
        }
        return configEntry;
    }

    private String getTierEnableBrokerConfig$default$1() {
        return "";
    }

    private AlterConfigsResult alterTierEnableBrokerConfig(String propValue, String entityName) {
        AlterConfigsResult alterConfigsResult;
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.TierEnableProp(), propValue), AlterConfigOp.OpType.SET);
        Map<ConfigResource, Set<AlterConfigOp>> toSetOnBroker = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, entityName), Collections.singleton(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(toSetOnBroker);
        }
        return alterConfigsResult;
    }

    private String alterTierEnableBrokerConfig$default$2() {
        return "";
    }

    private AlterConfigsResult alterTopicConfig(String propKey, String propValue) {
        AlterConfigsResult alterConfigsResult;
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey, propValue), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topicPartition().topic()), Collections.singletonList(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(configs);
        }
        return alterConfigsResult;
    }

    private void assertInvalid(AlterConfigsResult result) {
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> result.all().get());
        Assertions.assertEquals(InvalidConfigurationException.class, exception.getCause().getClass());
    }

    public static final /* synthetic */ boolean $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$2(TierConfigurationTest $this, KafkaBroker broker$1) {
        LogManager qual$3 = broker$1.logManager();
        TopicPartition x$10 = $this.topicPartition();
        boolean x$11 = qual$3.getLog$default$2();
        return ((AbstractLog)qual$3.getLog(x$10, x$11).get()).config().compact();
    }

    public static final /* synthetic */ String $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$3() {
        return "Timed out turning on tier compact";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$6, x$7).get()).tierPartitionState().isTieringEnabled());
        LogManager qual$2 = broker.logManager();
        TopicPartition x$8 = $this.topicPartition();
        boolean x$9 = qual$2.getLog$default$2();
        Assertions.assertFalse((boolean)((FileTierPartitionState)((AbstractLog)qual$2.getLog((TopicPartition)x$8, (boolean)x$9).get()).tierPartitionState()).cleanupFeatureFlag);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$2($this, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelNoTierCleanerEnable$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$6, x$7).get()).tierPartitionState().isTieringEnabled());
        LogManager qual$2 = broker.logManager();
        TopicPartition x$8 = $this.topicPartition();
        boolean x$9 = qual$2.getLog$default$2();
        Assertions.assertTrue((boolean)((FileTierPartitionState)((AbstractLog)qual$2.getLog((TopicPartition)x$8, (boolean)x$9).get()).tierPartitionState()).cleanupFeatureFlag);
        LogManager qual$3 = broker.logManager();
        TopicPartition x$10 = $this.topicPartition();
        boolean x$11 = qual$3.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$3.getLog(x$10, x$11).get()).config().delete());
    }

    public static final /* synthetic */ void $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$6, x$7).get()).tierPartitionState().isTieringEnabled());
        LogManager qual$2 = broker.logManager();
        TopicPartition x$8 = $this.topicPartition();
        boolean x$9 = qual$2.getLog$default$2();
        Assertions.assertFalse((boolean)((FileTierPartitionState)((AbstractLog)qual$2.getLog((TopicPartition)x$8, (boolean)x$9).get()).tierPartitionState()).cleanupFeatureFlag);
        LogManager qual$3 = broker.logManager();
        TopicPartition x$10 = $this.topicPartition();
        boolean x$11 = qual$3.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$3.getLog(x$10, x$11).get()).config().compact());
    }

    public static final /* synthetic */ boolean $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$3(TierConfigurationTest $this, KafkaBroker broker$2) {
        LogManager qual$4 = broker$2.logManager();
        TopicPartition x$12 = $this.topicPartition();
        boolean x$13 = qual$4.getLog$default$2();
        return ((AbstractLog)qual$4.getLog(x$12, x$13).get()).config().delete();
    }

    public static final /* synthetic */ String $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$4() {
        return "Timed out trying to switch back to delete";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$2(TierConfigurationTest $this, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$3($this, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$5(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$5 = broker.logManager();
        TopicPartition x$14 = $this.topicPartition();
        boolean x$15 = qual$5.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$5.getLog(x$14, x$15).get()).config().delete());
        LogManager qual$6 = broker.logManager();
        TopicPartition x$16 = $this.topicPartition();
        boolean x$17 = qual$6.getLog$default$2();
        Assertions.assertFalse((boolean)((AbstractLog)qual$6.getLog(x$16, x$17).get()).config().compact());
    }

    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtTopicLevel$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$6, x$7).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieringWhenSetAtTopicLevel$3(TierConfigurationTest $this, KafkaBroker broker$3) {
        boolean x$9;
        TopicPartition x$8;
        LogManager qual$2 = broker$3.logManager();
        return !((AbstractLog)qual$2.getLog(x$8 = $this.topicPartition(), x$9 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieringWhenSetAtTopicLevel$4() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtTopicLevel$2(TierConfigurationTest $this, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$3($this, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtBrokerLevel$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$6, x$7).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieringWhenSetAtBrokerLevel$3(TierConfigurationTest $this, KafkaBroker broker$4) {
        boolean x$9;
        TopicPartition x$8;
        LogManager qual$2 = broker$4.logManager();
        return !((AbstractLog)qual$2.getLog(x$8 = $this.topicPartition(), x$9 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieringWhenSetAtBrokerLevel$4() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtBrokerLevel$2(TierConfigurationTest $this, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$3($this, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$6, x$7).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$3(TierConfigurationTest $this, KafkaBroker broker$5) {
        boolean x$9;
        TopicPartition x$8;
        LogManager qual$2 = broker$5.logManager();
        return !((AbstractLog)qual$2.getLog(x$8 = $this.topicPartition(), x$9 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$4() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$2(TierConfigurationTest $this, int brokerToUpdate$1, boolean isDynamicallyEnabled$1, KafkaBroker broker) {
        if (broker.config().brokerId() == brokerToUpdate$1) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 5000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$3($this, broker)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ConfigEntry tierEnableConfig = $this.getTierEnableBrokerConfig(Integer.toString(broker.config().brokerId()));
            Assertions.assertFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(tierEnableConfig.value())).toBoolean());
            Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, (Object)tierEnableConfig.source());
            return;
        }
        LogManager qual$3 = broker.logManager();
        TopicPartition x$10 = $this.topicPartition();
        boolean x$11 = qual$3.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$3.getLog(x$10, x$11).get()).tierPartitionState().isTieringEnabled());
        ConfigEntry tierEnableConfig = $this.getTierEnableBrokerConfig(Integer.toString(broker.config().brokerId()));
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(tierEnableConfig.value())).toBoolean());
        if (isDynamicallyEnabled$1) {
            Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, (Object)tierEnableConfig.source());
            return;
        }
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, (Object)tierEnableConfig.source());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$6(TierConfigurationTest $this, KafkaBroker broker$6) {
        boolean x$13;
        TopicPartition x$12;
        LogManager qual$4 = broker$6.logManager();
        return !((AbstractLog)qual$4.getLog(x$12 = $this.topicPartition(), x$13 = qual$4.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$7() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$5(TierConfigurationTest $this, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$6($this, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public TierConfigurationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.topicPartition = new TopicPartition("foo", 0);
        this.brokerCount = 2;
    }
}

