/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import kafka.network.SocketServer;
import kafka.server.KafkaBroker;
import kafka.test.ClusterConfig;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.network.ListenerName;

public interface ClusterInstance {
    public ClusterType clusterType();

    default public boolean isKRaftTest() {
        return this.clusterType() == ClusterType.RAFT;
    }

    public String clusterId();

    public ClusterConfig config();

    public ListenerName clientListener();

    public ListenerName controllerListener();

    default public Optional<ListenerName> controllerListenerName() {
        return Optional.empty();
    }

    default public Optional<ListenerName> controlPlaneListenerName() {
        return Optional.empty();
    }

    public String bootstrapServers();

    public Collection<SocketServer> brokerSocketServers();

    public Collection<SocketServer> controllerSocketServers();

    public SocketServer anyBrokerSocketServer();

    public SocketServer anyControllerSocketServer();

    public SocketServer activeController() throws InterruptedException;

    public Object getUnderlying();

    default public <T> T getUnderlying(Class<T> asClass) {
        return asClass.cast(this.getUnderlying());
    }

    public ClusterInstance duplicateCluster(Consumer<ClusterConfig.Builder> var1);

    public Admin createAdminClient(Properties var1);

    default public Admin createAdminClient() {
        return this.createAdminClient(new Properties());
    }

    public void start();

    public void stop();

    public void shutdownBroker(int var1);

    public void startBroker(int var1);

    public void rollingBrokerRestart();

    public void waitForReadyBrokers() throws InterruptedException;

    public Map<Integer, KafkaBroker> brokers();

    public static enum ClusterType {
        ZK,
        RAFT;

    }
}

