/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageListener;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001\u0002\u00180\u0001YBQ!\u0010\u0001\u0005\u0002yBQ!\u0011\u0001\u0005\n\tCqa\u0015\u0001\u0012\u0002\u0013%A\u000bC\u0004`\u0001E\u0005I\u0011\u00021\t\u000b\t\u0004A\u0011A2\t\u000bQ\u0004A\u0011A2\t\u000bY\u0004A\u0011A2\u0007\ta\u0004\u0001!\u001f\u0005\u0006{!!\tA\u001f\u0005\b{\"\u0001\r\u0011\"\u0001\u007f\u0011%\ty\u0001\u0003a\u0001\n\u0003\t\t\u0002C\u0004\u0002\u0018!\u0001\u000b\u0015B@\t\u0013\u0005e\u0001B1A\u0005\u0002\u0005m\u0001\u0002CA'\u0011\u0001\u0006I!!\b\t\u0013\u0005=\u0003\u00021A\u0005\u0002\u0005E\u0003\"CA*\u0011\u0001\u0007I\u0011AA+\u0011\u001d\tI\u0006\u0003Q!\nAC\u0011\"a\u0017\t\u0001\u0004%\t!!\u0015\t\u0013\u0005u\u0003\u00021A\u0005\u0002\u0005}\u0003bBA2\u0011\u0001\u0006K\u0001\u0015\u0005\n\u0003KB\u0001\u0019!C\u0001\u0003OB\u0011\"a\u001c\t\u0001\u0004%\t!!\u001d\t\u0011\u0005U\u0004\u0002)Q\u0005\u0003SB\u0011\"a\u001e\t\u0001\u0004%\t!!\u0015\t\u0013\u0005e\u0004\u00021A\u0005\u0002\u0005m\u0004bBA@\u0011\u0001\u0006K\u0001\u0015\u0005\b\u0003\u0003CA\u0011IAB\r\u0019\t\u0019\n\u0001\u0001\u0002\u0016\"1Q\b\bC\u0001\u0003;Cq! \u000fA\u0002\u0013\u0005a\u0010C\u0005\u0002\u0010q\u0001\r\u0011\"\u0001\u0002\"\"9\u0011q\u0003\u000f!B\u0013y\b\"CAS9\u0001\u0007I\u0011AAT\u0011%\t\t\f\ba\u0001\n\u0003\t\u0019\f\u0003\u0005\u00028r\u0001\u000b\u0015BAU\u0011\u001d\tI\f\bC!\u0003wCq!!3\u001d\t\u0003\nY\rC\u0004\u0002Xr!\t%!7\t\u0013\u0005}\u0007A1A\u0005\n\u0005\u0005\b\u0002CAx\u0001\u0001\u0006I!a9\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"1\u00111 \u0001\u0005\u0002\rDa!a@\u0001\t\u0003\u0019\u0007b\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0005i\u0011%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014H+Z:u\u0015\t\u0001\u0014'\u0001\u0005nKR\fG-\u0019;b\u0015\t\u00114'\u0001\u0004tKJ4XM\u001d\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011C\u0001\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011aL\u0001\u001a]\u0016<(I]8lKJlU\r^1eCR\fG*[:uK:,'\u000fF\u0002D\r:\u0003\"\u0001\u0011#\n\u0005\u0015{#A\u0006\"s_.,'/T3uC\u0012\fG/\u0019'jgR,g.\u001a:\t\u000f\u001d\u0013\u0001\u0013!a\u0001\u0011\u0006Y1O\\1qg\"|G\u000f^3s!\rA\u0014jS\u0005\u0003\u0015f\u0012aa\u00149uS>t\u0007C\u0001!M\u0013\tiuFA\nNKR\fG-\u0019;b':\f\u0007o\u001d5piR,'\u000fC\u0004P\u0005A\u0005\t\u0019\u0001)\u000215\f\u0007PQ=uKN\u0014U\r^<fK:\u001cf.\u00199tQ>$8\u000f\u0005\u00029#&\u0011!+\u000f\u0002\u0005\u0019>tw-A\u0012oK^\u0014%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003US#\u0001\u0013,,\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u0013Ut7\r[3dW\u0016$'B\u0001/:\u0003)\tgN\\8uCRLwN\\\u0005\u0003=f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\rrWm\u001e\"s_.,'/T3uC\u0012\fG/\u0019'jgR,g.\u001a:%I\u00164\u0017-\u001e7uII*\u0012!\u0019\u0016\u0003!Z\u000b!\u0003^3ti\u000e\u0013X-\u0019;f\u0003:$7\t\\8tKR\tA\r\u0005\u00029K&\u0011a-\u000f\u0002\u0005+:LG\u000f\u000b\u0002\u0006QB\u0011\u0011N]\u0007\u0002U*\u00111\u000e\\\u0001\u0004CBL'BA7o\u0003\u001dQW\u000f]5uKJT!a\u001c9\u0002\u000b),h.\u001b;\u000b\u0003E\f1a\u001c:h\u0013\t\u0019(N\u0001\u0003UKN$\u0018a\u0003;fgR\u0004VO\u00197jg\"D#A\u00025\u0002/Q,7\u000f\u001e)vE2L7\u000f\u001b'fC\u0012,'o\u00115b]\u001e,\u0007FA\u0004i\u0005]iunY6NKR\fG-\u0019;b':\f\u0007o\u001d5piR,'oE\u0002\to-#\u0012a\u001f\t\u0003y\"i\u0011\u0001A\u0001\u0006S6\fw-Z\u000b\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019AC\u0002~\u0003\u000bQ1\u0001NA\u0004\u0015\r\tI\u0001]\u0001\u0007CB\f7\r[3\n\t\u00055\u00111\u0001\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002\u0013%l\u0017mZ3`I\u0015\fHc\u00013\u0002\u0014!A\u0011QC\u0006\u0002\u0002\u0003\u0007q0A\u0002yIE\na![7bO\u0016\u0004\u0013a\u00024bS2,(/Z\u000b\u0003\u0003;\u0001b!a\b\u00022\u0005URBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\r\u0005$x.\\5d\u0015\u0011\t9#!\u000b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002,\u00055\u0012\u0001B;uS2T!!a\f\u0002\t)\fg/Y\u0005\u0005\u0003g\t\tCA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0011\t9$a\u0012\u000f\t\u0005e\u00121\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014bAA#s\u00059\u0001/Y2lC\u001e,\u0017\u0002BA%\u0003\u0017\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u0015\u0013(\u0001\u0005gC&dWO]3!\u0003Q\t7\r^5wKNs\u0017\r]:i_R|eMZ:fiV\t\u0001+\u0001\rbGRLg/Z*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^0%KF$2\u0001ZA,\u0011!\t)\u0002EA\u0001\u0002\u0004\u0001\u0016!F1di&4Xm\u00158baNDw\u000e^(gMN,G\u000fI\u0001\u0014aJ,goQ8n[&$H/\u001a3PM\u001a\u001cX\r^\u0001\u0018aJ,goQ8n[&$H/\u001a3PM\u001a\u001cX\r^0%KF$2\u0001ZA1\u0011!\t)bEA\u0001\u0002\u0004\u0001\u0016\u0001\u00069sKZ\u001cu.\\7jiR,Gm\u00144gg\u0016$\b%\u0001\nqe\u001648i\\7nSR$X\rZ#q_\u000eDWCAA5!\rA\u00141N\u0005\u0004\u0003[J$aA%oi\u00061\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2i?\u0012*\u0017\u000fF\u0002e\u0003gB\u0011\"!\u0006\u0017\u0003\u0003\u0005\r!!\u001b\u0002'A\u0014XM^\"p[6LG\u000f^3e\u000bB|7\r\u001b\u0011\u00021A\u0014XM\u001e'bgR\u001cuN\u001c;bS:,G\rT8h)&lW-\u0001\u000fqe\u00164H*Y:u\u0007>tG/Y5oK\u0012dun\u001a+j[\u0016|F%Z9\u0015\u0007\u0011\fi\b\u0003\u0005\u0002\u0016e\t\t\u00111\u0001Q\u0003e\u0001(/\u001a<MCN$8i\u001c8uC&tW\r\u001a'pORKW.\u001a\u0011\u0002%5\f\u0017PY3Ti\u0006\u0014Ho\u00158baNDw\u000e\u001e\u000b\u0007\u0003\u000b\u000bY)a$\u0011\u0007a\n9)C\u0002\u0002\nf\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u000en\u0001\r\u0001U\u0001\u0015Y\u0006\u001cHoQ8oi\u0006Lg.\u001a3M_\u001e$\u0016.\\3\t\r\u0005E5\u00041\u0001\u0000\u0003!qWm^%nC\u001e,'!F'pG.lU\r^1eCR\f\u0007+\u001e2mSNDWM]\n\u00059]\n9\nE\u0002A\u00033K1!a'0\u0005EiU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d\u000b\u0003\u0003?\u0003\"\u0001 \u000f\u0015\u0007\u0011\f\u0019\u000b\u0003\u0005\u0002\u0016}\t\t\u00111\u0001\u0000\u0003!aW-\u00193fe&#WCAAU!\u0011\tY+!,\u000e\u0005\u0005%\u0012\u0002BAX\u0003S\u00111b\u00149uS>t\u0017\r\\%oi\u0006aA.Z1eKJLEm\u0018\u0013fcR\u0019A-!.\t\u0013\u0005U!%!AA\u0002\u0005%\u0016!\u00037fC\u0012,'/\u00133!\u0003\u001d\u0001XO\u00197jg\"$R\u0001ZA_\u0003\u000fDq!a0%\u0001\u0004\t\t-A\u0003eK2$\u0018\r\u0005\u0003\u0002\u0002\u0005\r\u0017\u0002BAc\u0003\u0007\u0011Q\"T3uC\u0012\fG/\u0019#fYR\f\u0007BBAII\u0001\u0007q0\u0001\u0005sK\u001eL7\u000f^3s)\r!\u0017Q\u001a\u0005\b\u0003\u001f,\u0003\u0019AAi\u0003!a\u0017n\u001d;f]\u0016\u0014\b\u0003BA\u0001\u0003'LA!!6\u0002\u0004\t)R*\u001a;bI\u0006$\u0018-S7bO\u0016d\u0015n\u001d;f]\u0016\u0014\u0018a\u00059vE2L7\u000f\u001b'fC\u0012,'o\u00115b]\u001e,Gc\u00013\u0002\\\"9\u0011Q\u001c\u0014A\u0002\u0005%\u0016a\u00038fo2+\u0017\rZ3s\u0013\u0012\faAR(P?&#UCAAr!\u0011\t)/a;\u000e\u0005\u0005\u001d(\u0002BAu\u0003\u000b\taaY8n[>t\u0017\u0002BAw\u0003O\u0014A!V;jI\u00069aiT(`\u0013\u0012\u0003\u0013aE4f]\u0016\u0014\u0018\r^3NC:L(+Z2pe\u0012\u001cH#\u00023\u0002v\u0006]\bBBAhS\u0001\u00071\t\u0003\u0004\u0002z&\u0002\r\u0001U\u0001\nK:$wJ\u001a4tKR\f\u0011\u0006^3ti\"\u000bg\u000e\u001a7f\u0007>lW.\u001b;t/&$\bNT8T]\u0006\u00048\u000f[8ui\u0016\u0014H)\u001a4j]\u0016$\u0007F\u0001\u0016i\u0003I!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;)\u0005-B\u0017a\u0004:fO&\u001cH/\u001a:Ce>\\WM]:\u0015\u000f\u0011\u00149A!\u0003\u0003\u0014!1\u0011q\u001a\u0017A\u0002\rCqAa\u0003-\u0001\u0004\u0011i!A\u0005ce>\\WM]%egB1\u0011q\u0007B\b\u0003SJAA!\u0005\u0002L\tA\u0011\n^3sC\ndW\r\u0003\u0004\u0002z2\u0002\r\u0001U\u0001\u001cGJ,\u0017\r^3U_BL7mV5uQ>sW\rU1si&$\u0018n\u001c8\u0015\u000f\u0011\u0014IBa\u0007\u0003&!1\u0011qZ\u0017A\u0002\rCqA!\b.\u0001\u0004\u0011y\"\u0001\u0005sKBd\u0017nY1t!\u0019\t9D!\t\u0002j%!!1EA&\u0005\r\u0019V-\u001d\u0005\u0007\u0003sl\u0003\u0019\u0001)")
public class BrokerMetadataListenerTest {
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");

    private BrokerMetadataListener newBrokerMetadataListener(Option<MetadataSnapshotter> snapshotter, long maxBytesBetweenSnapshots) {
        MetadataEncryptorFactory encryptorFactory = new MetadataEncryptorFactory(Collections.emptyMap());
        return new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, maxBytesBetweenSnapshots, snapshotter, x$1 -> null, encryptorFactory, KafkaConfigSchema.EMPTY);
    }

    private Option<MetadataSnapshotter> newBrokerMetadataListener$default$1() {
        return None$.MODULE$;
    }

    private long newBrokerMetadataListener$default$2() {
        return 1000000L;
    }

    @Test
    public void testCreateAndClose() {
        this.newBrokerMetadataListener(this.newBrokerMetadataListener$default$1(), this.newBrokerMetadataListener$default$2()).close();
    }

    @Test
    public void testPublish() {
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(this.newBrokerMetadataListener$default$1(), this.newBrokerMetadataListener$default$2());){
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0)})));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)2, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)200L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0)})));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newImage.highestOffsetAndEpoch().offset);
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true), (Object)delta.clusterDelta().broker(1));
                }

                public void register(MetadataImageListener listener) {
                }

                public void publishLeaderChange(OptionalInt leaderId) {
                }
            }).get();
        }
    }

    @Test
    public void testPublishLeaderChange() {
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(this.newBrokerMetadataListener$default$1(), this.newBrokerMetadataListener$default$2());){
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(1), 100));
            listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(2), 100));
            listener.startPublishing((MetadataPublisher)publisher).get();
            Assertions.assertEquals((int)2, (int)publisher.leaderId().getAsInt());
            listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(4), 900));
            listener.getImageRecords().get();
            Assertions.assertEquals((int)4, (int)publisher.leaderId().getAsInt());
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)}))));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        long x$1 = 1000L;
        Option<MetadataSnapshotter> x$2 = this.newBrokerMetadataListener$default$1();
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(x$2, x$1);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    @Test
    public void testCreateSnapshot() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener((Option<MetadataSnapshotter>)new Some((Object)snapshotter), 1000L);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)}))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava()).setLeader(0).setReplicas((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava()), (short)0)})));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;
        private OptionalInt leaderId;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public OptionalInt leaderId() {
            return this.leaderId;
        }

        public void leaderId_$eq(OptionalInt x$1) {
            this.leaderId = x$1;
        }

        public void publish(MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public void register(MetadataImageListener listener) {
        }

        public void publishLeaderChange(OptionalInt newLeaderId) {
            this.leaderId_$eq(newLeaderId);
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.leaderId = OptionalInt.empty();
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long lastContainedLogTime, MetadataImage newImage) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= newImage.highestOffsetAndEpoch().offset ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= newImage.highestOffsetAndEpoch().epoch ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                this.prevCommittedEpoch_$eq(newImage.highestOffsetAndEpoch().epoch);
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

