/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaQuota;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkTestUtils$ {
    public static ClusterLinkTestUtils$ MODULE$;
    private final Metrics metrics;
    private final MockTime time;
    private final AuthorizerServerInfo serverInfo;
    private final KafkaConfig props;
    private final boolean isMultiTenant;

    static {
        new ClusterLinkTestUtils$();
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private AuthorizerServerInfo serverInfo() {
        return this.serverInfo;
    }

    private KafkaConfig props() {
        return this.props;
    }

    private boolean isMultiTenant() {
        return this.isMultiTenant;
    }

    public ClusterLinkManager createClusterLinkManager() {
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(this.props(), "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.metrics(), (Time)this.time(), this.isMultiTenant(), ClusterLinkFactory$.MODULE$.createLinkManager$default$7());
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        EasyMock.expect((Object)this.serverInfo().interBrokerEndpoint()).andReturn((Object)brokerEndpoint).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInfo()});
        KafkaController controller = (KafkaController)EasyMock.createMock(KafkaController.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        ZkMetadataCache metadataCache = (ZkMetadataCache)EasyMock.createMock(ZkMetadataCache.class);
        EasyMock.expect((Object)zkClient.getChildren("/cluster_links")).andReturn((Object)Nil$.MODULE$).anyTimes();
        EasyMock.expect((Object)zkClient.getClusterLinks((Set)EasyMock.anyObject())).andReturn((Object)Predef$.MODULE$.Map().empty()).anyTimes();
        zkClient.transformEntityConfigs((String)EasyMock.anyObject(), (String)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkClient.clusterLinkExists((UUID)EasyMock.isA(UUID.class)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        zkClient.setOrCreateEntityConfigs(EasyMock.anyString(), EasyMock.anyString(), (Properties)EasyMock.isA(Properties.class));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        zkClient.createClusterLink((ClusterLinkData)EasyMock.isA(ClusterLinkData.class));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        zkClient.createConfigChangeNotification(EasyMock.anyString());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{zkClient});
        ZkSupport zkSupport = new ZkSupport(null, controller, zkClient, (Option)None$.MODULE$, metadataCache);
        manager.initialize(this.serverInfo(), null, (Option)None$.MODULE$, (MetadataSupport)zkSupport, (Option)None$.MODULE$);
        manager.startup(null);
        return (ClusterLinkManager)manager;
    }

    private ClusterLinkTestUtils$() {
        MODULE$ = this;
        this.metrics = new Metrics();
        this.time = new MockTime();
        this.serverInfo = (AuthorizerServerInfo)EasyMock.mock(AuthorizerServerInfo.class);
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        this.props = KafkaConfig$.MODULE$.apply((Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        this.isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((Map)this.props().values(), (Metrics)this.metrics()) != null;
    }
}

