/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.LinkMode;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0015+\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004B\u0001\u0001\u0006IA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019\t\u0006\u0001)A\u0005\t\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB,\u0001A\u0003%A\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\ru\u0003\u0001\u0015!\u0003[\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007S\u0002\u0001\u000b\u0011\u00024\t\u000f)\u0004!\u0019!C\u0005W\"1q\u000e\u0001Q\u0001\n1Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0007\u0003\u001b\u0001A\u0011A<\t\r\u0005]\u0001\u0001\"\u0001x\u0011\u0019\t\t\u0003\u0001C\u0001o\"1\u0011Q\u0005\u0001\u0005\u0002]Da!!\u000b\u0001\t\u00039\bBBA\u0017\u0001\u0011\u0005q\u000f\u0003\u0004\u00022\u0001!\ta\u001e\u0005\u0007\u0003k\u0001A\u0011A<\t\r\u0005e\u0002\u0001\"\u0001x\u0011\u0019\ti\u0004\u0001C\u0001o\"1\u0011\u0011\t\u0001\u0005\u0002]Dq!!\u0012\u0001\t\u0013\t9\u0005C\u0005\u0002\u0002\u0002\t\n\u0011\"\u0003\u0002\u0004\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011%\ti\u0010AI\u0001\n\u0013\ty\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!I!Q\u0005\u0001\u0012\u0002\u0013%!q\u0005\u0005\n\u0005W\u0001\u0011\u0013!C\u0005\u0005[AaA!\r\u0001\t\u00139(\u0001I\"mkN$XM\u001d'j].\u001c\u0016P\\2U_BL7m]\"p]\u001aLwm\u001d+fgRT!a\u000b\u0017\u0002\t1Lgn\u001b\u0006\u0003[9\naa]3sm\u0016\u0014(\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0004CA\u001e\u0001\u001b\u0005Q\u0013!C:dQ\u0016$W\u000f\\3s+\u0005q\u0004CA\u001e@\u0013\t\u0001%F\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013aC:pkJ\u001cW-\u00113nS:,\u0012\u0001\u0012\t\u0003\u000b>k\u0011A\u0012\u0006\u0003\u000f\"\u000bQ!\u00193nS:T!!\u0013&\u0002\u000f\rd\u0017.\u001a8ug*\u0011qf\u0013\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\r\nq1i\u001c8gYV,g\u000e^!e[&t\u0017\u0001D:pkJ\u001cW-\u00113nS:\u0004\u0013a\u00077pG\u0006d7\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG/F\u0001U!\tYT+\u0003\u0002WU\tYBj\\2bY\u000ecWo\u001d;fe2Kgn[!e[&t7\t\\5f]R\fA\u0004\\8dC2\u001cE.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\u0005Q\u0006CA\u001e\\\u0013\ta&F\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012\u0001\u0019\t\u0003w\u0005L!A\u0019\u0016\u00031\rcWo\u001d;fe2Kgn[\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgV\ta\r\u0005\u0002<O&\u0011\u0001N\u000b\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0002YB\u00111(\\\u0005\u0003]*\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011\u0002)Q|\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t+\u0005\u0011\bCA\u001et\u0013\t!(F\u0001\u000eNSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/A\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003a\u0004\"aM=\n\u0005i$$\u0001B+oSRD#A\u0005?\u0011\u0007u\fI!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0004CBL'\u0002BA\u0002\u0003\u000b\tqA[;qSR,'OC\u0002\u0002\b5\u000bQA[;oSRL1!a\u0003\u007f\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a1#!\u0005\u0011\u0007u\f\u0019\"C\u0002\u0002\u0016y\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002#Q,7\u000f^+qI\u0006$XmQ8oM&<7\u000fK\u0002\u0015\u00037\u00012!`A\u000f\u0013\r\tyB \u0002\u0005)\u0016\u001cH/A\nuKN$hj\\+qI\u0006$XmQ8oM&<7\u000fK\u0002\u0016\u00037\t\u0011\u0006^3ti:{'+\u001a9fCR,G\rT8dC24U\r^2i\u0007>tg-[4t\u001f:tun\u00115b]\u001e,\u0007f\u0001\f\u0002\u001c\u0005aB/Z:u\u000bb\u001cW\r\u001d;j_:4U\r^2iS:<7i\u001c8gS\u001e\u001c\bfA\f\u0002\u001c\u0005aB/Z:u\u000bb\u001cW\r\u001d;j_:\fE\u000e^3sS:<7i\u001c8gS\u001e\u001c\bf\u0001\r\u0002\u001c\u0005QB/Z:u\u000bb\u001cW\r\u001d;j_:\u001cuN\u001c4jON\u0014Vm];mi\"\u001a\u0011$a\u0007\u0002?Q,7\u000f^#yG\u0016\u0004H/[8o\u00032$XM]\"p]\u001aLwm\u001d*fgVdG\u000fK\u0002\u001b\u00037\t\u0001\u0003^3ti\u000eC\u0017M\\4f)>\u0004\u0018nY:)\u0007m\tY\"\u0001\u0011uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\bf\u0001\u000f\u0002\u001c\u0005qB/Z:u\u00032$XM]\"p]\u001aLw\rU8mS\u000eLh+[8mCRLwN\u001c\u0015\u0004;\u0005m\u0011a\u0004<fe&4\u0017pQ8oM&<W*\u00199\u0015\u000fa\fI%!\u0018\u0002h!9\u00111\n\u0010A\u0002\u00055\u0013!\u00029s_B\u001c\b\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005kRLGN\u0003\u0002\u0002X\u0005!!.\u0019<b\u0013\u0011\tY&!\u0015\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002`y\u0001\r!!\u0019\u0002#MLhn\u0019+pa&\u001c7oQ8oM&<7\u000fE\u0002<\u0003GJ1!!\u001a+\u0005q\u0019E.^:uKJd\u0015N\\6Ts:\u001cGk\u001c9jGN\u001cuN\u001c4jOND\u0011\"!\u001b\u001f!\u0003\u0005\r!a\u001b\u0002\u000bQ|\u0007/[2\u0011\t\u00055\u00141\u0010\b\u0005\u0003_\n9\bE\u0002\u0002rQj!!a\u001d\u000b\u0007\u0005U\u0004'\u0001\u0004=e>|GOP\u0005\u0004\u0003s\"\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002~\u0005}$AB*ue&twMC\u0002\u0002zQ\n\u0011D^3sS\u001aL8i\u001c8gS\u001el\u0015\r\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0011\u0016\u0005\u0003W\n9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019\nN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003EqWm^\"p]\u001aLwMU3t_V\u00148-\u001a\u000b\u0005\u0003;\u000bi\u000b\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\r\r|gNZ5h\u0015\r\t9KS\u0001\u0007G>lWn\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0011\u001d\tI\u0007\ta\u0001\u0003W\nQ#\u00197uKJ\u001cuN\u001c4jOJ+\u0017/^3ti6\u000b\u0007\u000f\u0006\u0003\u00024\u0006\u0015\u0007\u0003CA(\u0003k\u000bi*!/\n\t\u0005]\u0016\u0011\u000b\u0002\u0004\u001b\u0006\u0004\bCBA(\u0003w\u000by,\u0003\u0003\u0002>\u0006E#AC\"pY2,7\r^5p]B\u0019Q)!1\n\u0007\u0005\rgIA\u0007BYR,'oQ8oM&<w\n\u001d\u0005\b\u0003\u000f\f\u0003\u0019AAe\u0003%\u0019wN\u001c4jO6\u000b\u0007\u000f\u0005\u0005\u0002n\u0005-\u00171NA'\u0013\u0011\t9,a \u0002-5|7m[!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYR$b!!5\u0002X\u00065\bcA#\u0002T&\u0019\u0011Q\u001b$\u0003%\u0005cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u0005\b\u00033\u0014\u0003\u0019AAn\u0003\u0019!x\u000e]5dgB1\u0011Q\\At\u0003WrA!a8\u0002d:!\u0011\u0011OAq\u0013\u0005)\u0014bAAsi\u00059\u0001/Y2lC\u001e,\u0017\u0002BAu\u0003W\u0014A\u0001T5ti*\u0019\u0011Q\u001d\u001b\t\u0013\u0005=(\u0005%AA\u0002\u0005E\u0018!C3yG\u0016\u0004H/[8o!\u0015\u0019\u00141_A|\u0013\r\t)\u0010\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005u\u0017\u0011`\u0005\u0005\u0003w\fYOA\u0005UQJ|w/\u00192mK\u0006\u0001Sn\\2l\u00032$XM]\"p]\u001aLwm\u001d*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tA\u000b\u0003\u0002r\u0006\u001d\u0015a\b8fo\u000ecWo\u001d;fe2Kgn[*z]\u000e$v\u000e]5dg\u000e{gNZ5hgR\u0011\u0011\u0011M\u0001\ng\u0016$X\u000f]'pG.$R\u0001\u001fB\u0006\u0005?A\u0011B!\u0004&!\u0003\u0005\rAa\u0004\u0002#\u0005dG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u0017\u0010E\u00034\u0003g\u0014\t\u0002\u0005\u0003\u0003\u0014\tmQB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\rA|G.[2z\u0015\ti#*\u0003\u0003\u0003\u001e\tU!!E!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\"I!\u0011E\u0013\u0011\u0002\u0003\u0007!1E\u0001\ri\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e\u001f\t\u0006g\u0005M\u00181N\u0001\u0014g\u0016$X\u000f]'pG.$C-\u001a4bk2$H%M\u000b\u0003\u0005SQCAa\u0004\u0002\b\u0006\u00192/\u001a;va6{7m\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0006\u0016\u0005\u0005G\t9)\u0001\u0006wKJLg-_'pG.\u0004")
public class ClusterLinkSyncTopicsConfigsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final LocalClusterLinkAdminClient localClusterLinkAdminClient = (LocalClusterLinkAdminClient)EasyMock.mock(LocalClusterLinkAdminClient.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)EasyMock.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.mock(ClusterLinkClientManager.class);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", UUID.randomUUID(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, ClusterLinkConfig$.MODULE$.create$default$2());
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private LocalClusterLinkAdminClient localClusterLinkAdminClient() {
        return this.localClusterLinkAdminClient;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testUpdateConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).andReturn((Object)this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.mockAlterConfigsResult$default$2())).times(1);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        newProps.remove("unclean.leader.election.enable");
        this.verifyConfigMap(newProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testNoUpdateConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "compact");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        this.verifyMock();
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testNoRepeatedLocalFetchConfigsOnNoChange() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(2);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(2);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "compact");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testExceptionFetchingConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        Set<ConfigResource> describeConfigsArg = Collections.singleton(this.newConfigResource(topic));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andThrow((Throwable)new TopicAuthorizationException("")).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient(), this.metadataManager()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180))).getCause() instanceof TopicAuthorizationException));
        this.verifyMock();
    }

    @Test
    public void testExceptionAlteringConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).andThrow((Throwable)new TopicAuthorizationException("")).times(1);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221))).getCause() instanceof TopicAuthorizationException));
        this.verifyMock();
    }

    @Test
    public void testExceptionConfigsResult() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$)));
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)topics.toSet()).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl successConfig = new KafkaFutureImpl();
        successConfig.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl errorConfig = new KafkaFutureImpl();
        errorConfig.completeExceptionally((Throwable)new TopicAuthorizationException(""));
        List resources = (List)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.newConfigResource((String)topic), List$.MODULE$.canBuildFrom());
        java.util.HashSet describeConfigsArg = new java.util.HashSet(3);
        resources.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)describeConfigsArg.add(x$1)));
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.head()), (Object)successConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)errorConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(2)), (Object)successConfig)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig((String)topics.head())).andReturn((Object)curProps).times(1);
        EasyMock.expect((Object)this.metadataManager().getTopicConfig((String)topics.apply(2))).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        .colon.colon changedTopics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$));
        EasyMock.expect((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((TraversableOnce)changedTopics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)newProps), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())))).andReturn((Object)this.mockAlterConfigsResult((List<String>)changedTopics, this.mockAlterConfigsResult$default$2())).times(1);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        this.verifyConfigMap(newProps, syncTopicsConfigs, "test-topic-1");
        this.verifyConfigMap(new Properties(), syncTopicsConfigs, "test-topic-2");
        this.verifyConfigMap(newProps, syncTopicsConfigs, "test-topic-3");
    }

    @Test
    public void testExceptionAlterConfigsResult() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).andReturn((Object)this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)new Some((Object)new TopicAuthorizationException("unauthorized")))).times(1);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
    }

    @Test
    public void testChangeTopics() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)Nil$.MODULE$));
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head()}))).times(1);
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config1 = new KafkaFutureImpl();
        config1.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl config2 = new KafkaFutureImpl();
        config2.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("retention.ms", "1000000"), (List)Nil$.MODULE$)).asJavaCollection()));
        List resources = (List)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.newConfigResource((String)topic), List$.MODULE$.canBuildFrom());
        Set<Object> describeConfigsArg1 = Collections.singleton(resources.head());
        Set<Object> describeConfigsArg2 = Collections.singleton(resources.apply(1));
        DescribeConfigsResult describeConfigsResult1 = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.head()), (Object)config1)}))).asJava()));
        DescribeConfigsResult describeConfigsResult2 = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)config2)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg1))).andReturn((Object)describeConfigsResult1).times(1);
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg2))).andReturn((Object)describeConfigsResult2).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps1 = new Properties();
        curProps1.put("cleanup.policy", "compact");
        Properties curProps2 = new Properties();
        curProps2.put("retention.ms", "1000000");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig((String)topics.head())).andReturn((Object)curProps1).times(1);
        EasyMock.expect((Object)this.metadataManager().getTopicConfig((String)topics.apply(1))).andReturn((Object)curProps2).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        this.verifyMock();
    }

    @Test
    public void testClusterLinkAlterConfigPolicy() {
        scala.collection.immutable.Map oldConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preallocate"), (Object)"true")}));
        scala.collection.immutable.Map newConfigs = Predef$.MODULE$.Map().empty();
        ClusterLinkAlterConfigPolicy policy = (ClusterLinkAlterConfigPolicy)EasyMock.mock(ClusterLinkAlterConfigPolicy.class);
        EasyMock.expect((Object)policy.clusterLinkRestrictTopicConfigs((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)oldConfigs).asJava()))).andReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava()).times(1);
        policy.clusterLinkValidateTopicConfigs((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{policy});
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), (Option<String>)new Some((Object)"tenant_"));
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("preallocate", "true"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        curProps.put("preallocate", "true");
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        Properties newProps = new Properties();
        EasyMock.expect((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).andReturn((Object)this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.mockAlterConfigsResult$default$2())).times(1);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        EasyMock.verify((Object[])new Object[]{policy});
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testAlterConfigPolicyViolation() {
        AlterConfigPolicy policy = new AlterConfigPolicy(null){

            public void configure(java.util.Map<String, ?> configs) {
            }

            public void close() {
            }

            public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
                throw new PolicyViolationException("Violated!");
            }
        };
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.sourceAdmin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin()});
        Properties curProps = new Properties();
        EasyMock.expect((Object)this.metadataManager().getTopicConfig(topic)).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        EasyMock.replay((Object[])new Object[]{this.localClusterLinkAdminClient()});
        this.verifyMock();
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    private void verifyConfigMap(Properties props, ClusterLinkSyncTopicsConfigs syncTopicsConfigs, String topic) {
        scala.collection.mutable.Map actualConfigMap = syncTopicsConfigs.currentConfigMap();
        if (!props.isEmpty()) {
            HashSet expectedConfigs = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> expectedConfigs.add((Object)new ConfigEntry((String)k, (String)v))));
            Assertions.assertEquals((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)expectedConfigs).asJavaCollection()), (Object)((Option)actualConfigMap.apply((Object)topic)).get());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)actualConfigMap.apply((Object)topic));
    }

    private String verifyConfigMap$default$3() {
        return "test-topic";
    }

    private ConfigResource newConfigResource(String topic) {
        return new ConfigResource(ConfigResource.Type.TOPIC, topic);
    }

    /*
     * WARNING - void declaration
     */
    private java.util.Map<ConfigResource, Collection<AlterConfigOp>> alterConfigRequestMap(scala.collection.immutable.Map<String, Properties> configMap) {
        void var2_2;
        HashMap requestMap = new HashMap();
        configMap.foreach((Function1 & Serializable & scala.Serializable)entry2 -> {
            String topic = (String)entry2._1();
            Properties props = (Properties)entry2._2();
            java.util.HashSet configs = new java.util.HashSet();
            ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)configs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
            return requestMap.put(this.newConfigResource(topic), configs);
        });
        return var2_2;
    }

    private AlterConfigsResult mockAlterConfigsResult(List<String> topics, Option<Throwable> exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (exception instanceof Some) {
            Throwable e = (Throwable)((Some)exception).value();
            future.completeExceptionally(e);
        } else if (None$.MODULE$.equals(exception)) {
            future.complete(null);
        } else {
            throw new MatchError(exception);
        }
        scala.collection.immutable.Map valueMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)this.newConfigResource((String)t), (Object)future), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterConfigsResult result = (AlterConfigsResult)EasyMock.createMock(AlterConfigsResult.class);
        EasyMock.expect((Object)result.all()).andReturn((Object)future).anyTimes();
        EasyMock.expect((Object)result.values()).andReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)valueMap).asJava());
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private Option<Throwable> mockAlterConfigsResult$default$2() {
        return None$.MODULE$;
    }

    private ClusterLinkSyncTopicsConfigs newClusterLinkSyncTopicsConfigs() {
        return new ClusterLinkSyncTopicsConfigs(this.clientManager(), this.metadataManager(), this.localClusterLinkAdminClient(), 100, this.metrics());
    }

    private void setupMock(Option<AlterConfigPolicy> alterConfigPolicy, Option<String> tenantPrefix) {
        EasyMock.reset((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.reset((Object[])new Object[]{this.localClusterLinkAdminClient()});
        EasyMock.reset((Object[])new Object[]{this.metadataManager()});
        EasyMock.reset((Object[])new Object[]{this.clientManager()});
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.sourceAdmin()).anyTimes();
        EasyMock.expect((Object)this.clientManager().alterConfigPolicy()).andReturn(alterConfigPolicy).anyTimes();
        EasyMock.expect((Object)this.clientManager().linkData()).andReturn((Object)new ClusterLinkData("link-name", UUID.randomUUID(), (Option)None$.MODULE$, tenantPrefix, false)).anyTimes();
    }

    private Option<AlterConfigPolicy> setupMock$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setupMock$default$2() {
        return None$.MODULE$;
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
        EasyMock.verify((Object[])new Object[]{this.localClusterLinkAdminClient()});
    }
}

