/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.LinkMode;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4Aa\u0004\t\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rU\u0002\u0001\u0015!\u00030\u0011\u001d1\u0004A1A\u0005\n]Ba\u0001\u0010\u0001!\u0002\u0013A\u0004bB\u001f\u0001\u0005\u0004%IA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000f\r\u0003!\u0019!C\u0005\t\"1\u0011\u000b\u0001Q\u0001\n\u0015CqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004[\u0001\u0001\u0006I\u0001\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0002\u001d\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$H+Z:u\u0015\t\t\"#\u0001\u0003mS:\\'BA\n\u0015\u0003\u0019\u0019XM\u001d<fe*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002!\u00051A.\u001b8l\u0013\u0012,\u0012\u0001\n\t\u0003K)j\u0011A\n\u0006\u0003O!\nA!\u001e;jY*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0011)V+\u0013#\u0002\u000f1Lgn[%eA\u0005AA.\u001b8l\u001d\u0006lW-F\u00010!\t\u00014'D\u00012\u0015\t\u0011\u0004&\u0001\u0003mC:<\u0017B\u0001\u001b2\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\rEJ|7.\u001a:D_:4\u0017nZ\u000b\u0002qA\u0011\u0011HO\u0007\u0002%%\u00111H\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ce>\\WM]\"p]\u001aLw\rI\u0001\t[\u0016$\u0018\rZ1uCV\tq\b\u0005\u0002\"\u0001&\u0011\u0011\t\u0005\u0002\u0014\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y\u0001\n[\u0016$\u0018\rZ1uC\u0002\nq!\\3ue&\u001c7/F\u0001F!\t1u*D\u0001H\u0015\t\u0019\u0005J\u0003\u0002J\u0015\u000611m\\7n_:T!!F&\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0005\u0003!\u001e\u0013q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0011!\u0018.\\3\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016%\u0002\u000bU$\u0018\u000e\\:\n\u0005e3&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u00023Q,7\u000f\u001e'j].LE-\u00138SKF,Xm\u001d;IK\u0006$WM\u001d\u000b\u0002;B\u0011\u0011DX\u0005\u0003?j\u0011A!\u00168ji\"\u0012a\"\u0019\t\u0003E&l\u0011a\u0019\u0006\u0003I\u0016\f1!\u00199j\u0015\t1w-A\u0004kkBLG/\u001a:\u000b\u0005!l\u0015!\u00026v]&$\u0018B\u00016d\u0005\u0011!Vm\u001d;")
public class ClusterLinkNetworkClientTest {
    private final UUID linkId = UUID.randomUUID();
    private final String linkName;
    private final KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig(), this.linkName(), this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, 100L, 60000L);
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();

    private UUID linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private ClusterLinkMetadata metadata() {
        return this.metadata;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    @Test
    public void testLinkIdInRequestHeader() {
        Properties props = new Properties();
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        ClusterLinkNetworkClient client = new ClusterLinkNetworkClient(linkConfig, "", (Option)new Some((Object)this.metadata()), (Option)None$.MODULE$, this.metrics(), (Map)Map$.MODULE$.empty(), (Time)this.time(), "clientId", "fetcher", new LogContext());
        Assertions.assertNotNull((Object)client.networkClient());
        ((NetworkClient)client.networkClient()).enableDestinationClusterLink(this.linkId(), null, null);
        MetadataRequest.Builder builder = new MetadataRequest.Builder(Collections.emptyList(), false);
        RequestHeader header = client.networkClient().newClientRequest("0", (AbstractRequest.Builder)builder, this.time().milliseconds(), true, 30000, null).makeHeader(ApiKeys.METADATA.latestVersion());
        Assertions.assertEquals(Optional.of(this.linkId()), (Object)header.clusterLinkId());
    }

    public ClusterLinkNetworkClientTest() {
        this.linkName = "testLink";
    }
}

