/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import kafka.controller.KafkaController;
import kafka.server.link.AbstractClusterLinkMetadataManagerTest;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.metadata.ZkMetadataCache;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0004\b\u0001+!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0013q\u0002B\u0002\u0013\u0001A\u0003%q\u0004C\u0004&\u0001\t\u0007I\u0011\u0002\u0014\t\r5\u0002\u0001\u0015!\u0003(\u0011\u001dq\u0003A1A\u0005\n=BaA\u000e\u0001!\u0002\u0013\u0001\u0004\"B\u001c\u0001\t\u0003A\u0004\"B)\u0001\t\u0003\u0011\u0006\"B,\u0001\t\u0003\u0011\u0006\"\u0002/\u0001\t\u0003\u0011\u0006\"\u00020\u0001\t\u0003\u0011&aK\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014x+\u001b;i5.\u001cV\u000f\u001d9peR$Vm\u001d;\u000b\u0005=\u0001\u0012\u0001\u00027j].T!!\u0005\n\u0002\rM,'O^3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u00039I!!\u0007\b\u0003M\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011q\u0003A\u0001\u000bG>tGO]8mY\u0016\u0014X#A\u0010\u0011\u0005\u0001\u0012S\"A\u0011\u000b\u0005u\u0011\u0012BA\u0012\"\u0005=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018aC2p]R\u0014x\u000e\u001c7fe\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)\u0002\u0012\u0001C7fi\u0006$\u0017\r^1\n\u00051J#a\u0004.l\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005A!p[\"mS\u0016tG/F\u00011!\t\tD'D\u00013\u0015\t\u0019$#\u0001\u0002{W&\u0011QG\r\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013i\\7\t\\5f]R\u0004\u0013!B:fiV\u0003HCA\u001d@!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0011)f.\u001b;\t\u000b\u0001C\u0001\u0019A!\u0002\t%tgm\u001c\t\u0003\u0005.k\u0011a\u0011\u0006\u0003\t\u0016\u000b1!\u00199j\u0015\t1u)A\u0004kkBLG/\u001a:\u000b\u0005!K\u0015!\u00026v]&$(\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0007\nAA+Z:u\u0013:4w\u000e\u000b\u0002\t\u001dB\u0011!iT\u0005\u0003!\u000e\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A\u001d)\u0005%!\u0006C\u0001\"V\u0013\t16IA\u0005BMR,'/R1dQ\u0006QC/Z:u\u001b\u0016$\u0018\rZ1uCR{\u0007/[2De\u0016\fG/[8o/&$\bNR1jY\u0016$\u0017\t\u001e;f[B$\bF\u0001\u0006Z!\t\u0011%,\u0003\u0002\\\u0007\n!A+Z:u\u0003E\"Xm\u001d;NKR\fG-\u0019;b)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRDGk\u001c9jG\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:D#aC-\u0002GQ,7\u000f\u001e)beRLG/[8o\u000b2,7\r^5p]\u0006sGMU3tS\u001et\u0017\r^5p]\"\u0012A\"\u0017")
public class ClusterLinkMetadataManagerWithZkSupportTest
extends AbstractClusterLinkMetadataManagerTest {
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final ZkMetadataCache metadataCache = (ZkMetadataCache)EasyMock.createNiceMock(ZkMetadataCache.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);

    private KafkaController controller() {
        return this.controller;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @BeforeEach
    public void setUp(TestInfo info) {
        EasyMock.reset((Object[])new Object[]{this.destAdmin(), this.metadataCache(), this.zkClient()});
        if (info.getDisplayName().startsWith("testMetadataTopicCreation")) {
            EasyMock.replay((Object[])new Object[]{this.destAdmin(), this.metadataCache(), this.zkClient()});
            this.metadataManager_$eq((ClusterLinkMetadataManager)new ClusterLinkMetadataManagerWithZkSupport(this.brokerConfig(), this.scheduler(), this.metadataCache(), this.controller(), this.zkClient(), this.clusterLinkManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin()));
            return;
        }
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("_confluent-link-metadata")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)50))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.destAdmin(), this.metadataCache(), this.zkClient()});
        this.metadataManager_$eq((ClusterLinkMetadataManager)new ClusterLinkMetadataManagerWithZkSupport(this.brokerConfig(), this.scheduler(), this.metadataCache(), this.controller(), this.zkClient(), this.clusterLinkManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin()));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic();
    }

    @AfterEach
    public void tearDown() {
        if (this.metadataManager() != null) {
            this.metadataManager().shutdown();
        }
        this.metadataManager_$eq(null);
    }

    @Test
    public void testMetadataTopicCreationWithFailedAttempt() {
        EasyMock.reset((Object[])new Object[]{this.metadataCache(), this.zkClient()});
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("_confluent-link-metadata")).andReturn((Object)None$.MODULE$).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataCache(), this.zkClient()});
        EasyMock.reset((Object[])new Object[]{this.destAdmin()});
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).once().andReturn((Object)this.createMetadataTopicResult((Option<Throwable>)None$.MODULE$)).once();
        EasyMock.replay((Object[])new Object[]{this.destAdmin()});
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic();
        EasyMock.verify((Object[])new Object[]{this.destAdmin(), this.metadataCache(), this.zkClient(), this.clusterLinkManager()});
    }

    @Test
    public void testMetadataTopicCreationWithTopicExistsException() {
        EasyMock.reset((Object[])new Object[]{this.metadataCache(), this.zkClient()});
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("_confluent-link-metadata")).andReturn((Object)None$.MODULE$).once().andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions()))));
        EasyMock.replay((Object[])new Object[]{this.metadataCache(), this.zkClient()});
        EasyMock.reset((Object[])new Object[]{this.destAdmin()});
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicExistsException("")))).once();
        EasyMock.replay((Object[])new Object[]{this.destAdmin()});
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic();
        EasyMock.verify((Object[])new Object[]{this.destAdmin(), this.metadataCache(), this.zkClient(), this.clusterLinkManager()});
    }

    @Test
    public void testPartitionElectionAndResignation() {
        String clusterLinkName = "testLink";
        int partition = Utils.toPositive((int)Utils.murmur2((byte[])clusterLinkName.getBytes())) % Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions());
        this.metadataManager().onElection(partition, 10);
        ClusterLinkMetadataManager qual$1 = this.metadataManager();
        boolean x$2 = qual$1.isLinkCoordinator$default$2();
        Assertions.assertTrue((boolean)qual$1.isLinkCoordinator(clusterLinkName, x$2), (String)"Broker is not leader for cluster link");
        ClusterLinkMetadataManager qual$2 = this.metadataManager();
        String x$3 = "testLink2";
        boolean x$4 = qual$2.isLinkCoordinator$default$2();
        Assertions.assertFalse((boolean)qual$2.isLinkCoordinator(x$3, x$4), (String)"Broker is leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)));
        ClusterLinkMetadataManager qual$3 = this.metadataManager();
        boolean x$6 = qual$3.isLinkCoordinator$default$2();
        Assertions.assertTrue((boolean)qual$3.isLinkCoordinator(clusterLinkName, x$6), (String)"Broker is not leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)11)));
        ClusterLinkMetadataManager qual$4 = this.metadataManager();
        boolean x$8 = qual$4.isLinkCoordinator$default$2();
        Assertions.assertFalse((boolean)qual$4.isLinkCoordinator(clusterLinkName, x$8), (String)"Broker is leader for cluster link");
        this.metadataManager().onElection(partition, 9);
        ClusterLinkMetadataManager qual$5 = this.metadataManager();
        boolean x$10 = qual$5.isLinkCoordinator$default$2();
        Assertions.assertFalse((boolean)qual$5.isLinkCoordinator(clusterLinkName, x$10), (String)"Broker is leader for cluster link");
        this.metadataManager().onElection(partition, 12);
        ClusterLinkMetadataManager qual$6 = this.metadataManager();
        boolean x$12 = qual$6.isLinkCoordinator$default$2();
        Assertions.assertTrue((boolean)qual$6.isLinkCoordinator(clusterLinkName, x$12), (String)"Broker is not leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)None$.MODULE$);
        ClusterLinkMetadataManager qual$7 = this.metadataManager();
        boolean x$14 = qual$7.isLinkCoordinator$default$2();
        Assertions.assertFalse((boolean)qual$7.isLinkCoordinator(clusterLinkName, x$14), (String)"Broker is leader for cluster link");
        EasyMock.verify((Object[])new Object[]{this.destAdmin(), this.metadataCache(), this.zkClient(), this.clusterLinkManager()});
    }
}

