/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.Partition;
import kafka.cluster.PartitionState;
import kafka.common.KafkaException;
import kafka.controller.KafkaController;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.FetcherPool;
import kafka.server.FetcherTag;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.UnavailableClusterLink$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.test.TestUtils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001\u0002\u00180\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004H\u0001\u0001\u0006Ia\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u00191\u0006\u0001)A\u0005\u0015\"9q\u000b\u0001b\u0001\n\u0013A\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011B1\t\r\u0015\u0004\u0001\u0015!\u0003c\u0011\u001d1\u0007A1A\u0005\n\u001dDa!\u001c\u0001!\u0002\u0013A\u0007b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007m\u0002\u0001\u000b\u0011\u00029\t\u000f]\u0004!\u0019!C\u0005q\"1A\u0010\u0001Q\u0001\neD\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002@\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011q\u0001\u0005\u000b\u0003'\u0001\u0001\u0019!A!B\u0013y\bbCA\u000b\u0001\u0001\u0007\t\u0019!C\u0005\u0003/A1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u0011Q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\r\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0016\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0018\u0001\t\u0003\t)\u0005C\u0004\u0002h\u0001!\t!!\u0012\t\u000f\u0005E\u0004\u0001\"\u0001\u0002F!9\u0011Q\u000f\u0001\u0005\u0002\u0005\u0015\u0003bBA=\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003w\u0002A\u0011AA#\u0011\u001d\ti\b\u0001C\u0001\u0003\u000bBq!a \u0001\t\u0003\t)\u0005C\u0004\u0002\u0002\u0002!\t!!\u0012\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011q\u0017\u0001\u0005\u0002\u0005\u0015\u0003bBA^\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u007f\u0003A\u0011AA#\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bBq!a2\u0001\t\u0003\t)\u0005C\u0004\u0002L\u0002!\t!!\u0012\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017\u0011ac\u00117vgR,'\u000fT5oW6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003aE\nA\u0001\\5oW*\u0011!gM\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A \u0011\u0005\u0001\u0003Q\"A\u0018\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0016\u0003\r\u0003\"\u0001R#\u000e\u0003EJ!AR\u0019\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000eEJ|7.\u001a:D_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\t!\n\u0005\u0002L)6\tAJ\u0003\u0002I\u001b*\u0011ajT\u0001\u0007G>lWn\u001c8\u000b\u0005Q\u0002&BA)S\u0003\u0019\t\u0007/Y2iK*\t1+A\u0002pe\u001eL!!\u0016'\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,W#A-\u0011\u0005ikV\"A.\u000b\u0005qk\u0015!B;uS2\u001c\u0018B\u00010\\\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002EB\u0011AiY\u0005\u0003IF\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0002QB\u0011\u0011n[\u0007\u0002U*\u0011amM\u0005\u0003Y*\u0014qbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0001\fG>tGO]8mY\u0016\u0014\b%\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:4\u0003\tQ8.\u0003\u0002ve\ni1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005I\bC\u0001#{\u0013\tY\u0018GA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003}\u00042\u0001QA\u0001\u0013\r\t\u0019a\f\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/\u0001\fdYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014x\fJ3r)\u0011\tI!a\u0004\u0011\u0007a\nY!C\u0002\u0002\u000ee\u0012A!\u00168ji\"A\u0011\u0011C\t\u0002\u0002\u0003\u0007q0A\u0002yIE\n1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\n\u0011B_6TkB\u0004xN\u001d;\u0016\u0005\u0005e\u0001c\u0001#\u0002\u001c%\u0019\u0011QD\u0019\u0003\u0013i[7+\u001e9q_J$\u0018!\u0004>l'V\u0004\bo\u001c:u?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005\r\u0002\"CA\t)\u0005\u0005\t\u0019AA\r\u0003)Q8nU;qa>\u0014H\u000fI\u0001\u001ei>\u0004\u0018nY\"p]\u001aLwmU=oG&s7\r\\;eK\u0012+g-Y;miV\u0011\u00111\u0006\t\u0005\u0003[\tYD\u0004\u0003\u00020\u0005]\u0002cAA\u0019s5\u0011\u00111\u0007\u0006\u0004\u0003k)\u0014A\u0002\u001fs_>$h(C\u0002\u0002:e\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001ds\u0005qBo\u001c9jG\u000e{gNZ5h'ft7-\u00138dYV$W\rR3gCVdG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003\u0013A3\u0001GA%!\u0011\tY%!\u0017\u000e\u0005\u00055#\u0002BA(\u0003#\n1!\u00199j\u0015\u0011\t\u0019&!\u0016\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u000b*\u0002\u000b),h.\u001b;\n\t\u0005m\u0013Q\n\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007e\t\t\u0007\u0005\u0003\u0002L\u0005\r\u0014\u0002BA3\u0003\u001b\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002!Q,7\u000f^\"mkN$XM\u001d'j].\u001c\bf\u0001\u000e\u0002lA!\u00111JA7\u0013\u0011\ty'!\u0014\u0003\tQ+7\u000f^\u0001\u0010i\u0016\u001cHOU3d_:4\u0017nZ;sK\"\u001a1$a\u001b\u0002OQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2J]\u000edW\u000fZ3D_6\u0004\u0018\r^5cS2LG/\u001f\u0015\u00049\u0005-\u0014!\u0004,fe&4\u0017\u0010R3gCVdG/A\u000eWKJLg-\u001f.L\u0011\u0006\u001cX*\u00197g_JlW\rZ\"p]\u001aLwm]\u0001\u001a-\u0016\u0014\u0018NZ=[\u0017\"\u000b7/\u00168l]><hnQ8oM&<7/A\u000eWKJLg-\u001f.L\u001b&\u001c8/Z:BY^\f\u0017p]\"p]\u001aLwm]\u0001\u001e-\u0016\u0014\u0018NZ=[\u0017\"\u000b7/\u00138eKB,g\u000eZ3oi\u000e{gNZ5hg\u0006\t2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6\u0015\u0011\u0005\u001d\u0015QSAM\u0003[\u0003B!!#\u0002\u0010:\u0019\u0001)a#\n\u0007\u00055u&\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018\u0002BAI\u0003'\u0013aBR3uG\",'/T1oC\u001e,'OC\u0002\u0002\u000e>Bq!a&#\u0001\u0004\tY#\u0001\u0005mS:\\g*Y7f\u0011\u001d\tYJ\ta\u0001\u0003;\u000ba\u0001\\5oW&#\u0007\u0003BAP\u0003Sk!!!)\u000b\t\u0005\r\u0016QU\u0001\u0005kRLGN\u0003\u0002\u0002(\u0006!!.\u0019<b\u0013\u0011\tY+!)\u0003\tU+\u0016\n\u0012\u0005\b\u0003_\u0013\u0003\u0019AAY\u0003A\u0019G.^:uKJd\u0015N\\6Qe>\u00048\u000f\u0005\u0003\u0002 \u0006M\u0016\u0002BA[\u0003C\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003a!Xm\u001d;GC&dW\rZ!eI\u000ecWo\u001d;fe2Kgn\u001b\u0015\u0004G\u0005-\u0014A\u0006;fgR\u0014VmY8oM&<WO]3GC&dWO]3)\u0007\u0011\nY'A\u000buKN$H)\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6)\u0007\u0015\nY'\u0001\u000buKN$H)\u001f8b[&\u001cg)\u001a;dQNK'0\u001a\u0015\u0004M\u0005-\u0014!\t;fgR\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a*fK:\u001c'/\u001f9uS>t\u0007fA\u0014\u0002l\u0005\u0001C/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\"fM>\u0014X\rT5oWV\u0003H-\u0019;fQ\rA\u00131N\u0001\u0013GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw\rF\u0001D\u0003i\u0019G.^:uKJd\u0015N\\6QKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t+\t\t\t,A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e,\"!a7\u0011\u0007\u0001\u000bi.C\u0002\u0002`>\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003%\u0019X\r^;q\u001b>\u001c7\u000e\u0006\u0005\u0002\n\u0005\u0015\u0018Q\u001fB\u0001\u0011\u001d\t9\u000f\fa\u0001\u0003S\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<4\u0003\u001d\u0019G.^:uKJLA!a=\u0002n\nI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0003od\u0003\u0019AA}\u0003\t!\b\u000f\u0005\u0003\u0002|\u0006uX\"A'\n\u0007\u0005}XJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005mE\u00061\u0001\u0003\u0004A)\u0001H!\u0002\u0002\u001e&\u0019!qA\u001d\u0003\r=\u0003H/[8o\u0003a\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u000b\u0006\u007f\n5!q\u0002\u0005\u0006\u00036\u0002\ra\u0011\u0005\b\u0005#i\u0003\u0019\u0001B\n\u0003=iW\r^1eCR\f7+\u001e9q_J$\bc\u0001#\u0003\u0016%\u0019!qC\u0019\u0003\u001f5+G/\u00193bi\u0006\u001cV\u000f\u001d9peR\u0004")
public class ClusterLinkManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final MetadataCache metadataCache = MetadataCache$.MODULE$.zkMetadataCache(0, MetadataCache$.MODULE$.zkMetadataCache$default$2());
    private ClusterLinkManager clusterLinkManager;
    private ZkSupport zkSupport;
    private final String topicConfigSyncIncludeDefault = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault()).asScala()).mkString(",");

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    private ZkSupport zkSupport() {
        return this.zkSupport;
    }

    private void zkSupport_$eq(ZkSupport x$1) {
        this.zkSupport = x$1;
    }

    private String topicConfigSyncIncludeDefault() {
        return this.topicConfigSyncIncludeDefault;
    }

    @BeforeEach
    public void setUp() {
        EasyMock.expect((Object)this.replicaManager().metadataCache()).andReturn((Object)this.metadataCache()).anyTimes();
        EasyMock.expect((Object)this.replicaManager().zkClient()).andReturn((Object)new Some((Object)this.zkClient())).anyTimes();
        EasyMock.expect((Object)this.replicaManager().leaderPartitionsIterator()).andReturn((Object)Predef$.MODULE$.Set().empty().iterator()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)this.zkClient().getChildren("/cluster_links")).andReturn((Object)Nil$.MODULE$).anyTimes();
        EasyMock.expect((Object)this.zkClient().getClusterLinks(Predef$.MODULE$.Set().empty())).andReturn((Object)Predef$.MODULE$.Map().empty()).anyTimes();
        this.zkClient().transformEntityConfigs((String)EasyMock.anyObject(), (String)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.zkSupport_$eq(new ZkSupport(null, this.controller(), this.zkClient(), (Option)None$.MODULE$, (ZkMetadataCache)this.metadataCache()));
        this.clusterLinkManager_$eq(this.createClusterLinkManager(this.brokerConfig(), (MetadataSupport)this.zkSupport()));
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinks() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)EasyMock.createNiceMock(Partition.class);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.clusterLinkManager().resolveLinkIdOrThrow(linkName), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.clusterLinkManager().listClusterLinks());
        this.setupMock(partition0, tp0, (Option<UUID>)None$.MODULE$);
        this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        ClusterLinkClientManager clientManager = (ClusterLinkClientManager)this.clusterLinkManager().clientManager(linkId).get();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, UUID.randomUUID(), (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(ClusterLinkExistsException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertTrue((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not added to client manager");
        Assertions.assertFalse((boolean)fetcherManager.isEmpty(), (String)"Fetcher not recording active topic");
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)EasyMock.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        EasyMock.expect((Object)partitionState.clusterLinkId()).andReturn((Object)linkId.toString()).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkTopicState()).andReturn((Object)"Mirror").anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionState.linkedLeaderEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)1)).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkSourceTopicId()).andReturn((Object)Uuid.randomUuid()).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not removed from client manager");
        EasyMock.reset((Object[])new Object[]{partitionState});
        EasyMock.expect((Object)partitionState.clusterLinkId()).andReturn(null).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkSourceTopicId()).andReturn((Object)Uuid.randomUuid()).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager");
        EasyMock.reset((Object[])new Object[]{partitionState});
        EasyMock.expect((Object)partitionState.clusterLinkId()).andReturn((Object)linkId.toString()).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkSourceTopicId()).andReturn((Object)Uuid.randomUuid()).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkTopicState()).andReturn((Object)"FailedMirror").anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionState.linkedLeaderEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)-1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata for failed mirror");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager for failed mirror");
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Partition partition1 = (Partition)EasyMock.createNiceMock(Partition.class);
        this.setupMock(partition1, tp1, (Option<UUID>)new Some((Object)linkId));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be added to client manager");
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in to client manager");
        Object object = this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertTrue((object != null && object.equals(fetcherManager) ? 1 : 0) != 0, (String)"Unexpected fetcher manager");
        Object object2 = this.clusterLinkManager().clientManager(linkId).get();
        Assertions.assertTrue((object2 != null && object2.equals(clientManager) ? 1 : 0) != 0, (String)"Unexpected client manager");
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        this.zkClient().setClusterLink(new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().deleteClusterLink(linkName, linkId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().deleteClusterLink(linkName, linkId), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinks$4(this, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinks$5(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testReconfigure() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFactory.FetcherManager fetcherManager = (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString())).andReturn((Object)newProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$3(props)));
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString())).andReturn((Object)newProps).times(1);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).times(1);
        Capture capturedProps = EasyMock.newCapture();
        this.zkClient().setOrCreateEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Properties)EasyMock.capture((Capture)capturedProps));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$4(props)));
        this.clusterLinkManager().processClusterLinkChanges(linkId, (Properties)capturedProps.getValue());
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
    }

    @Test
    public void testTopicConfigSyncIncludeCompatibility() {
        this.VerifyDefault();
        this.VerifyZKHasMalformedConfigs();
        this.VerifyZKHasUnknownConfigs();
        this.VerifyZKMissesAlwaysConfigs();
        this.VerifyZKHasIndependentConfigs();
    }

    public void VerifyDefault() {
        String linkName = "test-default";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala()).toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKHasMalformedConfigs() {
        String linkName = "test-malformed";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(22).append(this.topicConfigSyncIncludeDefault()).append(" min.compaction.lag.ms").toString());
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala()).toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKHasUnknownConfigs() {
        String linkName = "test-unknown";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(21).append(this.topicConfigSyncIncludeDefault()).append(",unknown.topic.config").toString());
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala()).toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKMissesAlwaysConfigs() {
        String linkName = "test-always";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = LogConfig$.MODULE$.MinCompactionLagMsProp();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.MinCompactionLagMsProp()}))), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKHasIndependentConfigs() {
        String linkName = "test-independent";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.TierEnableProp()}))).mkString(",");
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public ClusterLinkFactory.FetcherManager createClusterLink(String linkName, UUID linkId, Properties clusterLinkProps) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$createClusterLink$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), clusterLinkProps);
        return (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
    }

    @Test
    public void testFailedAddClusterLink() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        this.zkClient().createClusterLink(clusterLinkData);
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new RuntimeException("")).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
    }

    @Test
    public void testReconfigureFailure() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)clusterLinkData)}))).once();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "");
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteClusterLink() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)clusterLinkData)}))).once();
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions.assertEquals((Object)UnavailableClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)this.clusterLinkManager().clearMirrorTopics().keySet());
        scala.collection.mutable.Map managers = (scala.collection.mutable.Map)TestUtils.fieldValue((Object)this.clusterLinkManager(), ClusterLinkManager.class, (String)"managers");
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)managers);
        this.clusterLinkManager().processClusterLinkChanges(linkId, new Properties());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})), (Object)this.clusterLinkManager().clearMirrorTopics().keySet());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testDeleteClusterLink$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testDeleteClusterLink$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDynamicFetchSize() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        FetchResponseSize defaultSize = new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()));
        Assertions.assertEquals((Object)defaultSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
        UUID linkId = UUID.randomUUID();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().createClusterLink(new ClusterLinkData("link", linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals((int)0, (int)fetcherManager.fetcherThreadCount());
        this.verifyFetchSize$1(defaultSize, props);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "6000");
        this.verifyFetchSize$1(new FetchResponseSize(6000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Integer.MAX_VALUE));
        this.verifyFetchSize$1(defaultSize, props);
        ClusterLinkFetcherThread thread = (ClusterLinkFetcherThread)EasyMock.createNiceMock(ClusterLinkFetcherThread.class);
        IntRef numThreads = IntRef.create((int)0);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()) * 6));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            ClusterLinkManagerTest.addFetcherThread$1(numThreads, fetcherManager, thread);
            this.verifyFetchSize$1(new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes())), props);
        });
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "1");
        this.verifyFetchSize$1(new FetchResponseSize(1000, 2000), props);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> ClusterLinkManagerTest.addFetcherThread$1(numThreads, fetcherManager, thread));
        this.verifyFetchSize$1(new FetchResponseSize(500, 1000), props);
        fetcherManager.fetcherThreadMap().clear();
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinkConfigReencryption() {
        String linkName = "link1";
        UUID linkId = UUID.randomUUID();
        ObjectRef executor = ObjectRef.create(null);
        KafkaException testException = new KafkaException("Test exception");
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)testException).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(Long.MAX_VALUE, executor);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$1(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(Long.MAX_VALUE, executor);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$3(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(30000L, executor);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$5(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(1L, executor);
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$7(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)testException).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(1L, executor);
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$9(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testLeaderAndIsrBeforeLinkUpdate() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)EasyMock.createNiceMock(Partition.class);
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        EasyMock.expect((Object)this.replicaManager().metadataCache()).andReturn((Object)this.metadataCache()).anyTimes();
        EasyMock.expect((Object)this.replicaManager().zkClient()).andReturn((Object)new Some((Object)this.zkClient())).anyTimes();
        EasyMock.expect((Object)this.replicaManager().leaderPartitionsIterator()).andReturn((Object)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))).iterator()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.mock(ClusterLinkFetcherManager.class);
        fetcherManager.addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        fetcherManager.shutdown();
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{fetcherManager});
        ClusterLinkDestConnectionManager connectionManager = (ClusterLinkDestConnectionManager)EasyMock.mock(ClusterLinkDestConnectionManager.class);
        EasyMock.expect((Object)connectionManager.currentConfig()).andReturn((Object)this.clusterLinkConfig()).anyTimes();
        connectionManager.shutdown();
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{connectionManager});
        ClusterLinkManager.Managers managers = new ClusterLinkManager.Managers((Option)new Some((Object)fetcherManager), (Option)None$.MODULE$, (ClusterLinkFactory.ConnectionManager)connectionManager, null);
        this.clusterLinkManager().commitAddClusterLink(clusterLinkData, managers, (LinkMode)LinkMode.Destination$.MODULE$);
        EasyMock.verify((Object[])new Object[]{fetcherManager});
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    /*
     * WARNING - void declaration
     */
    private Properties clusterLinkPersistentProps() {
        void var1_1;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        return var1_1;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)this.clusterLinkPersistentProps(), ClusterLinkConfig$.MODULE$.create$default$2());
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<UUID> linkId) {
        EasyMock.reset((Object[])new Object[]{partition});
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)tp).anyTimes();
        EasyMock.expect((Object)partition.getClusterLinkId()).andReturn(linkId).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty())).anyTimes();
        EasyMock.expect((Object)partition.getLinkedLeaderEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))).anyTimes();
        PartitionState partitionState = (PartitionState)EasyMock.mock(PartitionState.class);
        EasyMock.expect((Object)partitionState.clusterLink()).andReturn((Object)linkId.map((Function1 & Serializable & scala.Serializable)id -> new ClusterLinkState(id, (TopicLinkState)TopicLinkMirror$.MODULE$, null))).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        EasyMock.expect((Object)partition.partitionState()).andReturn((Object)partitionState).anyTimes();
        EasyMock.replay((Object[])new Object[]{partition});
    }

    private ClusterLinkManager createClusterLinkManager(KafkaConfig brokerConfig, MetadataSupport metadataSupport) {
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((java.util.Map)brokerConfig.values(), (Metrics)this.metrics()) != null;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.metrics(), (Time)this.time(), isMultiTenant, ClusterLinkFactory$.MODULE$.createLinkManager$default$7());
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)EasyMock.mock(AuthorizerServerInfo.class);
        EasyMock.expect((Object)serverInfo.interBrokerEndpoint()).andReturn((Object)brokerEndpoint).anyTimes();
        EasyMock.replay((Object[])new Object[]{serverInfo});
        manager.initialize(serverInfo, null, (Option)None$.MODULE$, metadataSupport, (Option)None$.MODULE$);
        manager.startup(this.replicaManager());
        return (ClusterLinkManager)manager;
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinks$4(ClusterLinkManagerTest $this, UUID linkId$1) {
        return $this.clusterLinkManager().fetcherManager(linkId$1).isEmpty() && $this.clusterLinkManager().clientManager(linkId$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinks$5(UUID linkId$1) {
        return new StringBuilder(38).append("Linked fetcher/client for ").append(linkId$1).append(" not removed").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$3(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$4(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLink$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteClusterLink$1(ClusterLinkManagerTest $this) {
        return $this.clusterLinkManager().clearMirrorTopics().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLink$2() {
        return "Cluster link not removed";
    }

    private final void verifyFetchSize$1(FetchResponseSize expectedSize, Properties props$1) {
        this.brokerConfig().updateCurrentConfig(KafkaConfig$.MODULE$.fromProps(props$1));
        this.clusterLinkManager().updateDynamicFetchSize();
        Assertions.assertEquals((Object)expectedSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
    }

    private static final void addFetcherThread$1(IntRef numThreads$1, ClusterLinkFetcherManager fetcherManager$1, ClusterLinkFetcherThread thread$1) {
        ++numThreads$1.elem;
        fetcherManager$1.fetcherThreadMap().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FetcherTag(0, numThreads$1.elem, (FetcherPool)FetcherPool.Default$.MODULE$)), (Object)thread$1));
    }

    private final void setupZkClient$1(UUID linkId$2, String linkName$4) {
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)this.zkClient().getChildren("/cluster_links")).andReturn((Object)new .colon.colon((Object)linkId$2.toString(), (List)Nil$.MODULE$)).anyTimes();
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId$2})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId$2), (Object)new ClusterLinkData(linkName$4, linkId$2, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).anyTimes();
    }

    private final void recreateClusterLinkManager$1(long oldSecretTtl, ObjectRef executor$1) {
        this.clusterLinkManager().shutdown();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.password.encoder.old.secret.ttl.ms", Long.toString(oldSecretTtl));
        this.clusterLinkManager_$eq(this.createClusterLinkManager(KafkaConfig$.MODULE$.fromProps(props), (MetadataSupport)this.zkSupport()));
        executor$1.elem = (ScheduledThreadPoolExecutor)TestUtils.fieldValue((Object)this.clusterLinkManager().scheduler(), KafkaScheduler.class, (String)"executor");
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$1(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$2() {
        return "Retry not scheduled after failure";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$3(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$4() {
        return "Unnecessary retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$5(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$6() {
        return "Old encoder delete not scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$7(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$8() {
        return "Unnecessary delete retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$9(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() > 1L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$10() {
        return "Delete retry not scheduled";
    }
}

