/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.utils.MethodInvocationTracker;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00044\u0001\u0001\u0006Ia\n\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019a\u0004\u0001)A\u0005m!IQ\b\u0001a\u0001\u0002\u0004%IA\u0010\u0005\n\r\u0002\u0001\r\u00111A\u0005\n\u001dC\u0011\"\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B \t\u000f9\u0003!\u0019!C\u0005\u001f\"1\u0001\f\u0001Q\u0001\nACQ!\u0017\u0001\u0005\u0002iCQA\u001a\u0001\u0005\u0002iCQa\u001b\u0001\u0005\u0002iCQ!\u001c\u0001\u0005\n9DQ\u0001\u001f\u0001\u0005\neDq!a\n\u0001\t\u0013\tI\u0003C\u0004\u00020\u0001!I!!\r\u0003-\rcWo\u001d;fe2Kgn\u001b$bGR|'/\u001f+fgRT!\u0001F\u000b\u0002\t1Lgn\u001b\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0019\u0012aB7fiJL7m]\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011QE\u000b\u0006\u0003W1\naaY8n[>t'B\u0001\r.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d+\u0003\u0015)H/\u001b7t\u0013\tY\u0004H\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003}\u0002\"\u0001Q\"\u000f\u0005\u0011\n\u0015B\u0001\"\u0014\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005\u0011+%a\u0003'j].l\u0015M\\1hKJT!AQ\n\u0002-\rdWo\u001d;fe2Kgn['b]\u0006<WM]0%KF$\"\u0001S&\u0011\u0005qI\u0015B\u0001&\u001e\u0005\u0011)f.\u001b;\t\u000f1;\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002-\u0011L7/\u00192mK\u0012tu\u000e\u001e+fgR,G-\u0012:s_J,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u00069B-[:bE2,GMT8u)\u0016\u001cH/\u001a3FeJ|'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\t\u0001\n\u000b\u0002\f9B\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u0004CBL'BA1c\u0003\u001dQW\u000f]5uKJT!aY\u0018\u0002\u000b),h.\u001b;\n\u0005\u0015t&!C!gi\u0016\u0014X)Y2i\u0003\u0019\"Xm\u001d;MS:\\W*\u00198bO\u0016\u0014x+\u001b;i\u00072,8\u000f^3s\u0019&t7\u000eR5tC\ndW\r\u001a\u0015\u0003\u0019!\u0004\"!X5\n\u0005)t&\u0001\u0002+fgR\fq\u0005^3ti\u0006#W.\u001b8NC:\fw-\u001a:XSRD7\t\\;ti\u0016\u0014H*\u001b8l\t&\u001c\u0018M\u00197fI\"\u0012Q\u0002[\u0001\u0013GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw\r\u0006\u0002pgB\u0011\u0001/]\u0007\u0002+%\u0011!/\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003u\u001d\u0001\u0007Q/A\tf]\u0006\u0014G.Z\"mkN$XM\u001d'j].\u0004\"\u0001\b<\n\u0005]l\"a\u0002\"p_2,\u0017M\\\u0001\ng\u0016$X\u000f]'pG.$b\u0001\u0013>\u0002\u0006\u0005E\u0001\"B>\u0010\u0001\u0004a\u0018!\u00039beRLG/[8o!\ri\u0018\u0011A\u0007\u0002}*\u0011qpF\u0001\bG2,8\u000f^3s\u0013\r\t\u0019A \u0002\n!\u0006\u0014H/\u001b;j_:Dq!a\u0002\u0010\u0001\u0004\tI!\u0001\u0002uaB!\u00111BA\u0007\u001b\u0005Q\u0013bAA\bU\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\n\u001f\u0001\u0007\u0011QC\u0001\u0007Y&t7.\u00133\u0011\u000bq\t9\"a\u0007\n\u0007\u0005eQD\u0001\u0004PaRLwN\u001c\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005+\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003K\tyB\u0001\u0003V+&#\u0015\u0001G2sK\u0006$Xm\u00117vgR,'\u000fT5oW6\u000bg.Y4feR\u0019q(a\u000b\t\r\u00055\u0002\u00031\u0001p\u00031\u0011'o\\6fe\u000e{gNZ5h\u0003e1XM]5gs\u000ecWo\u001d;fe2Kgn\u001b#jg\u0006\u0014G.\u001a3\u0015\u0007!\u000b\u0019\u0004C\u0004\u00026E\u0001\r!a\u000e\u0002\u0011I,hN\\1cY\u0016\u0004B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{q\u0016\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00131\b\u0002\u000b\u000bb,7-\u001e;bE2,\u0007")
public class ClusterLinkFactoryTest {
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();
    private ClusterLinkFactory.LinkManager clusterLinkManager;
    private final String disabledNotTestedError;

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    private String disabledNotTestedError() {
        return this.disabledNotTestedError;
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.metrics().close();
    }

    @Test
    public void testLinkManagerWithClusterLinkDisabled() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        KafkaConfig brokerConfig = this.createBrokerConfig(false);
        this.clusterLinkManager_$eq(this.createClusterLinkManager(brokerConfig));
        Assertions.assertTrue((boolean)(this.clusterLinkManager() instanceof ClusterLinkDisabled.LinkManager));
        MethodInvocationTracker invocationTracker = new MethodInvocationTracker(this.clusterLinkManager(), ClusterLinkFactory.LinkManager.class);
        ClusterLinkFactory.LinkManager clusterLinkManager = invocationTracker.proxy(this.clusterLinkManager());
        Assertions.assertTrue((boolean)(clusterLinkManager.admin() instanceof ClusterLinkDisabled.AdminManager));
        Assertions.assertTrue((boolean)(clusterLinkManager.admin().clusterLinkManager() instanceof ClusterLinkDisabled.LinkManager));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.createClusterLinkPolicy());
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.configEncoder());
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), ClusterLinkConfig$.MODULE$.create((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), ClusterLinkConfig$.MODULE$.create$default$2()), new Properties()));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.listClusterLinks());
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFactoryTest.$anonfun$testLinkManagerWithClusterLinkDisabled$5(props))));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.deleteClusterLink(linkName, linkId));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.fetcherManager(linkId));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.connectionManager(linkId));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.clientManager(linkId));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.resolveLinkId(linkName));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.resolveLinkIdOrThrow(linkName));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.ensureLinkNameDoesntExist(linkName));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.ensureClusterLinkExists(linkId));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.linkConfig(linkId));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.getTenantPrefix(linkName));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.linkState(linkName));
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.maybeCheckForOverlappingTopicFilters(ClusterLinkConfig$.MODULE$.create((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), ClusterLinkConfig$.MODULE$.create$default$2()), linkName, Option$.MODULE$.empty()));
        Assertions.assertFalse((boolean)clusterLinkManager.isLinkCoordinator(linkName));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.linkCoordinator(linkName));
        Assertions.assertTrue((boolean)clusterLinkManager.controllerListener().isEmpty());
        clusterLinkManager.processClusterLinkChanges(linkId, new Properties());
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.fetcherManager(linkId));
        TopicPartition tp0 = new TopicPartition("topic", 0);
        Partition partition0 = (Partition)EasyMock.createNiceMock(Partition.class);
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        clusterLinkManager.addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        clusterLinkManager.maybeNotifyReadyForFetch(partition0);
        this.verifyClusterLinkDisabled(() -> clusterLinkManager.fetcherManager(linkId));
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)EasyMock.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        clusterLinkManager.removePartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        clusterLinkManager.removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0})));
        clusterLinkManager.updateDynamicFetchSize();
        clusterLinkManager.onControllerChange(false);
        clusterLinkManager.onControllerChange(true);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.availabilityException(linkId));
        clusterLinkManager.onMetadataPartitionLeaderElection(1, 1);
        clusterLinkManager.onMetadataPartitionLeaderResignation(1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        Assertions.assertNotNull((Object)clusterLinkManager.metadataImageListener());
        clusterLinkManager.metadataImageListener().onClusterLinkCoordinatorElection(null);
        clusterLinkManager.metadataImageListener().onMetadataImageUpdate(null, null);
        clusterLinkManager.metadataImageListener().onLeaderUpdate(null);
        clusterLinkManager.isAutoMirroredTopic("");
        clusterLinkManager.clusterLinkMetadataManager();
        clusterLinkManager.fetchSourceTopicInfoForMirrors((Map)Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty(), null);
        clusterLinkManager.initialize(null, null, (Option)None$.MODULE$, null, (Option)None$.MODULE$);
        clusterLinkManager.startup(null);
        clusterLinkManager.shutdownIdleFetcherThreads();
        clusterLinkManager.shutdown();
        invocationTracker.verifyAllMethodsTested(this.disabledNotTestedError());
    }

    @Test
    public void testAdminManagerWithClusterLinkDisabled() {
        String linkName = "testLink";
        KafkaConfig brokerConfig = this.createBrokerConfig(false);
        this.clusterLinkManager_$eq(this.createClusterLinkManager(brokerConfig));
        Assertions.assertTrue((boolean)(this.clusterLinkManager().admin() instanceof ClusterLinkDisabled.AdminManager));
        MethodInvocationTracker invocationTracker = new MethodInvocationTracker(this.clusterLinkManager().admin(), ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.AdminManager admin = invocationTracker.proxy(this.clusterLinkManager().admin());
        Assertions.assertSame((Object)this.clusterLinkManager(), (Object)admin.clusterLinkManager());
        NewClusterLink newClusterLink = new NewClusterLink(linkName, "cluster1", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))).asJava());
        this.verifyClusterLinkDisabled(() -> admin.createClusterLink(newClusterLink, (Option)None$.MODULE$, new ListenerName("EXTERNAL"), true, false, 10000, 1));
        this.verifyClusterLinkDisabled(() -> admin.validateLinksWithCreateClusterLinkRequestForKraft(new CreateClusterLinksRequest.Builder(Collections.singletonList(newClusterLink), true, true, 10000).build((short)1), Option$.MODULE$.empty()));
        this.verifyClusterLinkDisabled(() -> admin.preprocessCreateClusterLinkRequestForKraft(new CreateClusterLinksRequest.Builder(Collections.singletonList(newClusterLink), true, true, 10000).build((short)1), Collections.emptyMap(), Option$.MODULE$.empty()));
        this.verifyClusterLinkDisabled(() -> admin.checkConflictingLinksForKraft(new CreateClusterLinksRequest.Builder(Collections.singletonList(newClusterLink), true, true, 10000).build((short)1), Option$.MODULE$.empty()));
        this.verifyClusterLinkDisabled(() -> admin.deleteClusterLink(linkName, true, true, 1));
        this.verifyClusterLinkDisabled(() -> admin.listClusterLinks((Option)None$.MODULE$, false, 3));
        this.verifyClusterLinkDisabled(() -> admin.describeClusterLinks((Option)None$.MODULE$, false));
        this.verifyClusterLinkDisabled(() -> admin.listMirrors((Option)None$.MODULE$, true, 1));
        this.verifyClusterLinkDisabled(() -> admin.describeMirror("topic", 2));
        this.verifyClusterLinkDisabled(() -> admin.alterMirror("topic", AlterMirrorOp.PROMOTE, true, 3));
        IntRef callbackCount = IntRef.create((int)0);
        admin.tryCompleteElseWatch(1000L, (Seq)new .colon.colon(CompletableFuture.completedFuture(null), (List)Nil$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ++callbackCount$1.elem);
        Assertions.assertEquals((int)1, (int)callbackCount.elem);
        Assertions.assertThrows(IllegalStateException.class, () -> admin.tryCompleteElseWatch(1000L, (Seq)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ++callbackCount$1.elem));
        Assertions.assertEquals((int)1, (int)callbackCount.elem);
        admin.clusterLinkingIsDisabled();
        admin.shutdown();
        invocationTracker.verifyAllMethodsTested(this.disabledNotTestedError());
    }

    private KafkaConfig createBrokerConfig(boolean enableClusterLink) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), Boolean.toString(enableClusterLink));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<UUID> linkId) {
        EasyMock.reset((Object[])new Object[]{partition});
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)tp).anyTimes();
        EasyMock.expect((Object)partition.getClusterLinkId()).andReturn(linkId).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty())).anyTimes();
        EasyMock.expect((Object)partition.getLinkedLeaderEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))).anyTimes();
        EasyMock.replay((Object[])new Object[]{partition});
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkFactory.LinkManager createClusterLinkManager(KafkaConfig brokerConfig) {
        void var3_3;
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((java.util.Map)brokerConfig.values(), (Metrics)this.metrics()) != null;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.metrics(), (Time)this.time(), isMultiTenant, ClusterLinkFactory$.MODULE$.createLinkManager$default$7());
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)EasyMock.mock(AuthorizerServerInfo.class);
        EasyMock.expect((Object)serverInfo.interBrokerEndpoint()).andReturn((Object)brokerEndpoint).anyTimes();
        EasyMock.replay((Object[])new Object[]{serverInfo});
        manager.initialize(serverInfo, null, (Option)None$.MODULE$, null, (Option)None$.MODULE$);
        manager.startup(null);
        return var3_3;
    }

    private void verifyClusterLinkDisabled(Executable runnable) {
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)runnable);
    }

    public static final /* synthetic */ boolean $anonfun$testLinkManagerWithClusterLinkDisabled$5(Properties props) {
        return false;
    }

    public ClusterLinkFactoryTest() {
        this.disabledNotTestedError = "ClusterLinkDisabled methods should not throw exceptions for methods unrelated to cluster linking that may be invoked when cluster linking is disabled. Cluster link and mirror operations that are not expected when cluster linking is disabled should throw ClusterLinkDisabledException.";
    }
}

