/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MockVault;
import kafka.server.link.MockVault$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\u0007\u000e\u0001QAQa\u0007\u0001\u0005\u0002qAQa\b\u0001\u0005\u0002\u0001BQ!\r\u0001\u0005\u0002\u0001BQa\r\u0001\u0005\u0002\u0001BQ!\u000e\u0001\u0005\u0002\u0001BQa\u000e\u0001\u0005\u0002\u0001BQ!\u000f\u0001\u0005\u0002iBQa\u0016\u0001\u0005\naCq\u0001\u001a\u0001\u0012\u0002\u0013%Q\rC\u0003q\u0001\u0011%\u0011\u000fC\u0003|\u0001\u0011%AP\u0001\u000fDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e,enY8eKJ$Vm\u001d;\u000b\u00059y\u0011\u0001\u00027j].T!\u0001E\t\u0002\rM,'O^3s\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u000e\u0003\u0001\"Xm\u001d;F]\u000e|G-\u001b8h/&$\bnU3og&$\u0018N^3D_:4\u0017nZ:\u0015\u0003\u0005\u0002\"A\u0006\u0012\n\u0005\r:\"\u0001B+oSRD#AA\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013aA1qS*\u0011!fK\u0001\bUV\u0004\u0018\u000e^3s\u0015\taS&A\u0003kk:LGOC\u0001/\u0003\ry'oZ\u0005\u0003a\u001d\u0012A\u0001V3ti\u0006qB/Z:u\u000b:\u001cw\u000eZ5oO:{7+\u001a8tSRLg/Z\"p]\u001aLwm\u001d\u0015\u0003\u0007\u0015\nq\u0003^3ti\u0016CH/\u001a:oC2L'0\u001a3D_:4\u0017nZ:)\u0005\u0011)\u0013!\u0007;fgR,en\u0019:zaRLwN\\&fsJ{G/\u0019;j_:D#!B\u0013\u0002=Q,7\u000f\u001e*fK:\u001c'/\u001f9uS>tgi\u001c:LKf\u0014v\u000e^1uS>t\u0007F\u0001\u0004&\u0003I1XM]5gs\u0016s7m\u001c3f\t\u0016\u001cw\u000eZ3\u0015\t\u0005ZT)\u0016\u0005\u0006y\u001d\u0001\r!P\u0001\u0006aJ|\u0007o\u001d\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bA!\u001e;jY*\t!)\u0001\u0003kCZ\f\u0017B\u0001#@\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006\r\u001e\u0001\raR\u0001\u0011g\u0016t7/\u001b;jm\u0016\u001cuN\u001c4jON\u00042\u0001S(S\u001d\tIU\n\u0005\u0002K/5\t1J\u0003\u0002M'\u00051AH]8pizJ!AT\f\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016KA\u0002TKRT!AT\f\u0011\u0005!\u001b\u0016B\u0001+R\u0005\u0019\u0019FO]5oO\")ak\u0002a\u0001{\u0005i!/Z:pYZ,G\r\u0015:paN\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e$2!W/c!\tQ6,D\u0001\u0010\u0013\tavBA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u00020\t\u0001\u0004y\u0016AB:fGJ,G\u000fE\u0002\u0017AJK!!Y\f\u0003\r=\u0003H/[8o\u0011\u001d\u0019\u0007\u0002%AA\u0002}\u000b\u0011b\u001c7e'\u0016\u001c'/\u001a;\u0002-\t\u0014xn[3s\u0007>tg-[4%I\u00164\u0017-\u001e7uII*\u0012A\u001a\u0016\u0003?\u001e\\\u0013\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00055<\u0012AC1o]>$\u0018\r^5p]&\u0011qN\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u0004<fe&4\u00170\u00128d_\u0012Lgn\u001a\u000b\u0006{I$\u0018P\u001f\u0005\u0006g*\u0001\r!W\u0001\fW\u000647.Y\"p]\u001aLw\rC\u0003v\u0015\u0001\u0007a/\u0001\u0006mS:\\7i\u001c8gS\u001e\u0004\"AH<\n\u0005al!!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\")aI\u0003a\u0001\u000f\")aK\u0003a\u0001{\u0005qa/\u001a:jMf$UmY8eS:<G#B\u0011~}\u0006\u0005\u0001\"B:\f\u0001\u0004I\u0006\"B@\f\u0001\u0004i\u0014\u0001D3oG>$W\r\u001a)s_B\u001c\b\"\u0002,\f\u0001\u0004i\u0004")
public class ClusterLinkConfigEncoderTest {
    @Test
    public void testEncodingWithSensitiveConfigs() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.keystore.location", "/path/to/keystore.jks");
        props.setProperty("ssl.keystore.password", "keystore-secret");
        props.setProperty("ssl.key.password", "key-secret");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.password", "ssl.key.password"}));
        this.verifyEncodeDecode(props, (Set<String>)sensitiveConfigs, props);
    }

    @Test
    public void testEncodingNoSensitiveConfigs() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "PLAINTEXT");
        this.verifyEncodeDecode(props, (Set<String>)Predef$.MODULE$.Set().empty(), props);
    }

    @Test
    public void testExternalizedConfigs() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("config.providers", "mockvault");
        props.setProperty(new StringBuilder(32).append("config.providers").append(".mockvault.class").toString(), MockVault.class.getName());
        props.setProperty(new StringBuilder(36).append("config.providers").append(".mockvault.param.url").toString(), MockVault$.MODULE$.Url());
        props.setProperty("ssl.keystore.location", new StringBuilder(52).append("${mockvault:/clusterlink/test:").append("ssl.keystore.location").append("}").toString());
        props.setProperty("ssl.keystore.password", new StringBuilder(52).append("${mockvault:/clusterlink/test:").append("ssl.keystore.password").append("}").toString());
        props.setProperty("ssl.key.password", new StringBuilder(47).append("${mockvault:/clusterlink/test:").append("ssl.key.password").append("}").toString());
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config.providers", new StringBuilder(32).append("config.providers").append(".mockvault.class").toString(), new StringBuilder(36).append("config.providers").append(".mockvault.param.url").toString(), "ssl.keystore.password", "ssl.key.password"}));
        Set externalizedConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.password", "ssl.key.password"}));
        Properties resolvedProps = new Properties();
        ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String k;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Object object = resolvedProps.setProperty(k, externalizedConfigs.contains((Object)(k = (String)x0$1._1())) ? (String)MockVault$.MODULE$.Configs().apply((Object)k) : props.getProperty(k));
            return object;
        });
        this.verifyEncodeDecode(props, (Set<String>)sensitiveConfigs, resolvedProps);
    }

    @Test
    public void testEncryptionKeyRotation() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.keystore.location", "/path/to/keystore.jks");
        props.setProperty("ssl.keystore.password", "keystore-secret");
        props.setProperty("ssl.key.password", "key-secret");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.password", "ssl.key.password"}));
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)new Some((Object)"secret-v1"), (Option<String>)None$.MODULE$);
        Properties encoded1 = this.verifyEncoding(brokerConfig1, linkConfig, (Set<String>)sensitiveConfigs, props);
        this.verifyDecoding(brokerConfig1, encoded1, props);
        KafkaConfig brokerConfig2 = this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), (Option<String>)new Some((Object)"secret-v1"));
        Properties encoded2 = this.verifyEncoding(brokerConfig2, linkConfig, (Set<String>)sensitiveConfigs, props);
        this.verifyDecoding(brokerConfig2, encoded2, props);
        this.verifyDecoding(brokerConfig1, encoded2, props);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), this.brokerConfig$default$2()), encoded2, props);
        KafkaConfig brokerConfig3 = this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), (Option<String>)new Some((Object)"secret-v2"));
        Properties encoded3 = this.verifyEncoding(brokerConfig3, linkConfig, (Set<String>)sensitiveConfigs, props);
        this.verifyDecoding(brokerConfig3, encoded3, props);
        this.verifyDecoding(brokerConfig2, encoded3, props);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), this.brokerConfig$default$2()), encoded3, props);
    }

    @Test
    public void testReencryptionForKeyRotation() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.keystore.location", "/path/to/keystore.jks");
        props.setProperty("ssl.keystore.password", "keystore-secret");
        props.setProperty("ssl.key.password", "key-secret");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.password", "ssl.key.password"}));
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)new Some((Object)"secret-v1"), (Option<String>)None$.MODULE$);
        Properties encoded1 = this.verifyEncoding(brokerConfig1, linkConfig, (Set<String>)sensitiveConfigs, props);
        SecureLinkConfigEncoder encoder1 = new SecureLinkConfigEncoder(brokerConfig1);
        Assertions.assertEquals((Object)props, (Object)encoder1.clusterLinkConfig(encoded1).originals());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)encoder1.maybeReencode(encoded1));
        KafkaConfig brokerConfig2 = this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), (Option<String>)new Some((Object)"secret-v1"));
        Properties encoded2 = this.verifyEncoding(brokerConfig2, linkConfig, (Set<String>)sensitiveConfigs, props);
        SecureLinkConfigEncoder encoder2 = new SecureLinkConfigEncoder(brokerConfig2);
        Assertions.assertEquals((Object)props, (Object)encoder2.clusterLinkConfig(encoded2).originals());
        Assertions.assertEquals((Object)props, (Object)encoder1.clusterLinkConfig(encoded2).originals());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)encoder2.maybeReencode(encoded2));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder1.maybeReencode(encoded2));
        Assertions.assertFalse((boolean)((Hashtable)encoder1.maybeReencode(encoded2).get()).isEmpty());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder2.maybeReencode(encoded1));
        Assertions.assertFalse((boolean)((Hashtable)encoder2.maybeReencode(encoded1).get()).isEmpty());
        KafkaConfig brokerConfig3 = this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), (Option<String>)new Some((Object)"secret-v2"));
        Properties encoded3 = this.verifyEncoding(brokerConfig3, linkConfig, (Set<String>)sensitiveConfigs, props);
        SecureLinkConfigEncoder encoder3 = new SecureLinkConfigEncoder(brokerConfig3);
        Assertions.assertEquals((Object)props, (Object)encoder3.clusterLinkConfig(encoded3).originals());
        Assertions.assertEquals((Object)props, (Object)encoder2.clusterLinkConfig(encoded3).originals());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)encoder3.maybeReencode(encoded3));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder2.maybeReencode(encoded3));
        Assertions.assertFalse((boolean)((Hashtable)encoder2.maybeReencode(encoded3).get()).isEmpty());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder3.maybeReencode(encoded2));
        Assertions.assertFalse((boolean)((Hashtable)encoder3.maybeReencode(encoded2).get()).isEmpty());
        encoder3.removeOldSecretEncoder();
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder3.maybeReencode(encoded3));
        Properties encoded4 = (Properties)encoder3.maybeReencode(encoded3).get();
        Assertions.assertFalse((boolean)encoded4.isEmpty());
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), this.brokerConfig$default$2()), encoded4, props);
        SecureLinkConfigEncoder encoder5 = new SecureLinkConfigEncoder(this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), this.brokerConfig$default$2()));
        Assertions.assertThrows(ConfigException.class, () -> encoder5.clusterLinkConfig(encoded4));
    }

    public void verifyEncodeDecode(Properties props, Set<String> sensitiveConfigs, Properties resolvedProps) {
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)None$.MODULE$, this.brokerConfig$default$2());
        SecureLinkConfigEncoder encoder1 = new SecureLinkConfigEncoder(brokerConfig1);
        if (sensitiveConfigs.isEmpty()) {
            this.verifyEncoding(brokerConfig1, linkConfig, sensitiveConfigs, resolvedProps);
        } else {
            Assertions.assertThrows(InvalidConfigurationException.class, () -> encoder1.encode(props));
        }
        KafkaConfig brokerConfig2 = this.brokerConfig((Option<String>)new Some((Object)"secret-1234"), this.brokerConfig$default$2());
        this.verifyEncoding(brokerConfig2, linkConfig, sensitiveConfigs, resolvedProps);
        KafkaConfig brokerConfig3 = this.brokerConfig((Option<String>)new Some((Object)"secret-new"), (Option<String>)new Some((Object)"secret-old"));
        Properties encoded = this.verifyEncoding(brokerConfig3, linkConfig, sensitiveConfigs, resolvedProps);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-new"), this.brokerConfig$default$2()), encoded, resolvedProps);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-old"), this.brokerConfig$default$2()), encoded, resolvedProps);
    }

    private KafkaConfig brokerConfig(Option<String> secret, Option<String> oldSecret) {
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        secret.foreach((Function1 & Serializable & scala.Serializable)x$1 -> brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (String)x$1));
        oldSecret.foreach((Function1 & Serializable & scala.Serializable)x$2 -> brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), (String)x$2));
        return new KafkaConfig((Map)brokerProps);
    }

    private Option<String> brokerConfig$default$2() {
        return None$.MODULE$;
    }

    private Properties verifyEncoding(KafkaConfig kafkaConfig, ClusterLinkConfig linkConfig, Set<String> sensitiveConfigs, Properties resolvedProps) {
        SecureLinkConfigEncoder encoder = new SecureLinkConfigEncoder(kafkaConfig);
        Properties props = new Properties();
        linkConfig.originalsStrings().forEach((k, v) -> props.setProperty((String)k, (String)v));
        Properties encodedProps = encoder.encode(props);
        sensitiveConfigs.foreach((Function1 & Serializable & scala.Serializable)name -> {
            ClusterLinkConfigEncoderTest.$anonfun$verifyEncoding$2(linkConfig, encodedProps, name);
            return BoxedUnit.UNIT;
        });
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(linkConfig.originals()).asScala()).keySet().diff(sensitiveConfigs).foreach((Function1 & Serializable & scala.Serializable)name -> {
            ClusterLinkConfigEncoderTest.$anonfun$verifyEncoding$3(linkConfig, encodedProps, name);
            return BoxedUnit.UNIT;
        });
        this.verifyDecoding(kafkaConfig, encodedProps, resolvedProps);
        return encodedProps;
    }

    private void verifyDecoding(KafkaConfig kafkaConfig, Properties encodedProps, Properties resolvedProps) {
        ClusterLinkConfig linkConfig = new SecureLinkConfigEncoder(kafkaConfig).clusterLinkConfig(encodedProps);
        Assertions.assertEquals((Object)resolvedProps, (Object)linkConfig.originals());
    }

    public static final /* synthetic */ void $anonfun$verifyEncoding$2(ClusterLinkConfig linkConfig$1, Properties encodedProps$1, String name) {
        Assertions.assertNotEquals(linkConfig$1.originals().get(name), (Object)encodedProps$1.getProperty(name));
    }

    public static final /* synthetic */ void $anonfun$verifyEncoding$3(ClusterLinkConfig linkConfig$1, Properties encodedProps$1, String name) {
        Assertions.assertEquals(linkConfig$1.originals().get(name), (Object)encodedProps$1.getProperty(name));
    }
}

