/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.server.authorizer.Authorizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00041\u0001\u0001\u0006I!\f\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001c\t\u0013u\u0002\u0001\u0019!A!B\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002!\t\u000f!\u0003!\u0019!C\u0001\u0013\"1Q\n\u0001Q\u0001\n)CqA\u0014\u0001C\u0002\u0013\u0005q\n\u0003\u0004^\u0001\u0001\u0006I\u0001\u0015\u0005\b=\u0002\u0011\r\u0011\"\u0001`\u0011\u0019\u0019\u0007\u0001)A\u0005A\")A\r\u0001C\u0001K\")\u0011\u000f\u0001C\u0001K\")1\u000f\u0001C\u0001K\")Q\u000f\u0001C\u0001K\")q\u000f\u0001C\u0001K\")\u0011\u0010\u0001C\u0005u\"9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA\u000f\u0001\u0011%\u0011q\t\u0005\b\u0003\u0017\u0002A\u0011BA'\u0005q\u0019E.^:uKJd\u0015N\\6DY&,g\u000e^'b]\u0006<WM\u001d+fgRT!AG\u000e\u0002\t1Lgn\u001b\u0006\u00039u\taa]3sm\u0016\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005I\u0012!C:dQ\u0016$W\u000f\\3s+\u0005i\u0003C\u0001\u0016/\u0013\ty\u0013D\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!D2mS\u0016tG/T1oC\u001e,'/F\u00014!\tQC'\u0003\u000263\tA2\t\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;NC:\fw-\u001a:\u0002#\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u00029wA\u0011!%O\u0005\u0003u\r\u0012A!\u00168ji\"9A(BA\u0001\u0002\u0004\u0019\u0014a\u0001=%c\u0005q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013AC1vi\"|'/\u001b>feV\t\u0001\t\u0005\u0002B\u000b6\t!I\u0003\u0002?\u0007*\u0011A)H\u0001\tg\u0016\u001cWO]5us&\u0011aI\u0011\u0002\u000e\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\u0002\u0017\u0005,H\u000f[8sSj,'\u000fI\u0001\u0013G2,8\u000f^3s\u0019&t7.T1oC\u001e,'/F\u0001K!\tQ3*\u0003\u0002M3\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003%!Wm\u001d;BI6Lg.F\u0001Q!\t\t6,D\u0001S\u0015\t\u0019F+A\u0003bI6LgN\u0003\u0002V-\u000691\r\\5f]R\u001c(B\u0001\u0010X\u0015\tA\u0016,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0006\u0019qN]4\n\u0005q\u0013&AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u000bI\u0016\u001cH/\u00113nS:\u0004\u0013aB7fiJL7m]\u000b\u0002AB\u0011!&Y\u0005\u0003Ef\u0011!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\buKN$(+Z2p]\u001aLw-\u001e:f)\u0005A\u0004FA\bh!\tAw.D\u0001j\u0015\tQ7.A\u0002ba&T!\u0001\\7\u0002\u000f),\b/\u001b;fe*\u0011a.W\u0001\u0006UVt\u0017\u000e^\u0005\u0003a&\u0014A\u0001V3ti\u0006QA/Z:u)>\u0004\u0018nY:)\u0005A9\u0017A\u0006;fgR\f5\r\\*z]\u000e$\u0016m]6Ti\u0006\u0014H/\u001e9)\u0005E9\u0017A\n;fgR\f5\r\\*z]\u000e$\u0016m]6Ti\u0006\u0014H/\u001e9XSRDgj\\!vi\"|'/\u001b>fe\"\u0012!cZ\u0001\u0019i\u0016\u001cH/Q2m'ft7\rV1tW:{7\u000b^1siV\u0004\bFA\nh\u0003AqWm^\"mS\u0016tG/T1oC\u001e,'\u000f\u0006\u00054w\u0006E\u00111DA\u0016\u0011\u0015aH\u00031\u0001~\u0003!a\u0017N\\6OC6,\u0007c\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u00051%\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\tIaI\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%1\u0005C\u0004\u0002\u0014Q\u0001\r!!\u0006\u0002\r\r|gNZ5h!\rQ\u0013qC\u0005\u0004\u00033I\"!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\"9\u0011Q\u0004\u000bA\u0002\u0005}\u0011\u0001D1e[&tg)Y2u_JL\bc\u0002\u0012\u0002\"\u0005U\u0011QE\u0005\u0004\u0003G\u0019#!\u0003$v]\u000e$\u0018n\u001c82!\rQ\u0013qE\u0005\u0004\u0003SI\"AF\"mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;\t\ry\"\u0002\u0019AA\u0017!\u0015\u0011\u0013qFA\u001a\u0013\r\t\td\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1APA\u001d\u0015\tab+\u0003\u0003\u0002>\u0005]\"AC!vi\"|'/\u001b>fe\u0006i1\r\\8tK6\u000bg.Y4feN$2\u0001OA\"\u0011\u0019\t)%\u0006a\u0001g\u0005A2\r\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;NC:\fw-\u001a:\u0015\t\u0005\u0015\u0012\u0011\n\u0005\b\u0003'1\u0002\u0019AA\u000b\u0003%qWm^\"p]\u001aLw\r\u0006\u0003\u0002\u0016\u0005=\u0003bBA)/\u0001\u0007\u00111K\u0001\bG>tg-[4t!\u0015q\u0018QK?~\u0013\u0011\t9&a\u0004\u0003\u00075\u000b\u0007\u000f")
public class ClusterLinkClientManagerTest {
    private final ClusterLinkScheduler scheduler = (ClusterLinkScheduler)EasyMock.createNiceMock(ClusterLinkScheduler.class);
    private ClusterLinkClientManager clientManager;
    private final AclAuthorizer authorizer = (AclAuthorizer)EasyMock.createNiceMock(AclAuthorizer.class);
    private final ClusterLinkManager clusterLinkManager = (ClusterLinkManager)EasyMock.createNiceMock(ClusterLinkManager.class);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)EasyMock.createNiceMock(ConfluentAdmin.class);
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)EasyMock.createNiceMock(ClusterLinkMetrics.class);

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    public void clientManager_$eq(ClusterLinkClientManager x$1) {
        this.clientManager = x$1;
    }

    public AclAuthorizer authorizer() {
        return this.authorizer;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReconfigure() {
        void newClientManager_adminFactory;
        void newClientManager_authorizer;
        String linkName = "test-link";
        IntRef factoryCalled = IntRef.create((int)0);
        ObjectRef factoryConfig = ObjectRef.create((Object)this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")})))));
        ObjectRef factoryAdmin = ObjectRef.create((Object)((KafkaAdminClient)EasyMock.createNiceMock(KafkaAdminClient.class)));
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)config -> ClusterLinkClientManagerTest.adminFactoryWithCount$1(config, factoryCalled, factoryConfig, factoryAdmin);
        ClusterLinkConfig newClientManager_config = (ClusterLinkConfig)factoryConfig.elem;
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
        EasyMock.expect((Object)this.clusterLinkManager().metadataManager()).andReturn((Object)newClientManager_metadataManager).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLinkManager()});
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(this.clusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), newClientManager_config, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        Assertions.assertEquals((int)0, (int)factoryCalled.elem);
        clusterLinkClientManager.startup();
        try {
            Assertions.assertEquals((int)1, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clusterLinkClientManager.getAdmin() ? 1 : 0) != 0);
            factoryAdmin.elem = (KafkaAdminClient)EasyMock.createNiceMock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clusterLinkClientManager.getAdmin() ? 1 : 0) != 0);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"5")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:3456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp(), "bootstrap.servers", ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> clusterLinkClientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> clusterLinkClientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            factoryAdmin.elem = (KafkaAdminClient)EasyMock.createNiceMock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)3, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clusterLinkClientManager.getAdmin() ? 1 : 0) != 0);
        }
        finally {
            this.closeManagers(clusterLinkClientManager);
        }
        Assertions.assertEquals((int)3, (int)factoryCalled.elem);
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> clusterLinkClientManager.getAdmin(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopics() {
        void newClientManager_authorizer;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))));
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
        EasyMock.expect((Object)this.clusterLinkManager().metadataManager()).andReturn((Object)newClientManager_metadataManager).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLinkManager()});
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(this.clusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        .colon.colon topics = new .colon.colon((Object)"topic0", (List)new .colon.colon((Object)"topic1", (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)));
        clusterLinkClientManager.startup();
        try {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.addTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1)})), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.addTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), (String)topics.apply(2)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1), (String)topics.apply(2)})), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.removeTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(2), (String)topics.head()})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)})), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.removeTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), "unknown"})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clusterLinkClientManager.getTopics());
        }
        finally {
            this.closeManagers(clusterLinkClientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartup() {
        void newClientManager_authorizer;
        String linkName = "test-link";
        String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }")).stripMargin();
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
        EasyMock.expect((Object)this.clusterLinkManager().metadataManager()).andReturn((Object)newClientManager_metadataManager).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLinkManager()});
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(this.clusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        clusterLinkClientManager.startup();
        try {
            Predef$.MODULE$.assert(clusterLinkClientManager.getSyncAclTask().isDefined());
        }
        finally {
            this.closeManagers(clusterLinkClientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartupWithNoAuthorizer() {
        void newClientManager_authorizer;
        String linkName = "test-link";
        String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }")).stripMargin();
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        None$ none$ = None$.MODULE$;
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
        EasyMock.expect((Object)this.clusterLinkManager().metadataManager()).andReturn((Object)newClientManager_metadataManager).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLinkManager()});
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(this.clusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        try {
            try {
                clusterLinkClientManager.startup();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assertions.assertEquals((Object)illegalArgumentException.getMessage(), (Object)"ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            }
        }
        finally {
            this.closeManagers(clusterLinkClientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskNoStartup() {
        void newClientManager_authorizer;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}))));
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
        EasyMock.expect((Object)this.clusterLinkManager().metadataManager()).andReturn((Object)newClientManager_metadataManager).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLinkManager()});
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(this.clusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        clusterLinkClientManager.startup();
        try {
            Predef$.MODULE$.assert(clusterLinkClientManager.getSyncAclTask().isEmpty());
        }
        finally {
            this.closeManagers(clusterLinkClientManager);
        }
    }

    private ClusterLinkClientManager newClientManager(String linkName, ClusterLinkConfig config, Function1<ClusterLinkConfig, ClusterLinkAdminClient> adminFactory, Option<Authorizer> authorizer) {
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
        EasyMock.expect((Object)this.clusterLinkManager().metadataManager()).andReturn((Object)metadataManager).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLinkManager()});
        return new ClusterLinkClientManager(this.clusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), linkData, fetcherManager, this.scheduler(), config, authorizer, (Option)None$.MODULE$, this.metrics(), adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
    }

    private void closeManagers(ClusterLinkClientManager clusterLinkClientManager) {
        this.destAdmin().close(Duration.ZERO);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.destAdmin()});
        clusterLinkClientManager.shutdown();
        EasyMock.reset((Object[])new Object[]{this.destAdmin()});
        EasyMock.reset((Object[])new Object[]{this.clusterLinkManager()});
        clusterLinkClientManager.scheduler().shutdown();
        EasyMock.reset((Object[])new Object[]{this.scheduler()});
    }

    private ClusterLinkAdminClient adminFactory(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)EasyMock.createNiceMock(ClusterLinkAdminClient.class);
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
    }

    private static final ClusterLinkAdminClient adminFactoryWithCount$1(ClusterLinkConfig config, IntRef factoryCalled$1, ObjectRef factoryConfig$1, ObjectRef factoryAdmin$1) {
        ++factoryCalled$1.elem;
        Assertions.assertTrue(((ClusterLinkConfig)factoryConfig$1.elem == config ? 1 : 0) != 0);
        return new ClusterLinkAdminClient((ConfluentAdmin)((KafkaAdminClient)factoryAdmin$1.elem), null, null, "");
    }
}

