/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkClearLinkReference;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.server.authorizer.Authorizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u000f\u001f\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019\u0019\u0005\u0001)A\u0005{!9A\t\u0001b\u0001\n\u0013)\u0005BB)\u0001A\u0003%a\tC\u0004S\u0001\t\u0007I\u0011B*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\neCa!\u0019\u0001!\u0002\u0013Q\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007O\u0002\u0001\u000b\u0011\u00023\t\u000f!\u0004!\u0019!C\u0005S\"11\u000f\u0001Q\u0001\n)DQ\u0001\u001e\u0001\u0005\u0002UDa!!\u0003\u0001\t\u0003)\bBBA\n\u0001\u0011\u0005Q\u000f\u0003\u0004\u0002\u001e\u0001!\t!\u001e\u0005\u0007\u0003C\u0001A\u0011A;\t\r\u0005\u0015\u0002\u0001\"\u0001v\u0011\u0019\tI\u0003\u0001C\u0001k\"1\u0011Q\u0006\u0001\u0005\u0002UDa!!\r\u0001\t\u0003)\bBBA\u001b\u0001\u0011\u0005Q\u000fC\u0004\u0002:\u0001!I!a\u000f\t\u000f\u00055\u0004\u0001\"\u0003\u0002p!I\u00111\u0012\u0001\u0012\u0002\u0013%\u0011Q\u0012\u0002\"\u00072,8\u000f^3s\u0019&t7n\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dKR+7\u000f\u001e\u0006\u0003?\u0001\nA\u0001\\5oW*\u0011\u0011EI\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0010\u0002\u00111Lgn\u001b(b[\u0016,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001\\1oO*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u001c\u0002\tU$\u0018\u000e\\\u0005\u0003\u0005~\u0012A!V+J\t\u00069A.\u001b8l\u0013\u0012\u0004\u0013!D:pkJ\u001cW\rV8qS\u000eLE-F\u0001G!\t9u*D\u0001I\u0015\tI%*\u0001\u0004d_6lwN\u001c\u0006\u0003G-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001\u000b\u0013\u0002\u0005+VLG-\u0001\bt_V\u00148-\u001a+pa&\u001c\u0017\n\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001+\u0011\u0005=*\u0016B\u0001,\u001f\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u0003i\u0003\"aW0\u000e\u0003qS!\u0001W/\u000b\u0005yS\u0015aB2mS\u0016tGo]\u0005\u0003Ar\u0013abQ8oM2,XM\u001c;BI6Lg.\u0001\u0004bI6Lg\u000eI\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feV\tA\r\u0005\u00020K&\u0011aM\b\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n!\"Y;uQ>\u0014\u0018N_3s+\u0005Q\u0007cA\u0014l[&\u0011A\u000e\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059\fX\"A8\u000b\u0005!\u0004(BA\u0011K\u0013\t\u0011xN\u0001\u0006BkRDwN]5{KJ\f1\"Y;uQ>\u0014\u0018N_3sA\u0005)1/\u001a;VaR\ta\u000f\u0005\u0002(o&\u0011\u0001\u0010\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0011uB\u001910!\u0002\u000e\u0003qT!! @\u0002\u0007\u0005\u0004\u0018NC\u0002\u0000\u0003\u0003\tqA[;qSR,'OC\u0002\u0002\u00045\u000bQA[;oSRL1!a\u0002}\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011#!\u0004\u0011\u0007m\fy!C\u0002\u0002\u0012q\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg\u0016k\u0007\u000f^=)\u0007I\t9\u0002E\u0002|\u00033I1!a\u0007}\u0005\u0011!Vm\u001d;\u0002;Q,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg&\u001bX*\u001b:s_JD3aEA\f\u00031\"Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jGNL5/T5se>\u0014H)\u001b4gKJ,g\u000e\u001e'j].LE\rK\u0002\u0015\u0003/\tq\u0005^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7/S:NSJ\u0014xN]#se>\u0014(+\u001a;ss\"\u001aQ#a\u0006\u0002MQ,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg&\u001bX*\u001b:s_J,%O]8s'.L\u0007\u000fK\u0002\u0017\u0003/\ta\u0004^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7OT8u\u001b&\u0014(o\u001c:)\u0007]\t9\"\u0001\u0013uKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:MS:\\Gi\\3t]R,\u00050[:uQ\rA\u0012qC\u0001+i\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2t\u0007>tGO]8mY\u0016\u0014X*\u00198z\u000b:$(/[3tQ\rI\u0012qC\u0001\u0016]\u0016<\u0018\t\u001c;fe6K'O]8sgJ+7/\u001e7u)\u0011\ti$a\u0011\u0011\u0007m\u000by$C\u0002\u0002Bq\u0013!#\u00117uKJl\u0015N\u001d:peN\u0014Vm];mi\"9\u0011Q\t\u000eA\u0002\u0005\u001d\u0013A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002J\u0005e\u0013q\f\b\u0005\u0003\u0017\n)F\u0004\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006J\u0001\u0007yI|w\u000e\u001e \n\u0003%J1!a\u0016)\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t\u00191+Z9\u000b\u0007\u0005]\u0003\u0006\u0005\u0003\u0002b\u0005%d\u0002BA2\u0003K\u00022!!\u0014)\u0013\r\t9\u0007K\u0001\u0007!J,G-\u001a4\n\u0007e\nYGC\u0002\u0002h!\nQC\\3x\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cW\r\u0006\u0004\u0002r\u0005]\u0014\u0011\u0011\t\u0004_\u0005M\u0014bAA;=\ti2\t\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cW\rC\u0004\u0002zm\u0001\r!a\u001f\u0002%\r|W\u000e\u001d7fi&|gnQ1mY\n\f7m\u001b\t\u0005O\u0005ud/C\u0002\u0002\u0000!\u0012\u0011BR;oGRLwN\u001c\u0019\t\u0013\u0005\r5\u0004%AA\u0002\u0005\u0015\u0015A\u0004;pa&\u001cwI]8vaNK'0\u001a\t\u0004O\u0005\u001d\u0015bAAEQ\t\u0019\u0011J\u001c;\u0002?9,wo\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0010*\"\u0011QQAIW\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\u0013Ut7\r[3dW\u0016$'bAAOQ\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0016q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClusterLinkClearLinkReferenceTest {
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManagerWithZkSupport.class);
    private final Option<Authorizer> authorizer = None$.MODULE$;

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.metadataManager()});
        this.scheduler().shutdown();
    }

    @Test
    public void testClearMirrorTopicsEmpty() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().empty());
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        CompletableFuture done = new CompletableFuture();
        int newClearLinkReference_topicGroupSize = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        KafkaFuture future = KafkaFuture.completedFuture(null);
        AlterMirrorsResult ret = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorDifferentLinkId() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        String otherLinkName = "other-link-name";
        UUID otherLinkId = UUID.randomUUID();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorRetry() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))}))).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        future1.completeExceptionally((Throwable)new TimeoutException());
        AlterMirrorsResult ret1 = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future1)}))).asJava());
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret1).andReturn((Object)ret2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorSkip() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        AlterMirrorsResult ret = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsNotMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().empty());
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    @Test
    public void testClearMirrorTopicsLinkDoesntExist() {
        EasyMock.reset((Object[])new Object[]{this.metadataManager()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        CompletableFuture done = new CompletableFuture();
        int newClearLinkReference_topicGroupSize = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    @Test
    public void testClearMirrorTopicsControllerManyEntries() {
        String otherLinkName = "other-link-name";
        UUID otherLinkId = UUID.randomUUID();
        int topicGroupSize = 2;
        Set topics = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)idx -> ClusterLinkClearLinkReferenceTest.$anonfun$testClearMirrorTopicsControllerManyEntries$1(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        List topicGroups = topics.grouped(topicGroupSize).toList();
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals((int)2, (int)((TraversableOnce)topicGroups.apply(0)).size());
        Assertions.assertEquals((int)2, (int)((TraversableOnce)topicGroups.apply(1)).size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)topicGroups.apply(2)).size());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.metadataManager().getAllTopicsInCluster()).andReturn((Object)topics);
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)topicGroups.head())).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.head()).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.head()).last()), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)topicGroups.apply(1))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(1)).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(1)).last()), (Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4()))})));
        EasyMock.expect((Object)this.metadataManager().clusterLinkTopicState((Set)topicGroups.apply(2))).andReturn((Object)Predef$.MODULE$.Map().empty());
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        scala.collection.immutable.Map expectedOps1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(0)).head()), (Object)AlterMirrorOp.CLEAR)}));
        scala.collection.immutable.Map expectedOps2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(1)).head()), (Object)AlterMirrorOp.CLEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(1)).last()), (Object)AlterMirrorOp.CLEAR)}));
        AlterMirrorsResult ret1 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)((String)((IterableLike)topicGroups.apply(0)).head()), (List)Nil$.MODULE$));
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)((String)((IterableLike)topicGroups.apply(1)).head()), (List)new .colon.colon((Object)((String)((TraversableLike)topicGroups.apply(1)).last()), (List)Nil$.MODULE$)));
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps1).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret1);
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps2).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), (Function0)newClearLinkReference_completionCallback, topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    private AlterMirrorsResult newAlterMirrorsResult(Seq<String> topics) {
        return new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)KafkaFuture.completedFuture(null)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private ClusterLinkClearLinkReference newClearLinkReference(Function0<BoxedUnit> completionCallback, int topicGroupSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), this.authorizer(), this.admin(), completionCallback, topicGroupSize, 10, 10);
    }

    private int newClearLinkReference$default$2() {
        return 10;
    }

    public static final /* synthetic */ String $anonfun$testClearMirrorTopicsControllerManyEntries$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public ClusterLinkClearLinkReferenceTest() {
        this.linkName = "link-name";
    }
}

